package com.yeejoin.amos.patrol.common.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import org.hibernate.annotations.Where;

@Entity
@Table(name="p_app_version")
@NamedQuery(name="AppVersion.findAll", query="SELECT c FROM AppVersion c")
@Where(clause="is_latest_version=1")//表示未删除的数据
public class AppVersion extends BasicEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3207180951171522450L;

	/**
	 * app版本
	 */
	@Column(name="version")
	private String version;
	
	/**
	 * 版本说明
	 */
	@Column(name="remark")
	private String remark;
	
	/**
	 * app发布人id
	 */
	@Column(name="publisher")
	private String publisher;
	
	/**
	 * app发布人名称
	 */
	@Column(name="publisher_name")
	private String publisherName;
	
	/**
	 * 是否需要强制更新
	 */
	@Column(name="update_type")
	private int updateType;
	
	/**
	 * 是否为最新版本
	 */
	@Column(name="is_latest_version")
	private Boolean isLatestVersion;
	
	/**
	 * app保存路径
	 */
	@Column(name="url")
	private String url;

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getPublisher() {
		return publisher;
	}

	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	public String getPublisherName() {
		return publisherName;
	}

	public void setPublisherName(String publisherName) {
		this.publisherName = publisherName;
	}

	public int getUpdateType() {
		return updateType;
	}

	public void setUpdateType(int updateType) {
		this.updateType = updateType;
	}

	public Boolean getIsLatestVersion() {
		return isLatestVersion;
	}

	public void setIsLatestVersion(Boolean isLatestVersion) {
		this.isLatestVersion = isLatestVersion;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

}
