package com.yeejoin.amos.patrol.common.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/**
 * <pre>
 * 基本实体类
 * </pre>
 *
 */

@MappedSuperclass

@EntityListeners(AuditingEntityListener.class) 
public class BasicEntity implements Serializable{

	private static final long serialVersionUID = -5464322936854328207L;
	
	/**
	 * id
	 */
	private long id;

	@CreatedDate
	@Column(name="create_date")
	private Date createDate;

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "ID",nullable=false,unique=true)
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	
	


	

}
