package com.yeejoin.amos.patrol.common.entity;

import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * 检查项
 */
@Entity
@Table(name = "p_input_item")
@NamedQuery(name = "InputItem.findAll", query = "SELECT c FROM InputItem c")
@Where(clause = "is_delete=0")//表示未删除的数据
public class InputItem extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 分类ID
     */
    @Column(name = "catalog_id")
    private long catalogId;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 配置JSON
     */
    @Lob
    @Column(name = "data_json")
    private String dataJson;

    /**
     * 默认值
     */
    @Column(name = "default_value")
    private String defaultValue;

    /**
     * 扩展项json
     */
    @Lob
    @Column(name = "input_json")
    private String inputJson;

    /**
     * 是否多选
     */
    @Column(name = "is_multiline")
    private String isMultiline;

    /**
     * 是否必填
     */
    @Column(name = "is_must")
    private String isMust;

    /**
     * 是否评分
     */
    @Column(name = "is_score")
    private String isScore;

    /**
     * 检查项类型
     */
    @Column(name = "item_type")
    private String itemType;

    /**
     * 检查项名称
     */
    private String name;

    /**
     * 排序编码
     */
    @Column(name = "order_no")
    private int orderNo;

    /**
     * 组织编码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 拍照配置json
     */
    @Lob
    @Column(name = "picture_json")
    private String pictureJson;

    @Lob
    private String remark;

    /**
     * 是否删除：0表示未删除，1表示已删除
     */
    @Column(name = "is_delete")
    private boolean isDelete;

    /**
     * 等级
     */
    @Column(name = "level")
    private String level;

    /**
     * 检查项编号
     */
    @Column(name = "item_no")
    private String itemNo;

    /**
     * 原始字段
     */
    @Column(name = "original_id", columnDefinition = "varchar(50) COMMENT '原始字段'")
    private String originalId;

    /**
     * 标准依据
     */
    @Column(name = "basis_json", columnDefinition = "text COMMENT '标准依据'")
    private String basisJson;


    public String getItemNo() {
        return itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public InputItem() {
    }

    public long getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(long catalogId) {
        this.catalogId = catalogId;
    }

    public String getDataJson() {
        return this.dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getInputJson() {
        return this.inputJson;
    }

    public void setInputJson(String inputJson) {
        this.inputJson = inputJson;
    }

    public String getIsMultiline() {
        return this.isMultiline;
    }

    public void setIsMultiline(String isMultiline) {
        this.isMultiline = isMultiline;
    }

    public String getIsMust() {
        return this.isMust;
    }

    public void setIsMust(String isMust) {
        this.isMust = isMust;
    }

    public String getIsScore() {
        return this.isScore;
    }

    public void setIsScore(String isScore) {
        this.isScore = isScore;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getPictureJson() {
        return this.pictureJson;
    }

    public void setPictureJson(String pictureJson) {
        this.pictureJson = pictureJson;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    public boolean equals(Object obj) {
        InputItem inputItem = (InputItem) obj;
        return this.getId() == inputItem.getId();
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getBasisJson() {
        return basisJson;
    }

    public void setBasisJson(String basisJson) {
        this.basisJson = basisJson;
    }
}