package com.yeejoin.amos.patrol.common.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Author: xinglei
 * @Description: 巡检路线
 * @Date: 2019/12/10 16:44
 */
@Entity
@Table( name= "b_patrol_route")
@org.hibernate.annotations.Table(appliesTo = "b_patrol_route",comment="巡检路线")
public class PatrolRoute extends BasicEntity {

    private static final long serialVersionUID = -7601707804744599095L;
    /**
     * 巡检人员ID
     */
    @Column(name ="user_id", nullable=true,unique = true, columnDefinition="bigint(20) COMMENT '巡检人员ID'")
    private Integer userId;
    /**
     * 巡检人员名称
     */
    @Column(name ="user_name", nullable=true,unique = true, columnDefinition="varchar(255) COMMENT '巡检人员名称'")
    private String userName;
    /**
     * 巡检人员所属单位
     */
    @Column(name ="dept_company", nullable=true,unique = true, columnDefinition="varchar(510) COMMENT '所属单位'")
    private String deptCompany;
    /**
     * 电话
     */
    @Column(name ="telephone", nullable=true,unique = true, columnDefinition="varchar(510) COMMENT '电话'")
    private String telephone;
    /**
     * 经度
     */
    @Column(name ="longitude", nullable=true,unique = true, columnDefinition="double COMMENT '经度'")
    private Double longitude;
    /**
     * 纬度
     */
    @Column(name ="latitude", nullable=true,unique = true, columnDefinition="double COMMENT '纬度'")
    private Double latitude;    /**
     * 同步标识
     */
    @Column(name ="sync_mark", columnDefinition="tinyint(4) COMMENT '同步标识'")
    private Integer syncMark = 1;

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDeptCompany() {
        return deptCompany;
    }

    public void setDeptCompany(String deptCompany) {
        this.deptCompany = deptCompany;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Integer getSyncMark() {
        return syncMark;
    }

    public void setSyncMark(Integer syncMark) {
        this.syncMark = syncMark;
    }
}
