package com.yeejoin.amos.patrol.common.enums;

public enum ExecuteStateEnum {

    未执行("未执行", 1, ""),
    通过("通过", 2, "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": false}]}"),
    驳回("驳回", 3, "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": true}]}");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    private String requestBody;

    ExecuteStateEnum(String name, Integer code, String requestBody) {
        this.name = name;
        this.code = code;
        this.requestBody = requestBody;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public static ExecuteStateEnum getByCode(Integer code) {
        for (ExecuteStateEnum e : ExecuteStateEnum.values()) {
            if (code.equals(e.getCode())) {
                return e;
            }
        }
        return null;
    }
}
