package com.yeejoin.amos.patrol.common.enums;

public enum LatentDangerActionFlagEnum {
    填写隐患("填写隐患", "input"),
    隐患评审("隐患评审", "review"),
    隐患治理("隐患治理", "reform"),
    填写安措计划("填写安措计划", "input_plan"),
    车间部门审核("车间部门审核", "workshop_review"),
    总工程师审核("总工程师审核", "engineer_review"),
    公司负责人审核("公司负责人审核", "leader_review"),
    治理验证("治理验证", "recheck");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    LatentDangerActionFlagEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static LatentDangerActionFlagEnum getByCode(Integer code) {
        for (LatentDangerActionFlagEnum l : LatentDangerActionFlagEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
