package com.yeejoin.amos.patrol.common.enums;

public enum LatentDangerTypeEnum {

    无码无计划隐患("无码无计划隐患", 1),
    巡检隐患("巡检隐患", 2),
    有码无计划隐患("有码无计划隐患", 3);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    LatentDangerTypeEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static LatentDangerTypeEnum getByCode(Integer code) {
        for (LatentDangerTypeEnum l : LatentDangerTypeEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
