package com.yeejoin.amos.patrol.common.enums;

public enum PhotoBizCodeEnum {

    隐患拍照("隐患拍照", "latent_danger"),
    评审拍照("评审拍照", "latent_danger_review"),
    治理拍照("治理拍照", "latent_danger_reform"),
    验证拍照("验证拍照", "latent_danger_recheck"),
    研判拍照("研判拍照", "risk_judgement"),
    作业活动拍照("作业活动拍照", "task_work");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    PhotoBizCodeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static PhotoBizCodeEnum getByCode(String code) {
        for (PhotoBizCodeEnum e : PhotoBizCodeEnum.values()) {
            if (code.equals(e.getCode())) {
                return e;
            }
        }
        return null;
    }
}
