package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanTaskDetailStatusEnum {
	
	NOTSTARTED("未开始","0"),
	QUALIFIED("正常","1"),
	UNQUALIFIED("异常","2"),
	OMISSION("漏检","3");
	
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private String value;
	


	private PlanTaskDetailStatusEnum(String name, String value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(String value) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (value.equals(c.getValue())) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getValue(String name) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return "";
	}


	public static PlanTaskDetailStatusEnum getEnumByValue(String value) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (value.equals(c.getValue())) {
				return c;
			}
		}
		return null;
	}


	public static PlanTaskDetailStatusEnum getEnumByName(String name) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (PlanTaskDetailStatusEnum c: PlanTaskDetailStatusEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getValue() +"");
			nameList.add(map);
		}
		return nameList;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PlanTaskDetailStatusEnum c: PlanTaskDetailStatusEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public String getValue() {
		return value;
	}


	public void setValue(String value) {
		this.value = value;
	}
}
