package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ViolationGradeEnum {

	无违章("无违章", "1"),
	一般违章("一般违章", "2"),
	严重违章("严重违章", "3");
	
	/**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;
    
    private ViolationGradeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }
    
    public static ViolationGradeEnum getEnum(String code) {
        for (ViolationGradeEnum type : ViolationGradeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (ViolationGradeEnum e : ViolationGradeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }
    
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
