package com.yeejoin.amos.patrol.service.business.bo.spc;

import com.yeejoin.amos.patrol.service.business.bo.spc.extend.TaskworkExtend;

import java.util.Date;

/**
 * 作业活动
 */
public class TaskworkBo extends TaskworkExtend {

    /**
     * 主键编号
     */
    private Long id;

    /**
     * 作业活动名称
     */
    private String name;

    /**
     * 类型
     */
    private String type;

    /**
     * 岗位
     */
    private String post;

    /**
     * 部位
     */
    private String part;

    /**
     * 所在分区
     */
    private String regionId;

    /**
     * 部门
     */
    private String departmentId;

    /**
     * 班组
     */
    private String groupId;
    
    /**
     * 违章状态:默认1；1-无违章；2-一般违章；3-严重违章
     */
    private Long violateState;

    /**
     * 作业活动状态（0：未启动；1：待班组审核；2：待车间/部门审核；3：待公司审核；4：待执行；5：待确认验收；6：完成）
     */
    private Integer status;

    /**
     * 风险等级id
     */
    private Long riskLevelId;

    /**
     * 创建人
     */
    private String creatorId;

    /**
     * 是否被监控
     */
    private Boolean isMonitor;

    /**
     * 组织编码
     */
    private String orgCode;

    /**
     * 当前工作流记录编号
     */
    private Long currentFlowRecordId;

    /**
     * 工作流实例编号
     */
    private String instanceId;

    private String businessKey;

    /**
     * 申请人
     */
    private String applyUserId;

    /**
     * 申请人部门编号
     */
    private String applyDepartmentId;

    /**
     * 申请时间
     */
    private Date applyDate;

    /**
     *
     */
    private Date createDate;

    /**
     * 修改时间
     */
    private Date updateDate;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public String getPost() {
        return post;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public String getPart() {
        return part;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentId() {
        return departmentId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return status;
    }

    public void setRiskLevelId(Long riskLevelId) {
        this.riskLevelId = riskLevelId;
    }

    public Long getRiskLevelId() {
        return riskLevelId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorId() {
        return creatorId;
    }

    public void setIsMonitor(Boolean isMonitor) {
        this.isMonitor = isMonitor;
    }

    public Boolean getIsMonitor() {
        return isMonitor;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setCurrentFlowRecordId(Long currentFlowRecordId) {
        this.currentFlowRecordId = currentFlowRecordId;
    }

    public Long getCurrentFlowRecordId() {
        return currentFlowRecordId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public String getBusinessKey() {
        return businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public void setApplyUserId(String applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserId() {
        return applyUserId;
    }

    public void setApplyDepartmentId(String applyDepartmentId) {
        this.applyDepartmentId = applyDepartmentId;
    }

    public String getApplyDepartmentId() {
        return applyDepartmentId;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

	public Long getViolateState() {
		return violateState;
	}

	public void setViolateState(Long violateState) {
		this.violateState = violateState;
	}

}
