package com.yeejoin.amos.patrol.service.business.controller;

//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;

import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;
import com.yeejoin.amos.patrol.common.entity.CatalogTree;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.service.business.param.CatalogTreePageParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ICatalogTreeService;
import com.yeejoin.amos.patrol.service.business.util.CatalogTreePageParamUtil;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/api/catalogTree")
@Api(tags = "分类api")
public class CatalogTreeController extends BaseController {

    private final Logger log = LoggerFactory.getLogger(CatalogTreeController.class);

    @Autowired
    private ICatalogTreeService catalogTreeService;

    /**
     * 树结构查询
     */
    @ApiOperation(value = "树结构查询", notes = "树结构查询")
    @RequestMapping(value = "/getCatalogTree", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getCatalogTree() {
        ReginParams reginParams = getSelectedOrgInfo();
        //String orgCode = getLoginOrgCode(reginParams);
        String orgCode = reginParams.getCompany().getOrgCode();
        List<Object> list = catalogTreeService.getCatalogTree(orgCode);
        return CommonResponseUtil.success(list);
    }

    /**
     * 树结构查询
     */
    @ApiOperation(value = "树结构查询", notes = "树结构查询")
    @RequestMapping(value = "/catalogList", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getCatalogList() {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        List<CatalogTree> list = catalogTreeService.getCatalogList(orgCode);
        return CommonResponseUtil.success(list);
    }

    /**
     * 分类新增
     */
    @ApiOperation(value = "分类新增", notes = "分类新增")
    @RequestMapping(value = "/addCatalogTree", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse catalogTreeAdd(@ApiParam(value = "分类", required = true) @RequestBody CatalogTree param) {
        try {
            String userId = getUserId();
            ReginParams reginParams = getSelectedOrgInfo();
            //String orgCode = getLoginOrgCode(reginParams);
            //分配到公司下
            String orgCode = reginParams.getCompany().getOrgCode();
            
            HashMap<String, Object> map = new HashMap<>();
            map.put("org_code", orgCode);
            map.put("user_id", userId);
            map.put("param", param);
            if(param.getId()>0){
            	 catalogTreeService.addCatalogTree(map);
            	 return CommonResponseUtil.success();
            }
            List<CatalogTree> catalogTreelist = catalogTreeService.getCatalogListByPid(Long.valueOf(param.getParentId()), orgCode);
            catalogTreelist = catalogTreelist.stream().filter(x -> param.getName().equals(x.getName())).collect(Collectors.toList());

            if (catalogTreelist.size() == 0) {
            	
                catalogTreeService.addCatalogTree(map);
                return CommonResponseUtil.success();
            } else {
                return CommonResponseUtil.failure("目录名称已存在");
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("分类新增失败");
        }
    }

    /**
     * 分类删除（支持批量）
     */
    @ApiOperation(value = "删除分类", notes = "删除分类")
    @RequestMapping(value = "/deleteCatalogTreeById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteCatalogTreeById(
      @ApiParam(value = "分类ID", required = true) @RequestBody Long[] param) {
        try {
            catalogTreeService.delCatalogTreeById(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除分类失败：" + e.getMessage());
        }
    }

    /**
     * 分类数据查询
     */
    @ApiOperation(value = "分类数据查询", notes = "分类数据查询")
    @RequestMapping(value = "/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qryCatalogTreeInfoPage(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                                 @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        HashMap<String, Object> paramMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        //单位过滤
        //String orgCode = getLoginOrgCode(reginParams);
        String orgCode = reginParams.getCompany().getOrgCode();
        
        paramMap.put("orgCode", orgCode);
        CatalogTreePageParam param = CatalogTreePageParamUtil.fillPageParam(queryRequests, commonPageable, paramMap);


        Page<HashMap<String, Object>> list = catalogTreeService.getCatalogTreeInfo(getToken(), getProduct(), getAppKey(), param);
        return CommonResponseUtil.success(list);
    }

    /**
     * 查询分类按照id
     */
    @ApiOperation(value = "查询分类按照id", notes = "查询分类按照id")
    @RequestMapping(value = "/catalogTreeDetById/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCatalogTreeById(@ApiParam(value = "分类id", required = true) @PathVariable(name = "id") Long id) {
        CatalogTree plan = catalogTreeService.queryCatalogTreeById(id);
        return CommonResponseUtil.success(plan);

    }
}
