package com.yeejoin.amos.patrol.service.business.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;
import com.yeejoin.amos.patrol.common.core.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.common.core.response.GraphInitDataResponse;
import com.yeejoin.amos.patrol.common.entity.CheckShot;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.common.enums.PlanTaskFinishStatusEnum;
import com.yeejoin.amos.patrol.service.business.dto.CheckDto;
import com.yeejoin.amos.patrol.service.business.param.CheckImgParam;
import com.yeejoin.amos.patrol.service.business.param.CheckInfoPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckInputParam;
import com.yeejoin.amos.patrol.service.business.param.CheckRecordParam;
import com.yeejoin.amos.patrol.service.business.param.CheckStatisticalParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ICheckService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPointService;
import com.yeejoin.amos.patrol.service.business.service.intfc.ISafety3DDataSendService;
import com.yeejoin.amos.patrol.service.business.util.CheckPageParamUtil;
import com.yeejoin.amos.patrol.service.business.util.CheckParamUtil;
import com.yeejoin.amos.patrol.service.business.util.FileHelper;
import com.yeejoin.amos.patrol.service.business.util.ToolUtils;
import com.yeejoin.amos.patrol.service.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.patrol.service.business.vo.CheckInfoVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import com.yeejoin.amos.patrol.service.remote.RemoteWebSocketServer;
import com.yeejoin.amos.patrol.service.remote.feign.AmosBankFeign;

//import com.yeejoin.amos.security.common.authorization.Authorization;
//import com.yeejoin.amos.security.common.model.UserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

//import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;


import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;

import org.apache.http.util.EntityUtils;

@RestController
@RequestMapping(value = "/api/check")
@Api(tags = "巡检记录api")
public class CheckController extends BaseController {
    private final Logger log = LoggerFactory.getLogger(CheckController.class);

    @Autowired
    private ICheckService checkService;

    @Autowired
    private IPointService iPointService;

    @Autowired
    private IPlanTaskService planTaskService;

    @Autowired
    private ISafety3DDataSendService is;

    @Autowired
    private AsyncTask asyncTask;

    @Autowired
    private RemoteWebSocketServer remoteWebSocketServer;

    @Autowired
    private  AmosBankFeign amosBankFeign;
    
    @Value("${upload.root.path}")
    private String uploadRootPath;
   /* @Value("${params.video}")
    private String videourl ;*/
    @Value("${params.token}")
    private String tokenurl ;
    
    /**
     * 巡检计划查询
     */
    @ApiOperation(value = "巡检记录查询", notes = "巡检记录查询")
    @RequestMapping(value = "/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qryCheckInfoPage(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        
       // HashMap<String, Object> paramMap = buildMybatisDaoCriterias(orgCode, roleTypeName);
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("orgCode", orgCode);
        paramMap.put("roleFlag", XJConstant.ADMIN_FLAG);
        
        
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, commonPageable, paramMap);
        if (ObjectUtils.isEmpty(param.getOrderBy())) {
            param.setOrderBy("checkDate desc");
        }
        if (!(ObjectUtils.isEmpty(param.getUserId())) && param.getUserId().equals("-1")) {

           
            param.setUserId(null);
        }
        if (!(ObjectUtils.isEmpty(param.getDepartmentId())) && param.getDepartmentId().equals("-1")) {

            
            param.setDepartmentId(null);
        }
        
        
        
        Page<CheckInfoVo> list = checkService.getCheckInfo(getToken(),getProduct(),getAppKey(),param);
        return CommonResponseUtil.success(list);


    }

    @ApiOperation(value = "导出巡检记录", notes = "导出巡检记录")
    @RequestMapping(value = "/export", method = RequestMethod.POST)
    public void exportCheck(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            HttpServletResponse response) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        HashMap<String, Object> paramMap = buildMybatisDaoCriterias(orgCode, roleTypeName);
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, null, paramMap);
        param.setPageSize(-1);
        param.setOrderBy("checkDate DESC");
        List<CheckInfoVo> list = checkService.getCheckInfoList(getToken(),getProduct(),getAppKey(),param);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "巡检记录", "巡检记录", CheckInfoVo.class, fileName + ".xls", response);
    }

    @ApiOperation(value = "导出巡检记录", notes = "导出巡检记录")
    @RequestMapping(value = "/exportSelectRecord", method = RequestMethod.GET)
    public void exportSelectCheckRecord(
            @ApiParam(value = "查询条件") @RequestParam(required = false) Long[] ids,
            HttpServletResponse response) {
        List<CheckInfoVo> list = checkService.getSelectedCheckInfoList(getToken(),getProduct(),getAppKey(),ids);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "巡检记录", "巡检记录", CheckInfoVo.class, fileName + ".xls", response);
    }

    @ApiOperation(value = "导出巡检记录图片", notes = "导出巡检记录图片")
    @RequestMapping(value = "/exportImgs", method = RequestMethod.POST)
    public void exportCheckImgs(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            HttpServletResponse response) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        HashMap<String, Object> paramMap = buildMybatisDaoCriterias(orgCode, roleTypeName);
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, null, paramMap);
        List<Map<String, Object>> list = checkService.getCheckInfoImgsList(param);
        String fileName = "巡检记录图片" + new Date().getTime() + ".zip";
        for (Map<String, Object> map : list) {
            map.put("photoData", uploadRootPath + map.get("photoData").toString());
        }
        FileHelper.exportZip(list, fileName, response);
    }

    @ApiOperation(value = "导出巡检记录图片", notes = "导出巡检记录图片")
    @RequestMapping(value = "/exportImgsByIds", method = RequestMethod.GET)
    public void exportCheckImgs(@ApiParam(value = "查询条件", required = false) @RequestParam(required = false) Long[] ids,
                                HttpServletResponse response) {
        List<Map<String, Object>> list = checkService.getCheckInfoImgsList(ids);
        String fileName = "巡检记录图片" + new Date().getTime() + ".zip";
        for (Map<String, Object> map : list) {
            map.put("photoData", uploadRootPath + map.get("photoData").toString());
        }
        FileHelper.exportZip(list, fileName, response);
    }

    @ApiOperation(value = "保存巡检记录<font color='blue'>手机app</font>", notes = "保存巡检记录<font color='blue'>手机app</font>")
    @RequestMapping(value = "/saveRecord", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse saveCheckRecord(
            @ApiParam(value = "检查信息", required = false) @RequestBody(required = true) CheckRecordParam requestParam) {
        int statu = -1;
        PlanTask planTask =null;
         if(requestParam.getPlanTaskId()!=null){
        	 planTask = planTaskService.selectPlanTaskStatus(requestParam.getPlanTaskId());
         }

        AgencyUserModel user = getUserInfo();
        String userId = user.getUserId();

        String realName = user.getRealName();
        requestParam.setIsOffline(requestParam.getIsOffline()==null?false:requestParam.getIsOffline());
        try {
            if (planTask != null) {
                //竞争修改
                if (!ToolUtils.transBeanList(planTask.getUserId()).contains(userId.toString())) {
                    return CommonResponseUtil.failure("无权执行该任务");
                }

                statu = planTask.getFinishStatus();
                if (!requestParam.getIsOffline() && statu == PlanTaskFinishStatusEnum.OVERTIME.getValue()) {
                    return CommonResponseUtil.failure("任务已超时，上传失败！");
                } else if (statu == PlanTaskFinishStatusEnum.FINISHED.getValue()) {
                    return CommonResponseUtil.failure("任务已完成！");
                }

                Date checkTime = requestParam.getIsOffline() ? DateUtil.getLongDate(requestParam.getCheckTime())
                        : new Date();
                Date beginTime = DateUtil.getLongDate(planTask.getBeginTime());
                Date endTime = DateUtil.getLongDate(planTask.getEndTime());
                int beginCompareTo = checkTime.compareTo(beginTime);
                int endCompareTo = checkTime.compareTo(endTime);
                if (beginCompareTo == -1 || endCompareTo == 1) {
                    return CommonResponseUtil.failure("请在计划时间内完成任务！");
                }
            }
        } catch (Exception e) {
            return CommonResponseUtil.failure("提交数据失败！");
        }
        int count = checkService.checkHasRecord(requestParam);
        if (count < 1 || requestParam.getPlanTaskId() < 1) {
            ReginParams reginParams = getSelectedOrgInfo();
            String orgCode = getLoginOrgCode(reginParams);
            String departmentId = getDepartmentId(reginParams);
            requestParam.setOrgCode(orgCode);
            requestParam.setUserId(getUserId());
            requestParam.setCheckDepartmentId(departmentId);
            CheckDto checkDto = checkService.saveCheckRecord(requestParam, user, reginParams.getDepartment());
            try {
                List<CheckInputParam> list = requestParam.getCheckItems();
                HashMap<String, Object> map = new HashMap<String, Object>();
                List<Long> pointClassIdList = list.stream().map(temp -> temp.getClassifyIds()).collect(Collectors.toList());
                map.put("pointId", requestParam.getPointId());
                map.put("pointclassifyIds", pointClassIdList);
                asyncTask.pushSpcCheckResult(checkDto.getCheckId());
                asyncTask.pushCheckRecordMessage(checkDto.getCheckId(), realName, map);
                //推送到风险系统
                asyncTask.pushCheckInfoTo3D(checkDto.getCheckId());
				
				 //推送银行首页
                //增建已超时，推送    
                asyncTask.pushChartResulplantask();
//                //推送首页统计
//                asyncTask.pushChartResult();
                if (!CollectionUtils.isEmpty(checkDto.getUnCheckInputList())) {
                	//取消隐患添加
                	checkDto.setUnCheckInputList(null);
                    asyncTask.pushNoPassCheckRecordMessage(checkDto.getCheckId(), realName, map);
                }
                remoteWebSocketServer.wsDataRefresh("check");
            } catch (InterruptedException e) {
                log.error("推送异常", e);
            }
            return CommonResponseUtil.success(checkDto);
        } else {
            return CommonResponseUtil.success("无需重新巡检");
        }
    }

    //@Authorization(ingore = true)
    @ApiOperation(value = "测试接口", notes = "测试接口")
    @RequestMapping(value = "/testPushSpcCheckResult", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse testPushSpcCheckResult(@RequestParam(required = true) long checkId) {
        try {
            asyncTask.pushSpcCheckResult(checkId);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    @ApiOperation(value = "上传检查记录图片<font color='blue'>手机app</font>", notes = "上传检查记录图片<font color='blue'>手机app</font>")
    @RequestMapping(value = "/uploadCheckImg", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse uploadCheckImg(
            @ApiParam(value = "检查图片", required = true) @RequestBody(required = true) MultipartFile file) {
    	synchronized (CheckController.class) {
			
    		CheckImgParam checkImgParam = new CheckImgParam();
    		//扩展分类id
    		
    		String classifyId = request.getParameter("classifyId");
    		
    		String classifyIdPathString = "";
    		if (null != classifyId && !"".equals(classifyId) && !"null".equals(classifyId)) {
    			checkImgParam.setClassifyId(Long.parseLong(request.getParameter("classifyId")));
    			classifyIdPathString = "/" + request.getParameter("classifyId");
    		}
    		checkImgParam.setCheckId(Long.parseLong(request.getParameter("checkId")));
    		if (!ObjectUtils.isEmpty(request.getParameter("inputItemId"))) {
    			checkImgParam.setInputItemId(Long.parseLong(request.getParameter("inputItemId")));
    		}
    		checkImgParam.setPointId(Long.parseLong(request.getParameter("pointId")));
    		checkImgParam.setName(request.getParameter("name"));
    		Point point = iPointService.queryPointById(checkImgParam.getPointId());
    		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    		
    		ReginParams reginParams = getSelectedOrgInfo();
    		String loginOrgCode = getLoginOrgCode(reginParams);
    		String[] companys = loginOrgCode.split("\\*");
    		
    		String path = "/" + companys[companys.length - 1] + "/"
    				+ sdf.format(new Date()) + "/" + point.getName() + "/"
    				+ checkImgParam.getCheckId();
    		
    		if(!"".equals(classifyIdPathString)) {
    			path += classifyIdPathString;
    		}
    		String filePath = uploadRootPath + path;
    		if (file.isEmpty()) {
    			return CommonResponseUtil.failure("上传文件失败");
    		}
    		String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
    		
    		String fileName = ObjectUtils.isEmpty(checkImgParam.getName()) ? "/" + file.getOriginalFilename()
    		: "/" + checkImgParam.getName()+UUID.randomUUID() + fileType;
    		
    		
    		try {
    			File dest = new File(filePath + "/" + fileName);
    			if (!dest.exists()) {
    				if (dest.getParentFile() != null && !dest.getParentFile().exists()) {
    					dest.getParentFile().mkdirs();
    				}
    				dest.createNewFile();
    			}
    			file.transferTo(dest);
    		} catch (IOException e) {
    			return CommonResponseUtil.failure("上传文件失败");
    		}
    		
    		CheckShot img = new CheckShot();
    		String photoFile = path + fileName;
    		img.setPhotoData(photoFile);
    		img.setCheckId(Integer.valueOf(checkImgParam.getCheckId() + ""));
    		img.setOrgCode(loginOrgCode);
    		img.setCreateDate(new Date());
    		img.setPointName(checkImgParam.getName());
    		img.setCheckInputId(checkImgParam.getInputItemId());
    		img.setShotType("1".equals(point.getIsFixed()) ? "定点" : "普通");
    		img.setClassifyId(checkImgParam.getClassifyId());
    		checkService.saveCheckImg(img);
		}
        
        return CommonResponseUtil.success();
    }

    /**
     * 巡检计划删除（支持批量）
     */
    @ApiOperation(value = "删除巡检记录", notes = "删除巡检记录")
    @RequestMapping(value = "/deleteCheckById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteCheckById(@ApiParam(value = "巡检计划ID", required = true) @RequestBody List<Long> ids) {
        try {
            checkService.delCheckById(ids);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除巡检记录失败");
        }
    }

    /**
     * 根据检查项ID获取所有不合格检查项
     */
    @ApiOperation(value = "据检查项ID获取所有不合格检查项<font color='blue'>手机app</font>", notes = "据检查项ID获取所有不合格检查项<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryUnqualifiedInputItem", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryUnqualifiedInputItem(@RequestParam(required = true) int checkId) {
        try {
            List<Map> list = checkService.queryUnqualifiedInputItem(checkId);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

   // @Authorization(ingore = true)
    @ApiOperation(value = "获取巡检计划巡检点(已完成或漏检的巡检点)详情信息<font color='blue'>手机app</font>", notes = "获取巡检计划巡检点(已完成或漏检的巡检点)详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckPointDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCheckPointDetail(@RequestParam(required = true) long checkId) {
        try {
            AppPointCheckRespone pointCheckRespone = checkService.queryCheckPointDetail(getToken(),getProduct(),getAppKey(),checkId);
            return CommonResponseUtil.success(pointCheckRespone);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    /**
     * 获取巡检日历数据
     *
     * @param queryRequests
     * @return
     */
    @ApiOperation(value = "获取巡检日历数据<font color='blue'>手机app</font>", notes = "获取巡检日历数据<font color='blue'>手机app</font>")
    @PostMapping(value = "/checkCalendar", produces = "application/json;charset=UTF-8")
    public CommonResponse checkCalendar(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            String roleTypeName = getRoleTypeName(reginParams);
            List<DaoCriteria> daoCriterias = buildDaoCriterias(queryRequests, true, loginOrgCode, roleTypeName);
            Map<String, Object> map = checkService.checkCalendar(CheckParamUtil.checkCalendar(daoCriterias));
            return CommonResponseUtil.success(map);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    @ApiOperation(value = "获取巡检点巡检记录列表信息<font color='blue'>手机app</font>", notes = "获取巡检点巡检记录列表信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckRecord", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRecordByPointId(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests) {
        HashMap<String, Object> req = CheckPageParamUtil.fillInfo(queryRequests);
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
//        if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())
//                || XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())) {
//            req.put("orgCode", loginOrgCode);
//        } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
//            req.put("departmentId", departmentId);
//        } else {
//            req.put("userId", userId);
//        }
        if (XJConstant.CCPC_PERSONAL.equals(roleTypeName)) {
        	//一线技术，一线业务只能看自己的
        	req.put("userId", getUserId());
        	req.put("orgCode", loginOrgCode);
        } else {
        	//管理员
        	 req.put("orgCode", loginOrgCode);
        }
        Map<String, Object> map = checkService.queryRecordByPointId(req);
        return CommonResponseUtil.success(map);
    }

    @ApiOperation(value = "获取巡检记录详情信息<font color='blue'>手机app</font>", notes = "获取巡检记录详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRecordById(@RequestParam(required = true) int checkId) {
        try {
            Map<String, Object> map = checkService.queryRecordById(checkId);
            return CommonResponseUtil.success(map);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    /**
     * 根据巡检记录ID获取巡检记录详情
     *
     * @param checkId
     * @return
     */
    @ApiOperation(value = "根据巡检记录ID获取巡检记录详情", notes = "根据巡检记录ID获取巡检记录详情")
    @RequestMapping(value = "/queryCheckInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse printTaskDetail(@ApiParam(value = "巡检记录ID") @RequestParam(required = true) int checkId) {
        Map<String, Object> map = checkService.queryRecordById(checkId);
        String xml = ToolUtils.map2Xml(map, "CheckInfo");
        if (ObjectUtils.isEmpty(xml)) {
            return CommonResponseUtil.failure();
        }
        InputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        ;
        Source source = new StreamSource(inputStream);
        try {
            FileInputStream fis1 = new FileInputStream(
                    this.getClass().getResource("/").getPath() + "temp/checkTemplate.xsl");
            Source template = new StreamSource(fis1);
            Date date = new Date();
            String path = request.getSession().getServletContext().getRealPath("/");
            String dir = path.substring(0, path.indexOf(File.separator) + 1) + "check";
            String html = path.substring(0, path.indexOf(File.separator) + 1) + "check" + File.separator + "task_"
                    + date.getTime() + ".html";
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }

            Result result = new StreamResult(html);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(template);

            transformer.transform(source, result);

            File htmlFile = new File(html);
            FileInputStream fis = new FileInputStream(htmlFile);
            String data = IOUtils.toString(fis, "utf-8");
            fis.close();
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            return new CommonResponse(SUCCESS, data, "查询成功");
        } catch (TransformerException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取巡检点，巡检线路初始数据
     *
     * @return
     */
    //@Authorization(ingore = true)
    @ApiOperation(value = "获取巡检点初始数据(<font color='blue'>release</font>)", notes = "获取巡检点初始数据")
    @RequestMapping(value = "/viewModule/initData", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getViewModuleInitData() {
        try {
            GraphInitDataResponse graphInitDataResponse = checkService.getViewModuleInitData();
            return CommonResponseUtil.success(graphInitDataResponse);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure();
        }
    }

    @ApiOperation(value = "巡检情况统计分析", notes = "巡检情况统计分析")
    @RequestMapping(value = "/statisticalAnalysis", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public CommonResponse getCheckStatisticalAnalysis(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) CheckStatisticalParam queryRequests) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        
        //String loginOrgCode = getLoginOrgCode(reginParams);
        
        //权限放到公司级别
        String loginOrgCode =reginParams.getCompany().getOrgCode();
        
        queryRequests.setOrgCode(loginOrgCode);
        List<CheckAnalysisVo> list = checkService.getCheckStatisticalAnalysis(getToken(),getProduct(),getAppKey(),queryRequests);
        return CommonResponseUtil.success(list);
    }

    @ApiOperation(value = "导出巡检情况统计分析", notes = "导出巡检情况统计分析")
    @RequestMapping(value = "/exportStatisticalAnalysis", method = RequestMethod.POST, produces = "application/vnd.ms-excel;charset=UTF-8")
    public void exportStatisticalAnalysis(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) CheckStatisticalParam queryRequests,
            HttpServletResponse response) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
         //String loginOrgCode = getLoginOrgCode(reginParams);
        
        //权限放到公司级别
        String loginOrgCode =reginParams.getCompany().getOrgCode();        queryRequests.setOrgCode(loginOrgCode);
        List<CheckAnalysisVo> list = checkService.getCheckStatisticalAnalysis(getToken(),getProduct(),getAppKey(),queryRequests);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "巡检情况统计分析", "巡检情况统计分析", CheckAnalysisVo.class, fileName + ".xls", response);
    }

//    @Authorization(ingore = true)
//    @ApiOperation(value = "111111(<font color='blue'>release</font>)", notes = "11111")
//    @RequestMapping(value = "/ids", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
//    public CommonResponse getIds() {
//        is.pointCheckInfoPush((long) 28);
//        return CommonResponseUtil.success();
//    }

    /**
     * 根据检查项ID和检查输入项ID查询图片， 如果输入项ID位0时，查询巡检现场照片， 如果不为0查询检查项照片
     *
     * @param checkId
     * @param checkInputId
     * @return
     */
    @ApiOperation(value = "获取检查项照片URL(<font color='blue'>release</font>)", notes = "获取检查项照片URL")
    @RequestMapping(value = "/getCheckPic", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getCheckPhotosByCheckAndInputId(
            @ApiParam(value = "巡检记录ID") @RequestParam(required = true) int checkId,
            @ApiParam(value = "扩展分类ID") @RequestParam(required = true) int classifyId,
            @ApiParam(value = "检查输入项ID") @RequestParam(required = false) int checkInputId) {
        try {
            List<String> list = checkService.getCheckPhotosByCheckAndInputIdAndClassifyId(checkId, checkInputId,classifyId);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }
    
    
    @ApiOperation(value = "test", notes = "test")
    @RequestMapping(value = "/test", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getCheckPhotosByCheckAndInputId() {
    		asyncTask.pushChartResult();
    		return null;
    }
    
    
    
    @ApiOperation(value = "视频监控接口", notes = "视频监控接口")
    @RequestMapping(value = "/getvideo/{parentId}/{current}/{pageSize}", method = RequestMethod.POST, produces = "application/vnd.ms-excel;charset=UTF-8")
    public String getvideo( @ApiParam(value = "父节点ID（给默认9）") @PathVariable(required = true) Long parentId,
    		@ApiParam(value = "父节点ID（给默认9）") @PathVariable(required = true) Integer current,
    		@ApiParam(value = "父节点ID（给默认9）") @PathVariable(required = true) Integer pageSize
            ) {
      	
    	/* MultiValueMap<String, Object> param = new LinkedMultiValueMap<>();
         param.add("current", current);
         param.add("pageSize", pageSize);
         param.add("parentId", parentId);
         MonitorParam dd=new MonitorParam();
         dd.setParentId(parentId);
         dd.setPageSize(pageSize);
         dd.setCurrent(current);*/
         
    	
         CommonResponse lis=   amosBankFeign.getVideos(getSelectedOrgInfo().getCompany().getOrgCode(),current, pageSize, parentId);
         String resultString = "";
          resultString = JSONObject.toJSONString(lis);
         
        /* CloseableHttpClient httpClient = HttpClients.createDefault();
         CloseableHttpResponse response = null;
         String resultString = "";
         try {
             HttpPost httpPost = new HttpPost(videourl);
             StringEntity entity = new StringEntity(JSON.toJSONString(param), ContentType.APPLICATION_JSON);
             httpPost.setEntity(entity);
             response = httpClient.execute(httpPost);
             resultString = EntityUtils.toString(response.getEntity(), "utf-8");
         } catch (Exception e) {
             e.printStackTrace();
             return resultString;
         } finally {
             try {
                 response.close();
             } catch (IOException e) {
                 // TODO Auto-generated catch block
                 e.printStackTrace();
                 return resultString;
             }
         }*/
         
    	return resultString;
    }
    
    
    
	
    @ApiOperation(value = "视屏页面接口", notes = "视屏页面接口")
    @RequestMapping(value = "/tokenurl", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getvideoToke() {   		    	 
    
    	return CommonResponseUtil.success(tokenurl);
    }
    
    
}
