package com.yeejoin.amos.patrol.service.business.controller;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.enums.CheckStatisticsTypeEnum;
import com.yeejoin.amos.patrol.common.enums.PhotoBizCodeEnum;
import com.yeejoin.amos.patrol.common.enums.PlanTaskExecution;
import com.yeejoin.amos.patrol.common.enums.PlanTaskFinishStatusEnum;
import com.yeejoin.amos.patrol.common.enums.TaskStatisticsTypeEnum;
import com.yeejoin.amos.patrol.service.business.service.intfc.IAppService;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
//import com.yeejoin.amos.security.common.authorization.Authorization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.UUID;


@RestController
@RequestMapping(value = "/api/common")
@Api(tags = "公共接口api")
public class CommonController extends BaseController {

    @Autowired
    private IAppService iAppService;

    @Value("${upload.server.address}")
    private String uploadServerAddress;

    @Value("${upload.root.path}")
    private String uploadRootPath;

    @ApiOperation(value = "任务统计口径类型", notes = "任务统计口径类型")
    @RequestMapping(value = "/taskgetStatisticsType", method = RequestMethod.GET)
    public CommonResponse getTaskStatisticsType() {
        return CommonResponseUtil.success(TaskStatisticsTypeEnum.getEnumList());
    }

    @ApiOperation(value = "巡检统计口径类型", notes = "巡检统计口径类型")
    @RequestMapping(value = "/checkStatisticsType", method = RequestMethod.GET)
    public CommonResponse getCheckStatisticsType() {
        return CommonResponseUtil.success(CheckStatisticsTypeEnum.getEnumList());
    }

    @ApiOperation(httpMethod = "GET", value = "计划任务完成种类", notes = "计划任务完成种类")
    @RequestMapping(value = "/planTaskFinishStatus", method = RequestMethod.GET)
    public CommonResponse getPlanTaskFinishStatus() {
        return CommonResponseUtil.success(PlanTaskFinishStatusEnum.getEnumList());
    }

    @ApiOperation(value = "计划任务执行情况种类", notes = "计划任务执行情况种类")
    @RequestMapping(value = "/planTaskExecution", method = RequestMethod.GET)
    public CommonResponse getPlanTaskExecution() {
        return CommonResponseUtil.success(PlanTaskExecution.getEnumList());
    }

    @ApiOperation(value = "获取app最新版本信息", notes = "获取app最新版本信息")
    @RequestMapping(value = "/queryAppVersion", method = RequestMethod.GET)
   // @Authorization(ingore = true)
    public CommonResponse getAppLastVersion() {
        return CommonResponseUtil.success(iAppService.queryAppLastVersion());
    }

    @ApiOperation(value = "获取用户选择的公司部门信息", notes = "获取用户选择的公司部门信息")
    @GetMapping(value = "/getSelectedInfo")
    public CommonResponse getSelectedInfo() {
        return CommonResponseUtil.success(getSelectedOrgInfo());
    }

    @ApiOperation(value = "获取用户是否有待办信息", notes = "获取用户是否有待办信息")
    @GetMapping(value = "/getHaveToDo")
    public CommonResponse getHaveToDo() {
        return iAppService.getHaveToDo(getUserId());
    }

    @ApiOperation(value = "上传相关图片", notes = "上传相关图片")
    @PostMapping(value = "/upload")
    public CommonResponse upload(@ApiParam(value = "图片类型(隐患图片：latent_danger；评审拍照：latent_danger_review；" +
            "治理拍照：latent_danger_reform；整改拍照：latent_danger_recheck；风险研判：risk_judgement；作业活动：task_work)", required = true) @RequestParam String bizCode,
                                 @ApiParam(value = "检查图片", required = true) @RequestPart("file") MultipartFile file) {
        PhotoBizCodeEnum bizCodeEnum = PhotoBizCodeEnum.getByCode(bizCode);
        if (bizCodeEnum == null) {
            return CommonResponseUtil.failure("图片类型有误");
        }
        String originalFilename = file.getOriginalFilename();
        String fileName = UUID.randomUUID().toString() + originalFilename.substring(originalFilename.lastIndexOf("."));
        String returnPath = XJConstant.IMG + "/" + bizCode + "/" + fileName;
        String realPath = uploadRootPath + returnPath;
        try {
            File dest = new File(realPath);
            if (!dest.exists()) {
                if (dest.getParentFile() != null && !dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                }
                dest.createNewFile();
            }
            file.transferTo(dest);
            return CommonResponseUtil.success(uploadServerAddress + returnPath);
        } catch (IOException e) {
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }
}
