package com.yeejoin.amos.patrol.service.business.controller;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.service.business.dao.mapper.ConfigMapper;
//import com.yeejoin.amos.security.common.authorization.Authorization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * 获取主题信息
 */
@RestController
@RequestMapping(value = "/api/config")
@Api(tags = "配置接口api")
public class ConfigController extends BaseController {

    @Autowired
    private ConfigMapper configMapper;

    /**
     * <pre>
     * 获取配置接口信息
     * </pre>
     */
   // @Authorization(ingore = true)
    @ApiOperation(value = "获取配置接口信息", notes = " 获取配置接口信息")
    @RequestMapping(value = "/getConfigsInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getConfigsInfo() {
        return CommonResponseUtil.success(configMapper.listAll());
    }


}
