package com.yeejoin.amos.patrol.service.business.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.service.business.service.impl.TaskReportServiceImpl;
//import com.yeejoin.amos.security.common.authorization.Authorization;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Map;

@Controller
@RequestMapping(value = "/api/excel")
@Api(tags = "巡检完成情况月报表")
public class ExcelExportController extends BaseController {

    @Autowired
    private TaskReportServiceImpl taskReportService;

    /**
     * 巡检完成情况月报表导出excel
     *
     * @param statistical 统计类型
     * @param startDate   统计开始时间
     * @param endDate     统计结束时间
     * @param planId      计划ID
     * @param routeId     路线ID
     * @return 导出格式为：vnd.ms-excel
     */
    //@Authorization(ingore = true)
    @ApiOperation(value = "巡检完成情况月报表导出excel", notes = " 巡检完成情况月报表导出excel")
    @RequestMapping(value = "/task/{statistical}", produces = "application/vnd.ms-excel;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse taskReport(
            @ApiParam(value = "统计口径", required = true) @PathVariable String statistical,
            @ApiParam(value = "开始日期", required = true) @RequestParam String startDate,
            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate,
            @ApiParam(value = "所属计划") @RequestParam(required = false) Integer planId,
            @ApiParam(value = "所属路线") @RequestParam(required = false) Integer routeId,
            HttpServletResponse response) throws Exception {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        startDate += " 00:00:00";
        endDate += " 23:59:59";
        Map<String, Object> map = taskReportService.queryForTaskReport(getToken(),getProduct(),getAppKey(),statistical, loginOrgCode, startDate, endDate, planId, routeId);


        Map summation = (Map) map.get("summation");

        for (Object key : summation.keySet())
            map.put("summation" + key, summation.get(key));

        String template = "temp/reportExportTemplate.xls";
        this.writToResponse(map, response, template, "report.xls");

        return CommonResponseUtil.success();
    }


    //@Authorization(ingore = true)
    @ApiOperation(value = "  人员综合统计分析Excel导出", notes = " 人员综合统计分析Excel导出")
    @RequestMapping(value = "/comprehensive/user", produces = "application/vnd.ms-excel;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse comprehensiveStatisticalForUser(
            @ApiParam(value = "开始日期", required = true) @RequestParam String startTime,
            @ApiParam(value = "结束日期", required = true) @RequestParam String endTime,
            HttpServletResponse response) throws Exception {
    	 ReginParams reginParams = getSelectedOrgInfo();
         String loginOrgCode = getLoginOrgCode(reginParams);
        Map<String, Object> map = taskReportService.comprehensiveStatisticalForUser(getToken(),getProduct(),getAppKey(),startTime, endTime,loginOrgCode);

        Map summation = (Map) map.get("summation");

        for (Object key : summation.keySet())
            map.put("summation" + key, summation.get(key));
        String template = "temp/comprehensiveStatistical.xls";
        this.writToResponse(map, response, template, "comprehensiveStatistical.xls");
        return CommonResponseUtil.success();
    }


    private void writToResponse(Map data, HttpServletResponse response, String templateFileName, String outFileName) throws Exception {
        Resource resource = new ClassPathResource(templateFileName);


        File file = resource.getFile();
        TemplateExportParams params = new TemplateExportParams(file.getAbsolutePath(), true);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();

        Workbook book = ExcelExportUtil.exportExcel(params, data);
        book.write(bout);

        response.setHeader("Content-Disposition", "attachment; filename=" + outFileName);
        response.setHeader("content-length", bout.size() + "");
        response.getOutputStream().write(bout.toByteArray());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }


}
