package com.yeejoin.amos.patrol.service.business.controller;

import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;


//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
//import com.yeejoin.amos.security.common.model.UserModel;

//import MailUtil;

/**
 * 获取部门、公司信息
 *
 * @author gaodongdong
 */
@RestController
@RequestMapping(value = "/api/group")
@Api(tags = "公司，部门数据api")
public class GroupController extends BaseController {

    private final Logger log = LoggerFactory.getLogger(GroupController.class);

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    
    
    
    
    
    
    /**
     * 部门查询
     *
     * @return
     */
    @ApiOperation(value = "获取当前用户所属公司的所有部门", notes = "获取当前用户所属公司的所有部门")
    @RequestMapping(value = "/queryDept1", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCurrentCompanyDept1() {
        ReginParams reginParams = getSelectedOrgInfo();
        String dep = reginParams.getCompany().getSequenceNbr();
        List<DepartmentModel> departmentModels =null;
       
        //判断当前登录用 
        if(reginParams.getDepartment()==null){
           departmentModels = remoteSecurityService.listDepartmentsByCompanyId(getToken(), getProduct(), getAppKey(), dep);

        	
        }else{
        	
         departmentModels = remoteSecurityService.listDepartmentsByCompanyId1(getToken(), getProduct(), getAppKey(), reginParams.getDepartment().getSequenceNbr());
        	
        	
        }
        List<DepartmentBo> departmentBos = ModelToBo(departmentModels);
        
        if(reginParams.getDepartment()!=null){
        	 DepartmentBo  ddd=new DepartmentBo();
             ddd.setSequenceNbr(reginParams.getDepartment().getSequenceNbr());
             ddd.setDepartmentName(reginParams.getDepartment().getDepartmentName());
             departmentBos.add(ddd);
         	
         }
       
        
        return CommonResponseUtil.success(departmentBos);
    }
    
    
    /**
     * 部门查询
     *
     * @return
     */
    @ApiOperation(value = "获取当前用户所属公司的所有部门", notes = "获取当前用户所属公司的所有部门")
    @RequestMapping(value = "/queryDept2", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCurrentCompanyDept2() {
        ReginParams reginParams = getSelectedOrgInfo();
        String dep = reginParams.getCompany().getSequenceNbr();
        List<DepartmentModel> departmentModels =null;     
        //判断当前登录用 
       departmentModels = remoteSecurityService.listDepartmentsByCompanyId(getToken(), getProduct(), getAppKey(), dep);
       List<DepartmentBo> departmentBos = ModelToBo(departmentModels);
         return CommonResponseUtil.success(departmentBos);
    }
    
    
    
    
    
    

    /**
     * 部门查询
     *
     * @return
     */
    @ApiOperation(value = "获取当前用户所属公司的所有部门", notes = "获取当前用户所属公司的所有部门")
    @RequestMapping(value = "/queryDept", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCurrentCompanyDept() {
        ReginParams reginParams = getSelectedOrgInfo();
        String dep = reginParams.getCompany().getSequenceNbr();
        List<DepartmentModel> departmentModels = remoteSecurityService.listDepartmentsByCompanyId(getToken(), getProduct(), getAppKey(), dep);
        List<DepartmentBo> departmentModels1=new ArrayList<>();
        List<DepartmentBo> departmentBos = ModelToBo(departmentModels);
        //判断当前登录用 
        if(reginParams.getDepartment()==null){
        	departmentModels1=departmentBos;
        	
        }else{
        	
        	for (DepartmentBo departmentModel : departmentBos) {
        		if(departmentModel.getDepartmentName().equals(reginParams.getDepartment().getDepartmentName())){
        			
        			departmentModels1.add(departmentModel);
        		}
        		
			}
        	
        	
        }
        
      
        
        
        return CommonResponseUtil.success(departmentModels1);
    }
//
//	/**
//	 * 部获取指定公司ID的所有末端公司信息
//	 * @param companyId
//	 * @return
//	 */
//	@ApiOperation(value = "根据指定公司ID获取公司和所属公司的子公司信息", notes = "根据指定公司ID获取公司和所属公司的子公司信息")
//	@RequestMapping(value = "/queryCompanyLeaves", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
//	public CommonResponse queryCompanyLeavesById(@ApiParam(value="公司Id") @RequestParam("companyId") String companyId) {
//		try {
//			if (ObjectUtils.isEmpty(companyId)) {
//				return CommonResponseUtil.failure("companyId is empty!!!");
//			}
//			CommonResponse amosRes = amosSecurityServer.queryCompanyLeavesById(companyId);
//			List response = getLeaves((List<LinkedHashMap<String, Object>>) amosRes.getDataList());
//			return CommonResponseUtil.success(response);
//		}catch (Exception e) {
//			return CommonResponseUtil.failure(e.getMessage());
//		}
//	}

    /**
     * 根据用户所有属公司ID，查询所有子公司末端公司信息
     *
     * @return
     */
    @ApiOperation(value = "获取用户所属公司和所属公司的子公司信息", notes = "获取用户所属公司和所属公司的子公司信息")
    @RequestMapping(value = "/queryAuthCompanyLeaves", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryAuthCompanyLeaves() {
        try {
            ReginParams reginParams = new ReginParams();
            String companyId = getCompanyId(reginParams);
            List<CompanyModel> companyBos = remoteSecurityService.getCompanyTreeByCompanyId(getToken(), getProduct(), getAppKey(), companyId);
            return CommonResponseUtil.success(companyBos);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

//	/**
//	 * 递归调用获取list中的末端节点
//	 * @return
//	 */
//	private List<LinkedHashMap<String, Object>> getLeaves(List<CompanyBo> companyBos) {
//		List<LinkedHashMap<String, Object>> dest = new ArrayList<>();
//		for (CompanyBo companyBo : companyBos) {
//			if (ObjectUtils.isEmpty(companyBo.get)) {
//				dest.add(leaves);
//			} else {
//				List<LinkedHashMap<String, Object>> list = getLeaves((List<LinkedHashMap<String, Object>>) leaves.get("children"));
//				dest.addAll(list);
//			}
//
//		}
//		return dest;
//	}

////	@Autowired
////	private AsyncTask asyncTask;
//	@Autowired
//	private IMessageService messageService;
//	@Authorization(ingore=true)
//	@ApiOperation(value = "获取指定公司ID的所有末端公司信息", notes = "获取指定公司ID的所有末端公司信息")
//	@RequestMapping(value = "/mail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
//	public CommonResponse getKey() {
//		try {
////			List<String> email = new ArrayList<>();
////			email.add("15809295445");
//////			email.add("maoying@yeejoin.com");
////			String[] e = email.toArray(new String[email.size()]);
////			long start = System.currentTimeMillis();
////			PushMsgParam msgResponse = new PushMsgParam();
////			msgResponse.setEmails(e);
////			msgResponse.setSubject("邮件测试");
////			msgResponse.setContent("你好");
////
////
//////			emailService.sendSimpleEmail(e,"测试","嘎嘎嘎嘎");
////			List<PushMsgParam> pmps = new ArrayList<PushMsgParam>();
////			PushMsgParam pushMsgParam = new PushMsgParam();
////			pushMsgParam.setRecivers(email);
////			pushMsgParam.setType(JPushTypeEnum.ALIAS.getCode());
////			pushMsgParam.setSubject("测试");
////			pushMsgParam.setContent("测试内容");
////			pmps.add(pushMsgParam);
////			appMessagePushService.sendMessage(pmps);
////			 long end = System.currentTimeMillis();
////			 String result = "任务完成，一共用时为："+(end-start)+"毫秒";
////			 System.out.println(result);
//
//			return CommonResponseUtil.success();
//		}catch (Exception e) {
//			log.error(e.getMessage());;
//			return CommonResponseUtil.failure(e.getMessage());
//		}
//	}
//
//
//
//	@Autowired
//	private ISafety3DDataSendService safety3DDataSend;
//	@Authorization(ingore=true)
//	@ApiOperation(value = "检查点状态推送", notes = "检查点状态推送")
//	@RequestMapping(value = "/testCheckPushStatus", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
//	public CommonResponse testCheckPushStatus(@ApiParam(value="Id") @RequestParam("checkId") long checkId) {
//		try {
////			asyncTask.pushCheckInfoTo3D(checkId);
////			messageService.pushCheckMessage(checkId);
//			return CommonResponseUtil.success();
//		}catch (Exception e) {
//			log.error(e.getMessage());;
//			return CommonResponseUtil.failure(e.getMessage());
//		}
//	}
//
//	@Authorization(ingore=true)
//	@ApiOperation(value = "任务状态推送", notes = "任务状态推送")
//	@RequestMapping(value = "/testTaskPushStatus", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
//	public CommonResponse testTaskPushStatus(@ApiParam(value="Id") @RequestParam("checkId") Long taskId) {
//		try {
//			TaskInfoRespone taskInfoRespone = safety3DDataSend.taskDetailInfoPush(taskId);
//			return CommonResponseUtil.success(taskInfoRespone);
//		}catch (Exception e) {
//			log.error(e.getMessage());;
//			return CommonResponseUtil.failure(e.getMessage());
//		}
//	}
//
//	@Authorization(ingore=true)
//	@ApiOperation(value = "巡检点信息", notes = "巡检点信息")
//	@RequestMapping(value = "/pointInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
//	public CommonResponse getPointInfo(@ApiParam(value="Id") @RequestParam("pointId") Long pointId) {
//		try {
////			asyncTask.pushTaskDetailInfoTo3D(taskId);
//			List<Long> ids = new ArrayList<>();
//			ids.add(pointId);
//			return CommonResponseUtil.success(safety3DDataSend.pushPointTo3D(ids));
//		}catch (Exception e) {
//			log.error(e.getMessage());;
//			return CommonResponseUtil.failure(e.getMessage());
//		}
//	}

    /**
     * 类型转换  DepartmentModel => DepartmentBo
     * @param departmentModels
     * @return
     */
    private List<DepartmentBo> ModelToBo(List<DepartmentModel> departmentModels){
        List<DepartmentBo> departmentBos = new ArrayList<>();
        departmentModels.forEach(
          x -> {
              DepartmentBo departmentBo = new DepartmentBo();
              departmentBo.setSequenceNbr(x.getSequenceNbr().toString());
              departmentBo.setCompanySeq(x.getCompanySeq().toString());
              departmentBo.setDepartmentDesc(x.getDepartmentDesc());
              departmentBo.setDepartmentName(x.getDepartmentName());
              departmentBo.setDeptOrgCode(x.getOrgCode());
              departmentBo.setLevel(x.getLevel());
              departmentBo.setOrgCode(x.getOrgCode());
              departmentBo.setParentId(x.getParentId().toString());
              if (!ObjectUtils.isEmpty(x.getChildren())) {
                  Object collect = x.getChildren().stream().collect(Collectors.toList());
                  List<LinkedHashMap> children = (List<LinkedHashMap>) collect;
                  //departmentBo.setChildren(children);
                  departmentBos.addAll(ModelToBo2(children));
              }
              departmentBos.add(departmentBo);
          }
        );
        return departmentBos;
    }
    
    private List<DepartmentBo> ModelToBo2(List<LinkedHashMap> departmentModels){
        List<DepartmentBo> departmentBos = new ArrayList<>();
        departmentModels.forEach(
          x -> {
              DepartmentBo departmentBo = new DepartmentBo();
              departmentBo.setSequenceNbr(x.get("sequenceNbr").toString());
              departmentBo.setCompanySeq(x.get("companySeq").toString());
              departmentBo.setDepartmentDesc(x.get("departmentDesc")+"");
              departmentBo.setDepartmentName(x.get("departmentName")+"");
              departmentBo.setDeptOrgCode(x.get("orgCode")+"");
              departmentBo.setLevel(x.get("level")+"");
              departmentBo.setOrgCode(x.get("orgCode")+"");
              departmentBo.setParentId(x.get("parentId")+"");
              
              if (x.get("children")!=null) {
            	  List<LinkedHashMap> collect = (List<LinkedHashMap>) x.get("children");
            	  departmentBos.addAll( ModelToBo2(collect));         	     
              }
              departmentBos.add(departmentBo);
          }
        );
        return departmentBos;
    }
}
