package com.yeejoin.amos.patrol.service.business.controller;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.service.business.service.intfc.ICheckService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPointService;
import com.yeejoin.amos.patrol.service.business.service.intfc.ITaskService;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping(value = "/api/home")
@Api(tags = "首页api")
public class HomeController extends BaseController {

    @Autowired
    private ICheckService checkService;

    @Autowired
    private IPointService iPointService;

    @Autowired
    private ITaskService taskService;

    @Autowired
    private IPlanTaskService planTaskService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @ApiOperation(value = "首页数据", notes = "首页数据")
    @GetMapping(value = "/overviewData")
    public CommonResponse init() {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String companyName = getCompanyName(reginParams);
        HashMap<String, Object> response = new HashMap<>();
        HashMap<String, Object> statusList = new HashMap<>();
        
        //巡检点按公司过滤
        String orgcode=reginParams.getCompany().getOrgCode();
        long point = iPointService.getPointCountByOrgCode(orgcode);
        
        String task = taskService.getTaskFinishCountByOrgCode(loginOrgCode);
        long check = checkService.getCumulativeCheckCountByOrgCode(loginOrgCode);
        String plan = planTaskService.getCumulativePlanCountByOrgCode(loginOrgCode);
        if(task==null){
        	task="0/0";
        }
        if(plan==null){
        	task="0/0";
        }
       
        statusList.put("point", point);
        statusList.put("task", task);
        statusList.put("check", check);
        statusList.put("plan", plan);
        response.put("company", companyName);
        response.put("statusList", statusList);
        return CommonResponseUtil.success(response);
    }

    @ApiOperation(value = "测试安全", notes = "测试安全")
    @GetMapping(value = "/listDepartmentData")
    public CommonResponse listDepartmentData() {
        return CommonResponseUtil.success(remoteSecurityService.getDepartmentTreeByCompanyId(getToken(),getProduct(),getAppKey(),"12321"));
    }

    @ApiOperation(value = "首页数据", notes = "首页数据")
    @GetMapping(value = "/getCheckData")
    public CommonResponse getCheckData() {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        SimpleDateFormat sdf = new SimpleDateFormat("MM月dd日");
        SimpleDateFormat sdf1 = new SimpleDateFormat("YYYY-MM-dd");
        List<String> xAxis = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DATE, -11);
        String startTime = sdf1.format(calendar.getTime());
        for (int i = 0; i < 12; i++) {
            xAxis.add(sdf.format(calendar.getTime()));
            calendar.add(Calendar.DATE, 1);
        }
        String endTime = sdf1.format(calendar.getTime());
        HashMap<String, Object> param = new HashMap<>();
//        if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName) ||
//                XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName)) {
//            param.put("orgCode", loginOrgCode);
//        } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
//            param.put("orgCode", loginOrgCode);
//        } else {
//            param.put("userId", userId);
//        }
        param.put("orgCode", loginOrgCode);
        param.put("endTime", endTime);
        param.put("startTime", startTime);
        param.put("param", '3');
        param.put("type", 1);
        List<Long> check = checkService.getCheckDataCount(param);
        param.put("type", 2);
        param.put("param", 0);
        List<Long> plan = checkService.getCheckDataCount(param);
        param.put("type", 3);
        param.put("param", '3');
        List<Long> missed = checkService.getCheckDataCount(param);
        HashMap<String, Object> response = new HashMap<>();
        response.put("check", check);
        response.put("plan", plan);
        response.put("missed", missed);
        response.put("xAxis", xAxis);
        return CommonResponseUtil.success(response);
    }
}