package com.yeejoin.amos.patrol.service.business.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.UserModel;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.enums.LatentDangerLevelEnum;
import com.yeejoin.amos.patrol.service.business.dto.ExecuteSubmitDto;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerExcuteParam;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerListParam;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerNormalParam;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerPatrolParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ILatentDangerService;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
//import com.yeejoin.amos.security.common.model.UserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
//import liquibase.util.StringUtils;

@RestController
@RequestMapping(value = "/api/latent/danger")
@Api(tags = "隐患接口api")
public class LatentDangerController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(LatentDangerController.class);

    @Autowired
    private ILatentDangerService iLatentDangerService;
    
 

    @ApiOperation(value = "创建无码无计划隐患", notes = "创建无码无计划隐患")
    @PostMapping(value = "/normal/save")
    public CommonResponse saveNormal(@ApiParam(value = "隐患对象", required = true) @RequestBody LatentDangerNormalParam latentDangerParam) {
//        try {
//            UserModel user = getUserInfo();
//            if (ObjectUtils.isEmpty(user)) {
//                return CommonResponseUtil.failure("用户session过期");
//            }
//            if (LatentDangerLevelEnum.getByCode(latentDangerParam.getDangerLevel()) == null) {
//                return CommonResponseUtil.failure("隐患等级有误");
//            }
//            ReginParams reginParams = getSelectedOrgInfo();
//            String loginOrgCode = getLoginOrgCode(reginParams);
//            String deptId = getDepartmentId(reginParams);
//            String companyId = getCompanyId(reginParams);
//            String departmentName = getDepartmentName(reginParams);
//            return iLatentDangerService.saveNormal(latentDangerParam, user.getUserId(),
//                    user.getRealName(), deptId, departmentName, companyId, loginOrgCode, getToken());
//        } catch (Exception e) {
//            logger.error("创建普通隐患异常", e);
//            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
//        }
    	 return CommonResponseUtil.success();
    }

    @ApiOperation(value = "创建巡检隐患", notes = "创建巡检隐患")
    @PostMapping(value = "/patrol/save")
    public CommonResponse savePatrol(@ApiParam(value = "隐患对象", required = true) @RequestBody LatentDangerPatrolParam latentDangerPatrolParam) {
//        try {
//            UserModel user = getUserInfo();
//            if (ObjectUtils.isEmpty(user)) {
//                return CommonResponseUtil.failure("用户session过期");
//            }
//            ReginParams reginParams = getSelectedOrgInfo();
//            String loginOrgCode = getLoginOrgCode(reginParams);
//            String deptId = getDepartmentId(reginParams);
//            String companyId = getCompanyId(reginParams);
//            String departmentName = getDepartmentName(reginParams);
//            return iLatentDangerService.savePatrol(latentDangerPatrolParam, user.getUserId(),
//                    user.getRealName(), deptId, departmentName, companyId, loginOrgCode, getToken());
//        } catch (Exception e) {
//            logger.error("创建巡检隐患异常", e);
//            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
//        }
    	 return CommonResponseUtil.success();
    }

    @ApiOperation(value = "隐患列表", notes = "隐患列表")
    @PostMapping(value = "/list")
    public CommonResponse list(@ApiParam(value = "隐患对象", required = true) @RequestBody LatentDangerListParam latentDangerListParam) {
        try {
        	AgencyUserModel user = getUserInfo();
            if (ObjectUtils.isEmpty(user)) {
                return CommonResponseUtil.failure("用户session过期");
            }
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            String deptId = getDepartmentId(reginParams);
            return iLatentDangerService.list(getToken(),getProduct(),getAppKey(),latentDangerListParam, user.getUserId(),loginOrgCode,deptId);
        } catch (Exception e) {
            logger.error("隐患列表异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "隐患详情", notes = "隐患详情")
    @GetMapping(value = "/detail")
    public CommonResponse detail(@ApiParam(value = "隐患编号", required = true) @RequestParam Long id) {
        try {
        	AgencyUserModel user = getUserInfo();
            if (ObjectUtils.isEmpty(user)) {
                return CommonResponseUtil.failure("用户session过期");
            }
            return iLatentDangerService.detail(getToken(),getProduct(),getAppKey(),id, user.getUserId());
        } catch (Exception e) {
            logger.error("隐患详情异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "隐患执行记录", notes = "隐患执行记录")
    @GetMapping(value = "/listFlowRecord")
    public CommonResponse listFlowRecord(@ApiParam(value = "隐患编号", required = true) @RequestParam Long id) {
        try {
        	AgencyUserModel user = getUserInfo();
            if (ObjectUtils.isEmpty(user)) {
                return CommonResponseUtil.failure("用户session过期");
            }
            return iLatentDangerService.listFlowRecord(getToken(),getProduct(),getAppKey(),id);
        } catch (Exception e) {
            logger.error("隐患执行记录异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "流程执行", notes = "流程执行")
    @PostMapping(value = "/excute")
    public CommonResponse excute(@ApiParam(value = "隐患对象", required = true) @RequestBody LatentDangerExcuteParam latentDangerExcuteParam) {
        try {
        	AgencyUserModel user = getUserInfo();
            if (ObjectUtils.isEmpty(user)) {
                return CommonResponseUtil.failure("用户session过期");
            }
            ReginParams reginParams = getSelectedOrgInfo();
            String deptId = getDepartmentId(reginParams);
            String departmentName = getDepartmentName(reginParams);
            String userRealName = user.getRealName();
            String userId = user.getUserId();
            ExecuteSubmitDto executeSubmitDto = iLatentDangerService.excute(latentDangerExcuteParam, userId,
                    userRealName, deptId, departmentName, getToken());
            iLatentDangerService.freshRiskJudgmentLangerCount(latentDangerExcuteParam);//更新统计
            if (executeSubmitDto.getOk()) {
                if (!StringUtils.isEmpty(executeSubmitDto.getPointOriginalId())) {
                    iLatentDangerService.sendLatentDangerExcuteResult(executeSubmitDto);
                }
                return CommonResponseUtil.success();
            } else {
                return CommonResponseUtil.failure(executeSubmitDto.getMsg());
            }
        } catch (Exception e) {
            logger.error("流程执行异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "根据流程实例编号获取隐患信息", notes = "根据流程实例编号获取隐患信息")
    @GetMapping(value = "/getByInstanceId")
    public CommonResponse getByInstanceId(@ApiParam(value = "流程实例编号", required = true) @RequestParam String instanceId) {
        try {
        	AgencyUserModel user = getUserInfo();
            if (ObjectUtils.isEmpty(user)) {
                return CommonResponseUtil.failure("用户session过期");
            }
            return iLatentDangerService.getByInstanceId(getToken(),getProduct(),getAppKey(),instanceId);
        } catch (Exception e) {
            logger.error("根据流程实例编号获取隐患信息异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "隐患按错计划流程执行回调", notes = "隐患按错计划流程执行回调")
    @PostMapping(value = "/plan/flow/excuteCallBack")
    public CommonResponse excuteCallBack(@ApiParam(value = "隐患按错计划流程执行回调对象") @RequestBody JSONObject json) {
        try {
        	AgencyUserModel user = getUserInfo();
            if (ObjectUtils.isEmpty(user)) {
                return CommonResponseUtil.failure("用户session过期");
            }
            String instanceId = json.getString("instanceId");
            Integer actionType = json.getInteger("actionType");
            String remark = json.getString("remark");
            ReginParams reginParams = getSelectedOrgInfo();
            String deptId = getDepartmentId(reginParams);
            String departmentName = getDepartmentName(reginParams);
            ExecuteSubmitDto executeSubmitDto = iLatentDangerService.excuteCallBack(instanceId, actionType, remark,
                    getToken(), user.getUserId(), user.getRealName(), deptId, departmentName);
            if (executeSubmitDto.getOk()) {
                if (!StringUtils.isEmpty(executeSubmitDto.getPointOriginalId())) {
                    iLatentDangerService.sendLatentDangerExcuteResult(executeSubmitDto);
                }
                return CommonResponseUtil.success();
            } else {
                return CommonResponseUtil.failure(executeSubmitDto.getMsg());
            }
        } catch (Exception e) {
            logger.error("隐患按错计划流程执行回调异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }
}
