package com.yeejoin.amos.patrol.service.business.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;
import com.yeejoin.amos.patrol.common.entity.*;
import com.yeejoin.amos.patrol.common.enums.MsgSubscribeTypeEnum;
import com.yeejoin.amos.patrol.service.business.param.MsgInfoPageParam;
import com.yeejoin.amos.patrol.service.business.param.NoticePublishParam;
import com.yeejoin.amos.patrol.service.business.param.UserMsgInitParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IAppService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IMessageService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IMsgSubscribeService;
import com.yeejoin.amos.patrol.service.business.util.MsgParamUtils;
import com.yeejoin.amos.patrol.service.business.vo.MsgVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import com.yeejoin.amos.patrol.service.quartz.IJobService;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
//import com.yeejoin.amos.security.common.authorization.Authorization;
//import com.yeejoin.amos.security.common.model.UserModel;


/**
 * 消息订阅接口   --- 手机
 *
 * @author gaodongdong
 */
@RestController
@RequestMapping("/api/msgSubscribe")
@Api(value = "手机--消息订阅", tags = "消息模块api")
public class MsgController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(MsgController.class);

    @Autowired
    private IMsgSubscribeService msgSubscribeService;

    @Autowired
    private IMessageService iMsgService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;
    
    @Autowired
    private IJobService jobService;

    @Autowired
    private IAppService iAppService;

    /**
     * 获取用户当前所选择公司的消息订阅信息
     */
    @ApiOperation(value = "获取用户当前所选择公司的消息订阅信息", notes = "获取用户当前所选择公司的消息订阅信息")
    @GetMapping(value = "/querySubscribe", produces = "application/json;charset=UTF-8")
    public CommonResponse queryMsgSetting() {
    	AgencyUserModel userModel = getUserInfo();
        String userId = userModel.getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
//        String departmentId = getDepartmentId(reginParams);
//        List<HashMap<String, Object>> routeList = routeService.queryRouteListByOrgCode(loginOrgCode, userId, departmentId);

        UserMsgInitParam userInitParam = new UserMsgInitParam();
        userInitParam.setOrgCode(loginOrgCode);
        userInitParam.setUserId(userId);
        userInitParam.setUserRealName(userModel.getRealName());
        List<MsgSubscribe> msgSubs = iAppService.saveUserMsgInit(userInitParam); // 获取搜友消息推送类型
//        emailType = setupSelectItem(emailType, msgSubs); //标记已经选择的邮件消息推送类型
//        checkType = setupSelectItem(checkType, msgSubs); // 标记已经选择的检查类型消息 List<Map<String, Object>> checkType = CheckTypeEnum.getEnumList();
        JSONObject response = new JSONObject();
        for (MsgSubscribe msgSubscribe : msgSubs) {
        	
        	 
			try {
				/*Map<String, Object> map= objectToMap(msgSubscribe);
			
				map.put("createDate", msgSubscribe.getCreateDate().getTime());*/
				
            MsgSubscribeTypeEnum typeEnum = MsgSubscribeTypeEnum.getByMsgType(msgSubscribe.getMsgType());
            if (typeEnum != null) {
                JSONArray array = response.getJSONArray(typeEnum.getType());
                if (array == null) {
                    array = new JSONArray();
                    array.add(msgSubscribe);
                } else {
                    array.add(msgSubscribe);
                }
                response.put(typeEnum.getType(), array);
            }
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        }
        return CommonResponseUtil.success(response);
//        /**
//         * 获取所有已经选择的路线id数组
//         */
//        String sRoutes = "";
//        for (MsgSubscribe msg : msgSubs) {
//            if ("route".equals(msg.getMsgType())) {
//                sRoutes = msg.getAttribute1();
//            }
//        }
//        List<Map<String, Object>> respRoute = new ArrayList<>();
//        if (!ObjectUtils.isEmpty(sRoutes)) {
//            String[] aRoutes = sRoutes.split(",");
//            for (HashMap<String, Object> route : routeList) {
//                for (String s : aRoutes) {
//                    if (!ObjectUtils.isEmpty(s) && s.equals(route.get("id"))) {
//                        route.put("selected", true);
//                        respRoute.add(route);
//                        break;
//                    } else {
//                        respRoute.add(route);
//                    }
//                }
//            } //将已经选择的路线标记位已选择
//
//        }
    }
    public static Map<String, Object> objectToMap(Object obj) throws IllegalAccessException {
        Map<String, Object> map = new HashMap<String,Object>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = nvl(field.get(obj));
            map.put(fieldName, value);
        }
        return map;
    }
    public static Object nvl(Object param) {  
        return param != null ? param : null;  
    } 
    /**
     * 保存用户消息订阅信息
     */
    @ApiOperation(value = "保存用户消息订阅信息", notes = "保存用户消息订阅信息")
    @PostMapping(value = "/saveSubscribe", produces = "application/json;charset=UTF-8")
    public CommonResponse saveSubscribe(@ApiParam(value = "消息订阅信息") @RequestBody(required = false) List<MsgSubscribe> subscribe) {
        try {
        	AgencyUserModel user = getUserInfo();
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            for (MsgSubscribe s : subscribe) {
                s.setOrgCode(loginOrgCode);
                s.setUserId(user.getUserId());
                //s.setUserName(user.getUserName());
            }
            msgSubscribeService.saveSubscribe(subscribe);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }

        return CommonResponseUtil.success();
    }

//    private List<Map<String, Object>> setupSelectItem(List<Map<String, Object>> type, List<MsgSubscribe> msgSubs) {
//        for (Map map : type) {
//            for (MsgSubscribe msg : msgSubs) {
//                if (!msg.getMsgType().equals(map.get("ower"))) continue;
//                if (map.get("code").equals(msg.getAttribute1())) {
//                    map.put("selected", true);
//                    break;
//                }
//            }
//        }
//        return type;
//    }

//    private Map<String, Object> objectToMap(Object obj) throws Exception {
//        if (obj == null)
//            return null;
//
//        Map<String, Object> map = new HashMap<String, Object>();
//
//        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
//        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
//        for (PropertyDescriptor property : propertyDescriptors) {
//            String key = property.getName();
//            if (key.compareToIgnoreCase("class") == 0) {
//                continue;
//            }
//            Method getter = property.getReadMethod();
//            Object value = getter != null ? getter.invoke(obj) : null;
//            map.put(key, value);
//        }
//
//        return map;
//    }

    /**
     * 根据登陆用户APP获取未读消息个数
     */
    @ApiOperation(value = "APP根据登陆用户获取未读消息个数", notes = "APP根据登陆用户获取未读消息个数")
    @GetMapping(value = "/unreadCount", produces = "application/json;charset=UTF-8")
    public CommonResponse getUnreadCount() {
        try {
        	AgencyUserModel user = getUserInfo();
            int count = msgSubscribeService.getUnreadCount(user);
            return CommonResponseUtil.success(count);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    /**
     * 获取消息类型
     */
    @ApiOperation(value = "APP获取消息类型", notes = "APP获取消息类型")
    @GetMapping(value = "/MsgType", produces = "application/json;charset=UTF-8")
    public CommonResponse getMsgType() {
        try {
        	
        //消息类型。从数据字典获取
        	
        	  JSONArray list= remoteSecurityService.listDictionaryByDictCode(getToken(),getProduct(),getAppKey(),"XXLX_TYPE");    
        	  List<Map<String, String>> listdate = Lists.newArrayList();
              if(list!=null &&list.size()>0){
            	  
              	for (int i = 0; i < list.size(); i++) { 
              		Map<String, String> map=new HashMap<>();
              		map.put(list.getJSONObject(i).get("dictDataKey").toString(), list.getJSONObject(i).get("dictDataValue").toString());
              		listdate.add(map);
      			}             	
              }     	
              return CommonResponseUtil.success(listdate);     	
           // return CommonResponseUtil.success(MsgSubscribeTypeEnum.getEnumList());
        } catch (Exception e) {
            return CommonResponseUtil.failure("获取消息类型失败");
        }

    }

    /**
     * 根据条件获取消息列表
     */
    @ApiOperation(value = "APP 根据条件获取消息列表", notes = "APP 根据条件获取消息列表")
    @PostMapping(value = "/msgList", produces = "application/json;charset=UTF-8")
    public CommonResponse queryMsgList(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
        try {
        	AgencyUserModel user = getUserInfo();
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            String roleTypeName = getRoleTypeName(reginParams);
            CommonRequest request = new CommonRequest();
            CommonRequest request1 = new CommonRequest();
            request.setName("userId");
            request.setValue(user.getUserId());
            request1.setName("status");
            request1.setValue(XJConstant.IS_SENT);
            queryRequests.add(request1);
            queryRequests.add(request);
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests, false, loginOrgCode, roleTypeName);
            Page<Msg> msgList = msgSubscribeService.queryMsgList(criterias, commonPageable);
            return CommonResponseUtil.success(msgList);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return CommonResponseUtil.failure("件获取消息列表失败");
        }
    }


    /**
     * 根据条件查询消息列表
     */
    @ApiOperation(value = "根据条件获取消息列表", notes = "APP 根据条件获取消息列表")
    @PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse querylist(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            // String loginOrgCode = getLoginOrgCode(reginParams);
            //放到公司级别
            String loginOrgCode = reginParams.getCompany().getOrgCode();
            String roleTypeName = getRoleTypeName(reginParams);
            HashMap<String, Object> paramMap = buildMybatisDaoCriterias(loginOrgCode, roleTypeName);
            MsgInfoPageParam param = MsgParamUtils.fillMsgInfoParam(queryRequests, commonPageable, paramMap);
            Page<MsgVo> dataList = iMsgService.queryMsgInfoList(param);
            return CommonResponseUtil.success(dataList);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return CommonResponseUtil.failure("根据条件获取消息列表失败");
        }
    }

    /**
     * 修改消失为已读
     */
    @ApiOperation(value = "修改消失为已读", notes = "修改消失为已读")
    @PostMapping(value = "/isRead", produces = "application/json;charset=UTF-8")
    public CommonResponse isRead(
            @ApiParam(value = "消息id", required = true) @RequestBody Long msgId) {
        try {
            Msg msg = msgSubscribeService.isRead(msgId);
            return CommonResponseUtil.success(msg);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return CommonResponseUtil.failure("修改消失为已读失败");
        }
    }

    /**
     * 通知发布
     */
    @ApiOperation(value = "通知发布", notes = "通知发布")
    @PostMapping(value = "/noticePublish", produces = "application/json;charset=UTF-8")
    public CommonResponse noticePublish(@ApiParam(value = "通知信息", required = true) @RequestBody NoticePublishParam msg) {
        try {
        	AgencyUserModel user = getUserInfo();
            msg.setCreateBy(user.getUserId());
            List<Msg> msgList = iMsgService.publishNotice(getToken(),getProduct(),getAppKey(),msg);
            msgList.forEach(m -> jobService.msgAddJob(m));
            return CommonResponseUtil.success();
        } catch (Exception e) {
            return CommonResponseUtil.failure("通知发布失败！");
        }
    }
    
    
    
    /**
     * 告警发布
     */
    //@Authorization(ingore = true)
    @ApiOperation(value = "告警发布", notes = "告警发布")
    @PostMapping(value = "/alarmNotification", produces = "application/json;charset=UTF-8")
    public CommonResponse alarmNotification(@ApiParam(value = "通知信息", required = true) @RequestBody Map<String,Object> map) {
        try {
          
        	
        	NoticePublishParam msg =new NoticePublishParam();
        	//设置为及时发送
        	msg.setIsImmediately(true);
        	msg.setBody(map.get("body").toString());
        	//获取公司code
        	String code=map.get("code").toString();
        	//获取公司单位树
        	List<CompanyModel> companyBoList = remoteSecurityService.listCompanyTree(getToken(),getProduct(),getAppKey(),null);
        	//单位id
        	List depid=new ArrayList();
        	buildUserDeptTreeForWeb(code,depid, companyBoList);
        	//获去单位下所有用户id
        	List listuserid=new ArrayList();
        	if(depid==null||depid.size()<1){
        		return CommonResponseUtil.failure("告警发布失败！");
        	}
        	//单位下部门
        	List<DepartmentModel> ld=remoteSecurityService.listDepartmentsByCompanyId(getToken(),getProduct(),getAppKey(),depid.get(0).toString());
        	
        	for (int i = 0; i < ld.size(); i++) {
        		 List<AgencyUserModel>  kk=	remoteSecurityService.listUserByDepartmentId(getToken(),getProduct(),getAppKey(),ld.get(i).getSequenceNbr()+"");
        		if(kk!=null&&kk.size()>0){
        		 kk.forEach(demo -> {
        			 listuserid.add(demo.getUserId());
        			});
			}
        	}     	      	       	
        	msg.setUserId(listuserid);
            List<Msg> msgList = iMsgService.publishNotice1(getToken(),getProduct(),getAppKey(),msg);           
            return CommonResponseUtil.success();
        } catch (Exception e) {
        	e.printStackTrace();
            return CommonResponseUtil.failure("告警发布失败！");
        }
    }

    /**
     * 添加信息
     */
    @ApiOperation(value = "添加信息", notes = "添加信息")
    @PostMapping(value = "/pushRiskMsg", produces = "application/json;charset=UTF-8")
    public CommonResponse saveMsg(@ApiParam(value = "添加信息", required = true) @RequestBody Map<String, Object> msgMap) {
        try {
            iMsgService.pushRiskMsg(msgMap);
            return CommonResponseUtil.success("保存成功");
        } catch (Exception e) {
            return CommonResponseUtil.failure("保存失败");
        }
    }

    //获取公司depid
    public void buildUserDeptTreeForWeb(String code, List<String>  depid,List<CompanyModel> children) {
    	
        for (int i = 0; i < children.size(); i++) {
        	
        	
        	CompanyModel json =  children.get(i);
            
                if (code.equals(json.getOrgCode())) {
                    
                	depid.add(json.getSequenceNbr().toString());               	
                } 
//                else{
//                	 List<CompanyModel> childrens = (List<CompanyModel>) children.get(i).getChildren();
//                     if (childrens != null && childrens.size() > 0) {
//                         buildUserDeptTreeForWeb(code,depid, childrens);
//                     }
//                }
                
        }
       
    }
    
    
    private void buildUserDeptTreeForWeb(List<String> list, JSONArray children) {
        for (int i = 0; i < children.size(); i++) {
            JSONObject json = children.getJSONObject(i);
            if (json != null && json.size() > 0) {
                if ("user".equals(json.getString("type"))) {
                   
                    Map map = JSONObject.parseObject(json.getString("object"), Map.class);                  
                    list.add(map.get("userId").toString());
                } else {
                    Map map = JSONObject.parseObject(json.getString("object"), Map.class);                    
                    JSONArray childrens = json.getJSONArray("children");
                    if (childrens != null && childrens.size() > 0) {
                        buildUserDeptTreeForWeb(list, childrens);
                    }                    
                }
           }
        }
    }       
}
