package com.yeejoin.amos.patrol.service.business.controller;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.PatrolRoute;
import com.yeejoin.amos.patrol.service.business.service.intfc.PatrolRouteService;
//import com.yeejoin.amos.security.common.authorization.Authorization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: xinglei
 * @Description: 巡检路线Controller
 * @Date: 2019/12/10 16:52
 */
@RestController
@RequestMapping(value = "/api/patrol")
@Api(value = "/api/patrol", tags = {"巡检路线API"})
//@Authorization(ingore = true)
public class PatrolRouteController  extends BaseController  {

    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PatrolRouteController.class);

    @Autowired
    private PatrolRouteService patrolRouteService;

    /**
     * 添加巡检路线信息
     *
     * @return
     */
    @ApiOperation(httpMethod = "POST", value = "添加巡检路线", notes = "添加巡检路线")
    @PostMapping(value = "/addRoute", produces = "application/json;charset=UTF-8")
    public CommonResponse addRoute(@ApiParam(value = "添加巡检路线", required = true) @RequestBody(required = true) PatrolRoute patrolRoute) {
        boolean flag = patrolRouteService.add(getToken(),getProduct(),getAppKey(),patrolRoute);
        if (flag) {
            log.info("======== app调用成功 =========");
            return CommonResponseUtil.success(null,"保存成功");
        } else {
            return CommonResponseUtil.failure(null,"保存失败");
        }
    }
}
