package com.yeejoin.amos.patrol.service.business.controller;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;
import com.yeejoin.amos.patrol.common.core.response.PointResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.common.entity.PointClassify;
import com.yeejoin.amos.patrol.service.business.param.MovePointParam;
import com.yeejoin.amos.patrol.service.business.param.PointImportParam;
import com.yeejoin.amos.patrol.service.business.param.PointImportQueryParam;
import com.yeejoin.amos.patrol.service.business.param.PointParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ICatalogTreeService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPointService;
import com.yeejoin.amos.patrol.service.business.util.FileHelper;
import com.yeejoin.amos.patrol.service.business.util.PointParamUtils;
import com.yeejoin.amos.patrol.service.business.vo.PointClassifyVo;
import com.yeejoin.amos.patrol.service.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.service.business.vo.PointVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
//import com.yeejoin.amos.security.common.authorization.Authorization;
//import com.yeejoin.amos.security.common.model.UserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/api/point")
@Api(tags = "巡检点api")
public class PointController extends BaseController {

    private final Logger log = LoggerFactory.getLogger(PointController.class);

    @Autowired
    private IPointService iPointService;

    @Autowired
    private ICatalogTreeService catalogTreeService;

    @Autowired
    private AsyncTask asyncTask;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    
    /**
     * 增加巡检点
     *
     * @param pointParam
     * @return
     */
    @ApiOperation(value = "新增巡检点", notes = "新增巡检点")
    @PostMapping(value = "/addPoint", produces = "application/json;charset=UTF-8")
    public CommonResponse addPoint(@ApiParam(value = "巡检点", required = true) @RequestBody PointParam pointParam) {
    	AgencyUserModel user = getUserInfo();
        if (ObjectUtils.isEmpty(user)) {
            return CommonResponseUtil.failure("用户session过期");
        }
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            
            //根据选择的部门获取orgcode
            Point point1 = pointParam.getPoint();
            DepartmentModel departmentModel = remoteSecurityService.getDepartmentByDeptId(getToken(),getProduct(),getAppKey(), point1.getChargeDeptId());
            
            if(departmentModel!=null){
            	point1.setOrgCode(departmentModel.getOrgCode());
            	pointParam.setPoint(point1);
            }else{
             pointParam.getPoint().setOrgCode(loginOrgCode);    //点归属于公司
            	
            }
        
            pointParam.getPoint().setCreatorId(user.getUserId());
            //默认值防止报错
            pointParam.getPoint().setOriginalId("0");            
            Point point = iPointService.addPoint(pointParam);
            List<Long> ids = new ArrayList<>();
            ids.add(point.getId());
            asyncTask.pushPointTo3D(ids);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("巡检点新增失败");
        }
    }

    @ApiOperation(value = "新增移动巡检点(<font color='blue'>手机app</font>)", notes = "新增移动巡检点(<font color='blue'>手机app</font>)")
    @PostMapping(value = "/addMovePoint", produces = "application/json;charset=UTF-8")
    public CommonResponse addMovePoint(@RequestBody MovePointParam param) {
    	AgencyUserModel user = getUserInfo();
        if (ObjectUtils.isEmpty(user)) {
            return CommonResponseUtil.failure("用户session过期");
        }
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            param.setOrgCode(loginOrgCode);    //点归属于公司
            param.setCreatorId(user.getUserId());

            iPointService.addMovePoint(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("巡检点新增失败");
        }
    }

    /**
     * 删除巡检点
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "删除巡检点", notes = "删除巡检点")
    @DeleteMapping(value = "/deletePoint", produces = "application/json;charset=UTF-8")
    //@Authorization(ingore = true)
    public CommonResponse deletePoint(@ApiParam(value = "巡检点ID", required = true) @RequestParam Long[] ids) {
        try {
            List<Long> deleteIdList = iPointService.delPointById(ids);
            asyncTask.pushDeletePointTo3D(deleteIdList);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除巡检点失败");
        }
    }

    /**
     * 更新巡检点
     *
     * @param pointParam
     * @return
     */
    @ApiOperation(value = "更新巡检点", notes = "更新巡检点")
    @PutMapping(value = "/updatePoint", produces = "application/json;charset=UTF-8")
    public CommonResponse updatePoint(@ApiParam(value = "巡检点", required = true) @RequestBody PointParam pointParam) {
        try {
        	
        	 //根据选择的部门获取orgcode
            Point point1 = pointParam.getPoint();
            DepartmentModel departmentModel = remoteSecurityService.getDepartmentByDeptId(getToken(),getProduct(),getAppKey(), point1.getChargeDeptId());
            
            if(departmentModel!=null){
            	point1.setOrgCode(departmentModel.getOrgCode());
            	pointParam.setPoint(point1);
            }
        	
            Point point = iPointService.updatePoint(pointParam);
            List<Long> ids = new ArrayList<>();
            ids.add(point.getId());
            asyncTask.pushPointTo3D(ids);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("更新巡检点失败");
        }
    }

    /**
     * 根据ID查询巡检点信息
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "查询巡检点信息", notes = "查询巡检点信息")
    @GetMapping(value = "/queryPointById/{id}", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPointById(@ApiParam(value = "巡检点id", required = true) @PathVariable(name = "id") Long id) {
        try {
            Point point = iPointService.queryPointById(id);
            return CommonResponseUtil.success(point);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点失败");
        }
    }

    @ApiOperation(value = "查询巡检点详情<font color='blue'>手机app</font>)", notes = "查询巡检点详情<font color='blue'>手机app</font>)")
    @GetMapping(value = "/queryPointDetailById", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPointDetailById(@ApiParam(value = "巡检点id", required = true) @RequestParam(name = "pointId") Long id) {
        try {
            Map point = iPointService.queryPointDetailById1(getToken(),getProduct(),getAppKey(),id);
            return CommonResponseUtil.success(point);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点详情失败");
        }

    }

    /**
     * 查询巡检点信息
     *
     * @return
     */
    @ApiOperation(value = "查询巡检点信息", notes = "查询巡检点信息")
    @PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse listPoint(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
    	AgencyUserModel user = getUserInfo();
        if (ObjectUtils.isEmpty(user)) {
            return CommonResponseUtil.failure("用户session过期");
        }
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            //String loginOrgCode = getLoginOrgCode(reginParams);
            //权限放到公司级别
            String loginOrgCode = reginParams.getCompany().getOrgCode();
            String roleTypeName = getRoleTypeName(reginParams);
            CommonRequest commonRequest = new CommonRequest();
            commonRequest.setName("orgCode");
            commonRequest.setValue(loginOrgCode);
            commonRequest.setType("LIKE");;
            queryRequests.add(commonRequest);
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests, false, loginOrgCode, roleTypeName);
            Page<PointVo> pointList = iPointService.queryPointInfo(criterias, commonPageable);
            return CommonResponseUtil.success(pointList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点信息失败");
        }
    }


    /**
     * 查询巡检点信息
     */
    @ApiOperation(value = "查询所有检查点", notes = "查询所有检查点")
    @PostMapping(value = "/list/all", produces = "application/json;charset=UTF-8")
    public CommonResponse listAllPoint() {

        return CommonResponseUtil.success(iPointService.queryAllPoint());
    }

    /**
     * 导入巡检点
     */
    @ApiOperation(value = "上传巡检点", notes = "上传巡检点")
    @RequestMapping(value = "/import", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse importPoint(@ApiParam(value = "导入数据文件", required = true) @RequestBody(required = true) MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (!fileName.endsWith(".xls")) {
            return CommonResponseUtil.failure("文件格式错误");
        }
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        if (ObjectUtils.isEmpty(reginParams)) {
            return CommonResponseUtil.failure("用户session过期");
        }
        try {
            List<PointImportParam> list = FileHelper.importExcel(file, 0, 1, PointImportParam.class);
            List<Long> pointIds = iPointService.addImportPoint(list, loginOrgCode, userId);
            asyncTask.pushPointTo3D(pointIds);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure("导入失败");
        }
    }

    @ApiOperation(value = "导入导入模板", notes = "导入导入模板")
    @PostMapping(value = "/exportTemplate", produces = "application/json;charset=UTF-8")
    public CommonResponse exportTemplate(HttpServletResponse response) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        //String loginOrgCode = getLoginOrgCode(reginParams);
        
        //放到公司级
        String loginOrgCode =reginParams.getCompany().getOrgCode();
        String fileName = "巡检点导入模板"; //模板名称
        String[] handers = {"点编号(必填)", "点名称(必填)", "是否为移动点", "计划外巡检是否评分", "是否允许离线巡检", "参考地址", "3维地图坐标", "3维地图楼层", "最少拍照数量", "最多拍照数量", "风险等级(必填)", "备注说明", "所属分类目录", "检查项目", "是否室内"}; //列标题
        List<String[]> downData = new ArrayList();
        String[] isScore = {"否", "是"};
        String[] isFixed = {"否", "是"};
        String[] offline = {"否", "是"};
        String[] isIndoor = {"否", "是"};
      // String[] level = {"一级", "二级", "三级", "四级"};
       // 等级改为查询数据字典
               
          String[] level = null;
         JSONArray list= remoteSecurityService.listDictionaryByDictCode(getToken(),getProduct(),getAppKey(),"FXDJ_TYPE");      
         if(list!=null &&list.size()>0){
         	
         	level=new String[list.size()];
         	
         	for (int i = 0; i < level.length; i++) {
         		level[i]=list.getJSONObject(i).get("dictDataValue")+"";
 			}
         	
         	
         }
      
        String[] catalog = catalogTreeService.getCataLogList(loginOrgCode);
//        String[] inputItems = inputItemService.queryInputItemNames(loginUserParam.getLoginOrgCode());
//        String[] routeNames = routeService.queryRouteNameOrgCode(loginUserParam.getLoginOrgCode());
        downData.add(isFixed);
        downData.add(isScore);
        downData.add(offline);
        downData.add(level);
//        downData.add(inputItems);
        downData.add(catalog);
        downData.add(isIndoor);
        String[] downRows = {"2", "3", "4", "10", "12", "14"}; //下拉的列序号数组(序号从0开始)

        try {
            FileHelper.createExcelTemplate(fileName, handers, downData, downRows, response);
        } catch (Exception e) {
            CommonResponseUtil.failure(e.getMessage());
        }
        return CommonResponseUtil.success();
    }

    @ApiOperation(value = "查询巡检点信息", notes = "查询巡检点信息")
    @PostMapping(value = "/exportListPoint", produces = "application/json;charset=UTF-8")
    public CommonResponse exportListPoint(@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
                                          @RequestParam(value = "exportType", required = false) int exportType,
                                          HttpServletResponse response) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
       // String orgCode = getLoginOrgCode(reginParams);
        //公司级
        String orgCode =reginParams.getCompany().getOrgCode();
        try {
            PointImportQueryParam pointImportQueryParam = PointParamUtils.fillPointImportQuery(queryRequests);
            pointImportQueryParam.setOrgCode(orgCode);
            List<PointVo> pointList = iPointService.queryPointInfoListByIds(pointImportQueryParam);
            if (exportType == 0) {
                FileHelper.exportExcel(pointList, "巡检点列表", "巡检点信息", PointVo.class, "巡检点.xls", response);
            } else if (exportType == 1) {
                FileHelper.exportQRCode(pointList, "巡检点二维码", response);
            }
            return null;
//            return CommonResponseUtil.success("导出成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点信息失败");
        }
    }

    @ApiOperation(value = "查询巡检点信息", notes = "查询巡检点信息")
    @GetMapping(value = "/exportListPointByIds", produces = "application/json;charset=UTF-8")
    //@Authorization(ingore = true)
    public CommonResponse exportListPointByIds(@ApiParam(value = "查询条件", required = false) @RequestParam(value = "ids", required = false) Long[] ids,
                                               @RequestParam(value = "exportType", required = false) int exportType,
                                               HttpServletResponse response) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        try {
            List<Long> idList = Arrays.asList(ids);
            PointImportQueryParam pointImportQueryParam = new PointImportQueryParam();
            pointImportQueryParam.setPointIds(idList);
            pointImportQueryParam.setOrgCode(orgCode);
            List<PointVo> pointList = iPointService.queryPointInfoListByIds(pointImportQueryParam);
            if (exportType == 0) {
                FileHelper.exportExcel(pointList, "巡检点列表", "巡检点信息", PointVo.class, "巡检点.xls", response);
            } else if (exportType == 1) {
                FileHelper.exportQRCode(pointList, "巡检点二维码", response);
            }
            return CommonResponseUtil.success("导出成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点信息失败");
        }
    }


    @ApiOperation(value = "查询巡检点信息(<font color='blue'>手机app</font>)", notes = "查询巡检点信息(<font color='blue'>手机app</font>)")
    @PostMapping(value = "/queryPointByPage", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPointByPage(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        //点放到公司下
        //String orgCode = getLoginOrgCode(reginParams);
        String orgCode = reginParams.getCompany().getOrgCode();
        try {
            CommonRequest commonRequest = new CommonRequest();
            commonRequest.setName("orgCode");
            commonRequest.setValue(orgCode);
            queryRequests.add(commonRequest);
            HashMap<String, Object> param = PointParamUtils.fillTaskInfo(queryRequests);
            Page<PointVo> pointList = iPointService.queryPointByPage(param, commonPageable);
            return CommonResponseUtil.success(pointList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点信息失败");
        }
    }

    @ApiOperation(value = "查询用户登录公司全部巡检点", notes = "查询用户登录公司全部巡检点")
    @GetMapping(value = "/authPoints", produces = "application/json;charset=UTF-8")
    public CommonResponse listPoint(@ApiParam(value = "巡检点编码", required = false) @RequestParam("ids") List<String> ids,
                                    @ApiParam(value = "巡检点名称", required = false) @RequestParam("names") List<String> names) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        try {
            List<Point> list = iPointService.queryPointList(ids, names, orgCode);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    /**
     * 查询巡检点信息及所包含得分类
     *
     * @param code
     * @param name
     * @return
     */
    @ApiOperation(value = "查询用户登录公司全部巡检点", notes = "查询用户登录公司全部巡检点")
    @GetMapping(value = "/queryPoints", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPoints(@ApiParam(value = "巡检点编码", required = false) @RequestParam("code") String code,
                                      @ApiParam(value = "巡检点名称", required = false) @RequestParam("name") String name) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        //公司级别
       // String orgCode = getLoginOrgCode(reginParams);
        String orgCode = reginParams.getCompany().getOrgCode();
        try {
            List<HashMap<String, Object>> list = iPointService.findPointList(code, name, orgCode);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            log.error(e.getMessage());
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    /**
     * 另存巡检点
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "另存巡检点", notes = "另存巡检点")
    @PostMapping(value = "/saveAs", produces = "application/json;charset=UTF-8")
    //@Authorization(ingore = true)
    public CommonResponse saveAs(@ApiParam(value = "巡检点id集合", required = true) @RequestParam Long[] ids) {
        try {
            List<String> list = iPointService.qryPointNoList(null, (long) -1);
            for (Long id : ids) {
                Point point = iPointService.queryPointById(id);
                if (list.contains(point.getPointNo() + "_copy")) {
                    return CommonResponseUtil.failure("巡检点" + point.getPointNo() + "已另存!");
                }
            }
            iPointService.saveAs(ids);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("另存巡检点失败");
        }
    }

    /**
     * 查询巡检点的巡检项
     */
    @ApiOperation(value = "查询巡检点的巡检项", notes = "查询巡检点的巡检项")
    @PostMapping(value = "/queryPointInputItem", produces = "application/json;charset=UTF-8")
    //@Authorization(ingore = true)
    public CommonResponse queryPointInputItem(@ApiParam(value = "巡检点id", required = true) @RequestParam Long pointId) {
        try {
            List<PointInputItemVo> pointInputItemList = iPointService.queryPointInputItem(pointId);
            return CommonResponseUtil.success(pointInputItemList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点的巡检项失败");
        }
    }

    /**
     * 查询巡检点的分类
     */
    @ApiOperation(value = "查询巡检点的分类", notes = "查询巡检点的分类")
    @PostMapping(value = "/queryPointClassify", produces = "application/json;charset=UTF-8")
    //@Authorization(ingore = true)
    public CommonResponse queryPointClassify(@ApiParam(value = "巡检点id", required = true) @RequestParam Long pointId) {
        try {
            List<PointClassify> pointClassify = iPointService.queryPointClassify(pointId);
            return CommonResponseUtil.success(pointClassify);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点的分类失败");
        }
    }

    /**
     * 根据分类id查询对应项
     */
    @ApiOperation(value = "根据分类id查询对应项", notes = "根据分类id查询对应项")
    @PostMapping(value = "/queryPointInputItemByClassify", produces = "application/json;charset=UTF-8")
   // @Authorization(ingore = true)
    public CommonResponse queryPointInputItemByClassify(@ApiParam(value = "巡检点id", required = true) @RequestParam Long pointId,
                                                        @ApiParam(value = "巡检点分类id", required = true) @RequestParam Long classifyId) {
        try {
            List<PointInputItemVo> pointInputItem = iPointService.queryPointInputItemByClassify(pointId, classifyId);
            return CommonResponseUtil.success(pointInputItem);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("根据分类id查询对应项失败");
        }
    }

    /**
     * 根据点id查询点的分类及对应项
     */
    @ApiOperation(value = "根据点id查询点的分类及对应项", notes = "根据点id查询点的分类及对应项")
    @PostMapping(value = "/queryPointClassifyWithInputItem", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPointClassifyWithInputItem(@ApiParam(value = "巡检点id", required = true) @RequestParam Long pointId) {
        try {
            Map<String, PointClassifyVo> classifyNameWithInputItemIdMap = iPointService.queryPointClassifyWithInputItemVo(pointId);
            return CommonResponseUtil.success(classifyNameWithInputItemIdMap);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("根据点id查询点的分类及对应项失败");
        }
    }

    /**
     * 设置巡检点巡检模式
     *
     * @param pointId
     * @param isOffine
     * @return
     */
    @ApiOperation(value = "设置巡检点巡检模式", notes = "设置巡检点巡检模式")
    @PostMapping(value = "/setPatrolMode", produces = "application/json;charset=UTF-8")
    public CommonResponse setPatrolMode(@ApiParam(value = "巡检点id", required = true) @RequestParam Long pointId,
                                        @ApiParam(value = "是否开启离线模式", required = true) @RequestParam Boolean isOffine) {
        try {
            Point point = iPointService.setPatrolMode(pointId, isOffine);
            if (ObjectUtils.isEmpty(point)) {
                return CommonResponseUtil.failure("该巡检点不存在");
            }
            return CommonResponseUtil.success(point);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("绑卡失败");
        }
    }

    @ApiOperation(value = "查询用户权限点信息饼图(<font color='blue'>手机app</font>)", notes = "查询用户权限点信息饼图(<font color='blue'>手机app</font>)")
    @GetMapping(value = "/queryPointPie", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPointPie() {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
        HashMap<String, Object> params = new HashMap<>();
        params.put("orgCode", loginOrgCode);
//        if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
//            params.put("department", departmentId);
//        } else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName)) {
//            params.put("userId", getUserId());
//        }
        if (XJConstant.CCPC_PERSONAL.equals(roleTypeName)) {
        	//一线技术，一线业务只能看自己的
            params.put("userId", getUserId());
            params.put("orgCode", loginOrgCode);
        	
        } else {
        	//二线技术
            params.put("orgCode", loginOrgCode);
        }
        
        
        HashMap<String, Object> response = iPointService.queryPointPie(params);
        return CommonResponseUtil.success(response);
    }

    @ApiOperation(value = "查询用户权限点信息柱状图(<font color='blue'>手机app</font>)", notes = "查查询用户权限点信息柱状图(<font color='blue'>手机app</font>)")
    @GetMapping(value = "/queryPointHistogram", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPointHistogram() {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
        HashMap<String, Object> params = new HashMap<>();
        params.put("orgCode", loginOrgCode);
//        if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
//            params.put("department", departmentId);
//        } else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName)) {
//            params.put("userId", getUserId());
//        }
        if (XJConstant.CCPC_PERSONAL.equals(roleTypeName)) {
        	//一线技术，一线业务只能看自己的
            params.put("userId", getUserId());
            params.put("orgCode", loginOrgCode);
        	
        } else {
        	//二线技术
            params.put("orgCode", loginOrgCode);
        }
        
        List<HashMap<String, Object>> response = iPointService.queryPointHistogram(params);
        return CommonResponseUtil.success(response);
    }

    /**
     * 查询巡检点信息
     */
    @ApiOperation(value = "查询巡检点编号信息", notes = "查询巡检点编号信息")
    @GetMapping(value = "/queryPointNo/{pointId}", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPointNoList(
            @ApiParam(value = "巡检点id", required = true) @PathVariable(name = "pointId") Long pointId,
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        try {
            CommonRequest commonRequest = new CommonRequest();
            commonRequest.setName("orgCode");
            commonRequest.setValue(loginOrgCode);
            if (queryRequests == null) {
                queryRequests = new ArrayList<>();
            }
            queryRequests.add(commonRequest);
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests, false, loginOrgCode, roleTypeName);
            List<String> pointNoList = iPointService.qryPointNoList(criterias, pointId);
            return CommonResponseUtil.success(pointNoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点编号信息失败");
        }
    }

    /**
     * 离线点信息同步
     *
     * @param startTime
     * @return
     */
   // @Authorization(ingore = true)
    @ApiOperation(value = "查询离线点信息", notes = "查询离线点信息")
    @GetMapping(value = "/queryLeavelPoint", produces = "application/json;charset=UTF-8")
    public CommonResponse queryLeavelPoint(@ApiParam(value = "数据同步开始时间（不传为全部同步）", required = false) @RequestParam(required = false) String startTime) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        return CommonResponseUtil.success(iPointService.queryLeavelPoint(loginOrgCode, startTime));
    }


    //@Authorization(ingore = true)
    @ApiOperation(value = "查询点信息json", notes = "查询点信息json")
    @GetMapping(value = "/getPointConfigJson", produces = "application/json;charset=UTF-8")
    public CommonResponse getPointConfigJson() {
        return CommonResponseUtil.success(iPointService.getPointConfigDom());
    }


   // @Authorization(ingore = true)
    @ApiOperation(value = "查询点信息xml", notes = "查询点信息xml")
    @GetMapping(value = "/getPointConfigDom", produces = MediaType.APPLICATION_XML_VALUE)
    public List<PointResponse> getPointConfigDom() {
        return iPointService.getPointConfigDom();
    }
	
	
	/*@Authorization(ingore=true)
	@ApiOperation(value = "巡检点xml", notes = "巡检点xml")
	@GetMapping(value = "/points", produces = "application/xml;charset=UTF-8")
	public List<Map<String, Object>> getPoints() {	
		List<Map<String, Object>> points = iPointService.getPoints();
		return points;
	}*/

    @ApiOperation(value = "手机端查询点详细信息", notes = "手机端查询点详细信息")
    @GetMapping(value = "/mobile/getPointInfo")
    public CommonResponse getPointInfo(@ApiParam(value = "点编号", required = true) @RequestParam Long pointId) {
        return iPointService.getPointInfo(pointId);
    }

    @ApiOperation(value = "手机端设备设施详情", notes = "手机端设备设施详情")
    @GetMapping(value = "/mobile/equipment/detail")
    public CommonResponse getEquipmentDetail(@ApiParam(value = "编号", required = true) @RequestParam Long equipmentId) {
        return iPointService.getEquipmentDetail(getToken(),getProduct(),getAppKey(),equipmentId);
    }

    @ApiOperation(value = "危险有害因素详情", notes = "危险有害因素详情")
    @GetMapping(value = "/mobile/riskFactor/detail")
    public CommonResponse getRiskFactorDetail(@ApiParam(value = "编号", required = true) @RequestParam Long riskFactorId) {
        return iPointService.getRiskFactorDetail(getToken(),getProduct(),getAppKey(),riskFactorId);
    }

    @SuppressWarnings("unused")
	//@Authorization(ingore = true)
    @ApiOperation(value = "巡检点统计", notes = "首页统计")
    @PostMapping(value = "/mobile/getcountxd")
    public CommonResponse getcountxd() {
        List<HashMap<String, Object>> list= iPointService.getcountxd();
        List<HashMap<String, Object>> list2= iPointService.getcountnum();
        List<HashMap<String, Object>> lista  =new ArrayList<>();
        if(list!=null&&list.size()>0){
        
        	if(list.size()==4){
        		  Map<String, Object> map =new HashMap<>();
                  if(list2!=null&&list2.size()>0){
               	   map.put("total", list2.get(0).get("num"));
                  }
                 
                  map.put("data", list);
        		return CommonResponseUtil.success(list);
        	}else{
        for (int i = 1; i < 5; i++) {
        	HashMap<String, Object> map =new  HashMap<>();
        	
        	for (int j = 0; j < list.size(); j++) {
				
        		if((i+"").equals(list.get(j).get("level")+"")){
        			
        			map= list.get(j);
        			continue;
        		}
			}
        	
             	if(map.isEmpty()){
             		map.put("value", "0/0");
             		if(i==1){
                    	map.put("name", "一级风险");

             		}else if(i==2){
                    	map.put("name", "二级风险");

             		}else if(i==3){
                    	map.put("name", "三级风险");

             		}else{
                    	map.put("name", "四级风险");
	
             		}
                	map.put("level", i);	
             	}
        
        	
        	lista.add(map);
		}
        	}
        }else{
        	
        	  for (int i = 1; i < 5; i++) {
              	HashMap<String, Object> map =new  HashMap<>();
                   	if(map==null){
                   		map.put("value", "0/0");
                   		if(i==1){
                          	map.put("name", "一级风险");

                   		}else if(i==2){
                          	map.put("name", "二级风险");

                   		}else if(i==3){
                          	map.put("name", "三级风险");

                   		}else{
                          	map.put("name", "四级风险");
      	
                   		}
                      	map.put("level", i);	
                   	}
              
              	
              	lista.add(map);
      		}
        	
        }
        
       
                   
                   Map<String, Object> map =new HashMap<>();
                   if(list2!=null&&list2.size()>0){
                	   map.put("total", list2.get(0).get("num"));
                   }
                  
                   map.put("data", lista);
        return CommonResponseUtil.success(map);
    }
}
