package com.yeejoin.amos.patrol.service.business.controller;

import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.service.business.param.CheckStatsListPageParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IQueryStatsService;
import com.yeejoin.amos.patrol.service.business.util.CheckStatsParamUtils;
import com.yeejoin.amos.patrol.service.business.vo.CheckStatsVo;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
//import com.yeejoin.amos.security.common.authorization.Authorization;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/stats")
@Api(tags = "巡检查询统计api")
public class QueryStatsController extends BaseController {

    @Autowired
    private IQueryStatsService iQueryStatsService;

    /**
     * 查询巡检统计信息
     */
    @ApiOperation(value = "查询巡检点信息", notes = "查询巡检点信息")
    @PostMapping(value = "/checkStats", produces = "application/json;charset=UTF-8")
    public CommonResponse queryCheckStats(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        HashMap<String, Object> paramMap = buildMybatisDaoCriterias(loginOrgCode, roleTypeName);
        CheckStatsListPageParam param = CheckStatsParamUtils.fillCheckInfoParam(queryRequests, commonPageable, paramMap);
        Page<CheckStatsVo> dataList = iQueryStatsService.queryCheckStats(param);
        return CommonResponseUtil.success(dataList);
    }
    
    @ApiOperation(value = "统计列表", notes = "统计列表")
    @GetMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse queryStatisticsList() {
    	return CommonResponseUtil.success(iQueryStatsService.queryStatisticsList());
    }
    
    @ApiOperation(value = "按统计口径获取统计详情", notes = "按统计口径获取统计详情")
    @GetMapping(value = "/detail/{type}", produces = "application/json;charset=UTF-8")
    public CommonResponse queryStatisticsDetailByType(@ApiParam(value = "统计类型（risk,danger,taskwork,judgment）", required = true) @PathVariable String type) {
    	ReginParams reginParams = getSelectedOrgInfo();
    	String loginOrgCode = getLoginOrgCode(reginParams);
    	return CommonResponseUtil.success(iQueryStatsService.queryStatisticsDetailByType(getToken(),getProduct(),getAppKey(),type, loginOrgCode));
    }
}
