package com.yeejoin.amos.patrol.service.business.controller;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.DateUtil;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
//import com.yeejoin.amos.op.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.business.param.JdReviewCallBackParam;
import com.yeejoin.amos.patrol.service.business.param.RiskJudgmentSaveRecordParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IRiskJudgmentService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IRiskJudgmentTaskService;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
//import com.yeejoin.amos.security.common.authorization.Authorization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

@RestController
@RequestMapping(value = "/api/riskJudgment")
@Api(tags = "风险研判")
public class RiskJudgmentController extends BaseController {

    @Autowired
    private IRiskJudgmentService iRiskJudgmentService;

    @Autowired
    private IRiskJudgmentTaskService iRiskJudgmentTaskService;

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "风险研判定时任务", notes = "风险研判定时任务")
    @GetMapping(value = "/runTask")
    public CommonResponse runTask(
            @ApiParam(value = "时间yyyy-MM-dd", required = true) @RequestParam String date,
            @ApiParam(value = "类型（1：研判任务；2：超时任务；3：进行任务）", required = true) @RequestParam Integer type) {
        Date parseDate = DateUtil.parseDate(date, DateUtil.DATE_DEFAULT_FORMAT);
        if (type.equals(1)) {
            iRiskJudgmentTaskService.initRiskJudgmentTask(getToken(),getProduct(),getAppKey(),parseDate);
        } else if (type.equals(2)) {
            iRiskJudgmentTaskService.updateRiskJudgmentTaskToOverTime(getToken(),getProduct(),getAppKey(),parseDate);
        } else if (type.equals(3)) {
            iRiskJudgmentTaskService.updateRiskJudgmentTaskToProcess(getToken(),getProduct(),getAppKey(),parseDate);
        }
        return CommonResponseUtil.success();
    }

    @ApiOperation(httpMethod = "GET", value = "风险研判列表", notes = "风险研判列表")
    @GetMapping(value = "/mobile/list")
    public CommonResponse list(
            @ApiParam(value = "当前页数", required = true) @RequestParam Integer pageNumber,
            @ApiParam(value = "每页数量", required = true) @RequestParam Integer pageSize,
            @ApiParam(value = "处理人（0：全部；1：我的）", required = true) @RequestParam Integer executorType,
            @ApiParam(value = "开始时间(格式：yyyy-MM-dd)", required = true) @RequestParam String beginTime,
            @ApiParam(value = "结束时间(格式：yyyy-MM-dd)", required = true) @RequestParam String endTime,
            @ApiParam(value = "状态（0：所有；1：进行中；2：已超时；3：已提交）", required = true) @RequestParam Integer status) {
        String userId = null;
        if (executorType == 1) {
            userId = getUserId();
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String deptId = getDepartmentId(reginParams);
        return iRiskJudgmentService.list(getToken(),getProduct(),getAppKey(),userId, pageNumber, pageSize, beginTime, endTime, status, orgCode,deptId);
    }

    @ApiOperation(httpMethod = "GET", value = "风险研判详情", notes = "风险研判详情")
    @GetMapping(value = "/mobile/detail")
    public CommonResponse detail(@ApiParam(value = "当前页数", required = true) @RequestParam Long id) {
        return iRiskJudgmentService.detail(getToken(),getProduct(),getAppKey(),id);
    }

    @ApiOperation(httpMethod = "GET", value = "风险研判执行/采集数据列表", notes = "风险研判/采集执行数据列表")
    @GetMapping(value = "/mobile/items")
    public CommonResponse getRiskJudgmentItemData(@ApiParam(value = "每日任务ID", required = true) @RequestParam Long taskId,
                                                  @ApiParam(value = "风险研判项类型（1：风险研判表；2：风险研判采集表）", required = true) @RequestParam Integer type,
                                                  @ApiParam(value = "风险研判项等级", required = true) @RequestParam Integer level,
                                                  @ApiParam(value = "风险研判项id") @RequestParam(required = false) Long itemId) {
        return CommonResponseUtil.success(iRiskJudgmentService.getRiskJudgmentItemData(taskId, type, level, itemId));
    }

    @ApiOperation(httpMethod = "POST", value = "保存风险研判表/风险研判信息采集表", notes = "保存风险研判表/风险研判信息采集表")
    @PostMapping(value = "/mobile/record")
    public CommonResponse saveRiskJudgmentRecordInfo(@ApiParam(value = "提交记录内容", required = true) @RequestBody RiskJudgmentSaveRecordParam record) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        return iRiskJudgmentService.saveRecordInfo(record, orgCode, getUserId());
    }

    @ApiOperation(httpMethod = "POST", value = "修改风险研判任务状态", notes = "修改风险研判任务状态")
    @PostMapping(value = "/mobile/updateTaskStatus")
    public CommonResponse updateTaskStatus(@ApiParam(value = "任务编号", required = true) @RequestParam Long taskId) {
        return iRiskJudgmentService.updateTaskStatus(getToken(),getProduct(),getAppKey(),taskId, getUserId(), getToken());
    }

    /**
     * 待删除
     * @param instanceId
     * @param taskDefinitionKey
     * @return
     */
    @ApiOperation(httpMethod = "POST", value = "车间审核拒绝回调", notes = "车间审核拒绝回调")
    @PostMapping(value = "/reviewRefuse/callBack")
    public CommonResponse reviewRefuseCallBack(@ApiParam(value = "工作流实例编号", required = true) @RequestParam String instanceId,
                                               @ApiParam(value = "工作流实例标识", required = true) @RequestParam String taskDefinitionKey) {
        return iRiskJudgmentService.reviewRefuseCallBack(instanceId, taskDefinitionKey);
    }

    @ApiOperation(httpMethod = "POST", value = "交大风险研判审核回调", notes = "交大风险研判审核回调")
    @PostMapping(value = "/jd/review/callBack")
    public CommonResponse reviewRefuseCallBack(@ApiParam(value = "节点类型:1-车间；2-合并", required = true) @RequestParam String nodeType,
                                               @ApiParam(value = "回调数据", required = true) @RequestBody(required = true) JdReviewCallBackParam requestParam) {
        return iRiskJudgmentService.jdReviewCallBack(nodeType, requestParam,getToken());
    }
}
