package com.yeejoin.amos.patrol.service.business.controller;

import com.google.common.base.Joiner;
import com.thoughtworks.xstream.XStream;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;
import com.yeejoin.amos.patrol.common.core.response.QueryCriteriaRespone;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.Task;
import com.yeejoin.amos.patrol.common.entity.TaskFeedback;
import com.yeejoin.amos.patrol.common.entity.TaskPicture;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.TaskFeedbackType;
import com.yeejoin.amos.patrol.common.enums.TaskStatusEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.TaskBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.TaskFeedbackBo;
import com.yeejoin.amos.patrol.service.business.param.FeedbackParam;
import com.yeejoin.amos.patrol.service.business.param.RoutePointParam;
import com.yeejoin.amos.patrol.service.business.param.TaskPageParam;
import com.yeejoin.amos.patrol.service.business.param.TaskParam;
import com.yeejoin.amos.patrol.service.business.param.TaskStatisticsParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPointService;
import com.yeejoin.amos.patrol.service.business.service.intfc.ITaskService;
import com.yeejoin.amos.patrol.service.business.util.FileHelper;
import com.yeejoin.amos.patrol.service.business.util.TaskPageParamUtil;
import com.yeejoin.amos.patrol.service.business.vo.TaskStatisticsVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
//import com.yeejoin.amos.security.common.authorization.Authorization;
//import com.yeejoin.amos.security.common.model.UserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 任务
 *
 * @author gaodongdong
 */
@RestController
@RequestMapping(value = "/api/task")
@Api(tags = "巡检任务")
public class TaskController extends BaseController {
    private final Logger log = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private ITaskService taskService;
    @Autowired
    private IPointService pointService;
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    @Autowired
    private AsyncTask asyncTask;


    /**
     * 新增任务
     *
     * @param param
     * @return
     */
    @ApiOperation(value = "新增任务", notes = "新增任务")
    @RequestMapping(value = "/addTask", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse addNewTask(@RequestBody TaskParam param) {
        try {
            AgencyUserModel user = getUserInfo();
            Date date = new Date();
            if (param.getTaskInfo().getFinishTime().before(date)) {
                return CommonResponseUtil.failure("完成时间应当大于当前时间！");
            }
            if(param.getTaskInfo().getWarnTime()!=null){
            	if (param.getTaskInfo().getWarnTime().before(param.getTaskInfo().getFinishTime())) {
                    return CommonResponseUtil.failure("提醒时间应当大于等于完成时间！");
                }
            }
            
            ReginParams reginParams = getSelectedOrgInfo();
            String orgCode = getLoginOrgCode(reginParams);
            param.getTaskInfo().setOrgCode(orgCode);
//			param.getTaskInfo().setCreateDate(new Date());
            param.getTaskInfo().setPublisher(user.getUserId());
            //     param.getTaskInfo().setPublisherName(user.getRealName());
            param.getTaskInfo().setPublisherName(user.getUserName());
            param.getTaskInfo().setPublishTime(date);
            taskService.addNewTask(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            return CommonResponseUtil.failure("新增任务失败: " + e.getMessage());
        }
    }

    /**
     * 根据任务ID获取任务详情
     *
     * @param taskID
     * @return
     */
    @ApiOperation(value = "任务详情", notes = "任务详情")
    @RequestMapping(value = "/queryTask", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryTaskDetail(@ApiParam(value = "任务ID") @RequestParam(required = true) long taskID) {
        TaskBo bo = taskService.queryTaskDetail(taskID);
        return CommonResponseUtil.success(bo);
    }

    /**
     * 根据任务ID获取任务详情
     *
     * @param taskID
     * @return
     */
    @ApiOperation(value = "任务详情", notes = "任务详情")
    @RequestMapping(value = "/printTask", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse printTaskDetail(@ApiParam(value = "任务ID") @RequestParam(required = true) long taskID) {
        TaskBo bo = taskService.queryTaskDetail(taskID);
        String xml = bean2xml(bo);
        InputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        ;
        Source source = new StreamSource(inputStream);
        try {
            FileInputStream fis1 = new FileInputStream(this.getClass().getResource("/").getPath() + "temp/template.xsl");
            Source template = new StreamSource(fis1);
            //String html = "D://10.html";
            Date date = new Date();
            String path = request.getSession().getServletContext().getRealPath("/");
            String dir = path.substring(0, path.indexOf(File.separator) + 1) + "print";
            String html = path.substring(0, path.indexOf(File.separator) + 1) + "print" + File.separator + "task_" + date.getTime() + ".html";
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }

            Result result = new StreamResult(html);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(template);

            transformer.transform(source, result);

            File htmlFile = new File(html);
            FileInputStream fis = new FileInputStream(htmlFile);
            String data = IOUtils.toString(fis, "utf-8");
            fis.close();
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            return new CommonResponse(SUCCESS, data, "查询成功");
        } catch (TransformerException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String bean2xml(TaskBo bo) {
        XStream xStream = new XStream();
        xStream.alias("taskInfo", TaskBo.class);
        xStream.alias("task", Task.class);
        xStream.alias("TaskFeedbacks", TaskFeedbackBo.class);
        //将对象转换成xml字符串
        String xml = xStream.toXML(bo);

        return xml;
    }


    /**
     * 跟新任务
     *
     * @param param
     * @return
     */
    @ApiOperation(value = "更新任务", notes = "更新任务")
    @RequestMapping(value = "/updateTask", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse updateTask(@ApiParam(value = "修改任务信息") @RequestBody TaskParam param) {
        if (param.getTaskInfo().getId() <= 0) {
            return addNewTask(param);
        }
        try {
            taskService.updateTask(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            return CommonResponseUtil.failure("更新任务失败: " + e.getMessage());
        }

    }

    /**
     * 修改任务状态
     */
    @ApiOperation(value = "处理任务", notes = "处理任务")
    @RequestMapping(value = "/handleTask", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse handleTask(@ApiParam(value = "任务ID", required = true) @RequestParam String taskIds,
                                     @ApiParam(value = "任务状态", required = true) @RequestParam int status) {
        if (ObjectUtils.isEmpty(taskIds)) {
            return CommonResponseUtil.failure("处理人ID不能为空");
        }
        try {
            AgencyUserModel user = getUserInfo();
            ReginParams reginParams = getSelectedOrgInfo();
            String orgCode = getLoginOrgCode(reginParams);
            taskService.handleTask(taskIds, status, user, orgCode);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            return CommonResponseUtil.failure("处理任务失败: " + e.getMessage());
        }

    }

    /**
     * 删除任务
     *
     * @param taskID
     * @return
     */
    @ApiOperation(value = "删除任务", notes = "删除任务")
    @RequestMapping(value = "/delTask", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse delTask(@ApiParam(value = "任务ID", required = true) @RequestParam long taskID) {
        try {
            taskService.delTask(taskID);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            return CommonResponseUtil.failure("删除任务失败: " + e.getMessage());
        }

    }

    /**
     * 删除任务
     */
    @ApiOperation(value = "删除任务", notes = "批量删除删除任务（任务id以半角英文字符分割。如： 1,2）")
    @RequestMapping(value = "/batchDelTask", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
    public CommonResponse batchDelTask(@ApiParam(value = "任务ID", required = true) @RequestParam String taskIDs) {
        try {
            taskService.batchDelTask(taskIDs);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            return CommonResponseUtil.failure("删除任务失败: " + e.getMessage());
        }

    }

    /**
     * 任务回复
     *
     * @param param
     * @return
     */
    @ApiOperation(value = "任务回复", notes = "任务回复")
    @RequestMapping(value = "/feedbackTask", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse feedbackTask(@ApiParam(value = "回复信息（包含图片base64编码）") @RequestBody FeedbackParam param) {
        AgencyUserModel user = getUserInfo();
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        TaskFeedback taskFeedback = new TaskFeedback();
        taskFeedback.setUserId(user.getUserId());
        taskFeedback.setUserName(user.getRealName());
        taskFeedback.setTaskId(param.getTaskID());
        taskFeedback.setPictureNumber(param.getPictureNumber());
        taskFeedback.setMessage(param.getMessage());
        taskFeedback.setCreateDate(new Date());
        taskFeedback.setFeedbackTime(new Date());
        taskFeedback.setOrgCode(orgCode);
        taskFeedback.setMessageType(TaskFeedbackType.FEEDBACK.getName());
        List<TaskPicture> pictures = new ArrayList<>();

        try {
            if (!ObjectUtils.isEmpty(param.getImgbase64())) {
                for (int i = 0; i < param.getImgbase64().size(); i++) {
                    TaskPicture picture = new TaskPicture();
                    picture.setTaskId(param.getTaskID());
                    picture.setCreateDate(new Date());
                    picture.setOrgCode(orgCode);
                    picture.setPhotoData(param.getImgbase64().get(i));
                    pictures.add(picture);
                }
            }
            Task task = taskService.feedbackTask(taskFeedback, pictures);
            if (task != null && task.getStatus() == TaskStatusEnum.FINISHED.getValue()) {
                asyncTask.pushTaskDetailInfoTo3D(task.getId());
            }
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("任务回复失败: " + e.getMessage());
        }

    }

    /**
     * 任务转发
     *
     * @param userId
     * @param taskID
     * @return
     */
    @ApiOperation(value = "任务转发", notes = "任务转发")
    @RequestMapping(value = "/forwardTask", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse forwardTask(@RequestParam(required = true) String userId, @RequestParam(required = true) long taskID) {
        AgencyUserModel user = getUserInfo();
        if (ObjectUtils.isEmpty(user)) {
            return CommonResponseUtil.failure("用户session过期");
        }
        try {
            taskService.forwardTask(getToken(), getProduct(), getAppKey(), taskID, user, userId);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure("任务转发失败: " + e.getMessage());
        }

    }

    /**
     * 分页查询任务列表
     *
     * @param queryRequests
     * @param pageable
     * @return
     */
    @ApiOperation(value = "分页查询任务", notes = "人也查询任务")
    @RequestMapping(value = "/queryTaskByPage", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryTaskByPage(
      @ApiParam(value = "组合查询条件", required = false, defaultValue = "[]") @RequestBody(required = false) List<CommonRequest> queryRequests,
      @ApiParam(value = "分页参数", required = false, defaultValue = "current=0&pageSize=10或pageNumber0&pageSize=10") CommonPageable pageable) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
           // String orgCode = getLoginOrgCode(reginParams);
            //分配到公司
            String orgCode =reginParams.getCompany().getOrgCode();
            String roleTypeName = getRoleTypeName(reginParams);
            HashMap<String, Object> paramMap = buildMybatisDaoCriterias(orgCode, roleTypeName);
            TaskPageParam param = TaskPageParamUtil.fillTaskInfo(queryRequests, pageable, paramMap);
            Page<HashMap<String, Object>> tasks = taskService.queryTaskByPage(param);

//          //获取用户信息
//        	List<String> userIds = new ArrayList<>();
//        	tasks.getContent().forEach(item ->{
//    			if(!userIds.contains(item.get("executorId"))) {
//    				userIds.add((String) item.get("executorId"));
//    			}
//        	});	
//        	//设置执行人员和执行部门
//        	List<UserModel> listUsers = remoteSecurityService.listUserByUserIds(
//        			Joiner.on(",").join(userIds));
//        	
//        	
//        	if( listUsers != null && listUsers.size() > 0) {
//        		tasks.getContent().forEach(item ->{
//        			List<UserModel> filter = listUsers.stream().filter(user -> user.getUserId().contains((String)item.get("executorId"))).collect(Collectors.toList());
//        			if(filter != null && filter.size() > 0) {
//        				UserModel agencyUserModel = filter.get(0);
//        				item.put("executor", filter.get(0).getRealName());
//        				//多个用户用  ‘,’隔开
//        				String names = filter.stream().map(UserModel::getRealName).collect(Collectors.joining(","));
//        			}
//        		});
//        	}

            return CommonResponseUtil.success(tasks);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    /**
     * 条件查询所有任务
     *
     * @param queryRequests
     * @return
     */
    @PostMapping(value = "/queryTaskByCondition", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "条件查询任务", notes = "条件查询任务")
    public CommonResponse queryTaskByCondition(
      @ApiParam(value = "组合查询条件", required = false, defaultValue = "[]") @RequestBody(required = false) List<CommonRequest> queryRequests) {
        if (queryRequests == null) {
            queryRequests = new ArrayList<>();
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests, true, orgCode, roleTypeName);
        List<Task> list = taskService.queryTaskByCondition(criterias);
        return CommonResponseUtil.success(list);
    }

    /**
     * 条件查询任务个数
     *
     * @param queryRequests
     * @return
     */
    @PostMapping(value = "/queryTaskCountByCondition", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "条件查询任务个数", notes = "条件查询任务个数")
    public CommonResponse queryTaskCountByCondition(
      @ApiParam(value = "组合查询条件", required = false, defaultValue = "[]") @RequestBody(required = false) List<CommonRequest> queryRequests) {
        if (queryRequests == null) {
            queryRequests = new ArrayList<>();
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests, true, orgCode, roleTypeName);
        int count = taskService.queryTaskCountByCondition(criterias);
        return CommonResponseUtil.success(count);
    }

    @PostMapping(value = "/queryTaskCharts", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "条件查询任务图表数据(<font color='blue'>手机app</font>)", notes = "条件查询任务图表数据(<font color='blue'>手机app</font>)")
    public CommonResponse queryTaskCharts(@ApiParam(value = "组合查询条件", required = false, defaultValue = "[]") @RequestBody(required = false) List<CommonRequest> queryRequests) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
        if (queryRequests == null) {
            queryRequests = new ArrayList<>();
        }
        HashMap<String, Object> request = TaskPageParamUtil.fillTaskInfo(queryRequests);
        if (!ObjectUtils.isEmpty(request.get("executorId"))) {
            request.put("executorId", getUserId());
        } else if (!ObjectUtils.isEmpty(request.get("publisher"))) {
            request.put("publisher", getUserId());
        } else {
//            if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase()) ||
//              XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())) {
//                request.put("orgCode", orgCode);
//            } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
//                request.put("orgCode", orgCode);
//                request.put("departmentId", departmentId);
//            } else {
//                request.put("executorId", getUserId());
//                request.put("publisher", getUserId());
//            }
        	
        	 if (XJConstant.CCPC_PERSONAL.equals(roleTypeName)) {
             	//一线技术，一线业务只能看自己的
        		 request.put("executorId", getUserId());
               request.put("publisher", getUserId());
               request.put("orgCode", orgCode);
             	
             } else {
             	//二线技术
            	 request.put("orgCode", orgCode);
             }
             
        	
        	
        }
//		String departmentId = request.get("department") != null ? request.get("department").toString() : null ;
//		if(!(ObjectUtils.isEmpty(request.get("departmentId"))) && Integer.valueOf(request.get("departmentId").toString()) > 0){
//			request.put("orgCode", request.get("orgCode") + "-" + departmentId);
//		}
//        if (!(ObjectUtils.isEmpty(request.get("departmentId"))) && request.get("departmentId").toString().equals("-1")) {
//            List<LinkedHashMap<String, Object>> userList = otherDeptService.queryDeptUsers("-1", orgCode);
//            List ids = new ArrayList<Long>();
//            for (LinkedHashMap<String, Object> linkedHashMap : userList) {
//                ids.add(linkedHashMap.get("id"));
//            }
//            request.put("ids", ids);
//        }
        Map charts = taskService.queryTaskCharts(request);
        return CommonResponseUtil.success(charts);
    }

    @PostMapping(value = "/queryTasksByPage", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "条件查询任务数据(<font color='blue'>手机app</font>)", notes = "条件查询任务数据(<font color='blue'>手机app</font>)")
    public CommonResponse queryTasksByPage(@ApiParam(value = "组合查询条件", required = false, defaultValue = "[]") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                           @ApiParam(value = "分页参数", required = false, defaultValue = "current=0&pageSize=10或pageNumber0&pageSize=10") CommonPageable pageable) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
        if (queryRequests == null) {
            queryRequests = new ArrayList<>();
        }
        HashMap<String, Object> request = TaskPageParamUtil.fillTaskInfo(queryRequests);
        if (!ObjectUtils.isEmpty(request.get("executorId"))) {
            request.put("executorId", getUserId());
        } else if (!ObjectUtils.isEmpty(request.get("publisher"))) {
            request.put("publisher", getUserId());
        } else {
//            if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase()) ||
//              XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())) {
//                request.put("orgCode", orgCode);
//            } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
//                request.put("orgCode", orgCode);
//                request.put("departmentId", departmentId);
//            } else {
//                request.put("executorId", getUserId());
//                request.put("publisher", getUserId());
//            }
        	
        	 if (XJConstant.CCPC_PERSONAL.equals(roleTypeName)) {
              	//一线技术，一线业务只能看自己的
         		 request.put("executorId", getUserId());
                request.put("publisher", getUserId());
                request.put("orgCode", orgCode);
              	
              } else {
              	//二线技术
             	 request.put("orgCode", orgCode);
              }
        }
        request.put("pageSize", pageable.getPageSize());
        request.put("pageNumber", pageable.getPageNumber());
//        if (!(ObjectUtils.isEmpty(request.get("departmentId"))) && request.get("departmentId").toString().equals("-1")) {
//            List ids = getDepartmentUserIds("-1", orgCode);
//            request.put("ids", ids);
//        }
        List<Map> charts = taskService.queryTasks(request);
        return CommonResponseUtil.success(charts);
    }

//    private List getDepartmentUserIds(String departmentId, String orgCode) {
//        List<LinkedHashMap<String, Object>> userList = otherDeptService.queryDeptUsers(departmentId,
//                orgCode);
//        List ids = new ArrayList<Long>();
//        for (LinkedHashMap<String, Object> linkedHashMap : userList) {
//            ids.add(linkedHashMap.get("id"));
//        }
//        return ids;
//    }


    /**
     * 获取任务列表查询接口
     *
     * @return
     */
    @ApiOperation(value = "获取任务列表查询接口(<font color='blue'>release</font>)", notes = "获取任务列表查询接口")
    @RequestMapping(value = "/queryCriteria/init", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getQueryCriteriaInit() {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        try {
            QueryCriteriaRespone respone = new QueryCriteriaRespone();
            respone.setStatus(TaskStatusEnum.getEnumList());
            List<AgencyUserModel> users = remoteSecurityService.listUserByOrgCode(getToken(), getProduct(), getAppKey(), orgCode);
           
//            if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase()) ||
//              XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())) {
//                respone.setPoints(pointService.queryPointList(null, null, orgCode));
//                respone.setUsers(users);
//            } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
//                respone.setPoints(pointService.queryPointList(null, null, orgCode));
//                respone.setUsers(users);
//            } else {
//                respone.setPoints(pointService.queryPointList(null, null, orgCode));
//                respone.setUsers(users);
//            }

            
            respone.setPoints(pointService.queryPointList(null, null, orgCode));
            respone.setUsers(users);
            return CommonResponseUtil.success(respone);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure();
        }
    }

    /**
     * 隐患治理统计
     *
     * @param dateMonth
     * @return
     */
    @ApiOperation(value = "隐患治理统计", notes = "隐患治理统计")
    @RequestMapping(value = "/hiddenDanger/count/{dateMonth}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse hiddenDangerCountByDate(@ApiParam(value = "年月日(yyyyMMdd)8位", required = true) @PathVariable String dateMonth) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
//        if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase()) ||
//          XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())) {
//            params.put("orgCode", orgCode);
//        } else {
//            params.put("orgCode", orgCode);
//        }

        params.put("orgCode", orgCode);
        
        params.put("startMonth", DateUtil.getFirstDayOfYear(dateMonth, "yyyyMM"));//本年开始日期
        params.put("curMonth", dateMonth.substring(0, 6));//当前年月
        params.put("monthStartDate", DateUtil.getStartMonthDate(dateMonth, "yyyyMMdd"));//本月开始日期
        params.put("monthEndDate", dateMonth);//当前日期
        params.put("timeOutStatus", XJConstant.TASK_STATUS_TIMEOUT);
        params.put("cancelStatus", XJConstant.TASK_STATUS_FINISH);
        params.put("finishStatus", XJConstant.TASK_STATUS_DEAL);
        params.put("dealStatus", XJConstant.TASK_STATUS_NO_START);
        HashMap<String, List<HashMap<String, Object>>> countList = taskService.getHiddenDangerCountData(params);
        return CommonResponseUtil.success(countList);
    }

    /**
     * 根据巡检路线ID获取该路线上的所有点ID
     *
     * @return IDs
     */
    @ApiOperation(value = "获取巡检路线上的所有点ID", notes = "获取巡检路线上的所有点ID")
    @RequestMapping(value = "/points", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    //@Authorization(ingore = true)
    public CommonResponse getPointIDsByRouteID(@ApiParam(value = "巡检路线IDs") @RequestBody(required = true) RoutePointParam param) {
        List<String> routeIDs = param.getRouteIDs();
        List<HashMap<String, Object>> routeIDsAndPointIDs = taskService.getPointIDsByRouteIDs(routeIDs);
        Map<String, Object> result = new HashMap<String, Object>();
        for (HashMap<String, Object> item : routeIDsAndPointIDs) {
            String[] pointIDs = item.get("PointID").toString().split(",");
            result.put(item.get("RouteID").toString(), pointIDs);
        }
        return CommonResponseUtil.success(result);
    }

    @GetMapping(value = "/queryTaskStatistics", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询用户任务统计(<font color='blue'>手机app</font>)", notes = "查询用户任务统计(<font color='blue'>手机app</font>)")
    public CommonResponse getUserTaskStatistics() {

        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> resp = new HashMap<String, Object>();
        AgencyUserModel user = getUserInfo();
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
        params.put("orgCode", orgCode);
        params.put("userId", getUserId());
        Map<String, Object> userResp = taskService.getTaskForAppPie(params);
        resp.put("user", userResp);
        params.put("userId", null);
//        if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName)) {
//            return CommonResponseUtil.success(resp);
//        }
        if (XJConstant.CCPC_PERSONAL.equals(roleTypeName)) {
            return CommonResponseUtil.success(resp);
        }
        if (!ObjectUtils.isEmpty(reginParams.getDepartment())) {
            params.put("departmentId", departmentId);
            Map<String, Object> deptResp = taskService.getTaskForAppPie(params);
            resp.put("department", deptResp);
            params.put("departmentId", null);
        }

//        if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
//            return CommonResponseUtil.success(resp);
//        }
        Map<String, Object> orgResp = taskService.getTaskForAppPie(params);
        resp.put("company", orgResp);
        return CommonResponseUtil.success(resp);
    }

    @PostMapping(value = "/getStatisticsData", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询任务统计", notes = "查询任务统计")
    public CommonResponse getTaskStatistics(@RequestBody(required = true) TaskStatisticsParam param) {
        ReginParams reginParams = getSelectedOrgInfo();
        //String orgCode = getLoginOrgCode(reginParams);
        //权限为公司级别
        String orgCode = reginParams.getCompany().getOrgCode();
        
        param.setOrgCode(orgCode);
        List<TaskStatisticsVo> list = taskService.getTaskStatistics(param);


        if (list != null && list.size() > 0) {
            //安全处里
            if (1 == param.getStatisticsTyle() || 0 == param.getStatisticsTyle()) {

                //处理用户信息


                String userIds = "";
                Set<String> set = new HashSet<>();
                list.forEach(s -> {


                    set.add(s.getName());


                });

                List<String> list1 = new ArrayList<>(set);
                userIds = String.join(",", list1);


                List<AgencyUserModel> listd = remoteSecurityService.listUserByUserIds(getToken(), getProduct(), getAppKey(), userIds);

                //新安全
                list.forEach(s -> {


                    listd.forEach(s1 -> {

                        if (s.getName().equals(s1.getUserId())) {

                            s.setName(s1.getUserName());

                        }
                    });

                });
            }else{
        	 if (4 == param.getStatisticsTyle()) {

                 //处理用户信息


                 String userIds = "";
                 Set<String> set = new HashSet<>();
                 list.forEach(s -> {


                     set.add(s.getName());


                 });

                 List<String> list1 = new ArrayList<>(set);
                 userIds = String.join(",", list1);


                 List<LinkedHashMap> listd = remoteSecurityService.listDepartmentByDeptIds(getToken(), getProduct(), getAppKey(), userIds);

                 //新安全
                 list.forEach(s -> {


                     listd.forEach(s1 -> {

                         if (s.getName().equals(s1.get("sequenceNbr")+"")) {

                             s.setName(s1.get("departmentName")+"");

                         }
                     });

                 });
             }
        }
            
            
           
        }


        TaskStatisticsVo vo = new TaskStatisticsVo();
        vo.setName("合计");
        for (TaskStatisticsVo item : list) {
            vo.setCancel(item.getCancel() + vo.getCancel());
            vo.setFinished(vo.getFinished() + item.getFinished());
            vo.setProccesed(vo.getProccesed() + item.getProccesed());
            vo.setTimeout(vo.getTimeout() + item.getTimeout());
            vo.setTotal(vo.getTotal() + item.getTotal());
        }
        list.add(vo);
        return CommonResponseUtil.success(list);
    }

    @PostMapping(value = "/exportStatisticsData", produces = "application/vnd.ms-excel;charset=UTF-8")
    @ApiOperation(value = "查询任务统计", notes = "查询任务统计")
    public void exportStatisticsData(@RequestBody(required = true) TaskStatisticsParam param, HttpServletResponse response) {
        ReginParams reginParams = getSelectedOrgInfo();
        //String orgCode = getLoginOrgCode(reginParams);
        //权限为公司级别
        String orgCode = reginParams.getCompany().getOrgCode();
        param.setOrgCode(orgCode);
        List<TaskStatisticsVo> list = taskService.getTaskStatistics(param);


        if (list != null && list.size() > 0) {
            //安全处里
            if (1 == param.getStatisticsTyle() || 0 == param.getStatisticsTyle()) {

                //处理用户信息


                String userIds = "";
                Set<String> set = new HashSet<>();
                list.forEach(s -> {


                    set.add(s.getName());


                });

                List<String> list1 = new ArrayList<>(set);
                userIds = String.join(",", list1);


                List<AgencyUserModel> listd = remoteSecurityService.listUserByUserIds(getToken(), getProduct(), getAppKey(), userIds);

                //新安全
                list.forEach(s -> {


                    listd.forEach(s1 -> {

                        if (s.getName().equals(s1.getUserId())) {

                            s.setName(s1.getUserName());

                        }
                    });

                });
            }
        }


        TaskStatisticsVo vo = new TaskStatisticsVo();
        vo.setName("合计");
        for (TaskStatisticsVo item : list) {
            vo.setCancel(item.getCancel() + vo.getCancel());
            vo.setFinished(vo.getFinished() + item.getFinished());
            vo.setProccesed(vo.getProccesed() + item.getProccesed());
            vo.setTimeout(vo.getTimeout() + item.getTimeout());
            vo.setTotal(vo.getTotal() + item.getTotal());
        }
        list.add(vo);
        String fileName = "任务统计" + new Date().getTime();
        FileHelper.exportExcel(list, "任务统计", "任务统计", TaskStatisticsVo.class, fileName + ".xls", response);
    }

    @ApiOperation(value = "根据任务id查询任务日志", notes = "根据任务id查询任务日志")
    @RequestMapping(value = "/queryTaskRecordByTaskId", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryTaskRecordByTaskId(@ApiParam(value = "任务ID") @RequestParam(required = true) long taskId) {
        return CommonResponseUtil.success(taskService.queryTaskRecord(taskId));
    }

    @ApiOperation(httpMethod = "GET", value = "查询检查项任务所有检查不合格项详情(<font color='blue'>手机app</font>)", notes = "查询检查项任务所有检查不合格项详情")
    @RequestMapping(value = "/queryCheckTaskDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCheckTaskDetail(@RequestParam(required = true) long checkId, @RequestParam(required = true) long taskId) {
        Map<String, Object> resp = taskService.queryCheckTaskDetail(checkId, taskId);
        return CommonResponseUtil.success(resp);
    }


    /**
     * 同步离线任务
     *
     * @return
     */
    @ApiOperation(value = "同步离线任务(<font color='blue'>手机app</font>)", notes = "同步离线任务")
    @RequestMapping(value = "/queryOfflineTasks", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse synchronizedOfflineTasks() {
        List<Map<String, Object>> resp = taskService.synchronizedOfflineTasks(getUserId());
        return CommonResponseUtil.success(resp);
    }
}
