package com.yeejoin.amos.patrol.service.business.controller;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.UserModel;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.service.business.param.TaskworkExecuteParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ITaskworkService;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
//import com.yeejoin.amos.security.common.model.UserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/api/taskwork")
@Api(tags = "作业活动")
public class TaskworkController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(TaskworkController.class);

    @Autowired
    private ITaskworkService iTaskworkService;

    @ApiOperation(value = "启动作业活动流程", notes = "启动作业活动流程")
    @PostMapping(value = "/startFlow")
    public CommonResponse startFlow(@ApiParam(value = "作业活动编号(多个逗号隔开)", required = true) @RequestParam String taskworkIds) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            String deptId = getDepartmentId(reginParams);
            String companyId = getCompanyId(reginParams);
            String departmentName = getDepartmentName(reginParams);
            List<Long> ids = Arrays.stream(taskworkIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            AgencyUserModel userModel = getUserInfo();
            String userId = userModel.getUserId();
            String userRealName = userModel.getRealName();
            String token = getToken();
            List<String> results = Lists.newArrayList();
            ids.forEach(id -> results.add(iTaskworkService.startFlow(id, userId, userRealName,
                    deptId, departmentName, companyId, loginOrgCode, token)));
            return CommonResponseUtil.success(results);
        } catch (Exception e) {
            logger.error("启动作业活动流程异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "作业活动列表", notes = "作业活动列表")
    @GetMapping(value = "/mobile/list")
    public CommonResponse list(@ApiParam(value = "当前页数", required = true) @RequestParam Integer pageNumber,
                               @ApiParam(value = "每页数量", required = true) @RequestParam Integer pageSize,
                               @ApiParam(value = "可执行人（0：全部；1：我的）", required = true) @RequestParam Integer canExecutorType,
                               @ApiParam(value = "状态（0：全部；1：待班组审核；2：待车间/部门审核；3：待公司审核；4：待执行；5：待确认验收；6：完成）", required = true) @RequestParam Integer status,
                               @ApiParam(value = "等级（0：全部；1：1级；2：2级；3：3级；4：4级；5：5级）", required = true) @RequestParam Integer level,
                               @ApiParam(value = "作业活动名称") @RequestParam(required = false) String taskworkName) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            return iTaskworkService.list(getToken(),getProduct(),getAppKey(),pageNumber, pageSize, getUserId(), loginOrgCode, canExecutorType, status, level, taskworkName);
        } catch (Exception e) {
            logger.error("作业活动列表异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "作业活动详情", notes = "作业活动详情")
    @GetMapping(value = "/mobile/detail")
    public CommonResponse detail(@ApiParam(value = "作业活动编号", required = true) @RequestParam Long id) {
        try {
            return iTaskworkService.detail(getToken(),getProduct(),getAppKey(),id);
        } catch (Exception e) {
            logger.error("作业活动详情异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "流程执行", notes = "流程执行")
    @PostMapping(value = "/mobile/excute")
    public CommonResponse excute(@ApiParam(value = "记录编号", required = true) @RequestBody TaskworkExecuteParam taskworkExecuteParam) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            AgencyUserModel userModel = getUserInfo();
            String userId = userModel.getUserId();
            String userName = userModel.getRealName();
            String deptId = getDepartmentId(reginParams);
            String deptName = getDepartmentName(reginParams);
            return iTaskworkService.excute(taskworkExecuteParam, userId, userName, deptId, deptName, getToken());
        } catch (Exception e) {
            logger.error("流程执行异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "作业活动步骤列表", notes = "作业活动步骤列表")
    @GetMapping(value = "/mobile/taskworkContent/list")
    public CommonResponse listTaskworkContent(@ApiParam(value = "作业活动编号", required = true) @RequestParam Long taskworkId) {
        try {
            return iTaskworkService.listTaskworkContent(taskworkId);
        } catch (Exception e) {
            logger.error("作业活动步骤列表异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

}
