package com.yeejoin.amos.patrol.service.business.dao.mapper;

import com.yeejoin.amos.patrol.common.core.response.PointCheckInfoBusinessRespone;
import com.yeejoin.amos.patrol.common.core.response.PointCheckInfoRespone;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckDetailBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckInfoBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckInputBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckTraListBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckUserBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PlanRoutePointBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PointCheckDetailBo;
import com.yeejoin.amos.patrol.service.business.param.CheckInfoListPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckInfoPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckRecordParam;
import com.yeejoin.amos.patrol.service.business.param.CheckStatisticalParam;
import com.yeejoin.amos.patrol.service.business.util.CheckDetailInputPageParam;
import com.yeejoin.amos.patrol.service.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.patrol.service.business.vo.CheckInfoVo;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CheckMapper extends BaseMapper {

    long countCheckInfoData(CheckInfoPageParam param);

    List<CheckInfoVo> getCheckInfo(CheckInfoPageParam param);

    List<Map> queryUnqualifiedInputItem(@Param(value = "checkId") int checkId);

    List<Map> queryCheckPointInputItem(@Param(value = "planTaskId") int planTaskId, @Param(value = "pointId") int pointId);

    List<PointCheckDetailBo> findCheckPointInputItem(@Param(value = "checkId") long checkId);

    int checkHasRecord(CheckRecordParam requestParam);

    List<Map<String, Object>> queryCheckPointImgs(@Param(value = "planTaskId") int planTaskId, @Param(value = "pointId") int pointId);

    /**
     * 巡检日历饼图数据
     *
     * @param param
     * @return
     */
    Map<String, Object> pieChartData(CheckRecordParam param);

    /**
     * 巡检日历日历数据
     *
     * @param param
     * @return
     */
    List<Map<String, Object>> calendarData(CheckRecordParam param);

    List<Map<String, Object>> queryRecordByPointId(HashMap<String, Object> req);

    Map<String, Object> queryCheckById(@Param(value = "checkId") int checkId);

    List<Map<String, Object>> queryCheckInputItems(@Param(value = "checkId") int checkId);

    List<Map<String, Object>> queryCheckImgs(@Param(value = "checkId") int checkId);

    /**
     * 查询所有巡检记录图片
     *
     * @param param
     * @return
     */
    List<Map<String, Object>> getCheckInfoImgsList(CheckInfoPageParam param);

    /**
     * 根据巡检记录id获取所有图片
     *
     * @param ids
     * @return
     */
    List<Map<String, Object>> getCheckInfoImgsByCheckIdsList(@Param(value = "checkIds") Long[] ids);

    /**
     * 根据ids获取巡检记录
     *
     * @param ids
     * @return
     */
    List<CheckInfoVo> getSelectedCheckInfoList(@Param(value = "checkIds") Long[] ids);

    /**
     * 月巡检情况统计
     *
     * @param param
     * @return
     */
    List<HashMap<String, Object>> getCountMonthChk(HashMap<String, Object> param);

    /**
     * 获取巡检日历信息列表
     *
     * @param paramMap
     * @return
     */
    List<HashMap<String, String>> getCalenderCountInfoList(HashMap<String, Object> paramMap);

    /**
     * 获取巡检人员
     *
     * @param paramsMap
     * @return
     */
    List<CheckUserBo> getCheckUserInfoList(HashMap<String, Object> paramsMap);

    /**
     * 根据巡检点id获取最新一条巡检记录
     *
     * @param pointId
     * @return
     */
    Long getLastsetCheckByPointID(@Param(value = "pointID") Long pointId);

    /**
     * 根据巡检记录ID查询巡检项个数
     *
     * @param checkID
     * @return
     */
    long countCheckInputByMybatis(@Param(value = "checkID") Long checkID);

    /**
     * 根据巡检记录ID获取巡检项
     *
     * @param param
     * @return
     */
    List<CheckInputBo> getCheckInputByCheckId(CheckDetailInputPageParam param);

    /**
     * 根据巡检记录ID和点ID获取巡检记录详情
     *
     * @param param
     * @return
     */
    CheckDetailBo getCheckDetailByID(CheckDetailInputPageParam param);

    /**
     * 根据巡检记录ID获取巡检记录图片信息
     *
     * @param checkID
     * @return
     */
    List<String> getCheckInputPhotoByID(@Param(value = "checkId") Long checkID);

    /**
     * 查询巡检轨迹数量
     *
     * @param params
     * @return
     */
    long countCheckTraListData(CheckPtListPageParam params);

    /**
     * 查询巡检轨迹
     *
     * @param params
     * @return
     */
    List<CheckTraListBo> getCheckTraList(CheckPtListPageParam params);

    /**
     * 根据检查id获取检查信息
     *
     * @param checkId
     * @return
     */
    List<PointCheckInfoRespone> getCheckInfoById(@Param(value = "checkId") Long checkId);

    /**
     * 计划路线点最新巡检记录查询
     *
     * @param params
     * @return
     */
    List<PlanRoutePointBo> getLastPointCheckList(CheckPtListPageParam params);

    /**
     * 计划路线点最新巡检记录分页统计用
     *
     * @param params
     * @return
     */
    long countLastPointCheckData(CheckPtListPageParam params);

    /**
     * 查询巡检记录信息记录个数
     *
     * @param params
     * @return
     */
    long countCheckInfoListData(CheckInfoListPageParam params);

    long countCheckInfoListData1(CheckInfoListPageParam params);

    /**
     * 查询巡检记录列表信息
     *
     * @param params
     * @return
     */
    List<CheckInfoBo> getCheckInfoList(CheckInfoListPageParam params);

    List<PointCheckInfoRespone> getCheckInfoList1(CheckInfoListPageParam params);

    /**
     * 查询点及线路信息
     *
     * @return
     */
    public List<Map<String, Object>> getRoutesAndPointsInfo();

    /**
     * 巡检情况统计分析
     *
     * @param param
     * @return
     */
    List<CheckAnalysisVo> getCheckStatisticalAnalysis(CheckStatisticalParam param);

    /**
     * 根据orgCode查询公司累计巡检次数
     *
     * @param loginOrgCode
     * @return
     */
    long getCumulativeCheckCountByOrgCode(String loginOrgCode);

    /**
     * 根据条件查询日巡检次数
     *
     * @param param
     * @return
     */
    List<Long> getCheckDataCount(HashMap<String, Object> param);

    PointCheckInfoBusinessRespone getCheckInfoBusinessById(@Param(value = "checkId") Long checkId);

    List<String> getLivePhotos(@Param(value = "checkId") Long checkID);


    List<String> getPhotosByCheckIDAndInputId(@Param(value = "checkId") int checkId, @Param(value = "checkInputId") int checkInputId);

	List<String> getCheckPhotosByCheckAndInputIdAndClassifyId(@Param(value = "checkId") int checkId, @Param(value = "checkInputId") int checkInputId,@Param(value = "classifyId") int classifyId);

}
