package com.yeejoin.amos.patrol.service.business.dao.mapper;

import com.yeejoin.amos.patrol.common.entity.Plan;
import com.yeejoin.amos.patrol.service.business.param.PlanInfoPageParam;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

public interface PlanMapper extends BaseMapper {

    void saveAs(String id);

    void updPlanStatusOrGenDate(HashMap<String, Object> id);

    /**
     * 根据路线id获取关联的计划
     *
     * @param routeId
     * @return
     */
    List<Plan> getPlanByRouteId(@Param(value = "routeId") Long routeId);

    /**
     * 统计巡检计划数量
     *
     * @param param
     * @return
     */
    long countPlanInfoData(PlanInfoPageParam param);

    /**
     * 按照查询巡检计划概要列表
     *
     * @param param
     * @return
     */
    List<HashMap<String, Object>> getPlanInfo(PlanInfoPageParam param);

    /**
     * 按照查询巡检计划概不分页
     *
     * @param param
     * @return
     */
    List<HashMap<String, Object>> getPlanInfoNoPage(PlanInfoPageParam param);

    /**
     * 查询计划列表
     *
     * @param loginOrgCode
     * @return
     */
    List<HashMap<String, Object>> queryPlanListByOrgCode(@Param("orgCode") String loginOrgCode);
}
