package com.yeejoin.amos.patrol.service.business.dao.mapper;

import com.yeejoin.amos.patrol.common.core.response.PointResponse;
import com.yeejoin.amos.patrol.common.entity.PointPhoto;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckPtListBo;
import com.yeejoin.amos.patrol.service.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.service.business.param.PointImportQueryParam;
import com.yeejoin.amos.patrol.service.business.vo.LeavelMovePointVo;
import com.yeejoin.amos.patrol.service.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.service.business.vo.PointVo;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface PointMapper extends BaseMapper {

    /**
     * 根据点ID获取点的检查项
     *
     * @param pointId
     * @param classifyId
     * @return
     */
    List<PointInputItemVo> getPointInputItemById(@Param(value = "pointId") Long pointId, @Param(value = "classifyId") Long classifyId);

    /**
     * 根据点ID获取点的检查项
     *
     * @param pointId
     * @param classifyId
     * @return
     */
    List<PointInputItemVo> getPointInputItemById1(@Param(value = "pointId") Long pointId, @Param(value = "classifyId") Long classifyId);

    List<PointInputItemVo> getPointClassInputItemById(@Param(value = "pointId") Long pointId);

    /**
     * 根据点ID获取点图片信息
     *
     * @param pointId
     * @return
     */
    List<PointPhoto> getPointPhotoByPointId(@Param(value = "pointId") Long pointId);

    List<HashMap<String, Object>> countByCatalogId(HashMap<String, Object> paramMap);

    int getPointCountByCondition(HashMap<String, Object> param);

    List<PointVo> getPointByCondition(HashMap<String, Object> param);

    Map<String, Object> getPointById(@Param(value = "pointId") Long id);

    List<Map<String, Object>> getPointInputItem(@Param(value = "pointId") Long id);

    List<Map<String, Object>> getPointRoute(@Param(value = "pointId") Long id);

    List<Map<String, Object>> getPointClassify(@Param(value = "pointId") Long id);

    List<HashMap<String, Object>> getPointInputClassifyInfo(@Param(value = "pointId") Long id);

    List<HashMap<String, Object>> getSumPtForDept(@Param(value = "orgCode") String loginOrgCode);

    List<HashMap<String, Object>> getSumPtForAdmin(@Param(value = "orgCode") String orgCode);

    long getCheckPointCount(CheckPtListPageParam param);

    List<CheckPtListBo> getCheckPointList(CheckPtListPageParam param);

    /**
     * 巡检点明细查询
     *
     * @param
     * @return
     */
    CheckPtListBo getCheckPointById(@Param(value = "pointId") int pointID);

    HashMap<String, Object> queryPointPie(HashMap<String, Object> params);

    List<HashMap<String, Object>> queryPointHistogram(HashMap<String, Object> params);

    long getPointCountByOrgCode(@Param("orgCode") String loginOrgCode);

    /**
     * 获取巡检点使用信息
     *
     * @param id
     * @return
     */
    List<Map<String, Object>> getPointInfoById(@Param(value = "pointId") Long id);

    /**
     * 同步离线移动巡检点信息
     *
     * @param orgCode
     * @param startTime
     * @return
     */
    List<LeavelMovePointVo> queryLeavelPoint(@Param(value = "orgCode") String orgCode, @Param(value = "startTime") String startTime);

    List<Map<String, Object>> getPoints();

    List<Map<String, Object>> queryPointClassifyByRouteIdAndPointId(@Param(value = "routeId") Long routeId, @Param(value = "pointId") Long pointId);

    List<PointResponse> getPointConfigDom();

    List<PointVo> getPointVoByIds(PointImportQueryParam pointImportQueryParam);

    List<PointVo> getPointVoByOrgCode(@Param(value = "orgCode") String orgCode);

    List<HashMap<String, Object>> findPointList(@Param(value = "orgCode") String orgCode, @Param(value = "name") String name, @Param(value = "code") String code);

    Map<String, Object> getPointInputItem1(@Param(value = "pointId") Long id, @Param(value = "inputitemId") Long inputitemId);

    List<HashMap<String, Object>> getcountxd();
    List<HashMap<String, Object>> getcountnum();
}
