package com.yeejoin.amos.patrol.service.business.dao.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.patrol.service.business.bo.patrol.StatisticPieBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.StatisticsSumBo;
import com.yeejoin.amos.patrol.service.business.param.CheckStatsListPageParam;
import com.yeejoin.amos.patrol.service.business.vo.CheckStatsVo;

public interface QueryStatsMapper extends BaseMapper {

    /**
     * 根据参数获取巡检情况统计信息
     *
     * @param paramMap
     * @return
     */
    List<CheckStatsVo> getCheckStats(CheckStatsListPageParam paramMap);
    
    /**
     * 查询风险点统计信息摘要
     * 
     * @return
     */
    StatisticsSumBo getStatisticsSumByRisk();
    
    /**
     * 查询隐患点统计信息摘要
     * 
     * @return
     */
    StatisticsSumBo getStatisticsSumByDanger(@Param("beginThisYear") String beginThisYear);
    
    /**
     * 查询作业活动统计信息摘要
     * @param string 
     * 
     * @return
     */
    StatisticsSumBo getStatisticsSumByTaskwork(@Param("beginThisYear") String beginThisYear);
    
    /**
     * 查询风险研判统计信息摘要
     * 
     * @return
     */
    StatisticsSumBo getStatisticsSumByJudgment(@Param("searchDate") String searchDate);
    
    /**
     * 查询风险点按等级统计数据
     * 
     * @return
     */
    List<StatisticPieBo> getRiskPieDetailInfo(@Param("orgCode") String orgCode);
    
    /**
     * 按部门统计风险点
     * 
     * @return
     */
    List<Map<String, String>> queryRiskByDepartment(@Param("orgCode") String orgCode,@Param("materialIds") List<Map<String, Object>> materialIds);
    
    /**
     * 按高纬度风险统计
     * 
     * @return
     */
    List<Map<String, String>> queryRiskByHighLevel(@Param("orgCode") String orgCode);

    /**
     * 查询隐患点按等级统计数据
     * 
     * @return
     */
	List<StatisticPieBo> getPieInfoByDangerLevel(@Param("orgCode") String orgCode, @Param("beginThisYear") String beginThisYear);
	
	/**
     * 查询隐患点按状态统计数据
     * 
     * @return
     */
	List<StatisticPieBo> getPieInfoByDangerStatus(@Param("orgCode") String orgCode, @Param("beginThisYear") String beginThisYear);
	
	/**
	 * 查询作业活动按风险等级统计数据
	 * 
	 * @param orgCode
	 * @param beginThisYear
	 * @return
	 */
	List<StatisticPieBo> getPieInfoByTaskworkRiskLevel(@Param("orgCode") String orgCode, @Param("beginThisYear") String beginThisYear);
	
	/**
	 * 查询作业活动按状态统计数据
	 * 
	 * @param orgCode
	 * @param beginThisYear
	 * @return
	 */
	List<StatisticPieBo> getPieInfoByTaskworkStatus(@Param("orgCode") String orgCode, @Param("beginThisYear") String beginThisYear);
	
	/**
	 * 查询作业活动按违章情况统计数据
	 * 
	 * @param orgCode
	 * @param beginThisYear
	 * @return
	 */
	List<StatisticPieBo> getPieInfoByTaskworkViolateStatus(@Param("orgCode") String orgCode, @Param("beginThisYear") String beginThisYear);
	
	/**
	 * 查询作业活动按类型统计数据
	 * 
	 * @param orgCode
	 * @param beginThisYear
	 * @return
	 */
	List<StatisticPieBo> getPieInfoByTaskworkType(@Param("orgCode") String orgCode, @Param("beginThisYear") String beginThisYear);

	/**
     * 根据部门查询风险研判状态信息
     * 
     * @return
     */
	List<Map<String, String>> getJudgmentStatusByDepartment(@Param("orgCode") String orgCode, @Param("searchDate") String searchDate);
}
