package com.yeejoin.amos.patrol.service.business.dao.repository;

//import com.yeejoin.amos.op.core.jpa.IBaseRepository;
import com.yeejoin.amos.patrol.common.entity.CatalogTree;
import com.yeejoin.amos.patrol.common.entity.Check;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("catalogTreeDao")
//public interface ICatalogTreeDao extends IBaseRepository<CatalogTree, Long> {
public interface ICatalogTreeDao extends BaseDao<CatalogTree, Long> {
	@Query(value = "select * from p_catalog_tree WHERE parent_id = ?1 and org_code like " + "concat(concat(" +"\'%\'"+",?2),"+"\'%\')" +" order by id", nativeQuery = true)
	List<CatalogTree> findByParentId(long parentId, String orgCode);
	
	@Query(value = "select * from p_catalog_tree WHERE parent_id = ?1 order by id", nativeQuery = true)
	List<CatalogTree> findChildrenByParentId(Long parentId);

	@Modifying
	@Transactional
	@Query(value = "delete from p_catalog_tree WHERE id in (?1)", nativeQuery = true)
	void deleteBatchById(Long[] ids);
	
	@Query(value = "select * from p_catalog_tree WHERE name = ?1 and org_code=?2", nativeQuery = true)
	CatalogTree findOneByNameAndOrgCode(String name, String orgCode);	
	
	@Query(value = "select * from p_catalog_tree WHERE org_code=?1", nativeQuery = true)
	List<CatalogTree> findByOrgCode(String orgCode);
}