package com.yeejoin.amos.patrol.service.business.dao.repository;

import com.yeejoin.amos.patrol.common.entity.InputItem;
import com.yeejoin.amos.patrol.service.business.dao.repository.BaseDao;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("inputItemDao")
public interface IInputItemDao extends BaseDao<InputItem, Long> {
    @Query(value = "select * from p_input_item where org_code  LIKE CONCAT( ?1,'%')  and level = ?2 and is_delete =0", nativeQuery = true)
    public List<InputItem> findByLevel(String orgCode, String level);

    @Query(value = "select * from p_input_item where org_code  LIKE CONCAT( ?1,'%') and level is null and is_delete =0", nativeQuery = true)
    public List<InputItem> findByLevelNull(String orgCodel);

    @Query(value = "select * from p_input_item where org_code  LIKE CONCAT( ?1,'%')  and is_delete =0", nativeQuery = true)
    public List<InputItem> findAllByLevel(String orgCode);

    InputItem findByOriginalId(String originalId);

    @Query(value = "select * from p_input_item where original_id in (?1)  and is_delete =0", nativeQuery = true)
    List<InputItem> listByOriginalIds(List<String> originalIds);

}
