package com.yeejoin.amos.patrol.service.business.dao.repository;

import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.service.business.dao.repository.BaseDao;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("iPointDao")
public interface IPointDao extends BaseDao<Point, Long> {

    @Modifying
    @Transactional
    @Query(value = "UPDATE p_point SET is_delete = 1 WHERE id IN (?1)", nativeQuery = true)
    void delPointById(List<Long> ids);

    @Query(value = "SELECT COUNT(1) FROM p_point p WHERE is_delete = 0 AND p.point_no = (?1) AND p.org_code = (?2)", nativeQuery = true)
    int findByPointNo(String pointNo, String orgCode);

    Point findByOriginalId(String originalId);

    @Query(value = "select * from p_point where original_id in ?1 and is_delete =0", nativeQuery = true)
    List<Point> listByOriginalIds(List<String> originalIds);

    @Query(value = "SELECT * FROM p_point p WHERE is_delete = 0 AND p.point_no = (?1) AND p.org_code like CONCAT(?2,'%')", nativeQuery = true)
    Point findByOrgCodeAndPointNo(String pointNo, String orgCode);
}
