package com.yeejoin.amos.patrol.service.business.dao.repository;

import com.yeejoin.amos.patrol.common.entity.RoutePointItem;
import com.yeejoin.amos.patrol.service.business.dao.repository.BaseDao;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface IRoutePointItemDao extends BaseDao<RoutePointItem, Long> {
	
	@Modifying
	@Transactional
	@Query(value = "delete from p_route_point_item WHERE route_point_id = ?1", nativeQuery = true)
	void delRoutePointItem(Long routePointId);
	
	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_route_point_item WHERE point_input_item_id IN (?1)", nativeQuery = true)
	void delRoutePointItemByItemId(List<Long> pItemIds);

	@Modifying
	@Query(value = "SELECT prpi.* FROM p_route_point_item prpi LEFT JOIN p_route_point prp ON prp.id = prpi.route_point_id WHERE prp.point_id = ?1 AND prpi.point_classify_id in (?2)", nativeQuery = true)
	List<RoutePointItem> getRoutePointItemByPointIdAndClassifyIds(Long pointId,List<Long> classifyIds);
	
	List<RoutePointItem> findAllByPointInputItemId(Long pointInputItemId);
}
