package com.yeejoin.amos.patrol.service.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.AppVersion;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.MsgSubscribe;
import com.yeejoin.amos.patrol.common.enums.MsgSubscribeTypeEnum;
import com.yeejoin.amos.patrol.service.business.dao.mapper.LatentDangerMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskJudgmentTaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.AppVersionDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IMsgSubscribeDao;
import com.yeejoin.amos.patrol.service.business.param.UserMsgInitParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IAppService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IMsgSubscribeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("iAppService")
public class AppServiceImpl implements IAppService {


    @Autowired
    private AppVersionDao appVersionDao;

    @Autowired
    private IMsgSubscribeDao iMsgSubscribeDao;

    @Autowired
    private IMsgSubscribeService iMsgSubscribeService;

    @Autowired
    private PlanTaskMapper planTaskMapper;

    @Autowired
    private LatentDangerMapper latentDangerMapper;

    @Autowired
    private RiskJudgmentTaskMapper riskJudgmentTaskMapper;

//	@Override
//	public List<SUser> findAll() {
//		return iUserDao.findAll();
//	}
//
//	@Override
//	public void save(UserDTO userDTO) {
//		//初始化用户消息订阅
//		UserMsgInitParam userInitParam = new UserMsgInitParam();
//		userInitParam.setOrgCode(userDTO.getOrgCode());
//		userInitParam.setUserId(userDTO.getId());
//		userInitParam.setRoleTypeName(userDTO.getRole().getRoleTypeName());
//		userInitParam.setInit(true);
//		saveUserMsgInit(userInitParam);
//	}
//

    /**
     * 新增用户时初始化消息订阅(p_msg_subscribe)表
     */
    public List<MsgSubscribe> saveUserMsgInit(UserMsgInitParam userInitParam) {
        Long count = iMsgSubscribeDao.countByUserId(userInitParam.getUserId());
        if (count > 0) {    //	已存在用户订阅，直接返回
            return iMsgSubscribeService.queryMsgSubscribes(userInitParam.getUserId());
        }
        List<MsgSubscribe> msgConfigs = new ArrayList<>();
        for (MsgSubscribeTypeEnum type : MsgSubscribeTypeEnum.values()) {
            if (type.getCanConfig()) {
                MsgSubscribe msgSub = new MsgSubscribe();
                msgSub.setOrgCode(userInitParam.getOrgCode());
                //msgSub.setUserName(userInitParam.getUserRealName());
                msgSub.setUserId(userInitParam.getUserId());
                if (type.equals(MsgSubscribeTypeEnum.计划开始前推送)
                        || type.equals(MsgSubscribeTypeEnum.计划开始后推送)
                        || type.equals(MsgSubscribeTypeEnum.计划漏检推送)) {
                    msgSub.setAttribute1("False");
                    msgSub.setAttribute2("10");
                } else if (type.equals(MsgSubscribeTypeEnum.有异常记录推送)) {
                    msgSub.setAttribute1("True");
                } else {
                    msgSub.setAttribute1("False");
                }
                msgSub.setAttribute5(type.getDesc());
                /**else if (type.equals(MsgSubscribeTypeEnum.ROUTE) && !userInitParam.getInit()) {
                 // TODO 查询该用户下的路线
                 String roleTypeName = userInitParam.getRoleTypeName();
                 String orgCode = userInitParam.getOrgCode();

                 Specification<Route> spec = new Specification<Route>() {// 构建查询条件

                 @Override public Predicate toPredicate(Root<Route> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                 List<Predicate> predicate = new ArrayList<>();
                 if (!ObjectUtils.isEmpty(roleTypeName)) {
                 if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName)
                 || XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName)) {
                 predicate.add(cb.like(root.get("orgCode").as(String.class), orgCode + "%"));
                 } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
                 String orgCode_ = orgCode;
                 if (orgCode.indexOf("-") != -1) {
                 orgCode_ = orgCode.substring(0, orgCode.indexOf("-"));
                 }
                 predicate.add(cb.like(root.get("orgCode").as(String.class), orgCode_ + "%"));
                 } else {
                 predicate.add(cb.equal(root.get("orgCode").as(String.class), orgCode));
                 }
                 }
                 Predicate[] pre = new Predicate[predicate.size()];
                 return query.where(predicate.toArray(pre)).getRestriction();
                 }

                 };
                 List<Route> routeList = iRouteDao.findAll(spec);
                 List<Long> routeIdList = new ArrayList<>();
                 for (Route route : routeList) {
                 routeIdList.add(route.getId());
                 }
                 String routeIds = StringUtils.join(routeIdList.toArray(), ",");
                 msgSub.setAttribute1(routeIds);
                 }*/
                msgSub.setMsgType(type.getMsgType());
                iMsgSubscribeDao.saveAndFlush(msgSub);
                msgConfigs.add(msgSub);
            }
        }
        return msgConfigs;
    }

    @Override
    public CommonResponse getHaveToDo(String userId) {
        int taskCount = planTaskMapper.getCurrentPlanTaskCount(userId);
        Long dangerCount = latentDangerMapper.countByFlowUserIds(userId);
        Long judgmentCount = riskJudgmentTaskMapper.countByFlowUserIds(userId);
        JSONObject result = new JSONObject();
        result.put("havaPlanTask", taskCount > 0);
        result.put("haveDanger", dangerCount > 0);
        result.put("havaJudgment", judgmentCount > 0);
        return CommonResponseUtil.success(result);
    }
    @Override
    public List<String> getHaveToDoList(String userId) {
        int taskCount = planTaskMapper.getCurrentPlanTaskCount(userId);
        Long dangerCount = latentDangerMapper.countByFlowUserIds(userId);
        Long judgmentCount = riskJudgmentTaskMapper.countByFlowUserIds(userId);
        List<String> havetoDoList = Lists.newArrayList();
        if (taskCount > 0) {
            havetoDoList.add("planPatrol");
        }
        if (dangerCount > 0) {
            havetoDoList.add("waitHandle");
        }
        if (judgmentCount > 0) {
            havetoDoList.add("riskJudgment");
        }
        return havetoDoList;
    }
//
//	@Override
//	public void delete(List<User> user) {
//		beforeDeleteUser(user);
//	}
//
//	/**
//	 * 删除用户时更新消息订阅(p_msg_subscribe)表
//	 *
//	 * @param user
//	 */
//	private void beforeDeleteUser(List<User> user) {
//		List<Long> userIds = new ArrayList<>();
//		for (User _user : user) {
//			userIds.add(_user.getId());
//		}
//		msgSubscribeDao.delMsgSubscribeByUserId(userIds);
//	}
//
//	@Override
//	public List<SUser> queryUserByOrgCode(String orgCode) {
//		return userMapper.queryUserByOrgCode(orgCode);
//	}
//
//	@Override
//	public String queryUserCompanyNameByUserId(String orgCode) {
//		return userMapper.queryUserCompanyNameByUserId(orgCode);
//	}

    public AppVersion queryAppLastVersion() {
        return appVersionDao.findLastVersion();
    }

//	@Override
//	public UserCompanyVo qryLoginUserAndCompany(LoginUserParam param) {
//		Long userId = param.getUserId();
//		SUser user = iUserDao.findOne(userId);
//		String[] orgs = param.getLoginOrgCode().split("\\*");
//		String companyId = orgs[orgs.length - 1];
//		SCompany company = iCompanyDao.findOne(companyId);
//		UserCompanyVo userCompanyVo = new UserCompanyVo();
//		userCompanyVo.setCompany(company);
//		userCompanyVo.setUser(user);
//		return userCompanyVo;
//	}
//
//	@Override
//	public void initUserMsgSubscribe() {
//		List<SUser> userList = iUserDao.findAll();
//		for (SUser user : userList) {
//			UserMsgInitParam userInitParam = new UserMsgInitParam();
//			userInitParam.setInit(true);
//			userInitParam.setOrgCode(user.getOrgCode());
//			userInitParam.setUserId(user.getId());
//			saveUserMsgInit(userInitParam);
//		}
//	}
//
//	@Override
//	public boolean existUser(String userId) {
//		SUser user = iUserDao.findOne(Long.parseLong(userId));
//		if (!ObjectUtils.isEmpty(user)) {
//			return true;
//		}
//		return false;
//	}
}
