package com.yeejoin.amos.patrol.service.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.predicate.InPredicate;
import org.springframework.data.jpa.domain.Specification;

import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.QueryOperatorEnum;

/**
 * <pre>
 * 查询条件转Specification
 * </pre>
 *
 * @author as-zhaoqi_1
 * @version $Id: BaseQuerySpecification.java, v 0.1 2017年11月2日 上午9:33:57 as-zhaoqi_1 Exp $
 */
public class BaseQuerySpecificationJoinOR<T> implements Specification<T> {

	private List<DaoCriteria> daoCriterias;
	
	private Map<String, List<DaoCriteria>> criterias;
	
	private Map<String, List<String>> orderbys;

	public BaseQuerySpecificationJoinOR(List<DaoCriteria> daoCriterias) {
		this.daoCriterias = daoCriterias;
	}

	@Override
	public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
		if(daoCriterias==null){
			return builder.and(new Predicate[]{});
		}
		
		//将属性分为查询和排序
		criterias = classify(daoCriterias);
		List<Predicate> conditions = new ArrayList<Predicate>();
		
		for(String key: criterias.keySet()) {
			List<DaoCriteria> daoCriterias = criterias.get(key);
			if (daoCriterias.size() > 1) {
				List<Predicate> sameConditions = new ArrayList<Predicate>();
				for(DaoCriteria daoCriteria: daoCriterias) {
					Predicate predicate = createPredicate(root, query, builder, daoCriteria);
					if (null == predicate) {
						throw new IllegalArgumentException("查询条件生成错误！");
					} else {
						sameConditions.add(predicate);
					}
				}
				Predicate[] predicates = new Predicate[sameConditions.size()];
				conditions.add(builder.or(sameConditions.toArray(predicates)));
			} else {
				for(DaoCriteria daoCriteria: daoCriterias) {
					Predicate predicate = createPredicate(root, query, builder, daoCriteria);
					if (null != predicate) {
						conditions.add(predicate);
					}
				}
			}
		}
		
		Predicate[] predicates = new Predicate[conditions.size()]; 
		query.where(builder.and(conditions.toArray(predicates)));
		
		List<Order> orders = new ArrayList<>();
		orderbys.keySet().forEach(key -> {
			if (key.toLowerCase().equals("asc") && !orderbys.get(key).isEmpty()) {
				orderbys.get(key).forEach(propertyName -> {
					orders.add(builder.asc(root.get(propertyName)));
				});
			} else if (key.toLowerCase().equals("desc") && !orderbys.get(key).isEmpty()) {
				orderbys.get(key).forEach(propertyName -> {
					orders.add(builder.desc(root.get(propertyName)));
				});
			}
		});
		
		query.orderBy(orders);
		
		return query.getRestriction();
	}
	
	/**
	 * 根据同类条件进行分组
	 * 
	 * @param criteraList
	 * @return
	 */
	private Map<String, List<DaoCriteria>> classify(List<DaoCriteria> criteraList) {
		Map<String, List<DaoCriteria>> criteraType = new HashMap<String, List<DaoCriteria>>();
		orderbys = new HashMap<>();
		orderbys.put("asc", new ArrayList<String>());
		orderbys.put("desc", new ArrayList<String>());
		if (criteraList != null && criteraList.size() > 0) {
			for (DaoCriteria daoCriteria : criteraList) {
				//排序属性
				if (daoCriteria.getOperator().equals(QueryOperatorEnum.ORDER_BY.getName())) {
					orderbys.get(daoCriteria.getValue().toString().toLowerCase()).add(daoCriteria.getPropertyName());
				} else {//查询属性
					List<DaoCriteria> temp = criteraType.get(daoCriteria.getPropertyName());
					if (temp == null) {
						temp = new ArrayList<DaoCriteria>();
						criteraType.put(daoCriteria.getPropertyName(), temp);
					}
					temp.add(daoCriteria);
				}
			}
		}
		return criteraType;
	}
	
	/**
	 * 根据条件类型，创建查询条件
	 * 
	 * @param root
	 * @param query
	 * @param builder
	 * @param daoCriteria
	 * @return
	 */
	private Predicate createPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder, DaoCriteria daoCriteria) {
		String name = daoCriteria.getPropertyName();
		Object value = daoCriteria.getValue();
		String operator = daoCriteria.getOperator();
		
		if (operator.equals(QueryOperatorEnum.EQUAL.getName())) {
			return builder.equal(root.get(name).as(String.class), value);
		} else if (operator.equals(QueryOperatorEnum.LIKE.getName())) {
			return builder.like(root.get(name).as(String.class), value.toString());
		} else if (operator.equals(QueryOperatorEnum.NOT_IN.getName())) {
			return builder.not(new InPredicate<Object>((CriteriaBuilderImpl) builder, root.get(name).as(String.class), value));
		} else if (operator.equals(QueryOperatorEnum.BIGGER.getName())) {
			return builder.greaterThan(root.get(name).as(String.class), value.toString());
		} else if (operator.equals(QueryOperatorEnum.BIGGER_EQUAL.getName())) {
			return builder.greaterThanOrEqualTo(root.get(name).as(String.class), value.toString());
		} else if (operator.equals(QueryOperatorEnum.LESS.getName())) {
			return builder.lessThan(root.get(name).as(String.class), value.toString());
		} else if (operator.equals(QueryOperatorEnum.LESS_EQUAL.getName())) {
			return builder.lessThanOrEqualTo(root.get(name).as(String.class), value.toString());
		} else if (operator.equals(QueryOperatorEnum.NOT_EQUAL.getName())) {
			return builder.notEqual(root.get(name).as(String.class), value);
		} else if (operator.equals(QueryOperatorEnum.IN.getName())) {
			return builder.and(new InPredicate<Object>((CriteriaBuilderImpl) builder, root.get(name).as(String.class), value));
		} else {
			return null;
		}
	}
}
