package com.yeejoin.amos.patrol.service.business.service.impl;


import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.patrol.common.core.response.AppCheckInputRespone;
import com.yeejoin.amos.patrol.common.core.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.common.core.response.CalendarStatusCountRespone;
import com.yeejoin.amos.patrol.common.core.response.CommonPage;
import com.yeejoin.amos.patrol.common.core.response.GraphInitDataResponse;
import com.yeejoin.amos.patrol.common.core.response.PatrolUserRespone;
import com.yeejoin.amos.patrol.common.core.response.PointCheckInfoRespone;
import com.yeejoin.amos.patrol.common.core.response.PointInfoResponse;
import com.yeejoin.amos.patrol.common.core.response.PointPositionInfoSyn3DRespone;
import com.yeejoin.amos.patrol.common.core.response.QueryCriteriaRespone;
import com.yeejoin.amos.patrol.common.core.response.RouteResponse;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.Check;
import com.yeejoin.amos.patrol.common.entity.CheckInput;
import com.yeejoin.amos.patrol.common.entity.CheckShot;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.PointClassify;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.CheckStatusEnum;
import com.yeejoin.amos.patrol.common.enums.PointLevelEnum;
import com.yeejoin.amos.patrol.common.enums.PointStatusEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckDetailBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckInfoBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckInputBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckTraListBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckUserBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PlanRoutePointBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PointCheckDetailBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.CheckMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanTaskDetailMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICatalogTreeDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckInputDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckShotDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointClassifyDao;
import com.yeejoin.amos.patrol.service.business.dto.CheckDto;
import com.yeejoin.amos.patrol.service.business.param.CheckInfoListPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckInfoPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckInputParam;
import com.yeejoin.amos.patrol.service.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckRecordParam;
import com.yeejoin.amos.patrol.service.business.param.CheckStatisticalParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ICheckService;
import com.yeejoin.amos.patrol.service.business.util.CheckDetailInputPageParam;
import com.yeejoin.amos.patrol.service.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.patrol.service.business.vo.CheckInfoVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.core.util.StringUtil;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
//import com.yeejoin.amos.security.common.model.UserModel;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import javax.transaction.Transactional;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.yeejoin.amos.patrol.service.constants.XJConstant.*;

@Service("checkService")
public class CheckServiceImpl implements ICheckService {

    @Autowired
    private CheckMapper checkMapper;

    @Autowired
    private ICatalogTreeDao catalogTreeDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Resource
    private ICheckShotDao checkShotDao;

    @Resource
    private IPlanTaskDao planTaskDao;

    @Autowired
    private PlanTaskMapper planTaskMapper;

    @Autowired
    private IInputItemDao inputItemDao;

    @Autowired
    private ICheckInputDao checkInputDao;

    @Autowired
    private ICheckDao checkDao;

    @Autowired
    private PlanTaskDetailMapper planTaskDetailMapper;

    @Autowired
    private IPointClassifyDao iPointClassifyDao;

    @Autowired
    private AsyncTask asyncTask;

    @Value("${upload.server.address}")
    private String uploadAddress;

    @Override
    public Page<CheckInfoVo> getCheckInfo(String toke, String product, String appKey, CheckInfoPageParam param) {
        long total = checkMapper.countCheckInfoData(param);
        List<CheckInfoVo> content = Lists.newArrayList();
        if (total == 0) {
            return new PageImpl<>(content, param, total);
        }
        content = checkMapper.getCheckInfo(param);
        if (!CollectionUtils.isEmpty(content)) {
            Set<String> userIds = Sets.newHashSet(Lists.transform(content, CheckInfoVo::getUserId));

            Set<String> deptIds = Sets.newHashSet(Lists.transform(content, CheckInfoVo::getDepId));
            deptIds.remove("");
            deptIds.remove(null);
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
            Map<String, String> deptMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty(deptIds)) {
                List<LinkedHashMap> deptList = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(deptIds));
                //deptMap = deptList.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));

                for (int i = 0; i < deptList.size(); i++) {
                    deptMap.put(deptList.get(i).get("sequenceNbr").toString(), deptList.get(i).get("departmentName").toString());
                }


            }
            Map<String, String> userModelMap = userModels.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            Map<String, String> deptMapNew = deptMap;
            List<String> userNames = new ArrayList<>();

            content.forEach(e -> {
                userNames.clear();
                List<String> userIds1 = Arrays.asList(e.getUserId().split(","));
                for (String userId : userIds1) {
                    userNames.add(userModelMap.get(userId));
                }
                userNames.remove(null);
                e.setUserName(Joiner.on(",").join(userNames));
                e.setDepartmentName(deptMapNew.get(e.getDepId()));
            });
        }
        return new PageImpl<>(content, param, total);
    }

    @Override
    @Transactional
    public void saveCheckImg(CheckShot img) {
        Check check = checkDao.findById(img.getCheckId()).get();
        check.setShotNumber(check.getShotNumber() + 1);
        checkDao.save(check);
        checkShotDao.save(img);
    }

    @Override
    @Transactional
    public CheckDto saveCheckRecord(CheckRecordParam requestParam, AgencyUserModel user, DepartmentBo departmentModel) {
        PlanTask planTask = null;
        Check check = new Check();
        //HashMap<String, Object> routeParam = new HashMap<String, Object>();
        Map detail = null;
        if (!ObjectUtils.isEmpty(requestParam) && !ObjectUtils.isEmpty(requestParam.getPlanTaskId()) && requestParam.getPlanTaskId() > 0) {
            detail = planTaskDetailMapper.findPlanTaskByTaskIdAndPointId(requestParam.getPlanTaskId(), requestParam.getPointId());
            if (!ObjectUtils.isEmpty(detail)) {
                planTask = planTaskDao.findById(requestParam.getPlanTaskId()).get();
//                routeParam.put("routeId", planTask.getRouteId());
//                routeParam.put("pointId", requestParam.getPointId());
                check.setPlanTaskDetailId(Long.parseLong(detail.get("planTaskDetailId").toString()));
                check.setRouteId(Long.parseLong(detail.get("routeId").toString()));
                check.setPlanTaskId(requestParam.getPlanTaskId());
                check.setPlanId(planTask.getPlanId());
                check.setDepId(detail.get("depId").toString());
            }
        } else {
            planTask = new PlanTask();
            check.setPlanTaskDetailId(0);
            check.setRouteId(0);
            check.setPlanTaskId(0);
            check.setPlanId(0);
        }
//        check.setPointId(requestParam.getPointId());
//        check.setRemark(requestParam.getRemark());
//        check.setCheckTime(new Date());
//        check.setUploadTime(new Date());
//        check.setOrgCode(requestParam.getOrgCode());
//        check.setUserId(requestParam.getUserId());
//        check.setCheckDepartmentId(requestParam.getCheckDepartmentId());
//        check.setCheckMode(requestParam.getCheckMode());

        check.setPointId(requestParam.getPointId());
        check.setRemark(requestParam.getRemark());
//        try {
//			//check.setCheckTime(DateUtil.getLongDate(requestParam.getCheckTime()));
//			
//		} catch (ParseException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		}

        check.setCheckTime(new Date());
        check.setUploadTime(new Date());
        check.setOrgCode(requestParam.getOrgCode());
        check.setUserId(user.getUserId());
        check.setUserName(user.getRealName());
        check.setCheckDepartmentId(requestParam.getCheckDepartmentId());
        check.setDepId(requestParam.getCheckDepartmentId());
//        check.setDepId(departmentModel.getSequenceNbr());
        check.setDepName(departmentModel.getDepartmentName());
        check.setCheckMode(requestParam.getCheckMode());


        List<CheckInputParam> list = requestParam.getCheckItems();
        List<CheckInput> checkItemList = new ArrayList<>();
        List<Map<String, Object>> unqualifiedcheckItemList = Lists.newArrayList();
        String error = "";
        HashMap<String, String> errorClassifyNames = new HashMap<>();
        boolean isPushFlag = false;
        for (CheckInputParam item : list) {
            String pointClassifyName = null;
            if (StringUtil.isNotEmpty(item.getClassifyIds()) && iPointClassifyDao.existsById(item.getClassifyIds())) {
                PointClassify pointClassify = iPointClassifyDao.findById(item.getClassifyIds()).get();
                pointClassifyName = pointClassify.getName();
                if (!ObjectUtils.isEmpty(pointClassifyName) && (pointClassifyName.contains(INPUT_ITEM_DEXT) || pointClassifyName.contains(INPUT_ITEM_XEXT) ||
                        pointClassifyName.contains(INPUT_ITEM_WYXT) || pointClassifyName.contains(INPUT_ITEM_JWXT))) {
                    isPushFlag = true;
                }
            }
            InputItem inputItem = inputItemDao.findById(item.getInputItemId()).get();
            CheckInput checkInput = new CheckInput();
            checkInput.setCreateDate(new Date());
            checkInput.setOrgCode(requestParam.getOrgCode());
            checkInput.setInputId(Long.valueOf(item.getInputItemId() + ""));
            checkInput.setInputName(inputItem.getName());
            checkInput.setOrderNo(inputItem.getOrderNo());
            checkInput.setRemark(item.getRemark());
            if (XJConstant.INPUT_ITEM_SELECT.equals(inputItem.getItemType())) {
                checkInput = paraseSelect(checkInput, inputItem.getDataJson(), item, inputItem.getIsScore());
            } else if (XJConstant.INPUT_ITEM_NUMBER.equals(inputItem.getItemType())) {
                checkInput = paraseNumber(checkInput, inputItem.getDataJson(), item, inputItem.getIsScore());
            } else if (XJConstant.INPUT_ITEM_TEXT.equals(inputItem.getItemType())) {
                checkInput = paraseText(checkInput, inputItem.getDataJson(), item, inputItem.getIsScore());
            }
            if (XJConstant.NO.equals(checkInput.getIsOk())) {
                String classifyName = pointClassifyName != null ? pointClassifyName + "-" : "";
                error += (classifyName + inputItem.getName() + "=" + (ObjectUtils.isEmpty(item.getInputValue()) ? "" : item.getInputValue()) + ";");
                errorClassifyNames.put(pointClassifyName != null ? pointClassifyName : "", "");
                checkInput.setIsOk(CheckStatusEnum.UNQUALIFIED.getCode());
                Map<String, Object> unCheckMap = Maps.newHashMap();
                unCheckMap.put("itemId", item.getInputItemId());
                unCheckMap.put("routeId", check.getRouteId());
                unCheckMap.put("pointId", requestParam.getPointId());
                unCheckMap.put("name", inputItem.getName());
                unCheckMap.put("inputValue", item.getInputValue());
                unCheckMap.put("routePointItemId", item.getRoutePointItemId());
                unqualifiedcheckItemList.add(unCheckMap);

                // checkInput.setIsOk(CheckStatusEnum.UNQUALIFIED.getCode());
            } else {
                checkInput.setIsOk(CheckStatusEnum.QUALIFIED.getCode());
            }
            checkInput.setRoutePointItemId(item.getRoutePointItemId());
//			if (planTask.getRouteId() > 0) {
//				routeParam.put("inputItemId", inputItem.getId());
//				routeParam.put("pointClassifyId", item.getClassifyIds());
//				List<RoutePointItem> routePointItem = routeMapper.queryRoutePointItem(routeParam);
//				if(!routePointItem.isEmpty()){
//					checkInput.setRoutePointItemId(routePointItem.get(0).getId());
//				}
//			} else {
//				checkInput.setRoutePointItemId(0l);
//			}
            checkInput.setInputValue(item.getInputValue());
            checkInput.setPointClassifyId(item.getClassifyIds());
            checkInput.setPointClassifyName(pointClassifyName);
            checkItemList.add(checkInput);
        }
        if (isPushFlag){
            asyncTask.pushChartResulPaytask();//更新支付业务刷新标识
        }
        if (!ObjectUtils.isEmpty(error) && error.endsWith(";")) {
            error.substring(0, error.length() - 1);
            check.setIsOk(CheckStatusEnum.UNQUALIFIED.getCode());
        } else {
            check.setIsOk(CheckStatusEnum.QUALIFIED.getCode());
        }
        check.setError(error);
        check.setErrorClassify(StringUtils.join(errorClassifyNames.keySet(), ","));
        check = checkDao.save(check);
        for (CheckInput item : checkItemList) {
            item.setCheckId(check.getId());
        }
        checkInputDao.saveAll(checkItemList);
        try {
            if (check.getPlanTaskId() > 0) {
                //
                if (planTask != null) {
                    int number = planTask.getPointNum() - planTask.getFinishNum();
//                    if (number == 1) {
//                        Plan plan = iPlanDao.findOne(planTask.getPlanId());
//                        if (plan != null) {
//                            remoteJiaodaService.updatePlanState(plan.getOriginalId(), "执行完毕");
//                        }
//                    }
                }
                planTaskDetailMapper.finishTaskDetail(Long.parseLong(detail.get("planTaskDetailId").toString()), requestParam.getPointId(), requestParam.getPlanTaskId(), requestParam.getUserId());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                planTaskMapper.reformStatistics(requestParam.getUserId(), sdf.format(new Date()), requestParam.getOrgCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new CheckDto(check.getId(), unqualifiedcheckItemList);
    }

    @Override
    public void delCheckById(List<Long> list) {
        for (Long id : list) {
            //checkDao.delete(id);
            checkDao.deleteById(id);
        }
    }

    private CheckInput paraseText(CheckInput checkInput, String json, CheckInputParam item, String isScore) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        String checkType = jsonObject.getString("CheckType");
        int score = 0;
        if (XJConstant.CHECK_TYPE_ALWAYS_OK.equals(checkType)) {
            score = jsonObject.getInt(XJConstant.INPUT_ITEM_OK_SCORE);
            checkInput.setIsOk(XJConstant.OK);

        } else if (XJConstant.CHECK_TYPE_ALWAYS_NO.equals(checkType)) {
            checkInput.setIsOk(XJConstant.NO);
            score = jsonObject.getInt(XJConstant.INPUT_ITEM_NOT_SCORE);

        } else if (XJConstant.CHECK_TYPE_CONTEXT_OK.equals(checkType)) {
            if (!ObjectUtils.isEmpty(item.getInputValue()) && !ObjectUtils.isEmpty(item.getInputValue().trim())) {
                checkInput.setIsOk(XJConstant.OK);
                score = jsonObject.getInt(XJConstant.INPUT_ITEM_OK_SCORE);
            } else {
                checkInput.setIsOk(XJConstant.NO);
                score = jsonObject.getInt(XJConstant.INPUT_ITEM_NOT_SCORE);
            }
        } else if (XJConstant.CHECK_TYPE_NO_CONTEXT_OK.equals(checkType)) {
            if (!ObjectUtils.isEmpty(item.getInputValue()) && !ObjectUtils.isEmpty(item.getInputValue().trim())) {
                checkInput.setIsOk(XJConstant.NO);
                score = jsonObject.getInt(XJConstant.INPUT_ITEM_NOT_SCORE);
            } else {
                checkInput.setIsOk(XJConstant.OK);
                score = jsonObject.getInt(XJConstant.INPUT_ITEM_OK_SCORE);
            }
        }
        if (XJConstant.YES.equals(isScore)) checkInput.setScore(score);
        return checkInput;
    }

    private CheckInput paraseNumber(CheckInput checkInput, String json, CheckInputParam item, String isScore) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        String OkUpStr = jsonObject.get("OkUp").toString();
        ;
        String OkDownStr = jsonObject.get("OkDown").toString();
        Double OkUp = StringUtil.isNotEmpty(OkUpStr) ? Double.valueOf(OkUpStr) : null;
        Double OkDown = StringUtil.isNotEmpty(OkDownStr) ? Double.valueOf(OkDownStr) : null;
        boolean CheckOkUp = jsonObject.getBoolean("CheckOkUp");
        boolean CheckOkDown = jsonObject.getBoolean("CheckOkDown");
        int OkScore = jsonObject.getInt("OkScore");
        int NoScore = jsonObject.getInt("NoScore");
        double inputValue = 0;
        int score = 0;
        String inputVal = item.getInputValue();
        if (!ObjectUtils.isEmpty(inputVal)) {
            inputValue = Double.valueOf(inputVal);
        }
        if (OkUp != null && inputValue > OkUp) {
            if (CheckOkUp) {
                checkInput.setIsOk(XJConstant.NO);
                score = NoScore;
            } else {
                checkInput.setIsOk(XJConstant.OK);
                score = OkScore;
            }
        } else if (OkDown != null && inputValue < OkDown) {
            if (CheckOkDown) {
                checkInput.setIsOk(XJConstant.NO);
                score = NoScore;
            } else {
                checkInput.setIsOk(XJConstant.OK);
                score = OkScore;
            }
        } else {
            checkInput.setIsOk(XJConstant.OK);
            score = OkScore;
        }
        if (XJConstant.YES.equals(isScore)) checkInput.setScore(score);
        return checkInput;
    }

    private CheckInput paraseSelect(CheckInput checkInput, String json, CheckInputParam item, String isScore) {
        JSONArray jsonArray = JSONArray.fromObject(json);
        int score = 0;
        if (!ObjectUtils.isEmpty(jsonArray)) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String validateName = jsonObject.getString("name");
                String validateIsOk = jsonObject.getString("isOk");
                int OkScore = 0;
                if (jsonObject.containsKey("score") && !ObjectUtils.isEmpty(jsonObject.get("score"))) {
                    OkScore = jsonObject.getInt("score");
                }
                if (validateName.equals(item.getInputValue())) {
                    if (validateIsOk.equals(XJConstant.YES) || validateIsOk.equals(XJConstant.OK)) {
                        checkInput.setIsOk(XJConstant.OK);
                        checkInput.setInputValue(XJConstant.YES);
                    } else {
                        checkInput.setIsOk(XJConstant.NO);
                        checkInput.setInputValue(XJConstant.NOT);
                    }
                    score = OkScore;
                    break;
                }
            }
        }
        if (XJConstant.YES.equals(isScore)) checkInput.setScore(score);
        return checkInput;
    }

    @Override
    public List<Map> queryUnqualifiedInputItem(int checkId) {
        return checkMapper.queryUnqualifiedInputItem(checkId);
    }

    @Override
    public int checkHasRecord(CheckRecordParam requestParam) {
        return checkMapper.checkHasRecord(requestParam);
    }

    @Override
    public AppPointCheckRespone queryCheckPointDetail(String toke, String product, String appKey, long checkId) {
//		List list = checkMapper.queryCheckPointInputItem(planTaskId, pointId);
        List<PointCheckDetailBo> list = checkMapper.findCheckPointInputItem(checkId);
        AppPointCheckRespone pointCheckRespone = new AppPointCheckRespone();
        if (!list.isEmpty()) {
            try {
//                InetAddress address = InetAddress.getLocalHost();
//                String ip = address.getHostAddress();
                List<String> pointImgUrls = new ArrayList<>();
                PointCheckDetailBo pointCheckDetailBo = list.get(0);
                List<CheckShot> pointShot = checkShotDao.findAllByCheckIdAndCheckInputId(pointCheckDetailBo.getCheckId(), 0l);
                pointShot.forEach(action -> {
                    pointImgUrls.add(uploadAddress + action.getPhotoData());
                });
                Check check = checkDao.findById(checkId).get();
                pointCheckRespone.setPointId(pointCheckDetailBo.getPointId());
                pointCheckRespone.setPointName(pointCheckDetailBo.getPointName());
                pointCheckRespone.setPointNo(pointCheckDetailBo.getPointNo());
                pointCheckRespone.setPointStatus(pointCheckDetailBo.getPointStatus());
                pointCheckRespone.setPlanName(pointCheckDetailBo.getPlanName());
                DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey, pointCheckDetailBo.getCheckDepartmentId());
                if (departmentBo != null) {
                    pointCheckRespone.setDepartmentName(departmentBo.getDepartmentName());
                }
                List<String> userIds = Arrays.asList(pointCheckDetailBo.getUserId().split(","));
                List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, pointCheckDetailBo.getUserId());
                Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
                if (userModelMap != null) {
                    List<String> userNameList = new ArrayList<>();
                    for (String userId : userIds) {
                        userNameList.add(userModelMap.get(userId));
                    }
                    userNameList.remove("");
                    userNameList.remove(null);
                    pointCheckRespone.setUsername(Joiner.on(",").join(userNameList));
                }
                pointCheckRespone.setCheckTime(pointCheckDetailBo.getCheckTime());
                pointCheckRespone.setCheckId(pointCheckDetailBo.getCheckId());
                pointCheckRespone.setRemark(pointCheckDetailBo.getCheckRemark());
                pointCheckRespone.setPointImgUrls(pointImgUrls);
                pointCheckRespone.setScore(check.getScore() + "");


                Map<String, List<AppCheckInputRespone>> appResponeMap = new HashMap<>();
                list.forEach(action -> {
                    List<String> pointInputImgUrls = new ArrayList<>();
                    //List<CheckShot> pointInputShot = checkShotDao.findAllByCheckIdAndCheckInputId(pointCheckDetailBo.getCheckId(), action.getCheckInputId());

                    List<CheckShot> pointInputShot = checkShotDao.findAllByCheckIdAndCheckInputIdAndClassifyId(pointCheckDetailBo.getCheckId(), action.getCheckInputId(), action.getClassifyId());


                    pointInputShot.forEach(inputShot -> {
                        pointInputImgUrls.add(uploadAddress + inputShot.getPhotoData());
                    });
                    AppCheckInputRespone appCheckInputRespone = new AppCheckInputRespone();
                    appCheckInputRespone.setCheckInputId(action.getCheckInputId());
                    appCheckInputRespone.setInputName(action.getInputName());
                    appCheckInputRespone.setInputStatus(action.getInputStatus());
                    appCheckInputRespone.setInputValue(action.getInputValue());
                    appCheckInputRespone.setItemType(action.getItemType());
                    appCheckInputRespone.setDataJson(action.getDataJson());
                    appCheckInputRespone.setIsMust(action.getIsMust());
                    appCheckInputRespone.setIsMultiline(action.getIsMultiline());
                    appCheckInputRespone.setPictureJson(action.getPictureJson());
                    appCheckInputRespone.setOrderNo(action.getOrderNo());
                    appCheckInputRespone.setPointInputImgUrls(pointInputImgUrls);
                    appCheckInputRespone.setClassifyId(action.getClassifyId());
                    appCheckInputRespone.setClassifyName(action.getClassifyName());
                    appCheckInputRespone.setRemark(action.getRemark());

                    String key = ObjectUtils.isEmpty(action.getClassifyName()) ? "其他" : action.getClassifyName();
                    if (appResponeMap.containsKey(key)) {
                        appResponeMap.get(key).add(appCheckInputRespone);
                    } else {
                        List<AppCheckInputRespone> appCheckInputResponeList = new ArrayList<AppCheckInputRespone>();
                        appCheckInputResponeList.add(appCheckInputRespone);
                        appResponeMap.put(key, appCheckInputResponeList);
                    }
                });
                pointCheckRespone.setAppCheckInput(appResponeMap);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return pointCheckRespone;
        }

//		List<Map<String, Object>> imgs = checkMapper.queryCheckPointImgs(planTaskId, pointId);
//		List<String> pointImgUrl = new ArrayList<String>();
//		Map<String, Object> resp = new HashMap<>();
//		resp.put("inputItems", list);
//		try {
//			InetAddress address = InetAddress.getLocalHost();
//			String ip = address.getHostAddress();
//			String ipPort ="http://" + ip+":"+port;
//			for (Map<String, Object> map : imgs) {
//				map.put("photoData", ipPort + map.get("photoData"));
//			}
//			resp.put("imgUrls", imgs);
//		} catch (UnknownHostException e) {
//			e.printStackTrace();
//		}
        return pointCheckRespone;
    }


    @Override
    public Map<String, Object> queryRecordByPointId(HashMap<String, Object> req) {
        if (!ObjectUtils.isEmpty(req.get("userId"))) {
            req.put("userId", req.get("userId") + ",");
        }
        if (!ObjectUtils.isEmpty(req.get("planId"))) {
            req.put("planId", req.get("planId") + ",");
        }
        if (!ObjectUtils.isEmpty(req.get("department"))) {
            req.put("department", req.get("department") + ",");
        }
        if (!ObjectUtils.isEmpty(req.get("pointId"))) {
            req.put("pointId", req.get("pointId") + ",");
        }
        List<Map<String, Object>> checkMaps = checkMapper.queryRecordByPointId(req);
        Map<String, Object> resp = new HashMap<>();

        for (Map<String, Object> item : checkMaps) {
            List<Map<String, Object>> respItems = (List<Map<String, Object>>) resp.get(item.get("checkDate").toString());
            if (ObjectUtils.isEmpty(respItems)) {
                respItems = new ArrayList<>();
            }
            respItems.add(item);
            resp.put(item.get("checkDate").toString(), respItems);
        }
        return resp;
    }

    @Override
    public Map<String, Object> queryRecordById(int checkId) {
        Map<String, Object> check = checkMapper.queryCheckById(checkId);
        List<Map<String, Object>> checkInputItems = checkMapper.queryCheckInputItems(checkId);
        List<Map<String, Object>> checkimgs = checkMapper.queryCheckImgs(checkId);

        Map<String, Object> resp = new HashMap<>();
        resp.put("check", check);
        resp.put("inputItems", checkInputItems);
        try {
            for (Map<String, Object> map : checkimgs) {
                String imgPath = map.get("photoData").toString().replace("\\", "/");
                map.put("photoData", uploadAddress + imgPath);
                map.put("openOperUrl", "window.open('" + uploadAddress + imgPath + "')");
            }
            resp.put("imgs", checkimgs);
        } catch (Exception e) {
            e.printStackTrace();
        }
//		resp.put("imgs", checkimgs);
        return resp;
    }

    @Override
    public Map<String, Object> checkCalendar(CheckRecordParam requestParam) {
        Map<String, Object> charData = checkMapper.pieChartData(requestParam);
        List<Map<String, Object>> calendarData = checkMapper.calendarData(requestParam);
        Map<String, Object> result = new HashMap<>();
        Map<String, List<CalendarStatusCountRespone>> calendarMap = new HashMap<>();
        if (!calendarData.isEmpty()) {
            calendarData.forEach(action -> {
                List<CalendarStatusCountRespone> statusCountList = new ArrayList<>();
                CalendarStatusCountRespone statusCount = new CalendarStatusCountRespone();
                statusCount.setCount(Double.valueOf(action.get("count").toString()));
                statusCount.setStatus(action.get("status").toString());
                if (calendarMap.containsKey(action.get("time"))) {
                    statusCountList = calendarMap.get(action.get("time"));
                    statusCountList.add(statusCount);
                } else {
                    statusCountList.add(statusCount);
                    calendarMap.put(action.get("time").toString(), statusCountList);
                }
            });
        }
        result.put("charData", charData);
        result.put("calendarData", calendarMap);
        return result;
    }

    @Override
    public List<CheckInfoVo> getCheckInfoList(String toke, String product, String appKey, CheckInfoPageParam param) {
        List<CheckInfoVo> list = checkMapper.getCheckInfo(param);
        Set<String> userIds = Sets.newHashSet(Lists.transform(list, CheckInfoVo::getUserId));
        Set<String> deptIds = Sets.newHashSet(Lists.transform(list, CheckInfoVo::getDepId));
        deptIds.remove("");
        deptIds.remove(null);
        List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
        Map<String, String> deptMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(deptIds)) {
            List<LinkedHashMap> deptList = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(deptIds));
            // deptMap = deptList.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));
            for (int i = 0; i < deptList.size(); i++) {
                deptMap.put(deptList.get(i).get("sequenceNbr").toString(), deptList.get(i).get("departmentName").toString());
            }
        }
        Map<String, String> userModelMap = userModels.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
        Map<String, String> deptMapNew = deptMap;
        List<String> userNames = new ArrayList<>();
        list.forEach(e -> {
            userNames.clear();
            List<String> userIds1 = Arrays.asList(e.getUserId().split(","));
            for (String userId : userIds1) {
                userNames.add(userModelMap.get(userId));
            }
            userNames.remove(null);
            e.setUserName(Joiner.on(",").join(userNames));
            e.setDepartmentName(deptMapNew.get(e.getDepId()));
        });
        return list;
    }

    @Override
    public List<Map<String, Object>> getCheckInfoImgsList(CheckInfoPageParam param) {
        return checkMapper.getCheckInfoImgsList(param);
    }

    @Override
    public List<Map<String, Object>> getCheckInfoImgsList(Long[] ids) {
        return checkMapper.getCheckInfoImgsByCheckIdsList(ids);
    }

    @Override
    public List<CheckInfoVo> getSelectedCheckInfoList(String toke, String product, String appKey, Long[] ids) {
        List<CheckInfoVo> list = checkMapper.getSelectedCheckInfoList(ids);
        Set<String> userIds = Sets.newHashSet(Lists.transform(list, CheckInfoVo::getUserId));
        Set<String> deptIds = Sets.newHashSet(Lists.transform(list, CheckInfoVo::getDepId));
        deptIds.remove("");
        deptIds.remove(null);
        List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
        Map<String, String> deptMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(deptIds)) {
            List<LinkedHashMap> deptList = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(deptIds));
            //deptMap = deptList.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));
            for (int i = 0; i < deptList.size(); i++) {
                deptMap.put(deptList.get(i).get("sequenceNbr").toString(), deptList.get(i).get("departmentName").toString());
            }
        }
        Map<String, String> userModelMap = userModels.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
        Map<String, String> deptMapNew = deptMap;
        List<String> userNames = new ArrayList<>();
        list.forEach(e -> {
            userNames.clear();
            List<String> userIds1 = Arrays.asList(e.getUserId().split(","));
            for (String userId : userIds1) {
                userNames.add(userModelMap.get(userId));
            }
            userNames.remove(null);
            e.setUserName(Joiner.on(",").join(userNames));
            e.setDepartmentName(deptMapNew.get(e.getDepId()));
        });
        return list;
    }

    @Override
    public List<HashMap<String, Object>> getCountMonthChkByRole(HashMap<String, Object> paramMap, String dateMonth) {
        if (dateMonth == null) {
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            dateMonth = format.format(date);
        } else {
            dateMonth = dateMonth.substring(0, 8);
        }
        String startDate = DateUtil.getStartMonthDate(dateMonth, "yyyy-MM-dd");
        String endDate = DateUtil.getEndMonthDate(dateMonth, "yyyy-MM-dd");
        paramMap.put("startDate", startDate);
        paramMap.put("endDate", endDate);
        paramMap.put("finish_yes", XJConstant.TASK_STATUS_FINISH);
        paramMap.put("finish_out", XJConstant.TASK_STATUS_TIMEOUT);
        List<HashMap<String, Object>> content = null;
        if (!XJConstant.PERSON_FLAG.equals(paramMap.get("roleFlag"))) {
            content = checkMapper.getCountMonthChk(paramMap);
        }
        return content;
    }

    @SuppressWarnings("unchecked")
    @Override
    public QueryCriteriaRespone getQueryCriteriaInit(String toke, String product, String appKey, String loginOrgCode, String roleTypeName, String departmentId, String companyId) {
        QueryCriteriaRespone pointQueryCriteriaRespone = new QueryCriteriaRespone();
        if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase()) || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())) {
            List<DepartmentModel> departmentBos = remoteSecurityService.listDepartmentsByCompanyId(toke, product, appKey, companyId);
            pointQueryCriteriaRespone.setDepartments(departmentBos);//公司下部门
        } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
            DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey, departmentId);
            pointQueryCriteriaRespone.setDepartments(Lists.newArrayList(departmentBo));//本公司
        } else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName.toUpperCase())) {//个人不返回
            return null;
        }
        pointQueryCriteriaRespone.setTypes(catalogTreeDao.findByOrgCode(loginOrgCode));
        pointQueryCriteriaRespone.setStatus(PointStatusEnum.getEnumList());
        pointQueryCriteriaRespone.setPointLevel(PointLevelEnum.getEnumList());
        return pointQueryCriteriaRespone;
    }

    @Override
    public List<HashMap<String, String>> getCalCountChkInfo(HashMap<String, Object> paramsMap) {
        List<HashMap<String, String>> checkCalCountInfoList = checkMapper.getCalenderCountInfoList(paramsMap);
        return checkCalCountInfoList;
    }

    @Override
    public List<CheckUserBo> getAuthUserInfo(HashMap<String, Object> paramsMap) {
        List<CheckUserBo> checkUserBoList = checkMapper.getCheckUserInfoList(paramsMap);
        return checkUserBoList;
    }

    private Long getLastsetCheckByPointID(Long pointId) {
        Long checkID = checkMapper.getLastsetCheckByPointID(pointId);
        return checkID;
    }

    @Override
    public CommonPage<CheckInputBo> getCheckInputByCheckId(CheckDetailInputPageParam param) {
        // 如果不传巡检ID，则获取最新一条巡检点对应的巡检记录ID
        if (param.getCheckID() == -1) {
            Long checkID = getLastsetCheckByPointID(param.getPointID());
            if (checkID != null) {
                param.setCheckID(checkID);
            }
        }
        Long checkID = param.getCheckID();
        long total = checkMapper.countCheckInputByMybatis(checkID);
        List<CheckInputBo> content = checkMapper.getCheckInputByCheckId(param);
        CommonPage<CheckInputBo> result = new CommonPage<>(content, param, total);
        return result;
    }

    @Override
    public CheckDetailBo getCheckDetailById(CheckDetailInputPageParam param) {
        long checkID = param.getCheckID();
        CheckDetailBo checkDetailBo = checkMapper.getCheckDetailByID(param);
        checkDetailBo.setCheckID(checkID);
        checkDetailBo.setPhotosUrl(getLivePhotos(checkID));
        return checkDetailBo;
    }

    @Override
    public List<String> getCheckInputPhotoById(Long checkID) {
        List<String> photos = checkMapper.getCheckInputPhotoByID(checkID);
        return photos;
    }

    @Override
    public Page<CheckTraListBo> getCheckTraList(CheckPtListPageParam params) {
        long total = checkMapper.countCheckTraListData(params);
        List<CheckTraListBo> content = checkMapper.getCheckTraList(params);
        Page<CheckTraListBo> result = new PageImpl<CheckTraListBo>(content, params, total);
        return result;
    }

    @Override
    public List<PlanRoutePointBo> getRoutePlanPointList(CheckPtListPageParam params) {
        List<PlanRoutePointBo> content = checkMapper.getLastPointCheckList(params);
        return content;
    }

    @Override
    public QueryCriteriaRespone findCheckSystemInit(String toke, String product, String appKey, String type, String orgCode, String roleTypeName, String departmentId, String companyId) {
        QueryCriteriaRespone pointQueryCriteriaRespone = new QueryCriteriaRespone();
        if ("user".equals(type)) {
            List<AgencyUserModel> users = remoteSecurityService.listUserByCompanyId(toke, product, appKey, companyId);
            pointQueryCriteriaRespone.setUsers(users);
        } else if ("status".equals(type)) {
            pointQueryCriteriaRespone.setStatus(PointStatusEnum.getEnumList());
        } else if ("pointLevel".equals(type)) {
            pointQueryCriteriaRespone.setPointLevel(PointLevelEnum.getEnumList());
        } else if ("type".equals(type)) {
            pointQueryCriteriaRespone.setTypes(catalogTreeDao.findByOrgCode(orgCode));
        } else if ("departments".equals(type)) {
//			pointQueryCriteriaRespone.setDepartments(iUserService.getGroupListByUser(user));
            if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())
                    || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())) {
                List<DepartmentModel> departmentBoList = remoteSecurityService.listDepartmentsByCompanyId(toke, product, appKey, companyId);
                pointQueryCriteriaRespone.setDepartments(departmentBoList);// 公司下部门
            } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
                DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey, departmentId);
                pointQueryCriteriaRespone.setDepartments(Lists.newArrayList(departmentBo));// 本公司
            } else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName.toUpperCase())) {// 个人不返回
                return null;
            }
        }

        return pointQueryCriteriaRespone;
    }

    @Override
    public Page<CheckInfoBo> getCheckInfoList(CheckInfoListPageParam params) {
        long total = checkMapper.countCheckInfoListData(params);
        List<CheckInfoBo> content = checkMapper.getCheckInfoList(params);
        Page<CheckInfoBo> result = new PageImpl<CheckInfoBo>(content, params, total);
        return result;
    }

    @Override
    public Page<PointCheckInfoRespone> getCheckInfoList1(CheckInfoListPageParam params) {
        long total = checkMapper.countCheckInfoListData1(params);
        List<PointCheckInfoRespone> content = checkMapper.getCheckInfoList1(params);
        Page<PointCheckInfoRespone> result = new PageImpl<PointCheckInfoRespone>(content, params, total);
        return result;
    }

    @Override
    public GraphInitDataResponse getViewModuleInitData() {
        List<Map<String, Object>> list = checkMapper.getRoutesAndPointsInfo();
        Map<String, RouteResponse> routeMap = new HashMap<String, RouteResponse>();
        Map<String, PointInfoResponse> pointMap = new HashMap<String, PointInfoResponse>();
        List<PointInfoResponse> pointInfoResponseList = new ArrayList<PointInfoResponse>();
        List<RouteResponse> routeResponseList = new ArrayList<RouteResponse>();
        Map<String, PatrolUserRespone> userMap = new HashMap<String, PatrolUserRespone>();
        GraphInitDataResponse graphInitDataResponse = new GraphInitDataResponse();
        list.forEach(action -> {
            PatrolUserRespone patrolUserRespone = null;
            if (action.get("OpenID") != null) {
                patrolUserRespone = userMap.get(action.get("OpenID").toString());
                if (patrolUserRespone == null) {
                    patrolUserRespone = new PatrolUserRespone();
                    patrolUserRespone.setUserId(action.get("OpenID") != null ? action.get("OpenID").toString() : "");
                    patrolUserRespone.setUserName(action.get("RealName") != null ? action.get("RealName").toString() : "");
                    patrolUserRespone.setOrgCode(action.get("orgCode") != null ? action.get("orgCode").toString() : "");
                    patrolUserRespone.setGroupName(action.get("GroupName") != null ? action.get("GroupName").toString() : "");
                }
            } else {
                String orgCode = null;
                if (action.get("gOrgCode") != null) {
                    orgCode = action.get("gOrgCode").toString();
                } else {
                    orgCode = action.get("compCode") != null ? action.get("compCode").toString() : null;
                }
                if (orgCode != null) {
                    patrolUserRespone = new PatrolUserRespone();
                    patrolUserRespone.setOrgCode(orgCode);
                }
            }

            if (action.get("PointID") != null) {
                getPointInfoResponseList(pointMap, action, patrolUserRespone, pointInfoResponseList);
            }
            if (action.get("RouteID") != null) {
                getRouteList(routeMap, action, patrolUserRespone, routeResponseList);
            }
        });
        graphInitDataResponse.setRoutes(routeResponseList);
        graphInitDataResponse.setPoints(pointInfoResponseList);
        return graphInitDataResponse;
    }

    private List<RouteResponse> getRouteList(Map<String, RouteResponse> route
            , Map<String, Object> data
            , PatrolUserRespone patrolUserRespone
            , List<RouteResponse> routeResponseList) {

        RouteResponse routeResponse = route.get(data.get("RouteID").toString());
        List<PatrolUserRespone> patrolUsers = new ArrayList<PatrolUserRespone>();
        if (routeResponse == null) {
            routeResponse = new RouteResponse();
            routeResponse.setRouteId(Integer.valueOf(data.get("RouteID").toString()));
            routeResponse.setRouteName(data.get("rName") != null ? data.get("rName").toString() : "");
            routeResponse.setBoss(data.get("Boss") != null ? data.get("Boss").toString() : "");
            routeResponse.setTel(data.get("Tel") != null ? data.get("Tel").toString() : "");
            if (patrolUserRespone != null) {
                patrolUsers.add(patrolUserRespone);
            }
            routeResponse.setPatrolUsers(patrolUsers);
            routeResponseList.add(routeResponse);
            route.put(data.get("RouteID").toString(), routeResponse);
        } else {
            if (patrolUserRespone != null) {
                patrolUsers = routeResponse.getPatrolUsers();
                List<String> userIds = patrolUsers.stream().filter(num -> num != null).map(arg0 -> arg0.getUserId()).collect(Collectors.toList());
                if (!userIds.contains(patrolUserRespone.getUserId())) {
                    patrolUsers.add(patrolUserRespone);
                    routeResponse.setPatrolUsers(patrolUsers);
                }
            }

        }
        return routeResponseList;

    }

    private List<PointInfoResponse> getPointInfoResponseList(Map<String, PointInfoResponse> pointMap
            , Map<String, Object> data
            , PatrolUserRespone patrolUserRespone
            , List<PointInfoResponse> pointInfoResponseList) {
        PointInfoResponse pointInfoResponse = pointMap.get(data.get("PointID").toString());
        List<PatrolUserRespone> patrolUsers = new ArrayList<PatrolUserRespone>();
        if (pointInfoResponse == null) {
            pointInfoResponse = new PointInfoResponse();
            pointInfoResponse.setPointId(Integer.valueOf(data.get("PointID").toString()));
            if (data.get("floor") != null) {
                PointPositionInfoSyn3DRespone config = new PointPositionInfoSyn3DRespone();
                config.setBelongObjModel("floor_" + data.get("floor").toString());
                config.setIsIndoor(Boolean.valueOf(data.get("isIndoor").toString()));
                pointInfoResponse.setConfig(config);
            }
            pointInfoResponse.setRouteNames(data.get("rName") != null ? data.get("rName").toString() : "");
            pointInfoResponse.setPointName(data.get("pName") != null ? data.get("pName").toString() : "");
            pointInfoResponse.setCoordinates(data.get("coordinates") != null ? data.get("coordinates").toString() : "");
            pointInfoResponse.setPointLevel(data.get("level") != null ? data.get("level").toString() : "");
            pointInfoResponse.setStatus(data.get("RealTimeStatus") != null ? data.get("RealTimeStatus").toString() : "");
            pointInfoResponse.setAddress(data.get("Address") != null ? data.get("Address").toString() : "");
            pointInfoResponse.setTaskId(data.get("taskId") != null ? Long.valueOf(data.get("taskId").toString()) : null);

            if (patrolUserRespone != null) {
                patrolUsers.add(patrolUserRespone);
            }
            pointInfoResponse.setUsers(patrolUsers);
            pointInfoResponseList.add(pointInfoResponse);
            pointMap.put(data.get("PointID").toString(), pointInfoResponse);
        } else {
            if (patrolUserRespone != null) {
                patrolUsers = pointInfoResponse.getUsers();
                List<String> userIds = patrolUsers.stream().filter(num -> num != null).map(arg0 -> arg0.getUserId()).collect(Collectors.toList());
                if (!userIds.contains(patrolUserRespone.getUserId())) {
                    patrolUsers.add(patrolUserRespone);
                    pointInfoResponse.setUsers(patrolUsers);
                }

                if (data.get("rName") != null && data.get("rName") != "") {
                    if (pointInfoResponse.getRouteNames().indexOf(data.get("rName").toString()) == -1) {
                        pointInfoResponse.setRouteNames(pointInfoResponse.getRouteNames() + "," + data.get("rName").toString());
                    }
                }
            }

        }
        return pointInfoResponseList;

    }

    @Override
    public List<CheckAnalysisVo> getCheckStatisticalAnalysis(String toke,String product,String appKey,CheckStatisticalParam param) {
        List<CheckAnalysisVo> checkAnalysisVos = checkMapper.getCheckStatisticalAnalysis(param);
        if(param.getStatisticsTyle()==4){
        	
           
        	//处理用户信息
            
            
            String userIds="";
            Set<String> set = new HashSet<>();
            checkAnalysisVos.forEach(s -> {  
            	
                 set.add(s.getName().toString());
            	
            });
            
            List<String> list1 = new ArrayList<>(set);
            userIds = String.join(",", list1);
     
              
            List<AgencyUserModel> listd=remoteSecurityService.listUserByUserIds( toke, product, appKey, userIds);
            
            //新安全
            checkAnalysisVos.forEach(s -> {      	
            		 listd.forEach(s1 -> {    
            	    		
            	    		if(s.getName().equals(s1.getUserId())){
            	    			
            	    			 s.setName(s1.getUserName());          	    			         	    		}
            	        	
            	        });          	    	
            	    });
          	
        	
        }else if(param.getStatisticsTyle()==3){
        	
        	 String dep="";
             Set<String> set = new HashSet<>();
             checkAnalysisVos.forEach(s -> {  
             	
                  set.add(s.getName().toString());
             	
             });
             
             List<String> list1 = new ArrayList<>(set);
             dep = String.join(",", list1);
      
               
             List<LinkedHashMap> listd=remoteSecurityService.listDepartmentByDeptIds( toke, product, appKey, dep);
             
             //新安全
             checkAnalysisVos.forEach(s -> {      	
             		 listd.forEach(s1 -> {    
             	    		
             	    		if(s.getName().equals(s1.get("sequenceNbr")+"")){
             	    			
             	    			 s.setName(s1.get("departmentName")+"");          	    			         	    		}
             	        	
             	        });          	    	
             	    });
           	
        	
        	
        }
        
        
        
        
        
        
        CheckAnalysisVo countVo = new CheckAnalysisVo();
        int planTaskCount = 0;
        int checkCount = 0;
        int ok = 0;
        int faild = 0;
        int missed = 0;
        double score = 0;
        double missedRate = 0;
        double faildRate = 0;
        int size = checkAnalysisVos.size();
        for (CheckAnalysisVo checkAnalysisVo : checkAnalysisVos) {
            planTaskCount += Integer.parseInt(checkAnalysisVo.getPlanTaskCount());
            checkCount += Integer.parseInt(checkAnalysisVo.getCheckCount());
            ok += Integer.parseInt(checkAnalysisVo.getOk());
            faild += Integer.parseInt(checkAnalysisVo.getFaild());
            missed += Integer.parseInt(checkAnalysisVo.getMissed());
            score += Double.parseDouble(checkAnalysisVo.getScore());
            missedRate += Double.parseDouble(checkAnalysisVo.getMissedRate());
            faildRate += Double.parseDouble(checkAnalysisVo.getFaildRate());
        }
        countVo.setName("合计");
        countVo.setPlanTaskCount(String.valueOf(planTaskCount));
        countVo.setCheckCount(String.valueOf(checkCount));
        countVo.setOk(String.valueOf(ok));
        countVo.setFaild(String.valueOf(faild));
        countVo.setMissed(String.valueOf(missed));
        
        if(size==0){
        	 countVo.setScore("0");
             countVo.setMissedRate("0");
             countVo.setFaildRate("0");
        }else{
        countVo.setScore(String.valueOf(score / size));
        countVo.setMissedRate(String.valueOf(missedRate / size));
        countVo.setFaildRate(String.valueOf(faildRate / size));
        }
        checkAnalysisVos.add(countVo);
        return checkAnalysisVos;
    }

    @Override
    public long getCumulativeCheckCountByOrgCode(String loginOrgCode) {
        return checkMapper.getCumulativeCheckCountByOrgCode(loginOrgCode);
    }

    @Override
    public List<Long> getCheckDataCount(HashMap<String, Object> param) {
        return checkMapper.getCheckDataCount(param);
    }

    @Override
    public List<String> getCheckPhotosByCheckAndInputId(int checkId, int checkInputId) {
        return checkMapper.getPhotosByCheckIDAndInputId(checkId, checkInputId);
    }

    @Override
    public List<String> getLivePhotos(Long checkID) {
        return checkMapper.getLivePhotos(checkID);
    }

    @Override
    public List<String> getCheckPhotosByCheckAndInputIdAndClassifyId(int checkId, int checkInputId, int classifyId) {
        return checkMapper.getCheckPhotosByCheckAndInputIdAndClassifyId(checkId, checkInputId, classifyId);
    }


}
