package com.yeejoin.amos.patrol.service.business.service.impl;


import java.io.Serializable;
import java.util.List;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.service.business.service.intfc.IGenericManager;

/*import com.yeejoin.amos.op.core.common.query.BaseQuerySpecification;
import com.yeejoin.amos.op.core.common.query.BaseQuerySpecificationJoinOR;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.service.impl.AbstractSupportedModel;
import com.yeejoin.amos.patrol.service.business.service.intfc.IGenericManager;*/
/**
 * <pre>
 *  JPA基础封装类
 * </pre>
 *
 * @author mincx
 * @version IBaseRepository.java v0.1
 * @time 2017-9-19 15:43:32
 */

public class GenericManagerImpl<T, ID extends Serializable> extends
		AbstractSupportedModel implements IGenericManager<T, ID>
{
    protected IBaseRepository<T, ID> repository;

    public GenericManagerImpl(IBaseRepository<T, ID> repository) {
        this.repository = repository;
    }

    @Override
    @Transactional(readOnly = true)
    public boolean exists(ID id) {
        return repository.existsById(id);
    }

    @Override
    @Transactional(readOnly = true)
    public List<T> findAll() {
        return repository.findAll();
    }

    @Override
    @Transactional(readOnly = true)
    public T findOne(ID id) {
        return repository.findById(id).get();
    }

    @Override
    public T save(T object) {
        return repository.save(object);
    }

    @Override
    public Iterable<T> save(Iterable<T> entities) {
        return repository.saveAll(entities);
    }

    @Override
    public void delete(T object) {
        repository.delete(object);
    }

    @Override
    public void delete(ID id) {
        repository.deleteById(id);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<T> findAll(Pageable pageable) {
        return repository.findAll(pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<T> findAll(Example<T> example, Pageable pageable) {
        return repository.findAll(example, pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public List<T> findAll(Example<T> example) {
        return repository.findAll(example);
    }

    @Override
    @Transactional(readOnly = true)
    public List<T> findAll(Example<T> example, Sort sort) {
        return repository.findAll(example, sort);
    }

    @Override
    @Transactional(readOnly = true)
    public List<T> findAll(Sort sort) {
        return repository.findAll(sort);
    }

    @Override
    @Transactional(readOnly = true)
    public List<T> findAll(Iterable<ID> ids) {
        return repository.findAllById(ids);
    }

    @Override
    @Transactional(readOnly = true)
    public List<T> findAll(Specification<T> spec) {
        return repository.findAll(spec);
    }

    @Override
    @Transactional(readOnly = true)
    public List<T> findAll(Specification<T> spec, Sort sort) {
        return repository.findAll(spec,sort);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        return repository.findAll(spec,pageable);
    }

	@Override
	public List<T> findAll(List<DaoCriteria> daoCriteria)
	{
		//将daoCriteria条件转换为jpa识别的Specification
		BaseQuerySpecification<T> spec = new BaseQuerySpecification<T>(daoCriteria);
		return findAll(spec);
	}

	@Override
	public Page<T> findAll(List<DaoCriteria> daoCriteria, Pageable pageable)
	{
		//将daoCriteria条件转换为jpa识别的Specification
		BaseQuerySpecification<T> spec = new BaseQuerySpecification<T>(daoCriteria);
		return findAll(spec,pageable);
	}
	
	@Override
	public List<T> findAllJoinOR(List<DaoCriteria> daoCriteria)
	{
		//将daoCriteria条件转换为jpa识别的Specification
		BaseQuerySpecificationJoinOR<T> spec = new BaseQuerySpecificationJoinOR<T>(daoCriteria);
		return findAll(spec);
	}

	@Override
	public Page<T> findAllJoinOR(List<DaoCriteria> daoCriteria, Pageable pageable)
	{
		//将daoCriteria条件转换为jpa识别的Specification
		BaseQuerySpecificationJoinOR<T> spec = new BaseQuerySpecificationJoinOR<T>(daoCriteria);
		return findAll(spec,pageable);
	}


}
