package com.yeejoin.amos.patrol.service.business.service.impl;

import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import com.yeejoin.amos.patrol.service.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RouteMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointInputItemDao;
import com.yeejoin.amos.patrol.service.business.param.InputItemPageParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IInputItemService;
import com.yeejoin.amos.patrol.service.business.vo.InputItemVo;
import com.yeejoin.amos.patrol.service.core.util.query.BaseQuerySpecification;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("inputItemService")
public class InputItemServiceImpl implements IInputItemService {

    @Autowired
    IInputItemDao inputItemDao;
    @Autowired
    IPointInputItemDao iPointInputItemDao;
    @Autowired
    RouteMapper routeMapper;
    @Autowired
    InputItemMapper inputItemMapper;

    @Override
    @Transactional
    public long addNewInputItem(InputItem param) {
        param = inputItemDao.save(param);
        return param.getId();
    }

    @Override
    public InputItem queryInputItemDetail(Long id) {
        return inputItemDao.findById(id).get();
    }

    @Override
    @Transactional
    public void updateInputItem(InputItem param) {
        if (param.getId() <= 0) {
            addNewInputItem(param);
            return;
        }
        inputItemMapper.updateInputItem(param);
    }

    @Override
    @Transactional
    public void delInputItem(Long id) {
        InputItem item = inputItemDao.findById(id).get();
        item.setId(id);
        item.setIsDelete(true);
        inputItemDao.saveAndFlush(item);
    }

    @Override
    public Page<InputItemVo> queryInputItemByPage(InputItemPageParam param) {
        long total = inputItemMapper.countInputItemInfoData(param);
        List<InputItemVo> content = inputItemMapper.getInputItemInfo(param);
        Page<InputItemVo> result = new PageImpl<InputItemVo>(content, param, total);
        return result;
    }

    @Override
    public List<InputItem> queryInputItemByCondition(List<DaoCriteria> criterias) {
        BaseQuerySpecification<InputItem> specification = new BaseQuerySpecification<>(criterias);
        return inputItemDao.findAll(specification);
    }

    @Override
    public int queryInputItemCountByCondition(List<DaoCriteria> criterias) {
        BaseQuerySpecification<InputItem> specification = new BaseQuerySpecification<>(criterias);
        return Integer.parseInt(inputItemDao.count(specification) + "");
    }

    @Override
    @Transactional
    public void saveAs(String[] ids, String userId) {
        for (String itemID : ids) {
            if (ObjectUtils.isEmpty(itemID)) continue;
            InputItem inputItem = inputItemDao.findById(Long.valueOf(itemID)).get();
            if("".equals(inputItem.getLevel())){
            	inputItem.setLevel("-0");
            }
            InputItem targetInputItem = new InputItem();
            BeanUtils.copyProperties(inputItem, targetInputItem);
            targetInputItem.setId(0);
            targetInputItem.setName(targetInputItem.getName() + "复制");
            targetInputItem.setCreateBy(userId);
            targetInputItem.setCreateDate(new Date());
            inputItemDao.save(targetInputItem);
        }

    }

    @Override
    @Transactional
    public void batchDelInputItem(String[] param) {
        List<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < param.length; i++) {
            ids.add(Long.parseLong(param[i]));
        }
        routeMapper.deleteReleInputItem(param);//1.删除p_route_point_inputitem
        iPointInputItemDao.delPointInputItem(ids);//2.删除p_point_inputitem
        for (String id : param) {//3.删除p_inputItem
            InputItem item = inputItemDao.findById(Long.valueOf(id)).get();
            item.setIsDelete(true);
            inputItemDao.saveAndFlush(item);
        }
    }

    @Override
    public String[] queryInputItemNames(String loginOrgCode) {
        InputItemPageParam param = new InputItemPageParam();
        param.setOrgCode(loginOrgCode);
        List<InputItemVo> content = inputItemMapper.getInputItemInfo(param);
        if (!ObjectUtils.isEmpty(content)) {
            String[] names = new String[content.size()];
            for (int i = 0; i < content.size(); i++) {
                names[i] = content.get(i).getName();
            }
            return names;
        }
        return null;
    }

    @Override
    public List<String> qryItemNoList(List<DaoCriteria> criterias, Long itemId) {
        BaseQuerySpecification<InputItem> spec = new BaseQuerySpecification<>(criterias);
        // 根据过滤条件查询出所有检查项编号
        List<InputItem> itemList = inputItemDao.findAll(spec);
        List<String> itemNoList = new ArrayList<>();
        // 将除去自身以外的所有编号添加到集合中
        for (InputItem item : itemList) {
            if (item.getId() != itemId) {
                itemNoList.add(item.getItemNo());
            }
        }
        return itemNoList;
    }
}
