package com.yeejoin.amos.patrol.service.business.service.impl;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageImpl;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
//import com.yeejoin.amos.op.core.util.DateUtil;
import com.yeejoin.amos.patrol.common.core.request.LatentDangerResultPushSpcRequest;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.CheckShot;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.DateUtil;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import com.yeejoin.amos.patrol.common.entity.PointClassify;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.ExecuteStateEnum;
import com.yeejoin.amos.patrol.common.enums.LatentDangerExcuteTypeEnum;
import com.yeejoin.amos.patrol.common.enums.LatentDangerLevelEnum;
import com.yeejoin.amos.patrol.common.enums.LatentDangerOvertimeStateEnum;
import com.yeejoin.amos.patrol.common.enums.LatentDangerReformTypeEnum;
import com.yeejoin.amos.patrol.common.enums.LatentDangerStateEnum;
import com.yeejoin.amos.patrol.common.enums.LatentDangerTypeEnum;
import com.yeejoin.amos.patrol.common.enums.RiskFactorsCmStatusEnum;
import com.yeejoin.amos.patrol.common.enums.WorkFlowDefinitionKeyEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.LatentDangerBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.LatentDangerFlowRecordBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.LatentDangerPatrolBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskFactorBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskSourceBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.CheckInputMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.LatentDangerFlowRecordMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.LatentDangerMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.LatentDangerPatrolMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskFactorCmMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskSourceMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckShotDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointClassifyDao;
import com.yeejoin.amos.patrol.service.business.dto.ExecuteSubmitDto;
import com.yeejoin.amos.patrol.service.business.dto.InputCheckDto;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerExcuteParam;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerListParam;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerNormalParam;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerPatrolItemParam;
import com.yeejoin.amos.patrol.service.business.param.LatentDangerPatrolParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ILatentDangerService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IRiskJudgmentTaskService;
import com.yeejoin.amos.patrol.service.business.util.RandomUtil;
import com.yeejoin.amos.patrol.service.business.vo.LatentDangerDetailRiskVo;
import com.yeejoin.amos.patrol.service.business.vo.LatentDangerDetailVo;
import com.yeejoin.amos.patrol.service.business.vo.LatentDangerListVo;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.core.util.StringUtil;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.remote.RemoteSpcService;
import com.yeejoin.amos.patrol.service.remote.RemoteWebSocketServer;
import com.yeejoin.amos.patrol.service.remote.RemoteWorkFlowService;
//import com.yeejoin.amos.security.common.model.UserModel;

@Service("latentDangerService")
public class LatentDangerServiceImpl implements ILatentDangerService {

    private final Logger logger = LoggerFactory.getLogger(LatentDangerServiceImpl.class);

    @Autowired
    private RemoteWorkFlowService remoteWorkFlowService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private LatentDangerMapper latentDangerMapper;

    @Autowired
    private RiskFactorMapper riskFactorMapper;

    @Autowired
    private RiskFactorCmMapper riskFactorCmMapper;

    @Autowired
    private RiskSourceMapper riskSourceMapper;

    @Autowired
    private LatentDangerFlowRecordMapper latentDangerFlowRecordMapper;

    @Autowired
    private LatentDangerPatrolMapper latentDangerPatrolMapper;

    @Autowired
    private IPointClassifyDao iPointClassifyDao;

    @Autowired
    private CheckInputMapper checkInputMapper;

    @Autowired
    private IInputItemDao iInputItemDao;

    @Autowired
    private RemoteSpcService remoteSpcService;

    @Autowired
    private ICheckShotDao iCheckShotDao;

    @Autowired
    private AsyncTask asyncTask;
    
    @Autowired
    private RemoteWebSocketServer remoteWebSocketServer;
    
    @Autowired
    private IRiskJudgmentTaskService iRiskJudgmentTaskService;

    private static final String permissionType = "SUBMENU";
    
    private static final String acctivePermissionType = "activitiItem";

    private static final String path = "AppNormalLatentDangerReview";

    @Value("${server.port}")
    private String port;

    @Transactional
    @Override
    public CommonResponse saveNormal(LatentDangerNormalParam latentDangerParam, String userId, String userRealName, String departmentId, String departmentName, String companyId, String orgCode, String token) {
        String businessKey = RandomUtil.buildOrderNo();
        JSONObject startJson = remoteWorkFlowService.start(businessKey, token, companyId, departmentId, WorkFlowDefinitionKeyEnum.隐患治理流程.getProcessDefinitionKey());
        if (startJson == null) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return CommonResponseUtil.failure("启动流程失败");
        }
        String instanceId = startJson.getJSONObject("dataList").getString("id");
        LatentDangerBo latentDangerBo = saveLatentDanger(instanceId, latentDangerParam.getRemark(),
                userId, departmentId, businessKey, orgCode, latentDangerParam.getDangerName(), latentDangerParam.getDangerLevel()
                , latentDangerParam.getDangerPosition(), LatentDangerTypeEnum.无码无计划隐患, latentDangerParam.getPhotoUrls());
        Long dangerId = latentDangerBo.getId();
        //获取填写隐患工作流节点
        JSONObject inputFlow = remoteWorkFlowService.currentTask(instanceId, token);
        if (inputFlow == null) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return CommonResponseUtil.failure("任务已经完成");
        }
        String reviewUserIds = "";
        Set<String> sendUserIds = null;
        List<UserModel> userModels = remoteSecurityService.listUserByMenuCode(permissionType, path);
        if (!CollectionUtils.isEmpty(userModels)) {
            sendUserIds = Sets.newHashSet(Lists.transform(userModels, UserModel::getUserId));
            reviewUserIds = Joiner.on(",").join(sendUserIds);
        }
        LatentDangerFlowRecordBo inputRecord = saveFlowRecord(inputFlow.getString("id"), reviewUserIds,
                inputFlow.getString("name"), inputFlow.getString("taskDefinitionKey"), dangerId);
        //执行填写隐患信息
        JSONObject excuteInputJson = remoteWorkFlowService.excute(inputFlow.getString("id"), LatentDangerExcuteTypeEnum.填写隐患完成.getRequestBody(), token);
        if (excuteInputJson == null) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return CommonResponseUtil.failure("执行填写隐患信息节点失败");
        }
        JSONObject flowJson = new JSONObject();
        flowJson.put("photoUrls", latentDangerParam.getPhotoUrls());
        updateFlowRecord(inputRecord, LatentDangerExcuteTypeEnum.填写隐患完成, userId, departmentId, latentDangerParam.getRemark(), flowJson);
        JSONObject reviewFlow = remoteWorkFlowService.currentTask(instanceId, token);
        if (reviewFlow == null) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return CommonResponseUtil.failure("任务已经完成");
        }
        LatentDangerFlowRecordBo record = saveFlowRecord(reviewFlow.getString("id"), reviewUserIds,
                reviewFlow.getString("name"), reviewFlow.getString("taskDefinitionKey"), dangerId);
        latentDangerBo.setCurrentFlowRecordId(record.getId());
        latentDangerMapper.update(latentDangerBo);
        sendMessage(latentDangerBo, LatentDangerExcuteTypeEnum.填写隐患完成, null,
                inputFlow.getString("name"), sendUserIds, userRealName, departmentName);
        return CommonResponseUtil.success();
    }

    @Transactional
    @Override
    public CommonResponse savePatrol(LatentDangerPatrolParam latentDangerPatrolParam, String userId, String userRealName, String departmentId, String departmentName, String companyId, String orgCode, String token) {
        List<LatentDangerPatrolItemParam> itemList = latentDangerPatrolParam.getItemList();
        Long checkId = latentDangerPatrolParam.getCheckId();
        if (CollectionUtils.isEmpty(itemList)) {
            return CommonResponseUtil.failure("请求参数有误");
        }
        for (LatentDangerPatrolItemParam param : itemList) {
            InputCheckDto inputCheckDto = checkInputMapper.getByCheckIdAndItemIdAndRoutePointItemId(checkId, param.getItemId(), param.getRoutePointItemId());
            if (inputCheckDto == null) {
                return CommonResponseUtil.failure("检查项不存在");
            }
            InputItem inputItem = iInputItemDao.getOne(inputCheckDto.getItemId());
            if (inputItem == null) {
                return CommonResponseUtil.failure("检查项不存在");
            }
            String businessKey = RandomUtil.buildOrderNo();
            JSONObject startJson = remoteWorkFlowService.start(businessKey, token, companyId, departmentId, WorkFlowDefinitionKeyEnum.隐患治理流程.getProcessDefinitionKey());
            if (startJson == null) {
                return CommonResponseUtil.failure("启动流程失败");
            }
            LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(param.getDangerLevel());
            if (levelEnum == null) {
                return CommonResponseUtil.failure("请求参数有误");
            }
            String remark = inputCheckDto.getRemark();
            String photoUrls = "";
            List<CheckShot> checkShots = iCheckShotDao.findAllByCheckIdAndCheckInputId(inputCheckDto.getCheckId(), inputCheckDto.getItemId());
            if (!CollectionUtils.isEmpty(checkShots)) {
                List<String> photos = Lists.transform(checkShots, e -> {
                    if (e != null) {
                        return buildLocalHost() + e.getPhotoData().replaceAll("\\\\", "/");
                    } else {
                        return "";
                    }
                });
                photoUrls = Joiner.on(",").join(photos);
            }
            String instanceId = startJson.getJSONObject("dataList").getString("id");
            LatentDangerBo latentDangerBo = saveLatentDanger(instanceId, remark, userId, departmentId, businessKey,
                    orgCode, inputItem.getName(), levelEnum.getCode(), null, LatentDangerTypeEnum.巡检隐患, photoUrls);
            Long dangerId = latentDangerBo.getId();
            //获取填写隐患工作流节点
            JSONObject inputFlow = remoteWorkFlowService.currentTask(instanceId, token);
            if (inputFlow == null) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return CommonResponseUtil.failure("任务已经完成");
            }
            Set<String> inputUserIds = getUserIdsStrByPerTypeAndDefKey(inputFlow);
            LatentDangerFlowRecordBo inputRecord = saveFlowRecord(inputFlow.getString("id"), Joiner.on(",").join(inputUserIds),
                    inputFlow.getString("name"), inputFlow.getString("taskDefinitionKey"), dangerId);
            //执行填写隐患信息
            JSONObject excuteInputJson = remoteWorkFlowService.excute(inputFlow.getString("id"), LatentDangerExcuteTypeEnum.填写隐患完成.getRequestBody(), token);
            if (excuteInputJson == null) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return CommonResponseUtil.failure("执行填写隐患信息节点失败");
            }
            JSONObject flowJson = new JSONObject();
            flowJson.put("photoUrls", photoUrls);
            updateFlowRecord(inputRecord, LatentDangerExcuteTypeEnum.填写隐患完成, userId, departmentId, remark, flowJson);
            JSONObject reviewFlow = remoteWorkFlowService.currentTask(instanceId, token);
            if (reviewFlow == null) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return CommonResponseUtil.failure("任务已经完成");
            }
            Set<String> reviewUserIds = getUserIdsStrByPerTypeAndDefKey(reviewFlow);
            LatentDangerFlowRecordBo record = saveFlowRecord(reviewFlow.getString("id"), Joiner.on(",").join(reviewUserIds),
                    reviewFlow.getString("name"), reviewFlow.getString("taskDefinitionKey"), dangerId);
            LatentDangerPatrolBo latentDangerPatrolBo = new LatentDangerPatrolBo();
            latentDangerPatrolBo.setRiskFactorFlowId(inputCheckDto.getEvaluateId().toString());
            latentDangerPatrolBo.setCheckId(inputCheckDto.getCheckId());
            latentDangerPatrolBo.setPointClassifyId(inputCheckDto.getPointClassifyId());
            latentDangerPatrolBo.setItemId(inputCheckDto.getItemId());
            latentDangerPatrolBo.setRouteId(inputCheckDto.getRouteId());
            latentDangerPatrolBo.setPointId(inputCheckDto.getPointId());
            latentDangerPatrolBo.setLatentDangerId(latentDangerBo.getId());
            latentDangerPatrolBo.setRoutePointItemId(inputCheckDto.getRoutePointItemId());
            latentDangerPatrolMapper.save(latentDangerPatrolBo);
            latentDangerBo.setCurrentFlowRecordId(record.getId());
            latentDangerMapper.update(latentDangerBo);
            //修改管控措施的状态为失效
            LatentDangerPatrolBo patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
            updateMeasuresContentStatus(Long.valueOf(patrolBo.getClassifyOriginalId()), Long.valueOf(patrolBo.getItemOriginalId()),
                    patrolBo.getRiskFactorFlowId(), RiskFactorsCmStatusEnum.outOfControl);
            sendMessage(latentDangerBo, LatentDangerExcuteTypeEnum.填写隐患完成, patrolBo,
                    inputFlow.getString("name"), reviewUserIds, userRealName, departmentName);
        }
        return CommonResponseUtil.success();
    }

    private String buildLocalHost() {
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            return "http://" + ip + ":" + port + "/";
        } catch (Exception e) {
            return "";
        }
    }
//    @Transactional
//    @Override
//    public CommonResponse saveHangup(LatentDangerHangupParam latentDangerHangupParam, String userId, String departmentId, String companyId, String orgCode, String token) {
//        List<LatentDangerHangupItemInfoParam> itemList = latentDangerHangupParam.getItemInfo();
//        if (CollectionUtils.isEmpty(itemList)) {
//            return CommonResponseUtil.failure("请求参数有误");
//        }
//        String evaluateId = latentDangerHangupParam.getInstanceId();
//        //PointClassify classify = iPointClassifyDao.findByOriginalId(latentDangerHangupParam.getPointClassifyOriginalId());
//        Point point = iPointDao.findByOriginalId(latentDangerHangupParam.getPointOriginalId());
//        for (LatentDangerHangupItemInfoParam itemInfoParam : itemList) {
//            String itemOriginalId = itemInfoParam.getItemOriginalId();
//            InputItem inputItem = iInputItemDao.findByOriginalId(itemOriginalId);
//            if (inputItem == null) {
//                return CommonResponseUtil.failure("检查项不存在");
//            }
//            String businessKey = RandomUtil.buildOrderNo();
//            JSONObject startJson = remoteWorkFlowService.start(businessKey, token, companyId, departmentId);
//            if (startJson == null) {
//                return CommonResponseUtil.failure("启动流程失败");
//            }
//            LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(itemInfoParam.getDangerLevel());
//            String instanceId = startJson.getJSONObject("dataList").getString("id");
//            LatentDangerBo latentDangerBo = saveLatentDanger(instanceId, null, userId, departmentId, businessKey,
//                    orgCode, inputItem.getName(), levelEnum.getCode(), null, LatentDangerTypeEnum.有码无计划隐患);
//            Long dangerId = latentDangerBo.getId();
//            //获取填写隐患工作流节点
//            JSONObject inputFlow = remoteWorkFlowService.currentTask(instanceId, token);
//            if (inputFlow == null) {
//                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                return CommonResponseUtil.failure("任务已经完成");
//            }
//            String inputUserIds = getUserIdsStrByRoleIdsStr(inputFlow);
//            LatentDangerFlowRecordBo inputRecord = saveFlowRecord(inputFlow.getString("id"), inputUserIds,
//                    inputFlow.getString("name"), inputFlow.getString("taskDefinitionKey"), dangerId);
//            //执行填写隐患信息
//            JSONObject excuteInputJson = remoteWorkFlowService.excute(inputFlow.getString("id"), LatentDangerExcuteTypeEnum.填写隐患完成.getRequestBody(), token);
//            if (excuteInputJson == null) {
//                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                return CommonResponseUtil.failure("执行填写隐患信息节点失败");
//            }
//            updateFlowRecord(inputRecord, LatentDangerExcuteTypeEnum.填写隐患完成, userId, departmentId, null, null);
//            JSONObject reviewFlow = remoteWorkFlowService.currentTask(instanceId, token);
//            if (reviewFlow == null) {
//                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                return CommonResponseUtil.failure("任务已经完成");
//            }
//            String reviewUserIds = getUserIdsStrByRoleIdsStr(reviewFlow);
//            LatentDangerFlowRecordBo record = saveFlowRecord(reviewFlow.getString("id"), reviewUserIds,
//                    reviewFlow.getString("name"), reviewFlow.getString("taskDefinitionKey"), dangerId);
//            LatentDangerPatrolBo latentDangerPatrolBo = new LatentDangerPatrolBo();
//            latentDangerPatrolBo.setItemId(inputItem.getId());
//            latentDangerPatrolBo.setPointId(point.getId());
//            latentDangerPatrolBo.setLatentDangerId(latentDangerBo.getId());
//            latentDangerPatrolBo.setRiskFactorFlowId(evaluateId);
//            latentDangerPatrolBo.setPointClassifyId(latentDangerHangupParam.getRiskFactorId());
//            latentDangerPatrolMapper.save(latentDangerPatrolBo);
//            latentDangerBo.setCurrentFlowRecordId(record.getId());
//            latentDangerMapper.update(latentDangerBo);
//            RiskFactorBo riskFactorBo = riskFactorMapper.getByEvaluateId(Long.valueOf(evaluateId));
//            updateMeasuresContentStatus(riskFactorBo.getId(), Long.valueOf(itemOriginalId),
//                    evaluateId, RiskFactorsCmStatusEnum.outOfControl);
//            updateRiskSourceDangerState(true, riskFactorBo.getRiskSourceId(), levelEnum, point.getId());
//        }
//        return CommonResponseUtil.success();
//    }

    private void updateMeasuresContentStatus(Long riskFactorId, Long measuresContentId, String evaluateId, RiskFactorsCmStatusEnum riskFactorsCmStatusEnum) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("riskFactorId", riskFactorId);
        map.put("measuresContentId", measuresContentId);
        map.put("evaluateId", evaluateId);
        map.put("status", riskFactorsCmStatusEnum.getCode());
        riskFactorCmMapper.updateStatusByMap(map);
        RiskFactorBo riskFactorBo = new RiskFactorBo();
        riskFactorBo.setId(riskFactorId);
        Long outControlNumber = riskFactorCmMapper.countOutControl(map);
        if (outControlNumber.equals(0L)) {
            riskFactorBo.setControlStatus(RiskFactorsCmStatusEnum.Control.getName());
        } else {
            riskFactorBo.setControlStatus(RiskFactorsCmStatusEnum.outOfControl.getName());
        }
        riskFactorMapper.updateControlStatus(riskFactorBo);
    }

    private LatentDangerBo saveLatentDanger(String instanceId, String remark, String userId, String departmentId, String businessKey, String orgCode,
                                            String dangerName, Integer level, String position, LatentDangerTypeEnum dangerTypeEnum, String photoUrls) {
        LatentDangerBo latentDangerBo = new LatentDangerBo();
        latentDangerBo.setInstanceId(instanceId);
        latentDangerBo.setRemark(remark);
        latentDangerBo.setDangerState(LatentDangerStateEnum.待评审.getCode());
        latentDangerBo.setDiscovererUserId(userId);
        latentDangerBo.setDiscovererDepartmentId(departmentId);
        latentDangerBo.setBusinessKey(businessKey);
        latentDangerBo.setOrgCode(orgCode);
        latentDangerBo.setDangerName(dangerName);
        latentDangerBo.setDangerLevel(level);
        latentDangerBo.setDangerPosition(position);
        latentDangerBo.setDangerType(dangerTypeEnum.getCode());
        latentDangerBo.setPhotoUrls(photoUrls);
        latentDangerMapper.save(latentDangerBo);
        return latentDangerBo;
    }

    private LatentDangerFlowRecordBo saveFlowRecord(String taskId, String userIds, String taskName, String taskDefinitionKey, Long dangerId) {
        LatentDangerFlowRecordBo record = new LatentDangerFlowRecordBo();
        record.setFlowTaskId(taskId);
        record.setFlowTaskUserIds(userIds);
        record.setFlowTaskName(taskName);
        record.setActionFlag(taskDefinitionKey);
        record.setDangerId(dangerId);
        latentDangerFlowRecordMapper.save(record);
        return record;
    }

    private void updateFlowRecord(LatentDangerFlowRecordBo flowRecord, LatentDangerExcuteTypeEnum excuteTypeEnum, String userId, String departmentId, String remark, JSONObject flowJson) {
        flowRecord.setExcuteState(excuteTypeEnum.getExcuteState().getCode());
        flowRecord.setExcuteDepartmentId(departmentId);
        flowRecord.setExcuteUserId(userId);
        flowRecord.setExcuteResult(excuteTypeEnum.getName());
        if (!StringUtils.isEmpty(remark)) {
            flowRecord.setRemark(remark);
        }
        if (flowJson != null) {
            flowRecord.setFlowJson(flowJson.toJSONString());
        }
        latentDangerFlowRecordMapper.update(flowRecord);
    }

    private Set<String> getUserIdsStrByPerTypeAndDefKey(JSONObject jsonObject) {
        String taskDefinitionKey = jsonObject.getString("taskDefinitionKey");
        List<UserModel> users = remoteSecurityService.listUserByMenuCode(acctivePermissionType, taskDefinitionKey);
        return Sets.newHashSet(Lists.transform(users, UserModel::getUserId));
    }

    private Map<String, Object> buildQueryMapForList(LatentDangerListParam latentDangerListParam, String userId) {
        Map<String, Object> map = Maps.newHashMap();
        long offset = latentDangerListParam.getOffset();
        map.put("offset", offset);
        map.put("limit", latentDangerListParam.getPageSize());
        if (latentDangerListParam.getIsHandle() != null) {
            List<Integer> states = Lists.newArrayList();
            if (latentDangerListParam.getIsHandle()) {
                states.add(LatentDangerStateEnum.治理完毕.getCode());
                states.add(LatentDangerStateEnum.已撤销.getCode());
            } else {
                states.add(LatentDangerStateEnum.待验证.getCode());
                states.add(LatentDangerStateEnum.安措计划中.getCode());
                states.add(LatentDangerStateEnum.待治理.getCode());
                states.add(LatentDangerStateEnum.待评审.getCode());
            }
            map.put("states", states);
        }
        if (!latentDangerListParam.getBelongType().equals(0)) {
            map.put("userId", userId);
        }
        if (!latentDangerListParam.getDangerLevel().equals(0)) {
            map.put("dangerLevel", latentDangerListParam.getDangerLevel());
        }
        if (!latentDangerListParam.getDangerState().equals(0)) {
            map.put("dangerState", latentDangerListParam.getDangerState());
        }
        if (!StringUtils.isEmpty(latentDangerListParam.getDangerName())) {
            map.put("dangerName", latentDangerListParam.getDangerName());
        }
        return map;
    }

    @Override
    public CommonResponse list(String toke,String product,String appKey,LatentDangerListParam latentDangerListParam, String userId,String loginOrgCode,String deptId) {
        Map<String, Object> map = buildQueryMapForList(latentDangerListParam, userId);
        map.put("org_code", loginOrgCode);
        map.put("discoverer_department_id", deptId);
        List<LatentDangerBo> list = latentDangerMapper.listByMap(map);
        Long count = 0L;
        List<LatentDangerListVo> voList = Lists.newArrayList();
        Date date = new Date();
        if (!CollectionUtils.isEmpty(list)) {
            Set<String> userIds = Sets.newHashSet();
            list.forEach(e -> userIds.add(e.getDiscovererUserId()));
            String userIdsStr = Joiner.on(",").join(userIds);
            List<AgencyUserModel> users = remoteSecurityService.listUserByUserIds( toke, product, appKey,userIdsStr);
            Map<String, AgencyUserModel> userMap = Maps.uniqueIndex(users, AgencyUserModel::getUserId);
            for (LatentDangerBo bo : list) {
                LatentDangerListVo vo = new LatentDangerListVo();
                vo.setDangerId(bo.getId());
                vo.setOvertimeState(bo.getOvertimeState());
                vo.setDangerName(bo.getDangerName());
                vo.setDiscovererUserName(userMap.get(bo.getDiscovererUserId()).getRealName());
                vo.setLevel(bo.getDangerLevel());
                LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(bo.getDangerLevel());
                if (levelEnum != null) {
                    vo.setLevelDesc(levelEnum.getName());
                }
                vo.setState(bo.getDangerState());
                LatentDangerStateEnum stateEnum = LatentDangerStateEnum.getByCode(bo.getDangerState());
                if (stateEnum != null) {
                    vo.setStateDesc(stateEnum.getName());
                }
                vo.setLimitDesc(getLimitDesc(bo, date));
                voList.add(vo);
            }
            count = latentDangerMapper.countByMap(map);
        }
        return CommonResponseUtil.success(new PageImpl<>(voList, latentDangerListParam, count));
    }

    private String getLimitDesc(LatentDangerBo bo, Date start) {
        Integer dangerState = bo.getDangerState();
        if (LatentDangerStateEnum.已撤销.getCode().equals(dangerState) || LatentDangerStateEnum.治理完毕.getCode().equals(dangerState)) {
            if (bo.getOvertimeState().equals(LatentDangerOvertimeStateEnum.已超时.getCode())) {
                return "逾期治理";
            } else {
                return "按期治理";
            }
        } else {
            Date end = bo.getReformLimitDate();
            if (end == null) {
                return "";
            }
            if (bo.getOvertimeState().equals(LatentDangerOvertimeStateEnum.已超时.getCode())) {
                return "逾期未治理";
            } else {
                long betweenSecond = (end.getTime() - start.getTime()) / 1000;
                if (betweenSecond < 0) {
                    return "逾期未治理";
                } else {
                    String str = "";
                    if (betweenSecond > 3600) {
                        long hour = betweenSecond / 3600;
                        str += hour + "时";
                        betweenSecond = betweenSecond % 3600;
                    }
                    if (betweenSecond > 60) {
                        long minute = betweenSecond / 60;
                        str += minute + "分";
                        betweenSecond = betweenSecond % 60;
                    }
                    if (betweenSecond > 0) {
                        str += betweenSecond + "秒";
                    }
                    return str;
                }
            }
        }
    }

    @Transactional
    @Override
    public ExecuteSubmitDto excute(LatentDangerExcuteParam latentDangerExcuteParam, String userId, String userRealName, String departmentId, String departmentName, String token) {
        ExecuteSubmitDto executeSubmitDto = new ExecuteSubmitDto();
        LatentDangerExcuteTypeEnum excuteTypeEnum = LatentDangerExcuteTypeEnum.getByCode(latentDangerExcuteParam.getExcuteType());
        if (excuteTypeEnum == null) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("执行类型有误");
            return executeSubmitDto;
        }
        Long currentFlowRecordId = latentDangerExcuteParam.getFlowRecordId();
        LatentDangerFlowRecordBo currentRecord = latentDangerFlowRecordMapper.getById(currentFlowRecordId);
        if (currentRecord == null) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("工作流记录不存在");
            return executeSubmitDto;
        }
        if (!currentRecord.getExcuteState().equals(ExecuteStateEnum.未执行.getCode())) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("已经被执行");
            return executeSubmitDto;
        }
        LatentDangerBo latentDangerBo = latentDangerMapper.getById(currentRecord.getDangerId());
        if (latentDangerBo == null) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("隐患不存在");
            return executeSubmitDto;
        }
        if (!latentDangerBo.getCurrentFlowRecordId().equals(currentFlowRecordId)) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("已经被执行");
            return executeSubmitDto;
        }
        if (latentDangerBo.getDangerState().equals(LatentDangerStateEnum.已撤销.getCode())) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("任务已经完成");
            return executeSubmitDto;
        }
        if (latentDangerBo.getCurrentFlowRecordId().equals(-1L)) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("任务已经完成");
            return executeSubmitDto;
        }
        String userIdsStr = currentRecord.getFlowTaskUserIds();
        List<String> userIds = Arrays.asList(userIdsStr.split(","));
        if (!userIds.contains(userId)) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("无权限执行此任务");
            return executeSubmitDto;
        }
        return excuteSubmit(latentDangerExcuteParam, excuteTypeEnum, latentDangerBo, currentRecord, userId, userRealName, departmentId, departmentName, token, executeSubmitDto);
    }

    @Override
    public CommonResponse detail(String toke,String product,String appKey,Long id, String userId) {
        LatentDangerBo latentDangerBo = latentDangerMapper.getById(id);
        LatentDangerDetailVo detailVo = new LatentDangerDetailVo();
        if (latentDangerBo != null) {
            detailVo.setDangerId(id);
            detailVo.setDangerType(latentDangerBo.getDangerType());
            detailVo.setPosition(latentDangerBo.getDangerPosition());
            detailVo.setDangerState(latentDangerBo.getDangerState());
            LatentDangerStateEnum dangerStateEnum = LatentDangerStateEnum.getByCode(latentDangerBo.getDangerState());
            if (dangerStateEnum != null) {
                detailVo.setDangerStateDesc(dangerStateEnum.getName());
            }
            detailVo.setDangerName(latentDangerBo.getDangerName());
            detailVo.setLevel(latentDangerBo.getDangerLevel());
            LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(latentDangerBo.getDangerLevel());
            if (levelEnum != null) {
                detailVo.setLevelDesc(levelEnum.getName());
            }
            detailVo.setRemark(latentDangerBo.getRemark());
            if (latentDangerBo.getReformType() != null) {
                LatentDangerReformTypeEnum typeEnum = LatentDangerReformTypeEnum.getByCode(latentDangerBo.getReformType());
                if (typeEnum != null) {
                    detailVo.setReformTypeDesc(typeEnum.getName());
                }
            }
            if (latentDangerBo.getReformLimitDate() != null) {
                detailVo.setReformLimitDate(DateUtil.date2Str(latentDangerBo.getReformLimitDate(), DateUtil.DATETIME_DEFAULT_FORMAT));
            }
            detailVo.setCurrentUserCanExcute(false);
            if (!latentDangerBo.getCurrentFlowRecordId().equals(-1L)) {
                LatentDangerFlowRecordBo currentRecord = latentDangerFlowRecordMapper.getById(latentDangerBo.getCurrentFlowRecordId());
                String userIdsStr = currentRecord.getFlowTaskUserIds();
                List<String> userIds = Arrays.asList(userIdsStr.split(","));
                if (userIds.contains(userId)) {
                    detailVo.setCurrentUserCanExcute(true);
                }
            }
            detailVo.setCurrentFlowRecordId(latentDangerBo.getCurrentFlowRecordId());
            if (!StringUtils.isEmpty(latentDangerBo.getReformJson())) {
                detailVo.setReformJson(JSONObject.parseObject(latentDangerBo.getReformJson()));
            }
            if (!StringUtils.isEmpty(latentDangerBo.getPhotoUrls())) {
                List<String> photoUrls = Lists.newArrayList(latentDangerBo.getPhotoUrls().split(","));
                detailVo.setPhotoUrls(photoUrls);
            }
            buildOfDifferentDangerType(toke, product, appKey,latentDangerBo, detailVo);
        }
        return CommonResponseUtil.success(detailVo);
    }

    private void buildOfDifferentDangerType(String toke,String product,String appKey,LatentDangerBo latentDangerBo, LatentDangerDetailVo detailVo) {
        if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())) {
            LatentDangerPatrolBo patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
            if (patrolBo != null) {
                LatentDangerDetailRiskVo riskVo = new LatentDangerDetailRiskVo();
                riskVo.setBasis(JSONArray.parseArray(patrolBo.getItemBasis(), String.class));
                riskVo.setPointName(patrolBo.getPointName());
                riskVo.setPointNo(patrolBo.getPointNo());
                riskVo.setPointLevel(patrolBo.getPointLevel());
                RiskFactorBo riskFactorBo = riskFactorMapper.getById(Long.valueOf(patrolBo.getClassifyOriginalId()));
                if (riskFactorBo != null && riskFactorBo.getEquipmentDepartmentId() != null) {
                    DepartmentModel department = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,riskFactorBo.getEquipmentDepartmentId());
                    if (department != null) {
                        riskVo.setBelongDepartmentName(department.getDepartmentName());
                    }
                }
                detailVo.setRiskInfo(riskVo);
            }
        }
    }

    @Override
    public CommonResponse getByInstanceId(String toke,String product,String appKey,String instanceId) {
        LatentDangerBo latentDangerBo = latentDangerMapper.getByInstanceId(instanceId);
        if (latentDangerBo == null) {
            return CommonResponseUtil.failure("隐患不存在");
        }
        JSONObject result = new JSONObject();
        JSONObject baseInfo = new JSONObject();
        JSONObject reviewInfo = new JSONObject();
        JSONObject dangerInfo = new JSONObject();
        Set<String> userIds = Sets.newHashSet();
        userIds.add(latentDangerBo.getDiscovererUserId());
        LatentDangerPatrolBo patrolBo = null;
        if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())) {
            patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
            if (patrolBo != null) {
                PointClassify classify = iPointClassifyDao.getOne(patrolBo.getPointClassifyId());
                RiskFactorBo riskFactorBo = riskFactorMapper.getById(Long.valueOf(classify.getOriginalId()));
                String jsonStr = patrolBo.getItemBasis();
                String itemBasis = "";
                if (!StringUtils.isEmpty(jsonStr)) {
                    StringBuilder itemBasisBuilder = new StringBuilder();
                    JSONArray arr = JSONArray.parseArray(jsonStr);
                    for (int i = 0; i < arr.size(); i++) {
                        JSONObject object = arr.getJSONObject(i);
                        itemBasisBuilder.append(object.getString("name")).append(",");
                    }
                    itemBasis = itemBasisBuilder.substring(0, itemBasisBuilder.length() - 1);
                }
                if (riskFactorBo != null) {
                    userIds.add(patrolBo.getCheckUserId());
                    dangerInfo.put("type", "设备设施类");
                    dangerInfo.put("equipmentCode", riskFactorBo.getEquipmentCode());
                    dangerInfo.put("isCheckWithPlan", "是");
                    dangerInfo.put("planName", patrolBo.getPlanName());
                    String type = patrolBo.getPlanType();
                    if (type != null) {
                        switch (type) {
                            case "1":
                                dangerInfo.put("planType", "天");
                                break;
                            case "2":
                                dangerInfo.put("planType", "周");
                                break;
                            case "3":
                                dangerInfo.put("planType", "月");
                                break;
                            case "4":
                                if (patrolBo.getExecuteRate().equals(1)) {
                                    dangerInfo.put("planType", "年");
                                } else if (patrolBo.getExecuteRate().equals(4)) {
                                    dangerInfo.put("planType", "季度");
                                }
                                break;
                            default:
                                break;
                        }
                    }
                    dangerInfo.put("routeName", patrolBo.getRouteName());
                    dangerInfo.put("classifyName", patrolBo.getClassifyName());
                    dangerInfo.put("itemName", patrolBo.getItemName());
                    dangerInfo.put("itemBasis", itemBasis);
                    dangerInfo.put("itemRemark", patrolBo.getItemRemark());
                    dangerInfo.put("checkTime", patrolBo.getCheckTime());
                }
            }
        }
        LatentDangerFlowRecordBo reviewRecordBo = latentDangerFlowRecordMapper.getByDangerIdAndActionFlag(latentDangerBo.getId(), "B_2");
        LatentDangerFlowRecordBo reformRecordBo = latentDangerFlowRecordMapper.getByDangerIdAndActionFlag(latentDangerBo.getId(), "B_3");
        if (reviewRecordBo != null) {
            userIds.add(reviewRecordBo.getExcuteUserId());
        }
        if (reformRecordBo != null) {
            userIds.add(reformRecordBo.getExcuteUserId());
        }
        List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey,Joiner.on(",").join(userIds));
        Map<String, AgencyUserModel> userMap = Maps.uniqueIndex(userModels, AgencyUserModel::getUserId);
        AgencyUserModel user = userMap.get(latentDangerBo.getDiscovererUserId());
        baseInfo.put("orderNo", latentDangerBo.getBusinessKey());
        baseInfo.put("startTime", latentDangerBo.getCreateDate());
        if (user != null) {
            baseInfo.put("userName", user.getRealName());
        }
        DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,latentDangerBo.getDiscovererDepartmentId());
        if (departmentBo != null) {
            baseInfo.put("department", departmentBo.getDepartmentName());
        }
        LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(latentDangerBo.getDangerLevel());
        if (levelEnum != null) {
            dangerInfo.put("latentDangerLevel", levelEnum.getName());
        }
        dangerInfo.put("latentDangerName", latentDangerBo.getDangerName());
        if (!StringUtils.isEmpty(latentDangerBo.getReformJson())) {
            dangerInfo.put("reformJson", JSONObject.parseObject(latentDangerBo.getReformJson()).getString("rectMeasures"));
        }
        dangerInfo.put("reformLimitDate", latentDangerBo.getReformLimitDate());
        if (reformRecordBo != null) {
        	AgencyUserModel reformUser = userMap.get(reformRecordBo.getExcuteUserId());
            if (reformUser != null) {
                dangerInfo.put("reformUserName", reformUser.getRealName());
            }
        }
        if (patrolBo != null) {
            if (patrolBo.getCheckUserId() != null) {
                AgencyUserModel checkUser = userMap.get(patrolBo.getCheckUserId());
                if (checkUser != null) {
                    dangerInfo.put("checkUserName", checkUser.getRealName());
                }
            }
            if (patrolBo.getCheckDepartmentId() != null) {
                DepartmentModel checkDepartment = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,patrolBo.getCheckDepartmentId());
                if (checkDepartment != null) {
                    dangerInfo.put("checkUserDeptName", checkDepartment.getDepartmentName());
                }
            }
        }
        if (reviewRecordBo != null) {
            AgencyUserModel reviewUser = userMap.get(reviewRecordBo.getExcuteUserId());
            reviewInfo.put("reviewUserName", reviewUser.getRealName());
            reviewInfo.put("reviewDate", reviewRecordBo.getUpdateDate());
            reviewInfo.put("reviewResult", reviewRecordBo.getExcuteResult());
        }
        result.put("baseInfo", baseInfo);
        result.put("dangerInfo", dangerInfo);
        result.put("reviewInfo", reviewInfo);
        result.put("latentDangerType", latentDangerBo.getDangerType());
        LatentDangerTypeEnum typeEnum = LatentDangerTypeEnum.getByCode(latentDangerBo.getDangerType());
        if (typeEnum != null) {
            result.put("latentDangerTypeDesc", typeEnum.getName());
        }
        return CommonResponseUtil.success(result);
    }

    @Transactional
    @Override
    public ExecuteSubmitDto excuteCallBack(String instanceId, Integer actionType, String remark, String token,
                                           String userId, String userRealName, String departmentId, String departmentName) {
        ExecuteSubmitDto executeSubmitDto = new ExecuteSubmitDto();
        executeSubmitDto.setOk(true);
        LatentDangerBo latentDangerBo = latentDangerMapper.getByInstanceId(instanceId);
        if (latentDangerBo != null) {
            LatentDangerFlowRecordBo currentRecord = latentDangerFlowRecordMapper.getById(latentDangerBo.getCurrentFlowRecordId());
            if (actionType.equals(1)) {
                //通过
                LatentDangerExcuteTypeEnum excuteTypeEnum = LatentDangerExcuteTypeEnum.公司负责人审核通过;
                updateFlowRecord(currentRecord, excuteTypeEnum, userId, departmentId, remark, null);
                JSONObject flowJson = remoteWorkFlowService.currentTask(latentDangerBo.getInstanceId(), token);
                if (flowJson == null) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return executeSubmitDto;
                }
                LatentDangerPatrolBo patrolBo = null;
                String userIds;
                if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())) {
                    patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
                    userIds = Joiner.on(",").join(getUserIdsStrByPerTypeAndDefKey(flowJson));
                } else {
                    LatentDangerFlowRecordBo recordBo = latentDangerFlowRecordMapper.getByDangerIdAndActionFlag(latentDangerBo.getId(), "B_8");
                    userIds = recordBo.getFlowTaskUserIds();
                }
                LatentDangerFlowRecordBo record = saveFlowRecord(flowJson.getString("id"), userIds,
                        flowJson.getString("name"), flowJson.getString("taskDefinitionKey"), latentDangerBo.getId());
                latentDangerBo.setCurrentFlowRecordId(record.getId());
                latentDangerBo.setDangerState(excuteTypeEnum.getNextState().getCode());
                latentDangerMapper.update(latentDangerBo);
                ///web推送刷新消息
                dangerStateChangeWebSockte(latentDangerBo);
                Set<String> nextExecuteUserIds = Sets.newHashSet(Arrays.asList(userIds.split(",")));
                sendMessage(latentDangerBo, excuteTypeEnum, patrolBo, currentRecord.getFlowTaskName(), nextExecuteUserIds, userRealName, departmentName);
            } else if (actionType.equals(2)) {
                //终止
                latentDangerBo.setCurrentFlowRecordId(-1L);
                latentDangerBo.setDangerState(LatentDangerStateEnum.已撤销.getCode());
                latentDangerMapper.update(latentDangerBo);
                remoteWorkFlowService.stop(latentDangerBo.getInstanceId(), remark, token);
                if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())) {
                    LatentDangerPatrolBo patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
                    updateMeasuresContentStatus(Long.valueOf(patrolBo.getClassifyOriginalId()), Long.valueOf(patrolBo.getItemOriginalId()),
                            patrolBo.getRiskFactorFlowId(), RiskFactorsCmStatusEnum.Control);
                    LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(latentDangerBo.getDangerLevel());
                    if (levelEnum != null) {
                        updateRiskSourceDangerState(false, Long.valueOf(patrolBo.getPointOriginalId()), levelEnum, patrolBo.getPointId(), latentDangerBo.getId());
                    }
                    executeSubmitDto.setDangerName(latentDangerBo.getDangerName());
                    executeSubmitDto.setPointOriginalId(patrolBo.getPointOriginalId());
                    executeSubmitDto.setExcuteTypeEnum(LatentDangerExcuteTypeEnum.隐患评审拒绝);
                }
            } else if (actionType.equals(3)) {
                //拒绝
                LatentDangerExcuteTypeEnum excuteTypeEnum = LatentDangerExcuteTypeEnum.公司负责人审核拒绝;
                updateFlowRecord(currentRecord, excuteTypeEnum, userId, departmentId, remark, null);
                JSONObject flowJson = remoteWorkFlowService.currentTask(latentDangerBo.getInstanceId(), token);
                if (flowJson == null) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return executeSubmitDto;
                }
                LatentDangerPatrolBo patrolBo = null;
                String userIds;
                if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())) {
                    patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
                    userIds = Joiner.on(",").join(getUserIdsStrByPerTypeAndDefKey(flowJson));
                } else {
                    LatentDangerFlowRecordBo recordBo = latentDangerFlowRecordMapper.getByDangerIdAndActionFlag(latentDangerBo.getId(), "B_3");
                    userIds = recordBo.getFlowTaskUserIds();
                }
                LatentDangerFlowRecordBo record = saveFlowRecord(flowJson.getString("id"), userIds,
                        flowJson.getString("name"), flowJson.getString("taskDefinitionKey"), latentDangerBo.getId());
                latentDangerBo.setCurrentFlowRecordId(record.getId());
                latentDangerBo.setDangerState(excuteTypeEnum.getNextState().getCode());
                latentDangerMapper.update(latentDangerBo);
                ///web推送刷新消息
                dangerStateChangeWebSockte(latentDangerBo);
                Set<String> nextExecuteUserIds = Sets.newHashSet(Arrays.asList(userIds.split(",")));
                sendMessage(latentDangerBo, excuteTypeEnum, patrolBo, currentRecord.getFlowTaskName(), nextExecuteUserIds, userRealName, departmentName);
            }
        }
        return executeSubmitDto;
    }

    @Override
    public void updateDangerStateOfOvertime() {
        logger.info("修改治理过期隐患的逾期状态");
        List<LatentDangerBo> overtimeList = latentDangerMapper.listOfOvertime();
        for (LatentDangerBo latentDangerBo : overtimeList) {
            latentDangerBo.setOvertimeState(LatentDangerOvertimeStateEnum.已超时.getCode());
            latentDangerMapper.update(latentDangerBo);
            if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())) {
                LatentDangerPatrolBo patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
                LatentDangerResultPushSpcRequest spcRequest = new LatentDangerResultPushSpcRequest();
                spcRequest.setProcessingTime(DateUtil.date2Str(new Date(), DateUtil.DATETIME_DEFAULT_FORMAT));
                spcRequest.setHiddenTroubleName(latentDangerBo.getDangerName());
                spcRequest.setRiskSourceId(patrolBo.getPointOriginalId());
                spcRequest.setHiddenTroubleStatus("治理逾期");
                remoteSpcService.pushLatentDangerExcuteResult(spcRequest);
            }
        }
        //推送页面刷新
        remoteWebSocketServer.wsDataRefresh("dangerOverdue"); 
    }
    
    /**
     * web安全态势预控 （ 隐患按车间/部门统计） 模块推送刷新消息
     * @param latentDangerBo
     */
    private void dangerStateChangeWebSockte(LatentDangerBo latentDangerBo){
    	Integer state = latentDangerBo.getDangerState();
    	Integer type = latentDangerBo.getDangerType();
    	 if(LatentDangerTypeEnum.巡检隐患.getCode().equals(type)
    			 || LatentDangerTypeEnum.有码无计划隐患.getCode().equals(type)){
    		 if(LatentDangerStateEnum.待治理.equals(state)|| LatentDangerStateEnum.安措计划中.equals(state)
    				 || LatentDangerStateEnum.待验证.equals(state)){
    	    	 remoteWebSocketServer.wsDataRefresh("dangerExecute"); 
    		 }
    	 }
    }

    @Override
    public CommonResponse listFlowRecord(String toke,String product,String appKey,Long id) {
        LatentDangerBo latentDangerBo = latentDangerMapper.getById(id);
        if (latentDangerBo == null) {
            return CommonResponseUtil.failure("隐患不存在");
        }
        LatentDangerDetailVo detailVo = new LatentDangerDetailVo();
        detailVo.setDangerName(latentDangerBo.getDangerName());
        detailVo.setLevel(latentDangerBo.getDangerLevel());
        LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(latentDangerBo.getDangerLevel());
        if (levelEnum != null) {
            detailVo.setLevelDesc(levelEnum.getName());
        }
        List<LatentDangerFlowRecordBo> records = latentDangerFlowRecordMapper.listByDangerId(latentDangerBo.getId());
        if (!CollectionUtils.isEmpty(records)) {
            Set<String> userIds = Sets.newHashSet();
            Set<String> deptIds = Sets.newHashSet();
            records.forEach(e -> {
                if (!StringUtils.isEmpty(e.getExcuteUserId())) {
                    userIds.add(e.getExcuteUserId());
                }
                if (!StringUtils.isEmpty(e.getExcuteDepartmentId())) {
                    deptIds.add(e.getExcuteDepartmentId());
                }
            });
            List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey,Joiner.on(",").join(deptIds));
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey,Joiner.on(",").join(userIds));
            Map<String, AgencyUserModel> userMap = Maps.uniqueIndex(userModels, AgencyUserModel::getUserId);
            Map<String, String> deptMap = new HashMap<>();
           // Map<Long, LinkedHashMap> departmentBoMap = Maps.uniqueIndex(departmentBos, DepartmentModel::get("DepartmentName"));
            
            for (int i = 0; i < departmentBos.size(); i++) {
            	deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(), departmentBos.get(i).get("departmentName").toString());
			}
            
            for (LatentDangerFlowRecordBo recordBo : records) {
            	AgencyUserModel user = userMap.get(recordBo.getExcuteUserId());
                if (user != null) {
                    recordBo.setExecuteUserName(user.getRealName());
                }
              //  DepartmentModel departmentBo = departmentBoMap.get(recordBo.getExcuteDepartmentId());
                String mma=deptMap.get(recordBo.getExcuteDepartmentId()+"");
                if (mma != null) {
                    recordBo.setExecuteDepartmentName(mma);
                }
                recordBo.setExecuteTime(DateUtil.date2Str(recordBo.getUpdateDate(), DateUtil.DATETIME_DEFAULT_FORMAT));
            }
            detailVo.setRecords(records);
        }
        return CommonResponseUtil.success(detailVo);
    }

//    private void resetMeasuresContentStatus(LatentDangerBo latentDangerBo) {
//        if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())
//                || latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.有码无计划隐患.getCode())) {
//            logger.info("重置管控内容的状态为受控");
//            //重置管控内容的状态为受控
//
//        }
//    }

    private ExecuteSubmitDto excuteSubmit(LatentDangerExcuteParam param, LatentDangerExcuteTypeEnum excuteTypeEnum,
                                          LatentDangerBo latentDangerBo, LatentDangerFlowRecordBo currentRecord,
                                          String userId, String userRealName, String departmentId, String departmentName,
                                          String token, ExecuteSubmitDto executeSubmitDto) {
        JSONObject excuteJson = remoteWorkFlowService.excute(currentRecord.getFlowTaskId(), excuteTypeEnum.getRequestBody(), token);
        if (excuteJson == null) {
            executeSubmitDto.setOk(false);
            executeSubmitDto.setMsg("执行失败");
            return executeSubmitDto;
        }
        LatentDangerPatrolBo patrolBo = null;
        if (latentDangerBo.getDangerType().equals(LatentDangerTypeEnum.巡检隐患.getCode())) {
            patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
        }
        updateFlowRecord(currentRecord, excuteTypeEnum, userId, departmentId, param.getRemark(), param.getFlowJson());
        Set<String> nextExecuteUserIds = Sets.newHashSet();
        if (excuteTypeEnum.getNextState().equals(LatentDangerStateEnum.已撤销)) {
            latentDangerBo.setCurrentFlowRecordId(-1L);
            latentDangerBo.setDangerState(excuteTypeEnum.getNextState().getCode());
            remoteWorkFlowService.stop(latentDangerBo.getInstanceId(), param.getRemark(), token);
            if (patrolBo != null) {
                updateSpcStateToControl(patrolBo, latentDangerBo);
            }
        } else if (excuteTypeEnum.getNextState().equals(LatentDangerStateEnum.治理完毕)) {
            latentDangerBo.setCurrentFlowRecordId(-1L);
            latentDangerBo.setDangerState(excuteTypeEnum.getNextState().getCode());
            if (patrolBo != null) {
                updateSpcStateToControl(patrolBo, latentDangerBo);
            }
        } else {
            JSONObject flowJson = remoteWorkFlowService.currentTask(latentDangerBo.getInstanceId(), token);
            if (flowJson == null) {
                executeSubmitDto.setOk(false);
                executeSubmitDto.setMsg("执行失败");
                return executeSubmitDto;
            }
            String userIds;
            if (LatentDangerTypeEnum.无码无计划隐患.getCode().equals(latentDangerBo.getDangerType())) {
                if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患验证拒绝)) {
                    LatentDangerFlowRecordBo recordBo = latentDangerFlowRecordMapper.getByDangerIdAndActionFlag(latentDangerBo.getId(), "B_3");
                    userIds = recordBo.getFlowTaskUserIds();
                } else {
                    userIds = param.getNextCanActionUser();
                }
            } else {
                userIds = Joiner.on(",").join(getUserIdsStrByPerTypeAndDefKey(flowJson));
            }
            nextExecuteUserIds.addAll(Arrays.asList(userIds.split(",")));
            LatentDangerFlowRecordBo record = saveFlowRecord(flowJson.getString("id"), userIds,
                    flowJson.getString("name"), flowJson.getString("taskDefinitionKey"), latentDangerBo.getId());
            latentDangerBo.setCurrentFlowRecordId(record.getId());
            latentDangerBo.setDangerState(excuteTypeEnum.getNextState().getCode());
            if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患常规治理)) {
                latentDangerBo.setReformType(LatentDangerReformTypeEnum.常规整改.getCode());
                latentDangerBo.setReformJson(param.getFlowJson().toJSONString());
            } else if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患安措计划)) {
                latentDangerBo.setReformType(LatentDangerReformTypeEnum.安措计划.getCode());
                latentDangerBo.setReformJson(param.getFlowJson().toJSONString());
            }
            if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患评审通过)) {
                latentDangerBo.setReformLimitDate(DateUtil.str2Date(param.getReformLimitDate(), DateUtil.DATETIME_DEFAULT_FORMAT));
            }
        }
        if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患评审通过)) {
            if (patrolBo != null) {
                LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(latentDangerBo.getDangerLevel());
                if (levelEnum != null) {
                    RiskFactorsCmStatusEnum cmStatusEnum;
                    if (levelEnum.equals(LatentDangerLevelEnum.一般隐患)) {
                        cmStatusEnum = RiskFactorsCmStatusEnum.generalDanger;
                    } else {
                        cmStatusEnum = RiskFactorsCmStatusEnum.majorDanger;
                    }
                    updateMeasuresContentStatus(Long.valueOf(patrolBo.getClassifyOriginalId()), Long.valueOf(patrolBo.getItemOriginalId()), patrolBo.getRiskFactorFlowId(), cmStatusEnum);
                    updateRiskSourceDangerState(true, Long.valueOf(patrolBo.getPointOriginalId()), levelEnum, patrolBo.getPointId(), latentDangerBo.getId());
                }
            }
        }
        latentDangerMapper.update(latentDangerBo);
        
        ///web推送刷新消息
        dangerStateChangeWebSockte(latentDangerBo);
        if (patrolBo != null) {
            executeSubmitDto.setPointOriginalId(patrolBo.getPointOriginalId());
        }
        executeSubmitDto.setOk(true);
        executeSubmitDto.setExcuteTypeEnum(excuteTypeEnum);
        executeSubmitDto.setDangerName(latentDangerBo.getDangerName());
        sendMessage(latentDangerBo, excuteTypeEnum, patrolBo, currentRecord.getFlowTaskName(), nextExecuteUserIds, userRealName, departmentName);
        return executeSubmitDto;
    }

    private void sendMessage(LatentDangerBo latentDangerBo, LatentDangerExcuteTypeEnum excuteTypeEnum,
                             LatentDangerPatrolBo patrolBo, String flowTaskName, Set<String> nextExecuteUserIds,
                             String userRealName, String departmentName) {
        try {
            if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患评审拒绝)) {
                String pointName = null;
                if (patrolBo != null) {
                    pointName = patrolBo.getPointName();
                }
                Set<String> sendUserIds = Sets.newHashSet(latentDangerBo.getDiscovererUserId());
                asyncTask.pushLatentDangerExecuteMessage(sendUserIds, latentDangerBo.getOrgCode(),
                        latentDangerBo.getDangerName(), pointName,
                        departmentName, latentDangerBo.getId(), userRealName,
                        flowTaskName, ExecuteStateEnum.驳回.getName(),
                        DateUtil.date2Str(new Date(), DateUtil.DATETIME_DEFAULT_FORMAT),
                        latentDangerBo.getDangerState());
            } else if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患验证通过)) {
                if (patrolBo != null) {
                    RiskFactorBo riskFactorBo = riskFactorMapper.getById(Long.valueOf(patrolBo.getClassifyOriginalId()));
                    Set<String> sendUserIds = Sets.newHashSet();
                    if (riskFactorBo != null) {
                        sendUserIds.addAll(Arrays.asList(riskFactorBo.getUserIds().split(",")));
                        sendUserIds.add(riskFactorBo.getFirstEvaluateUserId());
                        sendUserIds.add(riskFactorBo.getSecondEvaluateUserId());
                        asyncTask.pushRiskWarnMessage(sendUserIds, latentDangerBo.getOrgCode(),
                                latentDangerBo.getDangerName(), riskFactorBo.getId(),
                                riskFactorBo.getName(), patrolBo.getPointName(),
                                DateUtil.date2Str(new Date(), DateUtil.DATETIME_DEFAULT_FORMAT));
                    }
                }
            } else {
                String pointName = null;
                if (patrolBo != null) {
                    pointName = patrolBo.getPointName();
                }
                asyncTask.pushLatentDangerExecuteMessage(nextExecuteUserIds, latentDangerBo.getOrgCode(),
                        latentDangerBo.getDangerName(), pointName,
                        departmentName, latentDangerBo.getId(), userRealName,
                        flowTaskName, excuteTypeEnum.getExcuteState().getName(),
                        DateUtil.date2Str(new Date(), DateUtil.DATETIME_DEFAULT_FORMAT),
                        latentDangerBo.getDangerState());
            }
        } catch (Exception e) {
            logger.error("隐患执行发送消息失败", e);
        }
    }

    private void updateSpcStateToControl(LatentDangerPatrolBo patrolBo, LatentDangerBo latentDangerBo) {
        updateMeasuresContentStatus(Long.valueOf(patrolBo.getClassifyOriginalId()), Long.valueOf(patrolBo.getItemOriginalId()),
                patrolBo.getRiskFactorFlowId(), RiskFactorsCmStatusEnum.Control);
        LatentDangerLevelEnum levelEnum = LatentDangerLevelEnum.getByCode(latentDangerBo.getDangerLevel());
        if (levelEnum != null) {
            updateRiskSourceDangerState(false, Long.valueOf(patrolBo.getPointOriginalId()), levelEnum, patrolBo.getPointId(), latentDangerBo.getId());
        }
    }

//    private void wakeUpRiskFactorFlow(LatentDangerPatrolBo patrolBo, String token) {
//        Integer notFinishFlow = latentDangerMapper.countNotFinishByFlowId(patrolBo.getRiskFactorFlowId());
//        if (notFinishFlow == 0) {
//            logger.info("解冻原来的A流程");
//            //解冻原来的A流程
//            remoteSpcService.wakeUpOrRestartRiskFactorFlow(patrolBo.getRiskFactorFlowId(), WorkFlowRiskFactorUriEnum.流程回调, token, RiskFactorWorkFlowActionTypeEnum.唤起流程);
//        }
//    }

    @Async
    public void sendLatentDangerExcuteResult(ExecuteSubmitDto executeSubmitDto) {
        LatentDangerExcuteTypeEnum excuteTypeEnum = executeSubmitDto.getExcuteTypeEnum();
        String dangerName = executeSubmitDto.getDangerName();
        String riskSourceId = executeSubmitDto.getPointOriginalId();
        String status = null;
        if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患评审通过)) {
            status = "隐患评审通过";
        } else if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患评审拒绝)) {
            status = "隐患评审不通过";
        } else if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患验证拒绝)) {
            status = "治理验证不通过";
        } else if (excuteTypeEnum.equals(LatentDangerExcuteTypeEnum.隐患验证通过)) {
            status = "治理验证完成";
        }
        if (status != null) {
            LatentDangerResultPushSpcRequest spcRequest = new LatentDangerResultPushSpcRequest();
            spcRequest.setProcessingTime(DateUtil.date2Str(new Date(), DateUtil.DATETIME_DEFAULT_FORMAT));
            spcRequest.setHiddenTroubleName(dangerName);
            spcRequest.setRiskSourceId(riskSourceId);
            spcRequest.setHiddenTroubleStatus(status);
            remoteSpcService.pushLatentDangerExcuteResult(spcRequest);
        }
    }

    private void updateRiskSourceDangerState(Boolean isSave, Long riskSourceId, LatentDangerLevelEnum
            levelEnum, Long pointId, Long dangerId) {
        RiskSourceBo riskSourceBo = riskSourceMapper.getById(riskSourceId);
        if (riskSourceBo != null) {
            if (isSave) {
                //添加隐患
                riskSourceBo.setIsDanger(true);
                if (riskSourceBo.getDangerLevel() == null) {
                    riskSourceBo.setDangerLevel(levelEnum.getRiskSourceDangerLevelCode());
                } else {
                    if (riskSourceBo.getDangerLevel().equals(LatentDangerLevelEnum.一般隐患.getRiskSourceDangerLevelCode())
                            && levelEnum.equals(LatentDangerLevelEnum.重大隐患)) {
                        riskSourceBo.setDangerLevel(levelEnum.getRiskSourceDangerLevelCode());
                    }
                }
            } else {
                //撤销、完成隐患
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("pointId", pointId);
                params.put("dangerId", dangerId);
                List<LatentDangerBo> latentDangerBos = latentDangerMapper.listNotFinishByPointId(params);
                if (CollectionUtils.isEmpty(latentDangerBos)) {
                    riskSourceBo.setIsDanger(false);
                } else {
                    riskSourceBo.setIsDanger(true);
                    String dangerLevel = checkHasSeriousDanger(latentDangerBos);
                    riskSourceBo.setDangerLevel(dangerLevel);
                }
            }
            riskSourceMapper.updateDangerState(riskSourceBo);
        }
    }

    private String checkHasSeriousDanger(List<LatentDangerBo> latentDangerBos) {
        String dangerLevel = LatentDangerLevelEnum.一般隐患.getRiskSourceDangerLevelCode();
        for (LatentDangerBo latentDangerBo : latentDangerBos) {
            if (latentDangerBo.getDangerLevel().equals(LatentDangerLevelEnum.重大隐患.getCode())) {
                return LatentDangerLevelEnum.重大隐患.getRiskSourceDangerLevelCode();
            }
        }
        return dangerLevel;
    }

	@Override
	public void freshRiskJudgmentLangerCount(LatentDangerExcuteParam latentDangerExcuteParam) {
		Long currentFlowRecordId = latentDangerExcuteParam.getFlowRecordId();
        LatentDangerFlowRecordBo currentRecord = latentDangerFlowRecordMapper.getById(currentFlowRecordId);
        if (currentRecord == null) {;
            return ;
        }
        LatentDangerBo latentDangerBo = latentDangerMapper.getById(currentRecord.getDangerId());
        if (latentDangerBo == null) {
        	return;
        }
        LatentDangerPatrolBo patrolBo = latentDangerPatrolMapper.getByDangerId(latentDangerBo.getId());
        if(StringUtil.isNotEmpty(patrolBo.getPointOriginalId())){ 	
        	iRiskJudgmentTaskService.freshRiskJudgmentLangerCount(Long.parseLong(patrolBo.getPointOriginalId()));
        }
	}

}
