package com.yeejoin.amos.patrol.service.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.common.entity.Msg;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.StringUtil;
import com.yeejoin.amos.patrol.common.entity.Task;
import com.yeejoin.amos.patrol.common.enums.*;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckMsgBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PushTargetBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.TaskMsgBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.MsgMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.IMsgDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDetailDao;
import com.yeejoin.amos.patrol.service.business.param.MsgInfoPageParam;
import com.yeejoin.amos.patrol.service.business.param.NoticePublishParam;
import com.yeejoin.amos.patrol.service.business.param.PushMsgParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IMessageService;
import com.yeejoin.amos.patrol.service.business.vo.MsgVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.email.IEmailService;
import com.yeejoin.amos.patrol.service.jpush.AppMessagePushService;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.transaction.Transactional;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

//import com.yeejoin.amos.op.core.util.StringUtil;
//import com.yeejoin.amos.security.common.model.UserModel;


/**
 * 消息推送
 *
 * @author Administrator
 */
@Service("messageService")
public class MessageServiceImpl implements IMessageService {

    private final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);

    @Autowired
    private MsgMapper msgMapper;

    @Autowired
    private IMsgDao iMsgDao;
//
//	@Autowired
//	private IUserDao iUserDao;

//	@Autowired 
//	private IJobService jobService;

    @Autowired
    private IPlanTaskDetailDao planTaskDetailDao;

    @Autowired
    private IEmailService emailService;

    @Autowired
    private AppMessagePushService appMessagePushService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public void pushCheckMessage(Long checkId) {
        try {
            CheckMsgBo checkMsgBo = msgMapper.getCheckMsgBos(checkId);
            if (checkMsgBo != null) {
                PushMsgParam pushMsgParam = new PushMsgParam();
                pushMsgParam.setContent(checkMsgBo.getPushMsg());
                MsgSubscribeTypeEnum typeEnum = getAppPushConfig(checkMsgBo.getStatus());
                if (typeEnum != null) {
                    pushMsgParam.setSubject(typeEnum.getMsgType());
                }
                pushAppMsg(pushMsgParam, checkMsgBo, typeEnum);
                pushEmailMsg(pushMsgParam, checkMsgBo, typeEnum);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

    }

    private void pushEmailMsg(PushMsgParam pushMsgParam, CheckMsgBo checkMsgBo, MsgSubscribeTypeEnum typeEnum) throws InterruptedException {
//        List<PushTargetBo> pushMsgEmailInfoBos = msgMapper.getEmailPushTargetBo(checkMsgBo.getUserId()
//                , getEmailPushConfig(checkMsgBo.getStatus()), checkMsgBo.getRouteId());
        Map<String, String> charger = msgMapper.getChargerId(checkMsgBo.getCheckId());
        String routeChargerId = charger.get("routeChargerId");
//        List<Map<String, Object>> routeChargerIds = new ArrayList<Map<String, Object>>();
//        routeChargerIds = msgMapper.getChargerIds(checkMsgBo.getCheckId());
//        String pointChargerId = charger.get("pointChargerId").toString();
//        List<PushTargetBo> pushMsgAppPointUserInfoBos = msgMapper.getAppPushTargetBo(pointChargerId, typeEnum.getMsgType(), null);
//        //List<PushTargetBo> pushMsgAppRouteUserInfoBos = msgMapper.getAppPushTargetBo(routeChargerId, getAppPushConfig(checkMsgBo.getStatus()), null);
//        for (Map<String, Object> map : routeChargerIds) {
//            if (!ObjectUtils.isEmpty(map.get("routeChargerId"))) {
//                List<PushTargetBo> pushMsgAppRouteUserInfoBos = msgMapper.getAppPushTargetBo(map.get("routeChargerId").toString(), typeEnum.getMsgType(), null);
//                pushMsgEmailInfoBos.addAll(pushMsgAppRouteUserInfoBos);
//            }
//        }
//        pushMsgEmailInfoBos.addAll(pushMsgAppPointUserInfoBos);
//
//
//        List<String> pushMails = pushMsgEmailInfoBos.stream()
//                .map(PushTargetBo::getEmail).collect(Collectors.toList());
//        pushMails = pushMails.stream().filter(mail -> null != mail).distinct().collect(Collectors.toList());
//        remoteSecurityService.
//        if (!pushMails.isEmpty()) {
//            String[] emails = pushMails.toArray(new String[pushMails.size()]);
//            pushMsgParam.setEmails(emails);
//            emailService.sendSimpleEmail(pushMsgParam.getEmails(), pushMsgParam.getSubject(), pushMsgParam.getContent());
////			asyncTask.sendEmail(pushMsgParam);
//        }
    }

    private void pushAppMsg(PushMsgParam pushMsgParam, CheckMsgBo checkMsgBo, MsgSubscribeTypeEnum typeEnum) throws InterruptedException {
        List<PushTargetBo> pushMsgAppInfoBos = msgMapper.getAppPushTargetBo(checkMsgBo.getUserId()
                , typeEnum.getMsgType(), checkMsgBo.getRouteId());
        Map<String, String> charger = msgMapper.getChargerId(checkMsgBo.getCheckId());
        //Long routeChargerId = Long.parseLong(charger.get("routeChargerId").toString());
        List<Map<String, Object>> routeChargerIds = new ArrayList<Map<String, Object>>();
        routeChargerIds = msgMapper.getChargerIds(checkMsgBo.getCheckId());
        if (charger.get("pointChargerId") == null) {
            return;
        }
        String pointChargerId = charger.get("pointChargerId").toString();

        List<PushTargetBo> pushMsgAppPointUserInfoBos = msgMapper.getAppPushTargetBo(pointChargerId, typeEnum.getMsgType(), null);
        for (Map<String, Object> map : routeChargerIds) {
            if (!ObjectUtils.isEmpty(map.get("routeChargerId"))) {
                List<PushTargetBo> pushMsgAppRouteUserInfoBos = msgMapper.getAppPushTargetBo(map.get("routeChargerId").toString(), typeEnum.getMsgType(), null);
                pushMsgAppInfoBos.addAll(pushMsgAppRouteUserInfoBos);
            }
        }
        pushMsgAppInfoBos.addAll(pushMsgAppPointUserInfoBos);


        List<String> pushApps = pushMsgAppInfoBos.stream()
                .filter(bo -> StringUtil.isNotEmpty(bo.getUsername()))
                .map(PushTargetBo::getUsername).collect(Collectors.toList());
        pushApps = pushApps.stream().distinct().collect(Collectors.toList());
        if (!pushApps.isEmpty()) {
            List<PushMsgParam> pmps = new ArrayList<PushMsgParam>();
            pushMsgParam.setRecivers(pushApps);
            pushMsgParam.setType(JPushTypeEnum.ALIAS.getCode());
            Map<String, String> extras = new HashMap<String, String>();
            extras.put("type", typeEnum.getMsgType());
            extras.put("id", checkMsgBo.getCheckId() + "");
            pushMsgParam.setExtras(extras);
            pmps.add(pushMsgParam);
            createMsg(pushMsgAppInfoBos, checkMsgBo, typeEnum);
            appMessagePushService.sendMessage(pmps);
//			asyncTask.sendJpush(pmps);

        }
    }

    /**
     * 保存消失推送内容
     *
     * @param pushMsgAppInfoBos
     * @param checkMsgBo
     */
    private List createMsg(List<PushTargetBo> pushMsgAppInfoBos, CheckMsgBo checkMsgBo, MsgSubscribeTypeEnum typeEnum) {
        List<Msg> msgList = new ArrayList<Msg>();
        pushMsgAppInfoBos.forEach(action -> {
            Msg msg = new Msg();
//            msg.setTitle(typeEnum.getTitle());
//            msg.setBody(checkMsgBo.getSaveMsg());
//            msg.setMsgType(typeEnum.getMsgType());
//            msg.setRelationId(checkMsgBo.getCheckId());
//            msg.setUserId(action.getUserId());
//            msg.setRelationId(checkMsgBo.getCheckId());
//            msg.setOrgCode(checkMsgBo.getOrgCode());
//            msg.setRelationId(checkMsgBo.getCheckId());
//            msg.setCreateDate(new Date());
//            msg.setSendTime(new Date());
//            msg.setStatus(1);


            msg.setTitle(typeEnum.getTitle());
            msg.setBody(checkMsgBo.getSaveMsg());
            msg.setMsgType(typeEnum.getMsgType());
            msg.setRelationId(checkMsgBo.getCheckId());
            msg.setReciverName(checkMsgBo.getName());
            msg.setRelationId(checkMsgBo.getCheckId());
            msg.setOrgCode(checkMsgBo.getOrgCode());
            msg.setRelationId(checkMsgBo.getCheckId());
            msg.setCreateDate(new Date());
            msg.setSendTime(new Date());
            msg.setStatus(1);
            msgList.add(msg);
        });
        return iMsgDao.saveAll(msgList);
    }


    private MsgSubscribeTypeEnum getAppPushConfig(String checkStatus) {
        if (CheckStatusEnum.UNQUALIFIED.getCode().equals(checkStatus)) {
            return MsgSubscribeTypeEnum.有异常记录推送;
        } else if (CheckStatusEnum.OMISSION.getCode().equals(checkStatus)) {
            return MsgSubscribeTypeEnum.有漏检推送;
        } else {
            return MsgSubscribeTypeEnum.有检查记录推送;
        }
    }

    private String getEmailPushConfig(String checkStatus) {
        String checkType = CheckEmailEnum.ALL.getCode();
        if (CheckStatusEnum.UNQUALIFIED.getCode().equals(checkStatus)) {
            checkType = CheckEmailEnum.ERROR.getCode();
        } else if (CheckStatusEnum.OMISSION.getCode().equals(checkStatus)) {
            checkType = CheckEmailEnum.LEAK.getCode();
        }
        return checkType;

    }

    @Override
    public void pushTaskMessage(String toke, String product, String appKey, Task task) {
        //您好，您有一条名称为：my任务名称 内容为：my任务名称 说明 的任务单。要求完成时间为：2019-03-23 00:00:01 请您及时处理！任务下发人：18192060895
        TaskMsgBo taskMsgBo = msgMapper.getTaskMsgBos(task.getId());
        pushMsgAndSaveMsg(toke, product, appKey, taskMsgBo, MsgSubscribeTypeEnum.计划开始后推送.getTitle(), MsgSubscribeTypeEnum.计划开始后推送.getMsgType(), true);
    }

    @Override
    public Msg pushMsg(Msg msg) {
        List<PushMsgParam> pmps = new ArrayList<>();
        PushMsgParam pushMsg = new PushMsgParam();
        pushMsg.setRecivers(Lists.newArrayList(msg.getUserId()));
        //pushMsg.setRecivers(Arrays.asList(msg.getTargetTel()));
        pushMsg.setContent(ObjectUtils.isEmpty(msg.getPushBody()) ? msg.getBody() : msg.getPushBody());
        pushMsg.setSubject(msg.getTitle());
        pushMsg.setType(JPushTypeEnum.ALIAS.getCode());
        Map<String, String> extras = new HashMap<String, String>();
        extras.put("type", msg.getMsgType());
        extras.put("id", msg.getRelationId() == null ? "0" : msg.getRelationId().toString());
        pushMsg.setExtras(extras);
        pmps.add(pushMsg);
        msg.setSendTime(new Date());
        msg.setStatus(1);
        appMessagePushService.sendMessage(pmps);
        iMsgDao.save(msg);
        return msg;
    }

    @Override
    public Msg pushMsg1(Msg msg) {
        List<PushMsgParam> pmps = new ArrayList<>();
        PushMsgParam pushMsg = new PushMsgParam();
        pushMsg.setRecivers(Lists.newArrayList(msg.getUserId()));
        //pushMsg.setRecivers(Arrays.asList(msg.getTargetTel()));
        pushMsg.setContent(ObjectUtils.isEmpty(msg.getPushBody()) ? msg.getBody() : msg.getPushBody());
        pushMsg.setSubject(msg.getTitle());
        pushMsg.setType(JPushTypeEnum.ALL.getCode());
        Map<String, String> extras = new HashMap<String, String>();
        extras.put("type", msg.getMsgType());
        extras.put("id", msg.getRelationId() == null ? "0" : msg.getRelationId().toString());
        pushMsg.setExtras(extras);
        pmps.add(pushMsg);
        msg.setSendTime(new Date());
        msg.setStatus(1);
        appMessagePushService.sendMessage(pmps);
        iMsgDao.save(msg);
        return msg;
    }

    @Override
    @Transactional
    public void pushRiskMsg(Map<String, Object> msgMap) {
        Msg riskMsg = JSON.parseObject(JSON.toJSONString(msgMap.get("riskMsg")), Msg.class);
        PushMsgParam pushMsg = JSON.parseObject(JSON.toJSONString(msgMap.get("pushMsg")), PushMsgParam.class);
        boolean flag = appMessagePushService.pushNoticeManyMethod(pushMsg);
        if (flag) {
            iMsgDao.save(riskMsg);
            log.info(String.format("app推送成功，用户: %s", pushMsg.getRecivers()));
        }
    }

    @Override
    public Page<MsgVo> queryMsgInfoList(MsgInfoPageParam param) {
        long total = msgMapper.countMsgVoData(param);
        List<MsgVo> content = msgMapper.getMsgVoData(param);
        Page<MsgVo> result = new PageImpl<MsgVo>(content, param, total);
        return result;
    }

    @Override
    @Transactional
    public List<Msg> publishNotice(String toke, String product, String appKey, NoticePublishParam notice) {
        List<String> userIds = notice.getUserId();
        boolean isImmediately = notice.getIsImmediately();
        List<Msg> msgList = new ArrayList<>();
        List<AgencyUserModel> users = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
        for (AgencyUserModel user : users) {
            String targetTel = user.getRealName();
            Msg msg = new Msg();

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

            String start = sdf.format(notice.getFixedTime());
            msg.setBody(notice.getBody() + "\r\n发送时间:" + start);
            msg.setIsImmediately(isImmediately);
            msg.setMsgType(MsgSubscribeTypeEnum.通知公告推送.getMsgType());
            msg.setOrgCode(user.getCompanys().get(0).getOrgCode());
            msg.setTargetTel(targetTel);
            msg.setTitle(MsgSubscribeTypeEnum.通知公告推送.getTitle());
            msg.setUserId(user.getUserId());


            // msg.setUserId(user.getUserId());
            msg.setReciverName(user.getRealName());
            if (isImmediately) { //立即发送
                msg = pushMsg(msg);
            } else { //定时发送
                msg.setStatus(0);
                msg.setFixedTime(notice.getFixedTime());
                iMsgDao.save(msg);
                msgList.add(msg);
            }

        }
        return msgList;
    }


    @Override
    @Transactional
    public List<Msg> publishNotice1(String toke, String product, String appKey, NoticePublishParam notice) {
        List<String> userIds = notice.getUserId();
        boolean isImmediately = notice.getIsImmediately();
        List<Msg> msgList = new ArrayList<>();
        List<AgencyUserModel> users = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
        for (AgencyUserModel user : users) {
            String targetTel = user.getRealName();
            Msg msg = new Msg();
            msg.setBody(notice.getBody());
            msg.setIsImmediately(isImmediately);
            msg.setMsgType("alarmNotification");
            msg.setOrgCode(user.getCompanys().get(0).getOrgCode());
            msg.setTargetTel(targetTel);
            msg.setTitle("告警通知");
            msg.setUserId(user.getUserId());


            // msg.setUserId(user.getUserId());
            msg.setReciverName(user.getRealName());
            if (isImmediately) { //立即发送
                msg = pushMsg(msg);
            } else { //定时发送
                msg.setStatus(0);
                msg.setFixedTime(notice.getFixedTime());
                iMsgDao.save(msg);
                msgList.add(msg);
            }

        }
        return msgList;
    }


    @Override
    public void pushPlanTaskMessage(String toke, String product, String appKey, PlanTask planTask, String jobType) {
        // TODO Auto-generated method stub
        TaskMsgBo taskMsgBo = null;
        String title = "";
        String msgType = "";
        if (XJConstant.PLAN_TASK_WARN_MSG_PUSH.equals(jobType)) {
            title = MsgSubscribeTypeEnum.计划开始前推送.getTitle();
            msgType = MsgSubscribeTypeEnum.计划开始前推送.getMsgType();
            taskMsgBo = msgMapper.getPlanTaskWarnMsgBos(planTask.getId());
        } else if (XJConstant.PLAN_TASK_BEGIN_MSG_PUSH.equals(jobType)) {
            if (PlanTaskFinishStatusEnum.UNDERWAY.getValue() == planTask.getFinishStatus()) {
//                List<Integer> status = new ArrayList<>();
//                status.add(PlanTaskDetailIsFinishEnum.FINISHED.getValue());
                int count = planTaskDetailDao.countByIsFinishAndTaskNo(PlanTaskDetailIsFinishEnum.FINISHED.getValue(), planTask.getId());
                if (count == 0) {
                    title = MsgSubscribeTypeEnum.计划开始后推送.getTitle();
                    msgType = MsgSubscribeTypeEnum.计划开始后推送.getMsgType();
                    taskMsgBo = msgMapper.getPlanTaskBeginMsgBos(planTask.getId());
                }
            }
        } else if (XJConstant.PLAN_TASK_END_MSG_PUSH.equals(jobType)) {
            title = MsgSubscribeTypeEnum.计划漏检推送.getTitle();
            msgType = MsgSubscribeTypeEnum.计划漏检推送.getMsgType();
            taskMsgBo = msgMapper.getPlanTaskEndMsgBos(planTask.getId());
        }
        pushMsgAndSaveMsg(toke, product, appKey, taskMsgBo, title, msgType, false);
    }

    private void pushMsgAndSaveMsg(String toke, String product, String appKey, TaskMsgBo taskMsgBo, String title, String msgType, Boolean isImmediately) {
        if (taskMsgBo != null) {
            Msg msg = new Msg();
            msg.setTitle(title);
            msg.setBody(taskMsgBo.getSaveMsg());
            msg.setPushBody(taskMsgBo.getPushMsg());
            msg.setMsgType(msgType);
            msg.setRelationId(taskMsgBo.getTaskId());
            msg.setUserId(taskMsgBo.getUserId());
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, taskMsgBo.getUserId());
            if (userModels != null && userModels.size() > 0) {
                msg.setReciverName(userModels.get(0).getRealName());

            }
            //msg.setOrgCode(taskMsgBo.getOrgCode());
            msg.setTargetTel(taskMsgBo.getReciver());
            msg.setIsImmediately(isImmediately);

            pushMsg(msg);
        }
    }
}
