package com.yeejoin.amos.patrol.service.business.service.impl;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.Msg;
import com.yeejoin.amos.patrol.common.entity.MsgSubscribe;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.service.business.dao.repository.IMsgDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IMsgSubscribeDao;
import com.yeejoin.amos.patrol.service.business.service.intfc.IMsgSubscribeService;
import com.yeejoin.amos.patrol.service.core.util.query.BaseQuerySpecification;
//import com.yeejoin.amos.security.common.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.domain.Sort.Order;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;

@Service("msgSubscribeService")
public class MsgSubscribeServiceImpl implements IMsgSubscribeService {

    @Autowired
    private IMsgSubscribeDao msgSubscribeDao;

    @Autowired
    private IMsgDao iMsgDao;

    @Override
    public List<MsgSubscribe> queryMsgSubscribes(String orgCode, String userId) {
        return msgSubscribeDao.findMsgSubscribes(orgCode, userId);
    }

    @Override
    public List<MsgSubscribe> queryMsgSubscribes(String userId) {
        return msgSubscribeDao.findMsgSubscribes(userId);
    }


    @Override
    @Transactional
    public void saveSubscribe(List<MsgSubscribe> subscribe) {
        msgSubscribeDao.saveAll(subscribe);
    }

    @Override
    public int getUnreadCount(AgencyUserModel user) {
		return 0;
        // TODO Auto-generated method stub
        //return iMsgDao.countByIsReadFalseAndUserId(user.getUserId());
    }

    @Override
    public Page<Msg> queryMsgList(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        // TODO Auto-generated method stub
        BaseQuerySpecification<Msg> specification = new BaseQuerySpecification<>(criterias);
        Order createTime = new Order(Direction.DESC, "createDate");
        List<Order> orders = new ArrayList<Order>();
        orders.add(createTime);
        Sort sort = new Sort(orders);
        int page = commonPageable.getPageNumber();
        int size = commonPageable.getPageSize();
        Page<Msg> msgs = iMsgDao.findAll(specification, new PageRequest(page, size, sort));
        return msgs;
    }

    @Override
    public Msg isRead(long msgId) {
        // TODO Auto-generated method stub
        if (iMsgDao.existsById(msgId)) {
            Msg msg = iMsgDao.findById(msgId).get();
            msg.setIsRead(true);
            iMsgDao.save(msg);
        }
        return null;
    }

}
