package com.yeejoin.amos.patrol.service.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.common.entity.PatrolRoute;
import com.yeejoin.amos.patrol.service.business.dao.repository.PatrolRouteDao;
import com.yeejoin.amos.patrol.service.business.service.intfc.PatrolRouteService;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.remote.RemoteWebSocketServer;
import com.yeejoin.amos.patrol.service.websocket.AmosWsClient;
import com.yeejoin.amos.patrol.service.websocket.WebsocketParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

/**
 * @Author: xinglei
 * @Description:
 * @Date: 2019/12/10 16:53
 */
@Service("patrolRouteService")
public class PatrolRouteServiceImpl  implements PatrolRouteService {
  
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PatrolRouteServiceImpl.class);

    @Autowired
    private PatrolRouteDao dao;

    @Autowired
    private AmosWsClient client;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private RemoteWebSocketServer webSocketServer;

    @Override
    public boolean add(String toke,String product,String appKey,PatrolRoute patrolRoute) {
        try {
            dao.save(patrolRoute);
            AgencyUserModel user = remoteSecurityService.getUserById( toke, product, appKey,patrolRoute.getUserId().toString());
            if (!ObjectUtils.isEmpty(user)) {
                patrolRoute.setUserName(user.getRealName());
            }
            //推送的经纬度为0，不推送数据
            if (!(patrolRoute.getLongitude() == 0 || patrolRoute.getLatitude() == 0)) {
                //WebsocketParam param = new WebsocketParam("gj", JSON.toJSONString(patrolRoute));
                //client.sendMessage(param);
                webSocketServer.sendMessage(JSON.toJSONString(patrolRoute), "gj");
                log.info("推送成功");
            }
            return true;
        } catch (Exception e) {
            log.error("保存失败");
            e.printStackTrace();
            return false;
        }
    }
}
