package com.yeejoin.amos.patrol.service.business.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.response.AppCheckInputRespone;
import com.yeejoin.amos.patrol.common.core.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.Check;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.Plan;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.PlanTaskDetail;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.PlanTypeEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckChkExListBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PointCheckDetailBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanTaskDetailMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDetailDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IRoutePointDao;
import com.yeejoin.amos.patrol.service.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.service.business.param.PlanTaskPageParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.ICheckService;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.service.business.util.PlanTaskUtil;
import com.yeejoin.amos.patrol.service.business.vo.CalDateVo;
import com.yeejoin.amos.patrol.service.business.vo.CodeOrderVo;
import com.yeejoin.amos.patrol.service.business.vo.LeavePlanTaskVo;
import com.yeejoin.amos.patrol.service.business.vo.PlanTaskVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.core.util.StringUtil;
import com.yeejoin.amos.patrol.service.exception.YeeException;
import com.yeejoin.amos.patrol.service.framework.ReginParams;
import com.yeejoin.amos.patrol.service.quartz.IJobService;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
//import com.yeejoin.amos.security.common.model.UserModel;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Service("planTaskService")
public class PlanTaskServiceImpl implements IPlanTaskService {
    private final Logger log = LoggerFactory.getLogger(PlanTaskServiceImpl.class);
    @Autowired
    PlanTaskMapper planTaskMapper;
    @Autowired
    PlanTaskDetailMapper planTaskDetailMapper;
    @Autowired
    PlanMapper planMapper;
    @Autowired
    IPlanTaskDao iplanTaskDao;
    @Autowired
    IPlanDao iplanDao;

    @Autowired
    private ICheckDao checkDao;

    @Autowired
    private IPlanTaskDetailDao planTaskDetail;

    @Autowired
    IRoutePointDao iRoutePointDao;

    @Autowired
    IJobService jobService;

    @Autowired
    private ICheckService checkService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public Page<HashMap<String, Object>> getPlanTaskInfo(String toke, String product, String appKey, PlanTaskPageParam params) {
        long total = planTaskMapper.countPlanTask(params);
        List<HashMap<String, Object>> content = planTaskMapper.getPlanTaskInfo(params);

        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> deptIdSet = new HashSet<>();
        content.forEach(s -> {
            if (s.containsKey("userName")) {
                set.add(s.get("userName").toString());
            }
            if (s.containsKey("deptId")) {
                deptIdSet.add(s.get("deptId").toString());
            }
        });

        List<String> userList = new ArrayList<>(set);
        List<String> deptList = new ArrayList<>(deptIdSet);
        Map<String, String> deptMap = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();

        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);

            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
        }
        if (!CollectionUtils.isEmpty(deptList)) {
            deptIds = String.join(",", deptList);

            List<LinkedHashMap> deptBoList = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptIds);
            for (int i = 0; i < deptBoList.size(); i++) {
                deptMap.put(deptBoList.get(i).get("sequenceNbr").toString(), deptBoList.get(i).get("departmentName").toString());
            }
            // deptMap = deptBoList.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));
        }

        List<String> userNames = new ArrayList<>();
        Map<String, String> finalUserMap = userMap;
        Map<String, String> finalDeptMap = deptMap;
        content.forEach(c -> {
            userNames.clear();
            List<String> userIdsList = Arrays.asList(c.get("userName").toString().split(","));
            for (String userId : userIdsList) {
                userNames.add(finalUserMap.get(userId));
            }
            userNames.remove(null);
            c.put("userName", Joiner.on(",").join(userNames));
            c.put("deptName", finalDeptMap.get(c.get("deptId")));
        });

        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, params, total);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reGenPlanTask(HashMap<String, Object> param) throws ParseException {
        //1.公共参数准备
        String planId = param.get("planId").toString();//重做的计划编号id
        String strBginDate = param.get("beginDate").toString();//开始日期（yyyy-MM-dd）
        String strEndDate = param.get("endDate").toString();//结束日期（yyyy-MM-dd）
        String flag = param.get("changeFlag").toString();//是否记为合格标记：0-否，1-是
        Plan plan = iplanDao.findById(Long.parseLong(planId)).get();//
        if (plan == null) {
            throw new YeeException("计划不存在");
        }
        if (plan.getStatus() == 1) {
            throw new YeeException("1");
        }
        //2.数据必输校验，不满足直接return，不再向下进行
        Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
        if (!fileFlag) {
            return;
        }

        //3.计算生成数据的日期区间（前10位：yyyy-MM-dd）
        CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, strBginDate, strEndDate);

        if (null == vo) {//计划未开始,则结束
            return;
        }
        if (!vo.getIsGenData()) {//日期不符合条件直接结束
            return;
        }

        //3.删除planTask表，按照计划id+日期
        deletePlanTaskAndDet(param);

        //5.执行数据生成（具体时间 + 人员）
        List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.REGEN_FLAG);

        //6.插入planTask及planTaskDetail
        insertPlanTaskAndDet(list, plan, flag, new Date());

        //7.重新统计计划
        if (ObjectUtils.isEmpty(plan.getUserId())) {
            return;
        }

        reformStatisticsPlanTask(strBginDate, strEndDate, plan.getUserId(), plan.getOrgCode());

        //8、重新更新nextGenDate字段
        plan.setNextGenDate(getNextDataByPlan(plan));
        iplanDao.saveAndFlush(plan);
    }


    public void reformStatisticsPlanTask(String strBginDate, String strEndDate, String userId, String orgCode) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        Date startTime = sdf.parse(strBginDate);
        Date endTime = sdf.parse(strEndDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        Date currentDate = new Date();
        String strCurrentDate = sdf.format(currentDate);
        long abortTime = endTime.getTime();
        if (endTime.getTime() >= sdf.parse(strCurrentDate).getTime()) {
            abortTime = sdf.parse(strCurrentDate).getTime();
        }
        while (cal.getTime().getTime() <= abortTime) {
            String refDate = sdf.format(cal.getTime());
            String[] ids = userId.split(",");
            for (String id : ids) {
                if (!ObjectUtils.isEmpty(id)) {
                    planTaskMapper.reformStatistics(id, refDate, orgCode);
                }
            }
            cal.add(Calendar.DATE, 1);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void planTaskDet(String[] strArry) {
        if (strArry.length <= 0) {
            throw new YeeException("删除数据内容不能为空");
        }
        Set<Long> taskNos = new HashSet<>();
        for (String id : strArry) {
            PlanTaskDetail planTkDet = planTaskDetail.findById(Long.parseLong(id)).get();
            if (null != planTkDet) {
                taskNos.add(planTkDet.getTaskNo());
            }
        }
        planTaskMapper.planTaskDet(strArry);// 删除数据
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("IDS", new ArrayList<>(taskNos));
        param.put("FINISH_YES", XJConstant.PLAN_TASK_DET_FINISH_YES);
        planTaskMapper.updatePlanTaskPtInfo(param);// 更新主表，点数量，完成数量

        for (Long long1 : taskNos) {
            int num = planTaskDetail.countByTaskNo(long1);
            if (num <= 0) {
                iplanTaskDao.deleteById(long1);
            }
        }
    }

    @Override
    public List<PlanTaskVo> planTaskReport(String toke, String product, String appKey, PlanTaskPageParam param) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskInfoList(param);

        Set<String> userIdSet = Sets.newHashSet(Lists.transform(content, PlanTaskVo::getUserName));
        Set<Long> deptIdSet = Sets.newHashSet(Lists.transform(content, PlanTaskVo::getDeptId));

        userIdSet.remove("");
        userIdSet.remove(null);
        deptIdSet.remove("");
        deptIdSet.remove(null);

        Map<String, String> userMap = new HashMap<>();
        Map<String, String> deptMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userIdSet)) {
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIdSet));
            userMap = userModels.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
        }
        if (!CollectionUtils.isEmpty(deptIdSet)) {
            List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(deptIdSet));
            //deptMap = departmentBos.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));
            for (int i = 0; i < departmentBos.size(); i++) {
                deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(), departmentBos.get(i).get("departmentName").toString());
            }
        }

        List<String> userNames = new ArrayList<>();
        Map<String, String> finalUserMap1 = userMap;
        Map<String, String> finalDeptMap1 = deptMap;
        content.forEach(e -> {
            userNames.clear();
            List<String> userIds1 = Arrays.asList(e.getUserName().split(","));
            for (String userId : userIds1) {
                userNames.add(finalUserMap1.get(userId));
            }
            userNames.remove(null);
            e.setUserName(Joiner.on(",").join(userNames));
            e.setDeptName(finalDeptMap1.get(String.valueOf(e.getDeptId())));
        });
        return content;
    }

    /**
     * 自动任务执行
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskExecution(String runDate) {
        //1.扫描plan表查询，需要生成执行数据的任务信息，无则return
        Date now = new Date();//今天
        if (runDate != null) {//上送则已上送的为准
            now = DateUtil.str2Date(runDate, "yyyyMMdd");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = df.format(now);
        String tomorrow = DateUtil.getIntervalDateStr(now, 1, "yyyy-MM-dd");//下一天
        List<Plan> planList = iplanDao.queryScheduledPlan(strDate, XJConstant.PLAN_STATUS_START);
        if (planList == null || planList.size() <= 0) {
            log.info(strDate + " " + " 暂无待生成执行数据的计划");
            return;
        }
        //2.循环遍历执行
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (Plan plan : planList) {
            paramMap.clear();
            paramMap.put("id", plan.getId());
            //2.1计划数据合法性校验
            Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
            if (!fileFlag) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            }
            //2.2.计算生成数据的日期区间
            CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, tomorrow, tomorrow);

            //计划未开始，则更新生成时间为明天
            if (null == vo) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            }
            //计划已过期,则更新status = 1,停用
            if (!vo.getIsGenData()) {
                paramMap.put("status", XJConstant.PLAN_STATUS_STOP);
                planMapper.updPlanStatusOrGenDate(paramMap);
                continue;
            }

            //2.3.执行数据生成（具体时间 + 人员）
            List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.SCHED_FLAG);

            if (XJConstant.UPD_PLAN_GEN_DATE.equals(vo.getUpdFlag())) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            } else if (XJConstant.UPD_PLAN_STATUS.equals(vo.getUpdFlag())) {
                paramMap.put("status", XJConstant.PLAN_STATUS_STOP);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新status = 1,停用
                continue;
            }

            //2.4.删除今天可能重做生成的数据（计划重做后进行了计划的编辑）
            if (iplanTaskDao.findById(plan.getPlanTaskId()) != null && plan.getFirstFlag() == XJConstant.PLAN_FIRST_STATUS_YES)
                if (iplanTaskDao.existsById(plan.getPlanTaskId())) {
                    iplanTaskDao.deleteById(plan.getPlanTaskId());
                }

            //2.5.插入planTask及planTaskDetail
            insertPlanTaskAndDet(list, plan, XJConstant.SCHED_FLAG, now);
        }
    }

    /**
     * 删除plantask及det
     *
     * @param param
     */
    public void deletePlanTaskAndDet(HashMap<String, Object> param) {
        param.put("beginDate", param.get("beginDate") + " " + "00:00:00");
        param.put("endDate", param.get("endDate") + " " + "23:59:59");
        List<Long> ids = planTaskMapper.getGenPlanTask(param);
        for (long id : ids) {
            iplanTaskDao.deleteById(id);
        }
    }

    /**
     * 执行数据生成
     *
     * @param plan
     * @param vo
     * @return
     */
    public List<HashMap<String, Object>> genAllExeDate(Plan plan, CalDateVo vo, String flag) {
        //1.生成前8位日期（yyyy-MM-dd）
        List<HashMap<String, Date>> list = PlanTaskUtil.genExeDate(plan, vo, flag);
        if (list == null || list.size() <= 0) {
            vo.setUpdFlag(XJConstant.UPD_PLAN_GEN_DATE);
            return null;
        }
        //2.生成完整时间（yyyy-MM-dd HH:mm:ss）
        List<HashMap<String, Object>> timeList = PlanTaskUtil.genWholeExeDate(list, plan);
        if (timeList == null || timeList.size() <= 0) {
            vo.setUpdFlag(XJConstant.UPD_PLAN_STATUS);
        }
        //3.生成含有人员信息的日期执行数据
        List<HashMap<String, Object>> dataList = PlanTaskUtil.genWholeExeData(timeList, plan);
        return dataList;
    }


    /**
     * plantask及det入库
     *
     * @param list
     * @param plan
     * @param flag 是否初始状态0-初始 1-非初始
     */
    public void insertPlanTaskAndDet(List<HashMap<String, Object>> list, Plan plan, String flag, Date now) {
        if (list == null || list.size() <= 0) {
            return;
        }
        try {
            String isFixDate = plan.getIsFixedDate();// 是否固定日期
            List<Long> pointIdList = iRoutePointDao.queryRoutePointIds(plan.getRouteId());
            int pointNum = iRoutePointDao.countRoutePoint(plan.getRouteId());
            long batchNo = now.getTime();
            for (int i = 0; i < list.size(); i++) {
                PlanTask planTask = new PlanTask();
                planTask.setOrgCode(plan.getOrgCode());
                planTask.setPlanId(plan.getId());
                planTask.setBatchNo(batchNo);
                planTask.setRouteId(plan.getRouteId());
                planTask.setInOrder(plan.getInOrder());
                planTask.setUserId(list.get(i).get("USER_ID") == null ? "-1" : list.get(i).get("USER_ID").toString());
                planTask.setPointNum(pointNum);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startTime = list.get(i).get("BEGIN_TIME").toString();
                String endTime = list.get(i).get("END_TIME").toString();
                if (XJConstant.FIX_DATE_NO.equals(isFixDate)) {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    } else {
                        if (sdf.parse(endTime).getTime() < now.getTime()) {
                            planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                            planTask.setFinishNum(0);
                        }
                    }
                } else {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    }
                    if (sdf.parse(endTime).getTime() < now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                        planTask.setFinishNum(0);
                    }
                }
                if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                    planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
                    planTask.setFinishNum(pointNum);
                }
                if (XJConstant.FIX_DATE_YES.equals(isFixDate) || (XJConstant.FIX_DATE_NO.equals(isFixDate)
                        && XJConstant.PLAN_TYPE_DAY.equals(plan.getPlanType()))) {
                    planTask.setCheckDate(list.get(i).get("BEGIN_TIME").toString().substring(0, 10));
                }
                planTask.setBeginTime(startTime);
                planTask.setEndTime(endTime);
                // 1.保存执行数据主表
                iplanTaskDao.saveAndFlush(planTask);
                long planId = planTask.getId();
                String executorId = planTask.getUserId();
                for (int i1 = 0; i1 < pointIdList.size(); i1++) {
                    Number pointId = pointIdList.get(i1);
                    PlanTaskDetail planTaskDetailInstance = new PlanTaskDetail();
                    planTaskDetailInstance.setExecutorId(executorId);
                    planTaskDetailInstance.setPointId(pointId.longValue());
                    planTaskDetailInstance.setTaskNo(planId);
                    planTaskDetailInstance.setStatus("0");
                    if (XJConstant.TASK_STATUS_TIMEOUT == planTask.getFinishStatus()) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_OUT));
                    }
                    if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_YES));
                    }
                    // 2.保存执行数据明细表
                    planTaskDetail.saveAndFlush(planTaskDetailInstance);
                }
                // 定时任务监控
                jobService.planTaskAddJob(planTask);
            }
            // 3.如果为自动任务调用,则更新id，如果重做或且下次时间大于等于明天，则更新planTaskId到plan表
            Date genDate = DateUtil.str2Date(list.get(list.size() - 1).get("NEXT_GEN_DATE").toString(), "yyyy-MM-dd");//下次生成日期
            Date tomorrow = DateUtil.getIntervalDate(now, 1);//明天
            String strGenDate = list.get(list.size() - 1).get("NEXT_GEN_DATE").toString().substring(0, 10);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", strGenDate);
            if (XJConstant.SCHED_FLAG.equals(flag)) {
                paramMap.put("plan_task_id", 0);//修改为初始值
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
                planMapper.updPlanStatusOrGenDate(paramMap);// 更新为结束日期
            } else if (!XJConstant.SCHED_FLAG.equals(flag) && (genDate.getTime() - tomorrow.getTime() >= 0) && XJConstant.FIX_DATE_NO.equals(plan.getIsFixedDate())) {//更新日期及plantaskId到plan表
                long planTaskId = iplanTaskDao.findMaxIdByBatchNo(batchNo);
                paramMap.put("plan_task_id", planTaskId);// 更新新的任务id到plan
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
                planMapper.updPlanStatusOrGenDate(paramMap);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public List<PlanTask> getPlanTaskByRouteId(Long routeId) {
        List<PlanTask> planTaskList = planTaskMapper.getPlanTaskByRouteId(routeId);
        return planTaskList;
    }

    @Override
    public void disablePlanTask(Long[] planTaskIds) {
        // planTask表中status字段置为1
        for (long planTaskId : planTaskIds) {
            List<PlanTask> planTaskList = getPlanTaskByRouteId(planTaskId);
            for (PlanTask planTask : planTaskList) {
                planTask.setStatus((byte) 1);
                iplanTaskDao.save(planTask);
            }
        }
    }

    @Override
    public List getPlanTaskInfo(HashMap<String, Object> param) {
        return planTaskMapper.getPlanTaskByPointId(param);
    }

    @Override
    public Map findPlanTaskByTaskIdAndPointId(long plantaskId, long pointId) {
        return planTaskDetailMapper.findPlanTaskByTaskIdAndPointId(plantaskId, pointId);
    }

    @Override
    public Page<HashMap<String, Object>> getPlanTasks(String toke, String product, String appKey, HashMap<String, Object> params) {
        CommonPageable pageParam = new CommonPageable();
        List<HashMap<String, Object>> content = Lists.newArrayList();
        long total = planTaskMapper.getPlanTasksCount(params);
        if (total == 0) {
            return new PageImpl<>(content, pageParam, total);
        }
        content = planTaskMapper.getPlanTasks(params);
        if (!CollectionUtils.isEmpty(content)) {
            Set<String> userIds = Sets.newHashSet();
            content.forEach(e -> {
                String userId = e.get("userId").toString();
                if (StringUtil.isNotEmpty(userId)) {
                    userIds.add(userId);
                }
            });
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
            Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            List<String> userNames = new ArrayList<>();
            content.forEach(e -> {
                userNames.clear();
                List<String> userIds1 = Arrays.asList(e.get("userId").toString().split(","));
                for (String userId : userIds1) {
                    userNames.add(userModelMap.get(userId));
                }
                userNames.remove(null);
                e.put("executiveName", Joiner.on(",").join(userNames));
               
                /*e.put("beginTime",new Date().getTime());
                e.put("endTime",new Date().getTime());*/

            });
        }
        return new PageImpl<>(content, pageParam, total);
    }

    @Override
    public Map queryPlanTaskById(Long planTaskId) {
        return planTaskMapper.queryPlanTaskById(planTaskId);
    }

    @Override
    public List getPlanTaskPoints(Long planTaskId) {
        return planTaskMapper.getPlanTaskPoints(planTaskId);
    }

    @Override
    public int getCurrentPlanTaskCount(String userId) {
        return planTaskMapper.getCurrentPlanTaskCount(userId);
    }

    @Override
    public List<PlanTaskVo> getPlanTaskListByIds(String toke, String product, String appKey, Long[] ids) {

        List<PlanTaskVo> content = planTaskMapper.getPlanTaskListByIds(ids);

        Set<String> userIdSet = Sets.newHashSet(Lists.transform(content, PlanTaskVo::getUserName));
        Set<Long> deptIdSet = Sets.newHashSet(Lists.transform(content, PlanTaskVo::getDeptId));

        userIdSet.remove("");
        userIdSet.remove(null);
        deptIdSet.remove("");
        deptIdSet.remove(null);

        Map<String, String> userMap = new HashMap<>();
        Map<String, String> deptMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userIdSet)) {
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIdSet));
            userMap = userModels.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
        }
        if (!CollectionUtils.isEmpty(deptIdSet)) {
            List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(deptIdSet));
            //deptMap = departmentBos.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));
            for (int i = 0; i < departmentBos.size(); i++) {
                deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(), departmentBos.get(i).get("departmentName").toString());
            }
        }

        List<String> userNames = new ArrayList<>();
        Map<String, String> finalUserMap1 = userMap;
        Map<String, String> finalDeptMap1 = deptMap;
        content.forEach(e -> {
            userNames.clear();
            List<String> userIds1 = Arrays.asList(e.getUserName().split(","));
            for (String userId : userIds1) {
                userNames.add(finalUserMap1.get(userId));
            }
            userNames.remove(null);
            e.setUserName(Joiner.on(",").join(userNames));
            e.setDeptName(finalDeptMap1.get(String.valueOf(e.getDeptId())));
        });
        return content;
    }

    @Override
    public Page<CheckChkExListBo> getChkExList(CheckPtListPageParam param) {
        long total = planTaskMapper.countChkExListData(param);
        List<CheckChkExListBo> content = planTaskMapper.getChkExList(param);
        Page<CheckChkExListBo> result = new PageImpl<CheckChkExListBo>(content, param, total);
        return result;
    }

    @Override
    public Map<String, Object> getPlanTaskStatisticsForApp(HashMap<String, Object> params) {
        return planTaskMapper.getPlanTaskStatisticsForApp(params);
    }

    @Override
    public AppPointCheckRespone queryPointPlanTaskDetail(String toke, String product, String appKey, Long planTaskId, Long pointId) {
        AppPointCheckRespone pointCheckRespone = new AppPointCheckRespone();
        Check check = checkDao.findByPlanTaskIdAndPointId(planTaskId, pointId);
        if (check != null) {
            pointCheckRespone = checkService.queryCheckPointDetail(toke, product, appKey, check.getId());
        } else {
            PointCheckDetailBo planPointInfo = planTaskMapper.getPointPlanTaskInfo(planTaskId, pointId);
            if (planPointInfo != null) {
                pointCheckRespone.setPointId(pointId);
                pointCheckRespone.setPointName(planPointInfo.getPointName());
                pointCheckRespone.setPointNo(planPointInfo.getPointNo());
                pointCheckRespone.setPointStatus("0");
                pointCheckRespone.setPlanName(planPointInfo.getPlanName());
                pointCheckRespone.setUsername(planPointInfo.getUsername());
                pointCheckRespone.setDepartmentName(planPointInfo.getDepartmentName());
                List<PointCheckDetailBo> pointInputs = planTaskMapper.getPointInputByRouteIdAndPointId(planPointInfo.getRouteId(), planPointInfo.getPointId());

                Map<String, List<AppCheckInputRespone>> appResponeMap = new HashMap<>();
                pointInputs.forEach(action -> {
                    AppCheckInputRespone input = new AppCheckInputRespone();
                    input.setInputName(action.getInputName());
                    input.setCheckInputId(action.getCheckInputId());
                    input.setDataJson(action.getDataJson());
                    input.setIsMultiline(action.getIsMultiline());
                    input.setIsMust(action.getIsMust());
                    input.setItemType(action.getItemType());
                    input.setOrderNo(action.getOrderNo());
                    input.setPictureJson(action.getPictureJson());
                    input.setClassifyId(action.getClassifyId());
                    input.setClassifyName(action.getClassifyName());
                    String key = ObjectUtils.isEmpty(action.getClassifyName()) ? "其他" : action.getClassifyName();
                    if (appResponeMap.containsKey(key)) {
                        appResponeMap.get(key).add(input);
                    } else {
                        List<AppCheckInputRespone> appCheckInputResponeList = new ArrayList<AppCheckInputRespone>();
                        appCheckInputResponeList.add(input);
                        appResponeMap.put(key, appCheckInputResponeList);
                    }
                });
                pointCheckRespone.setAppCheckInput(appResponeMap);
            } else {
                return null;
            }
        }

        return pointCheckRespone;
    }

    @Override
    public String getCumulativePlanCountByOrgCode(String loginOrgCode) {
        return planTaskMapper.getCumulativePlanCountByOrgCode(loginOrgCode);
    }

    @Override
    public List<LeavePlanTaskVo> queryLeavePlanTask(HashMap<String, Object> params) {
        return planTaskMapper.queryLeavePlanTask(params);
    }

    @Override
    public List<CodeOrderVo> queryCodeOrderVo(HashMap<String, Object> params) {
        return planTaskMapper.queryCodeOrderVo(params);
    }

    @Override
    public PlanTask selectPlanTaskStatus(Long id) {
        // TODO Auto-generated method stub
        Optional<PlanTask> date = iplanTaskDao.findById(id);
        if (iplanTaskDao.findById(id) != null) {
            return date.get();
        } else {
            return null;
        }
    }

    @Override
    public CommonResponse startplan(List<String> ids) {
        try {
            List<Plan> plans = iplanDao.findByids(ids);
            if (plans != null && plans.size() > 0) {
                Plan plan = plans.get(0);
                plan.setStatus(Byte.parseByte(XJConstant.PLAN_STATUS_START));
                iplanDao.save(plan);

                //1.公共参数准备
                String planId = plan.getId() + "";//重做的计划编号id

                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                Date date = new Date();
                Date datef = null;
                try {
                    datef = sdf1.parse(plan.getPlanEnd());
                    date = sdf1.parse(sdf1.format(date));
                } catch (Exception e1) {
                    // TODO Auto-generated catch block
                    e1.printStackTrace();
                }

                if (date.getTime() > datef.getTime()) {
                    return CommonResponseUtil.failure("计划结束时间小于等于当前时间，计划不生成！");
                }

                String strBginDate = sdf1.format(date);
                String strEndDate = plan.getPlanEnd();
                plan.setPlanBegin(strBginDate);
                String flag = "0";


                if (plan == null) {
                    throw new YeeException("计划不存在");
                }

                if (plan.getStatus() == 1) {
                    throw new YeeException("1");
                }

                //2.数据必输校验，不满足直接return，不再向下进行
                Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
                if (!fileFlag) {
                    return CommonResponseUtil.failure();
                }

                //3.计算生成数据的日期区间（前10位：yyyy-MM-dd）
                CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, strBginDate, strEndDate);

                if (null == vo) {//计划未开始,则结束
                    return CommonResponseUtil.failure();
                }

                if (!vo.getIsGenData()) {//日期不符合条件直接结束
                    return CommonResponseUtil.failure();
                }

                //3.删除planTask表，按照计划id+日期
                HashMap<String, Object> param = new HashMap<>();
                param.put("beginDate", strBginDate);
                param.put("endDate", strEndDate);
                param.put("planId", planId);
                deletePlanTaskAndDet(param);

                //5.执行数据生成（具体时间 + 人员）
                List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.REGEN_FLAG);

                //6.插入planTask及planTaskDetail
                insertPlanTaskAndDet(list, plan, flag, new Date());

                //7.重新统计计划
                if (ObjectUtils.isEmpty(plan.getUserId())) {
                    return CommonResponseUtil.failure();
                }
                try {
                    reformStatisticsPlanTask(strBginDate, strEndDate, plan.getUserId(), plan.getOrgCode());
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }

        } catch (Exception e) {
        }
        return CommonResponseUtil.success();
    }

    /**
     * 根据计划获取下一次执行时间
     *
     * @param plan
     * @return
     */
    private Date getNextDataByPlan(Plan plan) {
        Date date = DateUtil.format();
        switch (plan.getPlanType()) {
            case "1":
                date = DateUtil.getPreviousDate(DateUtil.getDateByNumber(date, plan.getExecuteInterval()));
                break;
            case "2":
                date = DateUtil.getPreviousDate(DateUtil.getDateByWeek(date, plan.getExecuteInterval()));
                break;
            case "3":
                date = DateUtil.getPreviousDate(DateUtil.getDateByMonth(date, plan.getExecuteInterval()));
                break;
        }
        return date;
    }
}
