package com.yeejoin.amos.patrol.service.business.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.response.PointResponse;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.CatalogTree;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.common.entity.PointClassify;
import com.yeejoin.amos.patrol.common.entity.PointInputItem;
import com.yeejoin.amos.patrol.common.entity.PointPhoto;
import com.yeejoin.amos.patrol.common.entity.RoutePointItem;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.PointStatusEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckPtListBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.AftermathBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.ControlMeasuresBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.EquipmentBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskFactorBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.AftermathMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.ControlMeasuresMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.EquipmentMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PointMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskFactorCmMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RouteMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICatalogTreeDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDetailDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointClassifyDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointInputItemDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointPhotoDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IRoutePointDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IRoutePointItemDao;
import com.yeejoin.amos.patrol.service.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.service.business.param.MovePointParam;
import com.yeejoin.amos.patrol.service.business.param.PointImportParam;
import com.yeejoin.amos.patrol.service.business.param.PointImportQueryParam;
import com.yeejoin.amos.patrol.service.business.param.PointParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPointService;
import com.yeejoin.amos.patrol.service.business.vo.InputItemVo;
import com.yeejoin.amos.patrol.service.business.vo.LeavelMovePointVo;
import com.yeejoin.amos.patrol.service.business.vo.PointClassifyVo;
import com.yeejoin.amos.patrol.service.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.service.business.vo.PointVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.patrol.service.core.util.StringUtil;
import com.yeejoin.amos.patrol.service.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
//import com.yeejoin.amos.security.common.model.UserModel;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.util.Sets;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.math.BigInteger;
import java.util.*;
import java.util.stream.Collectors;

@Service("pointService")
public class PointServiceImpl implements IPointService {

    @Autowired
    private IPointDao iPointDao;

    @Autowired
    private IPointClassifyDao iPointClassifyDao;

    @Autowired
    private IPointInputItemDao iPointInputItemDao;

    @Autowired
    private IPointPhotoDao iPointPhotoDao;

    @Autowired
    private IRoutePointDao iRoutePointDao;

    @Autowired
    private IPlanTaskDetailDao iPlanTaskDetailDao;

    @Autowired
    private IRoutePointItemDao iRoutePointItemDao;

    @Resource
    private PointMapper pointMapper;

    @Resource
    private RouteMapper routeMapper;

    @Autowired
    private ICatalogTreeDao catalogTreeDao;
    @Autowired
    private InputItemMapper inputItemMapper;

    @Autowired
    private RiskFactorMapper riskFactorMapper;

    @Autowired
    private RiskFactorCmMapper riskFactorCmMapper;

    @Autowired
    private EquipmentMapper equipmentMapper;

    @Autowired
    private AftermathMapper aftermathMapper;

    @Autowired
    private ControlMeasuresMapper controlMeasuresMapper;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    @Transactional
    public Point addPoint(PointParam pointParam) {
        // 保存点基本信息
        Point point = pointParam.getPoint();
        point.setIsDelete(false);
        iPointDao.saveAndFlush(point);
        addClassifyAndInputItem(pointParam, point);
        return point;
    }

    @Override
    public void addMovePoint(MovePointParam param) {
        Point point = new Point();
        BeanUtils.copyProperties(param, point);
        point.setIsFixed("0");
        iPointDao.saveAndFlush(point);
        List<PointInputItem> pointInputItems = new ArrayList<>();
        if (!ObjectUtils.isEmpty(param.getInputItems())) {
            String[] ids = param.getInputItems().split(",");
            int index = 0;
            for (String id : ids) {
                PointInputItem item = new PointInputItem();
                item.setInputItemId(Integer.parseInt(id));
                item.setOrderNo(index++);
                item.setPointId(point.getId());
                item.setCreateDate(new Date());
                pointInputItems.add(item);
            }
            iPointInputItemDao.saveAll(pointInputItems);
        }
    }

    public List<Long> addImportPoint(List<PointImportParam> list, String orgCode, String userId) {
        List<Long> ids = new ArrayList<>();
        for (PointImportParam param : list) {
            Point point = new Point();
            // BeanUtils.copyProperties(param, point);
            int count = iPointDao.findByPointNo(param.getPointNo(), orgCode);
            if (count > 0) {// 该单位已存在该编号的点
                continue;
            }
            point.setName(param.getName());
            point.setAddress(param.getAddress());
            point.setCatalogId(param.getCatalogId() == null ? 0 : param.getCatalogId());
            point.setChargePersonId(param.getChargePersonId());
            // point.setDistance(param.getDistance() == null ? 0 :
            // param.getDistance());
            // point.setExtendJson(param.getExtendJson());
            point.setFixedShot(param.getFixedShot() == null ? 0 : param.getFixedShot());
            point.setIsFixed(param.getIsFixed());
            point.setIsScore(param.getIsScore());
            // point.setLatitude(param.getLatitude());
            // point.setLongitude(param.getLongitude());
            
            if(param.getLevel()!=null){
            	 point.setLevel(param.getLevel().substring(0, 1));
            }
            
            
            
            
            
            
           
            point.setName(param.getName());
            point.setOffline("1".equals(param.getOffline()) ? true : false);
            point.setPointNo(param.getPointNo());
            point.setRemark(param.getRemark());
            // point.setRouteId(param.getRouteId());
            // point.setRouteName(param.getRouteName());
            // point.setSaveGps(param.getSaveGps());
            point.setShotMaxNumber(param.getShotMaxNumber() == null ? 0 : param.getShotMaxNumber());
            point.setShotMinNumber(param.getShotMinNumber() == null ? 0 : param.getShotMinNumber());
            // point.setUsuallyShot(param.getUsuallyShot());
            point.setCoordinates(param.getCoordinates());
            point.setFloor(param.getFloor());
            point.setIsDelete(false);
            point.setOrgCode(orgCode);
            point.setCreateDate(new Date());
            point.setCreatorId(userId);
            point.setIsIndoor("1".equals(param.getIsIndoor()) ? true : false);

            CatalogTree catalog = catalogTreeDao.findOneByNameAndOrgCode(param.getCatalogName(),
              orgCode);
            if (catalog != null) {
                point.setCatalogId(catalog.getId());
            }
            iPointDao.saveAndFlush(point);
            ids.add(point.getId());
            String inputItems = param.getInputItems();
            if (!ObjectUtils.isEmpty(inputItems)) {
                String[] items = inputItems.replaceAll(" ", "").split(",");

                List<InputItemVo> inputItemList = inputItemMapper.getInputItemListByNames(items,
                  orgCode);
                int orderNo = 0;
                for (InputItemVo inputItem : inputItemList) {
                    PointInputItem pointInputItem = new PointInputItem();
                    pointInputItem.setPointId(point.getId());
                    pointInputItem.setInputItemId(inputItem.getId());
                    // pointInputItem.setClassifyIds(0);
                    pointInputItem.setId(0);
                    pointInputItem.setOrderNo(orderNo++);
                    iPointInputItemDao.save(pointInputItem);
                }
            }
        }
        return ids;
    }

    /**
     * 增加点的分类和项
     *
     * @param pointParam
     * @param point
     */
    private void addClassifyAndInputItem(PointParam pointParam, Point point) {
        long pointId = point.getId();

        // 保存点分类信息
        Map<String, Long> classifyNameIdMap = new HashMap<>();
        for (PointClassify pointClassify : pointParam.getPointClassifyList()) {
            if (pointClassify != null) {// pointClassify.getId() == 0 表示新增
                PointClassify newPointClassify = new PointClassify();
                BeanUtils.copyProperties(pointClassify, newPointClassify);
                newPointClassify.setCreatorId(point.getCreatorId());
                newPointClassify.setPointId(pointId);
                newPointClassify.setId(0);
                iPointClassifyDao.saveAndFlush(newPointClassify);

                classifyNameIdMap.put(newPointClassify.getName(), newPointClassify.getId());
            }
        }

        // 保存点的巡检项信息
        List<PointInputItemVo> pointInputItemVoList = pointParam.getInputItemVoInfo();
        List<Long> pointInputItemIdList = new ArrayList<>(); // 页面选择的点的所有项列表
        Map<Long, Integer> inputIdOrderNoMap = new HashMap<>();
        for (PointInputItemVo pItemVo : pointInputItemVoList) {
            pointInputItemIdList.add(pItemVo.getId());
            inputIdOrderNoMap.put(pItemVo.getId(), pItemVo.getpOrderNo());
        }
        // List<Long> classifiedInputItemIdList = new ArrayList<>(); //
        // 页面已选分类的项列表
        // List<Long> unClassifiedInputItemIdList = pointInputItemIdList; //
        // 页面未分类的项列表
        Map<String, List<Long>> classifyInputItemMap = pointParam.getClassifyInputItemMap(); // 前台传入的分类和项键值对
        Map<Long, String> itemClassifyIdMap = new HashMap<>();
        for (Long itemId : pointInputItemIdList) {
            Iterator<Map.Entry<String, List<Long>>> iterator = classifyInputItemMap.entrySet().iterator();
            List<String> ids = new ArrayList<>();
            while (iterator.hasNext()) {
                Map.Entry<String, List<Long>> entry = iterator.next();
                List<Long> cItemIds = entry.getValue();
                if (cItemIds.contains(itemId) && !ids.contains(itemId)) {
                    ids.add(classifyNameIdMap.get(entry.getKey()) == null ? "0"
                      : classifyNameIdMap.get(entry.getKey()).toString());
                }
            }
            itemClassifyIdMap.put(itemId, StringUtils.join(ids.toArray(), ","));
        }

        for (Long inputItemId : pointInputItemIdList) {
            PointInputItem pointInputItem = new PointInputItem();
            pointInputItem.setPointId(pointId);
            pointInputItem.setInputItemId(inputItemId);
            pointInputItem.setClassifyIds(itemClassifyIdMap.get(inputItemId));
            pointInputItem.setId(0);
            pointInputItem.setOrderNo(inputIdOrderNoMap.get(inputItemId));
            iPointInputItemDao.save(pointInputItem);
        }

        // for (String classify : classifyInputItemMap.keySet()) {
        // if (classify != null) {
        // List<Long> inputItemIdList = classifyInputItemMap.get(classify);
        // for (Long inputItemId : inputItemIdList) {
        // if (null != inputItemId &&
        // !classifiedInputItemIdList.contains(inputItemId)) {
        // classifiedInputItemIdList.add(inputItemId);
        // }
        // }
        // }
        // }
        // unClassifiedInputItemIdList.removeAll(classifiedInputItemIdList);
        // for (Long inputItemId : unClassifiedInputItemIdList) {
        // if (null != inputItemId) {
        //
        // PointInputItem pointInputItem = new PointInputItem();
        // pointInputItem.setPointId(pointId);
        // pointInputItem.setInputItemId(inputItemId);
        // pointInputItem.setClassifyIds(0);
        // pointInputItem.setId(0);
        // pointInputItem.setOrderNo(inputIdOrderNoMap.get(inputItemId));
        // iPointInputItemDao.save(pointInputItem);
        // }
        // }
        //
        // for (Long inputItemId : classifiedInputItemIdList) {
        // for (String classifyName : classifyNameIdMap.keySet()) {
        // if (classifyInputItemMap.get(classifyName) != null
        // && classifyInputItemMap.get(classifyName).contains(inputItemId)
        // && null != inputIdOrderNoMap.get(inputItemId)) {
        // PointInputItem pointInputItem = new PointInputItem();
        // pointInputItem.setPointId(pointId);
        // pointInputItem.setInputItemId(inputItemId);
        // pointInputItem.setClassifyIds(classifyNameIdMap.get(classifyName));
        // pointInputItem.setId(0);
        // pointInputItem.setOrderNo(inputIdOrderNoMap.get(inputItemId));
        // iPointInputItemDao.save(pointInputItem);
        // }
        // }
        // }

        // 保存点的图片说明信息
        // TODO 图片上传接口调用
        List<PointPhoto> pointPhotoList = pointParam.getPointPhotoList();
        List<PointPhoto> newPointPhotoList = new ArrayList<>();
        for (PointPhoto pointPhoto : pointPhotoList) {
            PointPhoto newPointPhoto = new PointPhoto();
            BeanUtils.copyProperties(pointPhoto, newPointPhoto);
            newPointPhoto.setPointId(pointId);
            newPointPhoto.setOrgCode(pointParam.getLoginOrgCode());
            newPointPhoto.setId(0);
            newPointPhotoList.add(newPointPhoto);
        }
        iPointPhotoDao.saveAll(newPointPhotoList);
    }

    /**
     * 更新点的分类和项
     *
     * @param pointParam
     * @param point
     */
    private void updateClassifyAndInputItem(PointParam pointParam, Point point) {
        long pointId = point.getId();

        // 保存点分类信息
        Map<String, Long> classifyNameIdMap = new HashMap<>();
        for (PointClassify pointClassify : pointParam.getPointClassifyList()) {
            if (pointClassify != null) {// pointClassify.getId() == 0 表示新增
                PointClassify newPointClassify = new PointClassify();
                BeanUtils.copyProperties(pointClassify, newPointClassify);
                newPointClassify.setCreatorId(point.getCreatorId());
                newPointClassify.setPointId(pointId);
                iPointClassifyDao.saveAndFlush(newPointClassify);

                classifyNameIdMap.put(newPointClassify.getName(), newPointClassify.getId());
            }
        }

        // 保存点的巡检项信息
        List<PointInputItemVo> pointInputItemVoList = pointParam.getInputItemVoInfo();
        Map<Long, Integer> inputIdOrderNoMap = new HashMap<>();
        Map<Long, PointInputItemVo> allInputItem = new HashMap<>();
        List<Long> pointInputItemIdList = new ArrayList<>(); // 页面选择的点的所有项列表
        for (PointInputItemVo pItemVo : pointInputItemVoList) {
            allInputItem.put(pItemVo.getId(), pItemVo);
            pointInputItemIdList.add(pItemVo.getId());
            inputIdOrderNoMap.put(pItemVo.getId(), pItemVo.getpOrderNo());
        }

        Map<String, List<HashMap<Long, Long>>> classifyItemHashMap = pointParam.getClassifyInputItemEditMap(); // 前台传入的分类和项键值对
        Map<String, List<Long>> classifyInputItemMap = new HashMap<>();
        for (String key : classifyItemHashMap.keySet()) {
            List<Long> itemList = null;
            Set<Long> itemSet = new HashSet<>();
            List<HashMap<Long, Long>> itemIdList = classifyItemHashMap.get(key);
            for (HashMap<Long, Long> item : itemIdList) {
                for (Long itemId : item.keySet()) {
                    itemSet.add(itemId);
                }
            }
            itemList = new ArrayList(itemSet);
            classifyInputItemMap.put(key, itemList);
        }

        Map<Long, String> itemClassifyIdMap = new HashMap<>();
        for (Long itemId : pointInputItemIdList) {
            Iterator<Map.Entry<String, List<Long>>> iterator = classifyInputItemMap.entrySet().iterator();
            List<String> ids = new ArrayList<>();
            while (iterator.hasNext()) {
                Map.Entry<String, List<Long>> entry = iterator.next();
                List<Long> cItemIds = entry.getValue();
                if (cItemIds.contains(itemId) && !ids.contains(itemId)) {
                    ids.add(classifyNameIdMap.get(entry.getKey()).toString());
                }
            }
            itemClassifyIdMap.put(itemId, StringUtils.join(ids.toArray(), ","));
        }
        List<PointInputItem> pointInputItems = new ArrayList<>();
        for (Long inputItemId : pointInputItemIdList) {

            PointInputItem pointInputItem = iPointInputItemDao.getPointInputItem(pointId, inputItemId);
            if (pointInputItem == null) {
                pointInputItem = new PointInputItem();
            }
            pointInputItem.setPointId(pointId);
            pointInputItem.setInputItemId(inputItemId);
            pointInputItem.setClassifyIds(itemClassifyIdMap.get(inputItemId));
            pointInputItem.setOrderNo(inputIdOrderNoMap.get(inputItemId));
            iPointInputItemDao.save(pointInputItem);
            pointInputItems.add(pointInputItem);
        }

        updateRoutePointItem(pointInputItems);
        // 保存点的图片说明信息
        // TODO 图片上传接口调用
        List<PointPhoto> pointPhotoList = pointParam.getPointPhotoList();
        List<PointPhoto> newPointPhotoList = new ArrayList<>();
        for (PointPhoto pointPhoto : pointPhotoList) {
            PointPhoto newPointPhoto = new PointPhoto();
            BeanUtils.copyProperties(pointPhoto, newPointPhoto);
            newPointPhoto.setPointId(pointId);
            newPointPhoto.setOrgCode(pointParam.getLoginOrgCode());
            newPointPhoto.setId(0);
            newPointPhotoList.add(newPointPhoto);
        }
        iPointPhotoDao.saveAll(newPointPhotoList);
    }


    void updateRoutePointItem(List<PointInputItem> pointInputItems) {


        List<RoutePointItem> updateData = new ArrayList<>();
        List<RoutePointItem> deleteData = new ArrayList<>();
        for (PointInputItem pointInputItem : pointInputItems) {
            List<RoutePointItem> routePointItems = iRoutePointItemDao.findAllByPointInputItemId(pointInputItem.getId());
            if (routePointItems.isEmpty()) {
                continue;
            }
            List<String> classifyids = StringUtil.isNotEmpty(pointInputItem.getClassifyIds()) ? Arrays.asList(pointInputItem.getClassifyIds().split(",")) : new ArrayList<>();
            System.out.println(classifyids.size() + "==" + classifyids.isEmpty());
            if (classifyids.isEmpty()) {
                //路线巡检项保留一个并且分类id为null
                for (int i = 0; i < routePointItems.size(); i++) {
                    RoutePointItem rp = routePointItems.get(i);
                    if (i == 0) {
                        rp.setPointClassifyId(null);
                        updateData.add(rp);
                    } else {
                        deleteData.add(rp);
                    }
                }
            } else {
                RoutePointItem rp = routePointItems.get(0);
                classifyids.forEach(classifyid -> {
                    RoutePointItem newRpi = new RoutePointItem();
                    newRpi.setRoutePointId(rp.getRoutePointId());
                    newRpi.setOrderNo(rp.getOrderNo());
                    newRpi.setPointInputItemId(rp.getPointInputItemId());
                    newRpi.setPointClassifyId(Long.valueOf(classifyid));
                    newRpi.setCreateDate(new Date());
                    updateData.add(newRpi);
                });
                deleteData.addAll(routePointItems);
            }
        }
        if (!deleteData.isEmpty()) {
            iRoutePointItemDao.deleteAll(deleteData);
        }
        if (!updateData.isEmpty()) {
            iRoutePointItemDao.saveAll(updateData);
        }
    }

    @Override
    @Transactional
    public List<Long> delPointById(Long[] ids) {
        List<Long> idList = new ArrayList<Long>();
        for (long pointId : ids) {
            idList.add(pointId);
        }
        iPointClassifyDao.deleteByPointId(idList); // 物理删除点的分类
        iPointInputItemDao.deleteByPointId(idList); // 物理删除p_point_inputitem表对应行
        iPointPhotoDao.deleteByPointId(idList); // 物理删除点的图片信息
        // iRoutePointDao.delRoutePointByPointId(idList); //
        // 物理删除p_route_point中相关行
        List<BigInteger> routePointIdList = iRoutePointDao.queryRoutePointByPointId(idList);
        for (BigInteger routePointId : routePointIdList) {
            iRoutePointItemDao.delRoutePointItem(routePointId.longValue());
            iRoutePointDao.deleteById(Long.parseLong(routePointId.toString()));
        }
        iPlanTaskDetailDao.deletePlanTaskDetailByPointId(idList); // 删除p_plan_task_detail相关行
        iPointDao.delPointById(idList);
        return idList;
    }

    @Override
    @Transactional
    public Point updatePoint(PointParam pointParam) {
        long pointId = pointParam.getPoint().getId();
        Point newPoint = iPointDao.findById(pointId).get();
        BeanUtils.copyProperties(pointParam.getPoint(), newPoint);
        newPoint.setLastUpdateTime(new Date());
        iPointDao.save(newPoint);

        // 删除点的旧巡检项
        // 删除旧巡检项前更新p_route_point_item里面用到该巡检项的行
        // Map<String, List<HashMap<Long, Long>>> newPItemIdMap =
        // pointParam.getClassifyInputItemEditMap();
        // Set<Long> newPItemIds = new HashSet<>();
        // for (Entry<String, List<HashMap<Long, Long>>> entry :
        // newPItemIdMap.entrySet()) {
        // List<HashMap<Long, Long>> t = entry.getValue();
        // for (Map<Long, Long> x : t) {
        // for (Entry<Long, Long> e : x.entrySet()) {
        // newPItemIds.add(Long.valueOf(e.getValue().toString()));
        // }
        // }
        // }
        List<PointInputItemVo> oldInputItemList = queryOldPointInputItem(pointId); // 新的巡检项的补集，即需要删除的项
        List<PointInputItemVo> newInputItemList = pointParam.getInputItemVoInfo();
        List<Long> ids = new ArrayList<>();
        newInputItemList.forEach(item -> {
            PointInputItem pii = iPointInputItemDao.getPointInputItem(pointId, item.getId());
            if (pii != null) {
                ids.add(item.getPointItemId());
            }
        });
        List<Long> pItemIds = new ArrayList<>();
        oldInputItemList.forEach(item -> {
            if (!ids.contains(item.getPointItemId())) {
                pItemIds.add(item.getPointItemId());
            }
        });
        if (pItemIds.size() > 0) {
            iPointInputItemDao.delPointInputItemById(pItemIds);
            iRoutePointItemDao.delRoutePointItemByItemId(pItemIds);// 删除p_route_point_item中使用到该项的行
        }

        // 删除点的旧分类
        // 删除点分类时更新p_point_inputitem里面分类id
        List<PointClassify> newPointClassifyList = pointParam.getPointClassifyList();
        List<PointClassify> oldPointClassifyList = queryPointClassify(pointId);// 新的点分类的补集，即需要删除的分类
        newPointClassifyList.forEach(item -> {
            Iterator<PointClassify> iter2 = oldPointClassifyList.iterator();
            while (iter2.hasNext()) {
                PointClassify pClassify = iter2.next();
                if (item.getId() == pClassify.getId()) {
                    iter2.remove();
                }
            }
        });
        for (PointClassify classify : oldPointClassifyList) {
            iPointClassifyDao.deleteById(classify.getId());
        }

        // 删除点的旧图片信息
        List<PointPhoto> oldPointPhotoList = queryPointPhoto(pointId);
        iPointPhotoDao.deleteAll(oldPointPhotoList);

        updateClassifyAndInputItem(pointParam, newPoint);
        return newPoint;

    }

    @Override
    @Transactional
    public void saveAs(Long[] pointIds) {
        // 保存点所有巡检项、点图片信息、点的扩展分类信息
        for (Long pointId : pointIds) {
            Point point = iPointDao.findById(pointId).get();
            String orgCode = point.getOrgCode();
            List<PointPhoto> pointPhotoList = queryPointPhoto(pointId);
            List<PointClassify> pointClassifyList = queryPointClassify(pointId);
            List<PointInputItemVo> inputItemList = queryPointInputItem(pointId);
            // List<Long> inputItemIds = new ArrayList<>();
            // List<HashMap<String, Object>> inputItemInfoList = new
            // ArrayList<>();
            // for (PointInputItemVo inputItem : inputItemList) {
            // inputItemIds.add(inputItem.getId());
            // HashMap<String, Object> inputItemInfoMap = new HashMap<>();
            // inputItemInfoMap.put("inputItemId", inputItem.getId());
            // inputItemInfoMap.put("orderNo", inputItem.getOrderNo());
            // inputItemInfoList.add(inputItemInfoMap);
            // }
            Map<String, List<Long>> classifyInputItemMap = queryPointClassifyNameMap(pointId);

            Point newPoint = new Point();
            BeanUtils.copyProperties(point, newPoint);
            newPoint.setName(point.getName() + "复制");
            newPoint.setPointNo(point.getPointNo() + "_copy");
            newPoint.setId(0);

            PointParam pointParam = new PointParam();
            pointParam.setPoint(newPoint);
            pointParam.setClassifyInputItemMap(classifyInputItemMap);
            pointParam.setInputItemVoInfo(inputItemList);
            pointParam.setLoginOrgCode(orgCode);
            pointParam.setPointClassifyList(pointClassifyList);
            pointParam.setPointPhotoList(pointPhotoList);

            addPoint(pointParam);
        }
    }

    @Override
    public void importPoint() {
        // TODO Auto-generated method stub

    }

    @Override
    public void exportPoint() {
        // TODO Auto-generated method stub

    }

    @Override
    public Point queryPointById(Long id) {
        return iPointDao.findById(id).get();
    }

    @Override
    public Page<List<Point>> queryPointInfoPage(List<DaoCriteria> criterias) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Page<PointVo> queryPointInfo(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        DaoCriteria criteria = new DaoCriteria();
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
//        criteria.setOperator(QueryOperatorEnum.ORDER_BY.getName());
//        criteria.setPropertyName("id");
//        criteria.setValue("DESC");
//        criterias.add(criteria);

        Sort sort = new Sort(Sort.Direction.DESC, "id");
        commonPageable.setSort(sort);

        Page<Point> pointPage = iPointDao.findAll(spec, commonPageable);
        List<PointVo> pointVoList = new ArrayList<>();
        for (Point point : pointPage) {
            PointVo pointVo = new PointVo();
            BeanUtils.copyProperties(point, pointVo);
            pointVo.setShotNumber(point.getShotMinNumber() + "-" + point.getShotMaxNumber());
            CatalogTree cataTree = null;
            Optional<CatalogTree> optional = catalogTreeDao.findById(point.getCatalogId());
            if (!ObjectUtils.isEmpty(optional)) {
                cataTree = optional.get();
            }
            String catalogName = cataTree != null ? cataTree.getName() : "";
            pointVo.setCatalogName(catalogName);
            List<String> routeNameList = routeMapper.getRouteNameByPointId(point.getId());
            String routeNames = StringUtils.join(routeNameList.toArray(), ",");
            pointVo.setRouteName(routeNames);
            List<String> inputItemNameList = new ArrayList<>();
            for (InputItem inputItem : queryPointInputItem(point.getId())) {
                inputItemNameList.add(inputItem.getName());
            }
            String inputItemName = StringUtils.join(inputItemNameList.toArray(), ",");
            ;
            pointVo.setInputItemName(inputItemName);
            List<String> classifyNameList = new ArrayList<>();
            for (PointClassify pointClassify : iPointClassifyDao.getPointClassifyByPointId(point.getId())) {
                classifyNameList.add(pointClassify.getName());
            }
            String classifynames = StringUtils.join(classifyNameList.toArray(), ",");
            ;
            pointVo.setClassifyName(classifynames);
            pointVoList.add(pointVo);
        }
        Pageable pageable = new CommonPageable(pointPage.getNumber(), pointPage.getSize(), pointPage.getSort());

        Page<PointVo> pointVoPage = new PageImpl<>(pointVoList, pageable, pointPage.getTotalElements());
        return pointVoPage;
    }

    @Override
    public List<PointVo> queryAllPoint() {
        List<PointVo> returnList = new ArrayList<>();
        List<Point> list = iPointDao.findAll();

        if (!CollectionUtils.isEmpty(list)) {
            for (Point point : list) {
                PointVo pointVo = new PointVo();
                BeanUtils.copyProperties(point, pointVo);
                returnList.add(pointVo);
            }
        }

        return returnList;
    }

    @Override
    public List<PointInputItemVo> queryPointInputItem(Long pointId) {
        List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById1(pointId, null);
        Map<Long, PointInputItemVo> itemMap = new HashMap<>();
        for (PointInputItemVo itemVo : inputItemList) {
            itemMap.put(itemVo.getId(), itemVo);
        }
        List<PointInputItemVo> list = new ArrayList<>();
        itemMap.values().forEach(item -> {
            list.add(item);
        });
        return list;
    }

    // 暂未用到
    @Override
    public Map<String, List<PointInputItemVo>> queryPointClassifyWithInputItem(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<String, List<PointInputItemVo>> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            classifyInputItemMap.put(pointClassify.getName() + "*" + pointClassify.getOrderNo(), inputItemList);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        List<PointInputItemVo> unClassifiedPointInputItemList = queryPointInputItem(pointId); // 未分类的巡检项列表
        unClassifiedPointInputItemList.removeAll(classifiedInputItemList);
        if (!unClassifiedPointInputItemList.isEmpty()) {
            classifyInputItemMap.put("未分类", unClassifiedPointInputItemList);
        }
        return classifyInputItemMap;
    }

    private Map<Long, List<PointInputItemVo>> queryPointClassify3(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<Long, List<PointInputItemVo>> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            classifyInputItemMap.put(pointClassify.getId(), inputItemList);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        List<PointInputItemVo> unClassifiedPointInputItemList = queryPointInputItem(pointId); // 未分类的巡检项列表
        unClassifiedPointInputItemList.removeAll(classifiedInputItemList);
        if (!unClassifiedPointInputItemList.isEmpty()) {
            // PointClassify pointClassify = new PointClassify();
            // pointClassify.setName("未分类");
            classifyInputItemMap.put(null, unClassifiedPointInputItemList);
        }
        return classifyInputItemMap;
    }

    @Override
    public List<PointPhoto> queryPointPhoto(Long pointId) {
        List<PointPhoto> pointPhotoList = pointMapper.getPointPhotoByPointId(pointId);
        return pointPhotoList;
    }

    @Override
    public void addPointPhoto(Long pointId) {
        // TODO Auto-generated method stub

    }

    private Map<String, List<Long>> queryPointClassifyNameMap(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<String, List<Long>> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            List<Long> inputItemIdList = new ArrayList<>();
            for (PointInputItemVo inputItem : inputItemList) {
                inputItemIdList.add(inputItem.getId());
            }
            classifyInputItemMap.put(pointClassify.getName(), inputItemIdList);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        List<PointInputItemVo> unClassifiedPointInputItemList = queryPointInputItem(pointId); // 未分类的巡检项列表
        unClassifiedPointInputItemList.removeAll(classifiedInputItemList);
        if (!unClassifiedPointInputItemList.isEmpty()) {
            List<Long> inputItemIdList = new ArrayList<>();
            for (PointInputItemVo inputItem : unClassifiedPointInputItemList) {
                inputItemIdList.add(inputItem.getId());
            }
            classifyInputItemMap.put(null, inputItemIdList);
        }
        return classifyInputItemMap;
    }

    @Override
    public List<PointClassify> queryPointClassify(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        return pointClassifyList;
    }

    @Override
    public List<PointInputItemVo> queryPointInputItemByClassify(Long pointId, Long classifyId) {
        List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, classifyId);
        return inputItemList;
    }

    @Override
    public List<Point> queryPointList(List<String> ids, List<String> names, String orgCode) {
        return iPointDao.findAll(getPointSpecification(ids, names, orgCode));
    }

    private Specification getPointSpecification(List<String> ids, List<String> names, String orgCode) {
        return new Specification<Point>() { // 构建查询条件
            @Override
            public Predicate toPredicate(Root<Point> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                List<Predicate> predicate = new ArrayList<>();
                if (!ObjectUtils.isEmpty(orgCode)) {
                    predicate.add(cb.like(root.get("orgCode").as(String.class), orgCode + "%"));
                }
                if (!ObjectUtils.isEmpty(names)) {
                    List<Predicate> namePredicate = new ArrayList<>();
                    for (String name : names) {
                        namePredicate.add(cb.like(root.get("name").as(String.class), "%" + name + "%"));
                    }
                    Predicate[] pre = new Predicate[namePredicate.size()];
                    predicate.add(cb.or(namePredicate.toArray(pre)));
                }
                if (!ObjectUtils.isEmpty(ids)) {
                    List<Predicate> noPredicate = new ArrayList<>();
                    for (String id : ids) {
                        noPredicate.add(cb.like(root.get("pointNo").as(String.class), "%" + id + "%"));
                    }
                    Predicate[] pre = new Predicate[noPredicate.size()];
                    predicate.add(cb.or(noPredicate.toArray(pre)));
                }

                Predicate[] pre = new Predicate[predicate.size()];
                return query.where(predicate.toArray(pre)).getRestriction();
            }
        };
    }

    @Override
    public Point queryPointByPointNo(HashMap<String, Object> params) {
        Point point = iPointDao.findByOrgCodeAndPointNo(params.get("pointNo").toString(), params.get("orgCode").toString());
        return point;
//        return iPointDao.findOne(new Specification<Point>() {
//
//            @Override
//            public Predicate toPredicate(Root<Point> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
//                List<Predicate> predicate = new ArrayList<>();
//                if (!ObjectUtils.isEmpty(params.get("pointNo"))) {
//                    predicate.add(cb.equal(root.get("pointNo").as(String.class), params.get("pointNo")));
//                }
//                if (!ObjectUtils.isEmpty(params.get("orgCode"))) {
//                    predicate.add(cb.like(root.get("orgCode").as(String.class), params.get("orgCode").toString() + "%"));
//                }
//                Predicate[] pre = new Predicate[predicate.size()];
//                return query.where(predicate.toArray(pre)).getRestriction();
//            }
//        }).get();
    }

    @Override
    public Point setPatrolMode(Long pointId, Boolean isOffine) {
        if (iPointDao.existsById(pointId)) {
            Point point = iPointDao.findById(pointId).get();
            point.setOffline(isOffine);
            return iPointDao.save(point);
        }
        return null;
    }

    @Override
    public Page<PointVo> queryPointByPage(HashMap<String, Object> param, CommonPageable commonPageable) {
        int count = pointMapper.getPointCountByCondition(param);
        param.put("offset", commonPageable.getPageNumber() * commonPageable.getPageSize());
        param.put("pageSize", commonPageable.getPageSize());
        List<PointVo> list = pointMapper.getPointByCondition(param);
        Page<PointVo> pointVoPage = new PageImpl<>(list, commonPageable, count);
        return pointVoPage;
    }

    @Override
    public Map queryPointDetailById(Long id) {
        Map<String, Object> resp = new HashMap<String, Object>();
        Map<String, Object> point = pointMapper.getPointById(id);

        List<Map<String, Object>> inputItem = pointMapper.getPointInputItem(id);
        List<Map<String, Object>> routes = pointMapper.getPointRoute(id);
        List<Map<String, Object>> classify = pointMapper.getPointClassify(id);

        resp.put("point", point);
        resp.put("inputItems", inputItem);
        resp.put("routes", routes);
        resp.put("classify", classify);
        return resp;
    }

    @Override
    public Map queryPointDetailById1(String toke, String product, String appKey, Long id) {
        Map<String, Object> resp = new HashMap<String, Object>();
        Map<String, Object> point = pointMapper.getPointById(id);


        if (StringUtil.isNotEmpty(point.get("depid"))) {
            List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, point.get("depid") + "");
            if (departmentBos != null && departmentBos.size() > 0) {
                for (int i = 0; i < departmentBos.size(); i++) {
                    point.put("departmentName", departmentBos.get(i).get("departmentName"));


                }
            }

        }

        // deptName = checkPointBo.getExecuteDeptId();
        if (StringUtil.isNotEmpty(point.get("routeName"))) {
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke, product, appKey, point.get("routeName") + "");
            String userName = "";
            if (userModels != null && userModels.size() > 0) {
                for (int i = 0; i < userModels.size(); i++) {
                    if (i == userModels.size() - 1) {
                        userName = userName + userModels.get(i).getRealName();
                    } else {
                        userName = userName + userModels.get(i).getRealName() + ",";
                    }

                }
                point.put("userName", userName);
            }


        }


        // List<Map<String, Object>> inputItem =
        // pointMapper.getPointInputItem(id);
        List<Map<String, Object>> routes = pointMapper.getPointRoute(id);
        List<HashMap<String, Object>> classify = pointMapper.getPointInputClassifyInfo(id);
        Map<String, List<HashMap<String, Object>>> inputItems = new HashMap<String, List<HashMap<String, Object>>>();
        if (!classify.isEmpty()) {
            classify.forEach(action -> {
                if (StringUtil.isNotEmpty(action.get("classifyName"))) {
                    if (inputItems.containsKey(action.get("classifyName").toString())) {
                        List<HashMap<String, Object>> list = inputItems.get(action.get("classifyName").toString());
                        list.add(action);
                    } else {
                        List<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                        list.add(action);
                        inputItems.put(action.get("classifyName").toString(), list);
                    }
                } else {
                    if (inputItems.containsKey("其他")) {
                        List<HashMap<String, Object>> list = inputItems.get("其他");
                        list.add(action);
                    } else {
                        List<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                        list.add(action);
                        inputItems.put("其他", list);
                    }
                }
            });
        }
		/*List<PointInputItem> pointInputItems = iPointInputItemDao.getPointInputItemByPointId(id);
		Map<String, Object> classify1 = new HashMap();
		classify1.put("pointId", id);
		classify1.put("classifyName", "");
		classify1.put("classifyId", 0);
		classify.add(classify1);

		for (Map<String, Object> map : classify) {

			List<Map<String, Object>> inputItems = new ArrayList<Map<String, Object>>();
			for (PointInputItem pointInputItem : pointInputItems) {
				String ids = pointInputItem.getClassifyIds();
				if (ids.contains(",")) {
					String[] idsArray = ids.split(",");
					if (Arrays.asList(idsArray).contains(map.get("classifyId").toString())) {
						Map<String, Object> inputItem = pointMapper.getPointInputItem1(id,
								pointInputItem.getInputItemId());
						inputItems.add(inputItem);
					}
				} else if (ids.equals(map.get("classifyId").toString())) {
					Map<String, Object> inputItem = pointMapper.getPointInputItem1(id, pointInputItem.getInputItemId());
					inputItems.add(inputItem);

				}

			}
			map.put("inputItem", inputItems);
		}*/

        resp.put("point", point);
        resp.put("inputItems", inputItems);
        resp.put("routes", routes);
//		resp.put("classify", classify);
        return resp;

    }

    @Override
    public Map<String, PointClassifyVo> queryPointClassifyWithInputItemVo(Long pointId) {
        List<PointClassify> pointClassifyList = iPointClassifyDao.getPointClassifyByPointId(pointId); // 点分类列表
        List<PointInputItemVo> classifiedInputItemList = new ArrayList<>(); // 所有已分类项的列表
        Map<String, PointClassifyVo> classifyInputItemMap = new HashMap<>();
        for (PointClassify pointClassify : pointClassifyList) {
            List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById(pointId, pointClassify.getId());
            PointClassifyVo pointClassifyVo = new PointClassifyVo();
            BeanUtils.copyProperties(pointClassify, pointClassifyVo);
            pointClassifyVo.setPointInputItemVo(inputItemList);
            classifyInputItemMap.put(pointClassify.getName() + "*" + pointClassify.getOrderNo(), pointClassifyVo);
            for (int i = 0; i < inputItemList.size(); i++) {
                if (!classifiedInputItemList.contains(inputItemList.get(i))) {
                    classifiedInputItemList.add(inputItemList.get(i));
                }
            }
        }

        return classifyInputItemMap;
    }

    @Override
    public List<PointVo> queryPointInfoList(List<DaoCriteria> criterias) {
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
        List<Point> pointList = iPointDao.findAll(spec);
        List<PointVo> pointVoList = new ArrayList<>();
        for (Point point : pointList) {
            PointVo pointVo = new PointVo();
            BeanUtils.copyProperties(point, pointVo);
            pointVo.setShotNumber(point.getShotMinNumber() + "-" + point.getShotMaxNumber());
            CatalogTree cataTree = catalogTreeDao.findById(point.getCatalogId()).get();
            String catalogName = cataTree != null ? cataTree.getName() : "";
            pointVo.setCatalogName(catalogName);
            List<String> routeNameList = routeMapper.getRouteNameByPointId(point.getId());
            String routeNames = StringUtils.join(routeNameList.toArray(), ",");
            pointVo.setRouteName(routeNames);
            List<String> inputItemNameList = new ArrayList<>();
            for (InputItem inputItem : queryPointInputItem(point.getId())) {
                inputItemNameList.add(inputItem.getName());
            }
            String inputItemName = StringUtils.join(inputItemNameList.toArray(), ",");
            ;
            pointVo.setInputItemName(inputItemName);
            pointVoList.add(pointVo);
        }
        return pointVoList;
    }

    @Override
    public List<PointVo> queryPointInfoListByIds(PointImportQueryParam pointImportQueryParam) {
        return pointMapper.getPointVoByIds(pointImportQueryParam);
    }

    @Override
    public List<HashMap<String, Object>> getSumPtByRole(HashMap<String, Object> paramMap) {
        List<HashMap<String, Object>> content = null;
        if (XJConstant.ADMIN_FLAG.equals(paramMap.get("roleFlag"))) {
            content = pointMapper
              .getSumPtForAdmin(paramMap.get("orgCode") == null ? null : paramMap.get("orgCode").toString());
        } else if (XJConstant.DEPART_FLAG.equals(paramMap.get("roleFlag"))) {
            content = pointMapper
              .getSumPtForDept(paramMap.get("orgCode") == null ? null : paramMap.get("orgCode").toString());
        } else if (XJConstant.PERSON_FLAG.equals(paramMap.get("roleFlag"))) {

        }
        List<Map<String, String>> statusEnums = PointStatusEnum.getEnumList();
        List<HashMap<String, Object>> rContent = new ArrayList<>();
        for (Map<String, String> statusEnum : statusEnums) {
            String code = statusEnum.get("value");
            boolean isCreate = true;
            for (HashMap<String, Object> c : content) {
                if (code.equals(c.get("status"))) {
                    isCreate = false;
                    rContent.add(c);
                    break;
                }
            }
            if (isCreate) {
                HashMap<String, Object> temp = new HashMap<>();
                temp.put("name", statusEnum.get("name"));
                temp.put("status", code);
                temp.put("value", 0);
                rContent.add(temp);
            }
        }
        return rContent;
    }

    @Override
    public Page<CheckPtListBo> getCheckPtList(CheckPtListPageParam param) {
        long total = pointMapper.getCheckPointCount(param);
        List<CheckPtListBo> content = pointMapper.getCheckPointList(param);
        Page<CheckPtListBo> result = new PageImpl<CheckPtListBo>(content, param, total);
        return result;
    }

    @Override
    public CheckPtListBo qryPointByID(int pointID) {
        CheckPtListBo point = pointMapper.getCheckPointById(pointID);
        return point;
    }

    @Override
    public List<PointClassify> queryClassByIds(List<Long> ids) {
        return iPointClassifyDao.findAllById(ids);
    }

//    @Override
//    public void initPointStatus() {
//        // TODO Auto-generated method stub
//        List<Point> pointList = iPointDao.findAll();
//        pointList.forEach(point -> {
//            PointStatusCache.getInstance().putPointStatus(point.getId(), point.getStatus());
//        });
//    }

    @Override
    public HashMap<String, Object> queryPointPie(HashMap<String, Object> params) {
        return pointMapper.queryPointPie(params);
    }

    @Override
    public List<String> qryPointNoList(List<DaoCriteria> criterias, Long pointId) {
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
        List<Point> pointList = iPointDao.findAll(spec);
        List<String> pointNoList = new ArrayList<>();
        for (Point point : pointList) {
            if (point.getId() != pointId) {
                pointNoList.add(point.getPointNo());
            }
        }
        return pointNoList;
    }

    @Override
    public List<HashMap<String, Object>> queryPointHistogram(HashMap<String, Object> params) {
        return pointMapper.queryPointHistogram(params);
    }

    @Override
    public long getPointCountByOrgCode(String loginOrgCode) {
        return pointMapper.getPointCountByOrgCode(loginOrgCode);
    }

    @Override
    public List<LeavelMovePointVo> queryLeavelPoint(String orgCode, String startTime) {
        return pointMapper.queryLeavelPoint(orgCode, startTime);
    }

    @Override
    public List<Map<String, Object>> getPoints() {
        // TODO Auto-generated method stub
        return pointMapper.getPoints();
    }

    @Override
    public List<Map<String, Object>> queryPointClassifyByRouteIdAndPointId(Long routeId, Long pointId) {
        // TODO Auto-generated method stub
        return pointMapper.queryPointClassifyByRouteIdAndPointId(routeId, pointId);
    }

    @Override
    public List<PointInputItemVo> queryOldPointInputItem(Long pointId) {
        List<PointInputItemVo> inputItemList = pointMapper.getPointInputItemById1(pointId, null);
        Map<Long, PointInputItemVo> itemMap = new HashMap<>();
        for (PointInputItemVo itemVo : inputItemList) {
            itemMap.put(itemVo.getPointItemId(), itemVo);
        }
        List<PointInputItemVo> list = new ArrayList<>();
        itemMap.values().forEach(item -> {
            list.add(item);
        });
        return list;
    }

    @Override
    public List<PointResponse> getPointConfigDom() {
        // TODO Auto-generated method stub
        return pointMapper.getPointConfigDom();
    }

    // @Override
    // public PointInfoSyn3DRespone pushPointTo3D(long pointId) {
    // List<Map<String,Object>> result = pointMapper.getPointInfoById(pointId);
    // PointInfoSyn3DRespone pointInfoResponse = new PointInfoSyn3DRespone();
    // List<PointUserSyn3DRespone> users = new
    // ArrayList<PointUserSyn3DRespone>();
    // if(!result.isEmpty()){
    // result.forEach(action->{
    // pointInfoResponse.setPointId(getValue(action.get("pointId")));
    // pointInfoResponse.setPointName(getValue(action.get("pointName")));
    // pointInfoResponse.setPointLevel(getValue(action.get("pointLevel")));
    // pointInfoResponse.setStatus(getValue(action.get("status")));
    // pointInfoResponse.setCoordinates(getValue(action.get("coordinates")));
    // pointInfoResponse.setAddress(getValue(action.get("address")));
    // PointUserSyn3DRespone pointUserSyn3DRespone = new
    // PointUserSyn3DRespone();
    // pointUserSyn3DRespone.setUserId(getValue(action.get("userId")));
    // pointUserSyn3DRespone.setUserName(getValue(action.get("userName")));
    // pointUserSyn3DRespone.setOrgCode(getValue(action.get("orgCode")));
    // pointUserSyn3DRespone.setGroupName(getValue(action.get("groupName")));
    // users.add(pointUserSyn3DRespone);
    // });
    // pointInfoResponse.setUsers(users);
    // }
    // List<PointInfoSyn3DRespone> list = new ArrayList<>();
    // list.add(pointInfoResponse);
    // remoteServer.pointInfoPush(list);
    // return pointInfoResponse;
    // }
    //
    // private String getValue(Object value){
    // if(value == null){
    // return "";
    // }
    // return value.toString();
    // }


    @Override
    public List<HashMap<String, Object>> findPointList(String code, String name, String orgCode) {
        // TODO Auto-generated method stub
        return pointMapper.findPointList(orgCode, name, code);
    }

    @Override
    public List<Point> queryPointInfoByParms(List<DaoCriteria> criterias) {
        // TODO Auto-generated method stub
        BaseQuerySpecification<Point> spec = new BaseQuerySpecification<>(criterias);
        List<Point> point = iPointDao.findAll(spec);
        return point;
    }

    @Override
    public CommonResponse getPointInfo(Long pointId) {
        JSONObject json = new JSONObject();
        Point point = iPointDao.findById(pointId).get();
        List<RiskFactorBo> riskFactorBos = riskFactorMapper.listEquipmentByRiskSourceId(Long.valueOf(point.getOriginalId()));
        List<Long> equipmentIds = Lists.transform(riskFactorBos, RiskFactorBo::getControlObjectId);
        if (!CollectionUtils.isEmpty(equipmentIds)) {
            List<EquipmentBo> equipmentBos = equipmentMapper.listByIds(equipmentIds);
            json.put("equipmentList", equipmentBos);
        }
        json.put("pointId", pointId);
        json.put("pointName", point.getName());
        json.put("pointNo", point.getPointNo());
        json.put("pointLevel", point.getLevel());
        json.put("pointType", point.getIsFixed());
        json.put("pointTypeName", point.getIsFixed() == "0" ? "移动点" : "固定点");
        json.put("offline", point.getOffline());
        json.put("riskFactorList", riskFactorBos);
        return CommonResponseUtil.success(json);
    }

    @Override
    public CommonResponse getEquipmentDetail(String toke, String product, String appKey, Long equipmentId) {
        JSONObject json = new JSONObject();
        EquipmentBo equipmentBo = equipmentMapper.getById(equipmentId);
        if (equipmentBo != null) {
            Set<String> deptIds = Sets.newHashSet();
            deptIds.add(equipmentBo.getDepartmentId());
            deptIds.add(equipmentBo.getRegionId());
            List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(deptIds));
            //Map<Long, DepartmentModel> departmentBoMap = Maps.uniqueIndex(departmentBos, DepartmentModel::getSequenceNbr);
            Map<String, String> deptMap = new HashMap<>();

            for (int i = 0; i < departmentBos.size(); i++) {
            	deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(), departmentBos.get(i).get("departmentName").toString());
			}
            AgencyUserModel userModel = remoteSecurityService.getUserById(toke, product, appKey, equipmentBo.getCreatorId());
            List<RiskFactorBo> riskFactorBos = riskFactorMapper.listEquipmentByEquipmentId(equipmentId);
            json.put("equipmentName", equipmentBo.getName());
            json.put("equipmentCode", equipmentBo.getCode());
            json.put("equipmentRegionName", deptMap.get(equipmentBo.getRegionId()+""));
            json.put("equipmentDepartmentName", deptMap.get(equipmentBo.getDepartmentId()+""));
            json.put("equipmentWorkshopSection", equipmentBo.getWorkshopSection());
            if (userModel != null) {
                json.put("equipmentUserName", userModel.getRealName());
            }
            json.put("riskFactorList", riskFactorBos);
        }
        return CommonResponseUtil.success(json);
    }

    @Override
    public CommonResponse getRiskFactorDetail(String toke, String product, String appKey, Long riskFactorId) {
        JSONObject json = new JSONObject();
        RiskFactorBo riskFactorBo = riskFactorMapper.getById(riskFactorId);
        if (riskFactorBo != null) {
            json.put("riskFactorName", riskFactorBo.getName());
            json.put("riskFactorLevel", riskFactorBo.getRfLevel());
            json.put("userNames", riskFactorBo.getUserNames());
            json.put("identificationMethodNames", riskFactorBo.getIdentificationMethodNames());
            if (riskFactorBo.getSecondEvaluateUserId() != null) {
                AgencyUserModel userModel = remoteSecurityService.getUserById(toke, product, appKey, riskFactorBo.getSecondEvaluateUserId());
                json.put("evaluateUserNames", userModel.getRealName());
            }
            json.put("evaluateMethodNames", riskFactorBo.getSecondEvaluateMothodName());
            json.put("riskSourceName", riskFactorBo.getRiskResourceName());
            if (!StringUtils.isEmpty(riskFactorBo.getAftermathIds())) {
                List<Long> aftermathIds = Arrays.stream(riskFactorBo.getAftermathIds().split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(aftermathIds)) {
                    List<AftermathBo> aftermathBos = aftermathMapper.listByIds(aftermathIds);
                    json.put("aftermathList", aftermathBos);
                }
            }
            Map<String, Object> map = Maps.newHashMap();
            map.put("evaluateId", riskFactorBo.getEvaluateId());
            map.put("riskFactorId", riskFactorId);
            List<Long> controlMeasuresIds = riskFactorCmMapper.listControlMeasuresIdsByMap(map);

            if (!CollectionUtils.isEmpty(controlMeasuresIds)) {
                JSONArray categoryArr = remoteSecurityService.listDictionaryByDictCode(toke, product, appKey, XJConstant.CM_CATEGORY_DIC_CODE);
                Map<String, String> categoryMap = Maps.newHashMap();
                for (int i = 0; i < categoryArr.size(); i++) {
                    JSONObject categoryJson = categoryArr.getJSONObject(i);
                    categoryMap.put(categoryJson.getString("dictDataKey"), categoryJson.getString("dictDataValue"));
                }
                JSONArray typeArr = remoteSecurityService.listDictionaryByDictCode(toke, product, appKey, XJConstant.CM_TYPE_DIC_CODE);
                Map<String, String> typeMap = Maps.newHashMap();
                for (int i = 0; i < typeArr.size(); i++) {
                    JSONObject typeJson = typeArr.getJSONObject(i);
                    typeMap.put(typeJson.getString("dictDataKey"), typeJson.getString("dictDataValue"));
                }
                List<ControlMeasuresBo> controlMeasuresBos = controlMeasuresMapper.listByIds(controlMeasuresIds);
                controlMeasuresBos.forEach(c -> {
                    c.setCategoryName(categoryMap.get(c.getCategory()));
                    c.setTypeName(typeMap.get(c.getType()));
                });
                json.put("controlMeasureList", controlMeasuresBos);
            }
        }
        return CommonResponseUtil.success(json);
    }

    @Override
    public List<PointInputItemVo> queryPointClassInputItem(Long pointId) {
        // TODO Auto-generated method stub
        return pointMapper.getPointClassInputItemById(pointId);
    }

    @Override
    public List<HashMap<String, Object>> getcountxd() {
        // TODO Auto-generated method stub
        return pointMapper.getcountxd();
    }

    @Override
    public List<HashMap<String, Object>> getcountnum() {
        // TODO Auto-generated method stub
        return pointMapper.getcountnum();
    }


//	@Override
//	public PointInfoSyn3DRespone pushPointTo3D(long pointId) {
//		List<Map<String,Object>> result = pointMapper.getPointInfoById(pointId);
//		PointInfoSyn3DRespone pointInfoResponse = new PointInfoSyn3DRespone();
//		List<PointUserSyn3DRespone> users = new ArrayList<PointUserSyn3DRespone>();
//		if(!result.isEmpty()){
//			result.forEach(action->{
//				pointInfoResponse.setPointId(getValue(action.get("pointId")));
//				pointInfoResponse.setPointName(getValue(action.get("pointName")));
//				pointInfoResponse.setPointLevel(getValue(action.get("pointLevel")));
//				pointInfoResponse.setStatus(getValue(action.get("status")));
//				pointInfoResponse.setCoordinates(getValue(action.get("coordinates")));
//				pointInfoResponse.setAddress(getValue(action.get("address")));
//				PointUserSyn3DRespone pointUserSyn3DRespone = new PointUserSyn3DRespone();
//				pointUserSyn3DRespone.setUserId(getValue(action.get("userId")));
//				pointUserSyn3DRespone.setUserName(getValue(action.get("userName")));
//				pointUserSyn3DRespone.setOrgCode(getValue(action.get("orgCode")));
//				pointUserSyn3DRespone.setGroupName(getValue(action.get("groupName")));
//				users.add(pointUserSyn3DRespone);
//			});
//			pointInfoResponse.setUsers(users);
//		}
//		List<PointInfoSyn3DRespone> list = new ArrayList<>();
//		list.add(pointInfoResponse);
//		remoteServer.pointInfoPush(list);
//		return pointInfoResponse;
//	}
//	
//	private String getValue(Object value){
//		if(value == null){
//			return "";
//		}
//		return value.toString();
//	}


}
