package com.yeejoin.amos.patrol.service.business.service.impl;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.common.enums.StatisticalCaliberEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.StatisticPieBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.StatisticsSumBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.QueryStatsMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointDao;
import com.yeejoin.amos.patrol.service.business.param.CheckStatsListPageParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IQueryStatsService;
import com.yeejoin.amos.patrol.service.business.vo.CheckStatsVo;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.exception.YeeException;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;

@Service("queryStatsService")
public class QueryStatsServiceImpl implements IQueryStatsService {

    @Resource
    private QueryStatsMapper queryStatsMapper;
    @Autowired
    private IPointDao iPointDao;
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    
    private String beginDateOfThisYear = DateUtil.getLongDate(DateUtil.getCurrYearFirst());

    @Override
    public Page<CheckStatsVo> queryCheckStats(CheckStatsListPageParam paramMap) {
//		long total = queryStatsMapper.countCheckStatsData(paramMap);
        long total = 100;
        List<CheckStatsVo> content = queryStatsMapper.getCheckStats(paramMap);
        Page<CheckStatsVo> result = new PageImpl<CheckStatsVo>(content, paramMap, total);
        return result;
    }

	@Override
	public Map<String, Object> queryStatisticsList() {
		Map<String, Object> statisticsMap = new HashMap<>();
//		//1.查询风险点统计信息(本年度,等级不为空)
//		StatisticsSumBo riskSum = queryStatsMapper.getStatisticsSumByRisk();
//		riskSum.setName("风险点");
//		statisticsMap.put(StatisticalCaliberEnum.RISK.getCode(), riskSum);
		
		     //1.改为巡点点
		StatisticsSumBo riskSum=new StatisticsSumBo();
				List<Point> list = iPointDao.findAll();
				riskSum.setName("风险点");
				if(list!=null&&list.size()>0){
					riskSum.setActualNum(0l);
					riskSum.setTotalNum(Long.valueOf(list.size()+""));
				}else{
					riskSum.setActualNum(0l);
					riskSum.setTotalNum(0l);
				}
				
				statisticsMap.put(StatisticalCaliberEnum.RISK.getCode(), riskSum);
		
		
		
		//2.查询隐患统计信息(本年度)
		StatisticsSumBo dangerSum = queryStatsMapper.getStatisticsSumByDanger(beginDateOfThisYear);
		dangerSum.setName("隐患");
		statisticsMap.put(StatisticalCaliberEnum.DANGER.getCode(), dangerSum);
		//3.查询作业活动统计信息(本年度,等级不为空)
		StatisticsSumBo taskworkSum = queryStatsMapper.getStatisticsSumByTaskwork(beginDateOfThisYear);
		taskworkSum.setName("作业活动");
		statisticsMap.put(StatisticalCaliberEnum.TASKWORK.getCode(), taskworkSum);
		//4.查询风险研判统计信息(当天)
		String searchDateStr = "";
		Date now = new Date();
		if (!now.before(DateUtil.getHourBeginOfDay(8))) {
			searchDateStr = DateUtil.getShortDate(DateUtil.getDateByNumber(now, -1));
		} else {
			searchDateStr = DateUtil.getShortDate(now);
		}
		StatisticsSumBo judgmentSum = queryStatsMapper.getStatisticsSumByJudgment(searchDateStr);
		judgmentSum.setName("风险研判");
		statisticsMap.put(StatisticalCaliberEnum.JUDGMENT.getCode(), judgmentSum);
		return statisticsMap;
	}

	@Override
	public Map<String, Object> queryStatisticsDetailByType(String toke,String product,String appKey,String type, String loginOrgCode) {
		Map<String, Object> detailMap = new HashMap<>();
		//String orgCode = loginOrgCode.split("\\*")[0];
		String orgCode = loginOrgCode.split("\\-")[0];
		if (type.equals(StatisticalCaliberEnum.RISK.getCode())) {
			getRiskStatistics( toke, product, appKey,orgCode, detailMap);
		} else if (type.equals(StatisticalCaliberEnum.DANGER.getCode())) {
			getDangerStatistics(orgCode, detailMap);
		} else if (type.equals(StatisticalCaliberEnum.TASKWORK.getCode())) {
			getTaskworkStatistics( toke, product, appKey,orgCode, detailMap);
		} else if (type.equals(StatisticalCaliberEnum.JUDGMENT.getCode())) {
			getJudgmentStatistics( toke, product, appKey,orgCode, detailMap);
		} else {
			throw new YeeException("参数错误");
		}
		return detailMap;
	}

	private void getRiskStatistics(String toke,String product,String appKey,String orgCode, Map<String, Object> detailMap) {
		
	 JSONArray list= remoteSecurityService.listDictionaryByDictCode(toke, product, appKey,"FXDJ_TYPE");
		String typesql="";
		List<Map<String, Object> > listmap=new ArrayList<Map<String, Object> >();
		List<StatisticPieBo> levelBoListdate=new ArrayList<StatisticPieBo>();
	     if(list!=null&&list.size()>0){
	    	 
	    	 
	    	 for (int i = 0; i < list.size(); i++) {
               
	    		 Map<String, Object> map=new HashMap<>();
		    	 map.put("key", list.getJSONObject(i).get("dictDataKey"));
		    	 map.put("name", "level"+list.getJSONObject(i).get("dictDataKey"));
		    	 listmap.add(map);
	    		 
	    		 
				StatisticPieBo dd=new StatisticPieBo();
				dd.setName(list.getJSONObject(i).get("dictDataValue")+"");
				dd.setPercent("0%");
				dd.setTotal(0L);
				dd.setValue("0");
				levelBoListdate.add(dd);
			}
	    	 
	     }
			
		List<StatisticPieBo> levelBoList = queryStatsMapper.getRiskPieDetailInfo(orgCode);
		
		
		for (int i = 0; i < levelBoListdate.size(); i++) {
			
			if(levelBoList!=null&&levelBoList.size()>0){
				
				for (int j = 0; j < levelBoList.size(); j++) {
					
					if(levelBoListdate.get(i).getName().equals(levelBoList.get(j).getName())){
						
						levelBoListdate.get(i).setPercent(levelBoList.get(j).getPercent());
						levelBoListdate.get(i).setTotal(levelBoList.get(j).getTotal());
						levelBoListdate.get(i).setValue(levelBoList.get(j).getValue());
						
						continue;
					}
					
				}
				
				
				
				
			}
			
		}
		
		
		
		
		Long total = 0l;
		for (StatisticPieBo bo : levelBoListdate) {
			total += Long.parseLong(bo.getValue());
		}
		for (StatisticPieBo bo : levelBoListdate) {
			bo.setTotal(total);
		}
		detailMap.put("byRiskLevel", levelBoListdate);
		
		
		List<Map<String, String>> departmentMap = queryStatsMapper.queryRiskByDepartment(orgCode,listmap);
		departmentMap.forEach(d -> {
			String departmentId = d.get("belongDepartmentId");
			DepartmentModel deptBo = remoteSecurityService.getDepartmentByDeptId( toke, product, appKey,departmentId);
			if (null != deptBo) {				
				d.put("departmentName", deptBo.getDepartmentName());
			}
		});
		detailMap.put("byDepartment", departmentMap);
		List<Map<String, String>> highLevelBoList = queryStatsMapper.queryRiskByHighLevel(orgCode);
		detailMap.put("byHighLevel", highLevelBoList);
	}
	
	private void getDangerStatistics(String orgCode, Map<String, Object> detailMap) {
		List<StatisticPieBo> levelBoList = queryStatsMapper.getPieInfoByDangerLevel(orgCode, beginDateOfThisYear);
		detailMap.put("byDangerLevel", levelBoList);
		List<StatisticPieBo> statusBoList = queryStatsMapper.getPieInfoByDangerStatus(orgCode, beginDateOfThisYear);
		Long total = 0L;
		for (int i = 0; i < statusBoList.size(); i++) {
			total += Long.parseLong(statusBoList.get(i).getValue());
		}
		for (StatisticPieBo bo : statusBoList) {
			bo.setTotal(total);
			bo.setPercent(parsePercent(percent(Long.parseLong(bo.getValue()), total)));
		}
		detailMap.put("byDangerStatus", statusBoList);
	}
	
	
	/**
	 * Object 转化成百分比 传如的参数必须是数字类型， 如"0.02" return 2.00%
	 * 百分比位数 参数可自行调整
	 *  
	 * @param obj
	 * @return 返回百分比    
	 */
	private String parsePercent(Object obj) {
		Double d = Double.parseDouble(obj.toString());
		NumberFormat percentFormat = NumberFormat.getPercentInstance();
		percentFormat.setMaximumFractionDigits(2); // 最大小数位数
		percentFormat.setMaximumIntegerDigits(3);// 最大整数位数
		percentFormat.setMinimumFractionDigits(2); // 最小小数位数
		percentFormat.setMinimumIntegerDigits(1);// 最小整数位数
		return percentFormat.format(d);// 自动转换成百分比显示
	}

	private void getTaskworkStatistics(String toke,String product,String appKey,String orgCode, Map<String, Object> detailMap) {
		
		
		
		JSONArray list= remoteSecurityService.listDictionaryByDictCode( toke, product, appKey,"FXDJ_TYPE");
		String typesql="";
		List<StatisticPieBo> levelBoListdate=new ArrayList<StatisticPieBo>();
	     if(list!=null&&list.size()>0){
	    	 
	    	 for (int i = 0; i < list.size(); i++) {
               
				StatisticPieBo dd=new StatisticPieBo();
				dd.setName(list.getJSONObject(i).get("dictDataValue")+"");
				dd.setPercent("0%");
				dd.setTotal(0L);
				dd.setValue("0");
				levelBoListdate.add(dd);
			}
	    	 
	     }
		
		List<StatisticPieBo> levelBoList = queryStatsMapper.getPieInfoByTaskworkRiskLevel(orgCode, beginDateOfThisYear);
		
		
for (int i = 0; i < levelBoListdate.size(); i++) {
			
			if(levelBoList!=null&&levelBoList.size()>0){
				
				for (int j = 0; j < levelBoList.size(); j++) {
					
					if(levelBoListdate.get(i).getName().equals(levelBoList.get(j).getName())){
						
						levelBoListdate.get(i).setPercent(levelBoList.get(j).getPercent());
						levelBoListdate.get(i).setTotal(levelBoList.get(j).getTotal());
						levelBoListdate.get(i).setValue(levelBoList.get(j).getValue());
						
						continue;
					}
					
				}
				
				
				
				
			}
			
		}
		
		
		List<StatisticPieBo> statusBoList = queryStatsMapper.getPieInfoByTaskworkStatus(orgCode, beginDateOfThisYear);
		List<StatisticPieBo> violateStatusBoList = queryStatsMapper.getPieInfoByTaskworkViolateStatus(orgCode, beginDateOfThisYear);
		List<StatisticPieBo> typeBoList = queryStatsMapper.getPieInfoByTaskworkType(orgCode, beginDateOfThisYear);
		Long total = 0l;
		for (StatisticPieBo bo : levelBoListdate) {
			total += Long.parseLong(bo.getValue());
		}
		for (StatisticPieBo bo : levelBoListdate) {
			bo.setTotal(total);
		}
		detailMap.put("byRiskLevel", levelBoListdate);
		total = 0l;
		for (StatisticPieBo bo : statusBoList) {
			total += Long.parseLong(bo.getValue());
		}
		for (StatisticPieBo bo : statusBoList) {
			bo.setTotal(total);
			bo.setPercent(parsePercent(percent(Long.parseLong(bo.getValue()), total)));
		}
		detailMap.put("byTaskworkStatus", statusBoList);
		total = 0l;
		for (StatisticPieBo bo : violateStatusBoList) {
			total += Long.parseLong(bo.getValue());
		}
		for (StatisticPieBo bo : violateStatusBoList) {
			bo.setTotal(total);
			bo.setPercent(parsePercent(percent(Long.parseLong(bo.getValue()), total)));
		}
		detailMap.put("byTaskworkViolateStatus", violateStatusBoList);
		total = 0l;
		for (StatisticPieBo bo : typeBoList) {
			total += Long.parseLong(bo.getValue());
		}
		for (StatisticPieBo bo : typeBoList) {
			bo.setTotal(total);
			bo.setPercent(parsePercent(percent(Long.parseLong(bo.getValue()), total)));
		}
		detailMap.put("byTaskworkType", typeBoList);
	}
	
	private Float percent(Long a, Long b) {
		return b != 0 ? a / (float) b : 0;
	}
	
	private void getJudgmentStatistics(String toke,String product,String appKey,String orgCode, Map<String, Object> detailMap) {
		String searchDateStr = "";
		Date now = new Date();
		if (now.before(DateUtil.getHourBeginOfDay(8))) {
			searchDateStr = DateUtil.getShortDate(DateUtil.getDateByNumber(now, -1));
		} else {
			searchDateStr = DateUtil.getShortDate(now);
		}
		List<Map<String, String>> result = queryStatsMapper.getJudgmentStatusByDepartment(orgCode, searchDateStr);
		Set<String> deptIdSet = Sets.newHashSet();
		for (int i = 0; i < result.size(); i++) {
			String deptId = result.get(i).get("deptId");
			if (result.get(i).get("status") == null) {
				result.remove(i);
				i--;
			} else {
				deptIdSet.add(deptId);
			}
		}
		   Map<String, String> deptMap = new HashMap<>();
		List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds( toke, product, appKey,Joiner.on(",").join(deptIdSet));
		if (null != departmentBos) {
			//Map<Long, DepartmentModel> departmentBoMap = Maps.uniqueIndex(departmentBos, DepartmentModel::getSequenceNbr);
			 for (int i = 0; i < departmentBos.size(); i++) {
	            	deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(), departmentBos.get(i).get("departmentName").toString());
				}
			for (int i = 0; i < result.size(); i++) {
				String deptBo = deptMap.get(result.get(i).get("deptId")+"");
				result.get(i).put("deptName", deptBo);
			}
			detailMap.put("byDepartmentStatus", result);
		}
	}
}
