package com.yeejoin.amos.patrol.service.business.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.transaction.Transactional;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.RiskJudgmentTaskStatusEnum;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskJudgmentFillRecordBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskJudgmentTaskBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskJudgmentFillRecordMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskJudgmentTaskMapper;
import com.yeejoin.amos.patrol.service.business.param.JdReviewCallBackParam;
import com.yeejoin.amos.patrol.service.business.param.RiskJudgmentFillRecordParam;
import com.yeejoin.amos.patrol.service.business.param.RiskJudgmentSaveRecordParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IRiskJudgmentService;
import com.yeejoin.amos.patrol.service.business.vo.RiskJudgmentTaskVo;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.remote.RemoteWorkFlowService;
//import com.yeejoin.amos.security.common.model.UserModel;

@Service("riskJudgmentService")
public class RiskJudgmentServiceImpl implements IRiskJudgmentService {

    private final Logger logger = LoggerFactory.getLogger(RiskJudgmentServiceImpl.class);

    @Autowired
    private RiskJudgmentTaskMapper riskJudgmentTaskMapper;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private RiskJudgmentFillRecordMapper riskJudgmentFillRecordMapper;

    @Autowired
    private RemoteWorkFlowService remoteWorkFlowService;

    @Autowired
    private AsyncTask asyncTask;

    private static final String permissionType = "activitiItem";

    @Override
    public CommonResponse list(String toke,String product,String appKey,String userId, Integer pageNumber, Integer pageSize, String beginTime, String endTime, Integer status, String orgCode, String deptId) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("userId", userId);
        map.put("beginTime", beginTime);
        map.put("endTime", endTime);
        map.put("orgCode", orgCode);
        map.put("departmentId", deptId);
        map.put("offset", pageNumber * pageSize);
        map.put("limit", pageSize);
        if (status != 0) {
            map.put("taskStatus", status);
        }
        List<RiskJudgmentTaskBo> list = riskJudgmentTaskMapper.listByMap(map);
        List<RiskJudgmentTaskVo> result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponseUtil.success(new PageImpl<>(result, null, 0L));
        }
        Long count = riskJudgmentTaskMapper.countByMap(map);
        List<String> deptIds = Lists.transform(list, RiskJudgmentTaskBo::getDepartmentId);
        Set<String> deptIdSet = Sets.newHashSet(deptIds);
        List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds( toke, product, appKey,Joiner.on(",").join(deptIdSet));
       // Map<Long, LinkedHashMap> departmentBoMap = Maps.uniqueIndex(departmentBos, LinkedHashMap::get("departmentName"));
       
        Map<String, String> deptMap = new HashMap<>();

        for (int i = 0; i < departmentBos.size(); i++) {
        	deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(), departmentBos.get(i).get("departmentName").toString());
		}
        list.forEach(e -> {
        	String departmentBo = deptMap.get(e.getDepartmentId()+"");
        	DepartmentModel departmentBo4 =new DepartmentModel();
        	departmentBo4.setDepartmentName(departmentBo);
            result.add(getRiskJudgmentTaskVo(departmentBo4, e));
        });
        return CommonResponseUtil.success(new PageImpl<>(result, null, count));
    }

    @Transactional
    @Override
    public CommonResponse saveRecordInfo(RiskJudgmentSaveRecordParam recordParam, String orgCode, String userId) {
        RiskJudgmentTaskBo taskBo = riskJudgmentTaskMapper.getById(recordParam.getTaskId());
        if (taskBo == null) {
            return CommonResponseUtil.failure("任务不存在");
        }
        if (!taskBo.getTaskStatus().equals(RiskJudgmentTaskStatusEnum.进行中.getCode())) {
            return CommonResponseUtil.failure("进行中任务可保存");
        }
        List<String> userIdList = Arrays.asList(taskBo.getFlowUserIds().split(","));
        if (!userIdList.contains(userId)) {
            return CommonResponseUtil.failure("无权限执行");
        }
        List<RiskJudgmentFillRecordBo> saveRecordBos = Lists.newArrayList();
        List<RiskJudgmentFillRecordBo> updateRecordBos = Lists.newArrayList();
        recordTreeToList(recordParam.getRecords(), saveRecordBos, updateRecordBos, orgCode);
        if (!CollectionUtils.isEmpty(saveRecordBos)) {
            riskJudgmentFillRecordMapper.saveBatch(saveRecordBos);
        }
        if (!CollectionUtils.isEmpty(updateRecordBos)) {
            riskJudgmentFillRecordMapper.updateBatch(updateRecordBos);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse updateTaskStatus(String toke,String product,String appKey,Long taskId, String userId, String token) {
        RiskJudgmentTaskBo taskBo = riskJudgmentTaskMapper.getById(taskId);
        if (taskBo == null) {
            return CommonResponseUtil.failure("任务不存在");
        }
        if (!taskBo.getTaskStatus().equals(RiskJudgmentTaskStatusEnum.进行中.getCode())) {
            return CommonResponseUtil.failure("进行中任务可提交");
        }
        if (!taskBo.getFlowUserIds().contains(userId)) {
            return CommonResponseUtil.failure("无权限执行");
        }
        Long count = riskJudgmentFillRecordMapper.countNotFinishRecordByTaskId(taskId);
        if (count > 0) {
            return CommonResponseUtil.failure("请完善信息");
        }
        JSONObject request = new JSONObject();
        request.put("action", "complete");
        JSONObject executeJson = remoteWorkFlowService.excute(taskBo.getCurrentFlowTaskId(), request.toJSONString(), token);
        if (executeJson == null) {
            return CommonResponseUtil.failure("提交工作流失败");
        }
        RiskJudgmentTaskStatusEnum statusEnum = RiskJudgmentTaskStatusEnum.已提交;
        taskBo.setTaskStatus(statusEnum.getCode());
        taskBo.setTaskCommitDate(new Date());
        riskJudgmentTaskMapper.update(taskBo);
        try {
            List<UserModel> userModels = remoteSecurityService.listUserByMenuCode(permissionType, taskBo.getTaskDefinitionKey() + "_1");
            Set<String> userIds = Sets.newHashSet(Lists.transform(userModels, UserModel::getUserId));
            String cdate = DateUtil.formatDatrToStr(taskBo.getTaskDate(), "yyyy年MM月dd日");
            DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,taskBo.getDepartmentId());
            // 风险研判取消
//            asyncTask.pushRiskJudgmentMessage(userIds, taskBo.getOrgCode(),
//                    taskBo.getTaskName(), cdate, departmentBo.getDepartmentName(),
//                    statusEnum.getName(), taskId, taskBo.getTaskStatus());
        } catch (Exception e) {
            logger.error("风险研判推送异常", e);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse reviewRefuseCallBack(String instanceId, String taskDefinitionKey) {
        RiskJudgmentTaskBo taskBo = riskJudgmentTaskMapper.getByInstanceIdAndTaskDefinitionKey(instanceId, taskDefinitionKey);
        if (taskBo != null) {
            if (taskBo.getTaskStatus().equals(RiskJudgmentTaskStatusEnum.已超时.getCode())) {
                return CommonResponseUtil.success();
            } else if (taskBo.getTaskStatus().equals(RiskJudgmentTaskStatusEnum.已提交.getCode())) {
                taskBo.setTaskStatus(RiskJudgmentTaskStatusEnum.进行中.getCode());
                riskJudgmentTaskMapper.update(taskBo);
            }
        }
        return CommonResponseUtil.success();
    }

    private void recordTreeToList(List<RiskJudgmentFillRecordParam> records, List<RiskJudgmentFillRecordBo> saveRecords, List<RiskJudgmentFillRecordBo> updateRecords, String orgCode) {
        records.forEach(record -> {
            RiskJudgmentFillRecordBo riskJudgmentFillRecordBo = new RiskJudgmentFillRecordBo();
            riskJudgmentFillRecordBo.setDeleted(record.getDeleted());
            riskJudgmentFillRecordBo.setItemFinish(record.getItemFinish());
            riskJudgmentFillRecordBo.setTaskId(record.getTaskId());
            riskJudgmentFillRecordBo.setItemId(record.getItemId());
            riskJudgmentFillRecordBo.setInputResult(record.getInputResult());
            riskJudgmentFillRecordBo.setPhotoResult(record.getPhotoResult());
            riskJudgmentFillRecordBo.setRemarkResult(record.getRemarkResult());
            riskJudgmentFillRecordBo.setSelectResult(record.getSelectResult());
            riskJudgmentFillRecordBo.setOrgCode(orgCode);
            if (record.getId() != null) {
                riskJudgmentFillRecordBo.setId(record.getId());
                updateRecords.add(riskJudgmentFillRecordBo);
            } else {
                saveRecords.add(riskJudgmentFillRecordBo);
            }
            if (!CollectionUtils.isEmpty(record.getChilds())) {
                recordTreeToList(record.getChilds(), saveRecords, updateRecords, orgCode);
            }
        });
    }

    @Override
    public List<RiskJudgmentFillRecordBo> getRiskJudgmentItemData(Long taskId, Integer itemType, Integer itemLevel, Long itemId) {
        return riskJudgmentFillRecordMapper.listFillRecordData(taskId, itemType, itemLevel, itemId);
    }

    @Override
    public CommonResponse jdReviewCallBack(String nodeType, JdReviewCallBackParam requestParam, String token) {
        String instanceId = requestParam.getInstanceId();
        String taskDefinitionKey = requestParam.getTaskDefinitionKey();
        Boolean isPass = requestParam.getIsPass();
        if (XJConstant.REVIEW_DEPT.equals(nodeType)) {//车间节点
            RiskJudgmentTaskBo taskBo = riskJudgmentTaskMapper.getByInstanceIdAndTaskDefinitionKey(instanceId, taskDefinitionKey);
            if (taskBo == null) {
                return CommonResponseUtil.success();
            }
            if (!isPass) {
                //车间审核拒绝
                if (taskBo.getTaskStatus().equals(RiskJudgmentTaskStatusEnum.已超时.getCode())) {
                    return CommonResponseUtil.success();
                } else if (taskBo.getTaskStatus().equals(RiskJudgmentTaskStatusEnum.已提交.getCode())) {           	
                	JSONObject nextJson = remoteWorkFlowService.currentTask(instanceId, taskBo.getTaskDefinitionKey(),token);
            		if (nextJson == null) {
            			taskBo.setCurrentFlowTaskId("-1");
            		} else {
            			taskBo.setCurrentFlowTaskId(nextJson.getString("id"));
            		}
                    taskBo.setTaskStatus(RiskJudgmentTaskStatusEnum.进行中.getCode());
                    riskJudgmentTaskMapper.update(taskBo);
                }
            } else {
                //车间审核通过
                taskBo.setTaskStatus(RiskJudgmentTaskStatusEnum.已审核.getCode());
                riskJudgmentTaskMapper.update(taskBo);
            }
        } else if (XJConstant.COMBINE_DATA.equals(nodeType)) {
            //合并节点
            HashMap<String, Object> map = new HashMap<>();
            map.put("flowInstanceId", instanceId);
            map.put("taskStatus", RiskJudgmentTaskStatusEnum.已合并.getCode());
            riskJudgmentTaskMapper.updatetTaskStatusByInstanceId(map);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse detail(String toke,String product,String appKey,Long taskId) {
        RiskJudgmentTaskBo taskBo = riskJudgmentTaskMapper.getById(taskId);
        DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,taskBo.getDepartmentId());
        return CommonResponseUtil.success(getRiskJudgmentTaskVo(departmentBo, taskBo));
    }

    private RiskJudgmentTaskVo getRiskJudgmentTaskVo(DepartmentModel departmentBo, RiskJudgmentTaskBo taskBo) {
        RiskJudgmentTaskVo riskJudgmentTaskVo = new RiskJudgmentTaskVo();
        riskJudgmentTaskVo.setId(taskBo.getId());
        riskJudgmentTaskVo.setDate(DateUtil.formatDatrToStr(taskBo.getTaskDate(), "yyyy年MM月dd日"));
        if (departmentBo != null) {
            riskJudgmentTaskVo.setDepartmentName(departmentBo.getDepartmentName());
        }
        riskJudgmentTaskVo.setJudgmentName(taskBo.getTaskName());
        riskJudgmentTaskVo.setStatus(taskBo.getTaskStatus());
        RiskJudgmentTaskStatusEnum statusEnum = RiskJudgmentTaskStatusEnum.getByCode(taskBo.getTaskStatus());
        if (statusEnum != null) {
            riskJudgmentTaskVo.setStatusDesc(statusEnum.getName());
        }
        return riskJudgmentTaskVo;
    }
}
