package com.yeejoin.amos.patrol.service.business.service.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.patrol.common.core.response.bo.CompanyBo;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.BooleanEnum;
import com.yeejoin.amos.patrol.common.enums.RiskJudgeTaskworkTypeEnum;
import com.yeejoin.amos.patrol.common.enums.RiskJudgmentSelectStatusEnum;
import com.yeejoin.amos.patrol.common.enums.RiskJudgmentStatusEnum;
import com.yeejoin.amos.patrol.common.enums.RiskJudgmentTaskStatusEnum;
import com.yeejoin.amos.patrol.common.enums.RiskLevelEnum;
import com.yeejoin.amos.patrol.common.enums.TaskworkTypeEnum;
import com.yeejoin.amos.patrol.common.enums.WorkFlowDefinitionKeyEnum;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskJudgmentFillRecordBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskJudgmentItemBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskJudgmentTaskBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskSourceBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.LatentDangerMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskJudgmentFillRecordMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskJudgmentItemMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskJudgmentTaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskSourceMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.TaskworkMapper;
import com.yeejoin.amos.patrol.service.business.service.intfc.IRiskJudgmentTaskService;
import com.yeejoin.amos.patrol.service.business.util.RandomUtil;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.core.util.StringUtil;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.remote.RemoteWorkFlowService;
//import com.yeejoin.amos.security.common.model.UserModel;

@Service("iSpcRiskJudgmentTaskService")
public class RiskJudgmentTaskServiceImpl implements IRiskJudgmentTaskService {

    private final Logger logger = LoggerFactory.getLogger(RiskJudgmentTaskServiceImpl.class);

    @Autowired
    private RiskJudgmentTaskMapper riskJudgmentTaskMapper;
    
    @Autowired
    private RiskSourceMapper riskSourceMapper;

    @Autowired
    private RiskJudgmentItemMapper riskJudgmentItemMapper;

    @Autowired
    private RiskJudgmentFillRecordMapper riskJudgmentFillRecordMapper;

    @Autowired
    private RiskFactorMapper riskFactorMapper;

    @Autowired
    private LatentDangerMapper latentDangerMapper;

    @Autowired
    private TaskworkMapper taskworkMapper;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private RemoteWorkFlowService remoteWorkFlowService;

    @Autowired
    private AsyncTask asyncTask;

    private static final String permissionType = "activitiItem";

    @Override
    public void initRiskJudgmentTask(String toke,String product,String appKey,Date date) {
        JSONObject body = new JSONObject();
        String businessKey = RandomUtil.buildOrderNo();
        body.put("processDefinitionKey", WorkFlowDefinitionKeyEnum.风险研判评审.getProcessDefinitionKey());
        body.put("businessKey", businessKey);
        JSONObject startJson = remoteWorkFlowService.startWithAppKey(body);
        if (startJson == null) {
            logger.info("启动流程失败");
            return;
        }
        JSONObject dataList = startJson.getJSONObject("dataList");
        String instanceId = dataList.getJSONObject("historicInstance").getString("id");
        JSONArray taskInstances = dataList.getJSONArray("taskInstances");
        Map<String, JSONObject> taskDefinitionKeyMap = buildTaskDefinitionKeyMap(taskInstances);
        List<CompanyModel> companyBoList = remoteSecurityService.listCompanyTree( toke, product, appKey,null);
        if (CollectionUtils.isEmpty(companyBoList)) {
            return;
        }
        List<CompanyModel> companyBos = Lists.newArrayList();
        writeCompany(companyBoList, companyBos);
        companyBos.forEach(c -> {
            List<DepartmentModel> departmentBos = Lists.newArrayList();
            String companyId = c.getSequenceNbr()+"";
            List<DepartmentModel> list = remoteSecurityService.getDepartmentTreeByCompanyId( toke, product, appKey,companyId);
            writeDepartment(list, departmentBos);
            if (!CollectionUtils.isEmpty(departmentBos)) {
                for (DepartmentModel departmentBo : departmentBos) {
                    JSONObject taskInstance = getTaskInstanceByName(departmentBo.getDepartmentName(), taskDefinitionKeyMap);
                    if (taskInstance != null) {
                        List<RiskJudgmentItemBo> items = riskJudgmentItemMapper.listAllItemByDepartmentId(departmentBo.getSequenceNbr()+"");
                        boolean success = initRiskJudgment(taskInstance, departmentBo, date, items, c.getOrgCode(), companyId, instanceId);
                        if (!success) {
                            logger.info("初始化风险研判任务失败，部门编号===================>" + departmentBo.getSequenceNbr());
                        }
                    }
                }
            }
        });
    }

    private Map<String, JSONObject> buildTaskDefinitionKeyMap(JSONArray arr) {
        Map<String, JSONObject> map = Maps.newHashMap();
        for (int i = 0; i < arr.size(); i++) {
            JSONObject object = arr.getJSONObject(i);
            map.put(object.getString("taskDefinitionKey"), object);
        }
        return map;
    }

    private JSONObject getTaskInstanceByName(String departmentName, Map<String, JSONObject> map) {
        JSONObject object = null;
        switch (departmentName) {
            case "双甲车间二期":
                object = map.get("G_1");
                break;
            case "双甲车间三期":
                object = map.get("G_2");
                break;
            case "动力车间":
                object = map.get("G_3");
                break;
            case "合成车间":
                object = map.get("G_4");
                break;
            case "气化车间":
                object = map.get("G_5");
                break;
            case "化工科技车间":
                object = map.get("G_6");
                break;
            case "原料车间":
                object = map.get("G_7");
                break;
            case "供排水车间":
                object = map.get("G_8");
                break;
            default:
                break;
        }
        return object;
    }

    private boolean initRiskJudgment(JSONObject taskInstance, DepartmentModel departmentBo, Date date, List<RiskJudgmentItemBo> items, String orgCode, String companyId, String instanceId) {
        RiskJudgmentTaskBo riskJudgmentTaskBo = new RiskJudgmentTaskBo();
        String currentFlowTaskId = taskInstance.getString("id");
        String taskDefinitionKey = taskInstance.getString("taskDefinitionKey");
        String reviewUserIds = getUserIds(taskDefinitionKey, companyId, departmentBo.getSequenceNbr()+"");
        riskJudgmentTaskBo.setFlowInstanceId(instanceId);
        riskJudgmentTaskBo.setTaskStatus(RiskJudgmentStatusEnum.未开始.getCode());
        riskJudgmentTaskBo.setTaskDefinitionKey(taskDefinitionKey);
        riskJudgmentTaskBo.setCurrentFlowTaskId(currentFlowTaskId);
        riskJudgmentTaskBo.setFlowUserIds(reviewUserIds);
        riskJudgmentTaskBo.setTaskName("风险研判任务");
        riskJudgmentTaskBo.setDepartmentId(departmentBo.getSequenceNbr()+"");
        riskJudgmentTaskBo.setTaskDate(date);
        riskJudgmentTaskBo.setOrgCode(orgCode);
        riskJudgmentTaskMapper.save(riskJudgmentTaskBo);
        List<RiskJudgmentFillRecordBo> records = Lists.newArrayList();
        for (RiskJudgmentItemBo item : items) {
            RiskJudgmentFillRecordBo record = new RiskJudgmentFillRecordBo();
            record.setTaskId(riskJudgmentTaskBo.getId());
            record.setItemId(item.getId());
            String selectResultStr = null;
            if (item.getSelectIsNeed().equals(BooleanEnum.YES.getCode())) {
                StringBuilder selectResult = new StringBuilder();
                JSONArray arr = JSONArray.parseArray(item.getSelectJson());
                for (int i = 0; i < arr.size(); i++) {
                    JSONObject jsonObject = arr.getJSONObject(i);
                    if (jsonObject.getBoolean("defaultSelect")) {
                        selectResult.append(jsonObject.getString("id")).append(",");
                    }
                }
                if (selectResult.length() > 0) {
                    selectResultStr = selectResult.substring(0, selectResult.length() - 1);
                }
            }
            record.setSelectResult(selectResultStr);
            Long count = getCount(item.getItemFlag(), departmentBo.getSequenceNbr()+"");
            if (count != null) {//数量回显
                record.setInputResult(String.valueOf(count));
            }
            String defaultSelectId = getDefaultSelectId(item.getItemFlag(), departmentBo.getSequenceNbr()+"");    
            if (defaultSelectId != null) {//作业活动是否可控回显
                record.setSelectResult(defaultSelectId);
            }
            record.setOrgCode(orgCode);
            records.add(record);
        }
        riskJudgmentFillRecordMapper.saveBatch(records);
        return true;
    }

    private String getDefaultSelectId(String itemFlag, String deptId) {
		String defaultSelectId = null;
		Long count = null;
		switch (itemFlag) {
		case "danger_work_control_a"://重大工艺操作
            count = taskworkMapper.countViolateState(TaskworkTypeEnum.重大工艺操作.getCode(), deptId);
            break;
        case "danger_work_control_b"://检维修作业
            count = taskworkMapper.countViolateState(TaskworkTypeEnum.检维修作业.getCode(), deptId);
            break;
        case "danger_work_control_c"://特殊动火作业
            count = taskworkMapper.countViolateState(TaskworkTypeEnum.特殊动火作业.getCode(), deptId);
            break;
        case "danger_work_control_d"://一级动火作业
            count = taskworkMapper.countViolateState(TaskworkTypeEnum.一级动火作业.getCode(), deptId);
            break;
        case "danger_work_control_e"://二级动火作业
            count = taskworkMapper.countViolateState(TaskworkTypeEnum.二级动火作业.getCode(), deptId);
            break;
        case "danger_work_control_f"://进入受限空间作业
            count = taskworkMapper.countViolateState(TaskworkTypeEnum.进入受限空间作业.getCode(), deptId);
            break;
		default:
			break;
		}
		if(count != null && count > 0){
			defaultSelectId = RiskJudgmentSelectStatusEnum.不可控.getCode();//不可控
		} else if(count != null && count == 0) {
			defaultSelectId = RiskJudgmentSelectStatusEnum.可控.getCode();//可控
		}
		return defaultSelectId;
	}

	private String getUserIds(String path, String companyId, String departmentId) {
        String reviewUserIds = "";
        List<UserModel> userModels = remoteSecurityService.listUserByMenuCode(permissionType, path);
        if (!CollectionUtils.isEmpty(userModels)) {
            List<String> userIds = Lists.newArrayList();
            for (UserModel userModel : userModels) {
                String userId = getUserIdIsInDepartmentId(departmentId, userModel, companyId);
                if (userId != null) {
                    userIds.add(userId);
                }
            }
            if (!CollectionUtils.isEmpty(userIds)) {
                reviewUserIds = Joiner.on(",").join(userIds);
            }
        }
        return reviewUserIds;
    }

    private String getUserIdIsInDepartmentId(String departmentId, UserModel userModel, String companyId) {
        Map<Long, List<Map<String, Object>>> companyDepartmentsMap = userModel.getCompanyDepartments();
        List<Map<String, Object>> departments = companyDepartmentsMap.get(Long.valueOf(companyId));
        if (!CollectionUtils.isEmpty(departments)) {
            for (Map<String, Object> map : departments) {
                if (map.get("sequenceNbr").equals(departmentId)) {
                    return userModel.getUserId();
                }
            }
        }
        return null;
    }

    private Long getCount(String flag, String deptId) {
        Long count = null;
        switch (flag) {
            case "other_latent_danger_state_a"://一般隐患--
                count = latentDangerMapper.countNotFinishByTypeAndDeptId(1, deptId);
                break;
            case "other_latent_danger_state_b"://重大隐患--
                count = latentDangerMapper.countNotFinishByTypeAndDeptId(2, deptId);
                break;
            case "other_latent_danger_state_c"://重大风险-1级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_1.getCode(), deptId);
                break;
            case "other_latent_danger_state_d"://较大风险-2级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_2.getCode(), deptId);
                break;
            case "other_latent_danger_state_e"://一般风险-3级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_3.getCode(), deptId);
                break;
            case "other_latent_danger_state_f"://低风险-4级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_4.getCode(), deptId);
                break;
            case "danger_work_control_a"://重大工艺操作
                count = taskworkMapper.countByTypeAndDeptId(TaskworkTypeEnum.重大工艺操作.getCode(), deptId);
                break;
            case "danger_work_control_b"://检维修作业
                count = taskworkMapper.countByTypeAndDeptId(TaskworkTypeEnum.检维修作业.getCode(), deptId);
                break;
            case "danger_work_control_c"://特殊动火作业
                count = taskworkMapper.countByTypeAndDeptId(TaskworkTypeEnum.特殊动火作业.getCode(), deptId);
                break;
            case "danger_work_control_d"://一级动火作业
                count = taskworkMapper.countByTypeAndDeptId(TaskworkTypeEnum.一级动火作业.getCode(), deptId);
                break;
            case "danger_work_control_e"://二级动火作业
                count = taskworkMapper.countByTypeAndDeptId(TaskworkTypeEnum.二级动火作业.getCode(), deptId);
                break;
            case "danger_work_control_f"://进入受限空间作业
                count = taskworkMapper.countByTypeAndDeptId(TaskworkTypeEnum.进入受限空间作业.getCode(), deptId);
                break;
            default:
                break;
        }
        return count;
    }

    private void writeCompany(Collection<CompanyModel> tree, List<CompanyModel> companyBos) {
        tree.forEach(d -> {
            companyBos.add(d);
//            if (!CollectionUtils.isEmpty(d.getChildren())) {
//                writeCompany(d.getChildren(), companyBos);
//            }
        });
    }

    private void writeDepartment(Collection<DepartmentModel> tree, List<DepartmentModel> departmentBos) {
        tree.forEach(d -> {
            if (d.getLevel().equals("shop")) {
                departmentBos.add(d);
            }
            if (!CollectionUtils.isEmpty(d.getChildren())) {
                writeDepartment(d.getChildren(), departmentBos);
            }
        });
    }

    @Override
    public void updateRiskJudgmentTaskToOverTime(String toke,String product,String appKey,Date date) {
        String dateStr = DateUtil.formatDatrToStr(date, DateUtil.SHORT_PATTERN);
        RiskJudgmentTaskStatusEnum statusEnum = RiskJudgmentTaskStatusEnum.已超时;
        List<RiskJudgmentTaskBo> taskBos = riskJudgmentTaskMapper.listByDateAndStatus(dateStr, RiskJudgmentTaskStatusEnum.进行中.getCode());
        taskBos.forEach(e -> {
            e.setTaskStatus(statusEnum.getCode());
            try {
                String cdate = DateUtil.formatDatrToStr(e.getTaskDate(), "yyyy年MM月dd日");
                String userIds = e.getFlowUserIds();
                Set<String> userIdSet = Sets.newHashSet(Arrays.asList(userIds.split(",")));
                List<UserModel> reviewUserModels = remoteSecurityService.listUserByMenuCode(permissionType, e.getTaskDefinitionKey() + "_1");
                List<UserModel> companyReviewUserModels = remoteSecurityService.listUserByMenuCode(permissionType, "G_9");
                if (!CollectionUtils.isEmpty(reviewUserModels)) {
                    userIdSet.addAll(Lists.transform(reviewUserModels, UserModel::getUserId));
                }
                if (!CollectionUtils.isEmpty(companyReviewUserModels)) {
                    userIdSet.addAll(Lists.transform(companyReviewUserModels, UserModel::getUserId));
                }
                DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,e.getDepartmentId());
//                asyncTask.pushRiskJudgmentMessage(userIdSet, e.getOrgCode(), e.getTaskName(),
//                        cdate, departmentBo.getDepartmentName(),
//                        statusEnum.getName(), e.getId(),statusEnum.getCode());
            } catch (Exception ex) {
                logger.error("风险研判推送异常", ex);
            }

        });
        if (taskBos.size() > 0) {
            riskJudgmentTaskMapper.updateBatch(taskBos);
        }
    }

    @Override
    public void updateRiskJudgmentTaskToProcess(String toke,String product,String appKey,Date date) {
        String dateStr = DateUtil.formatDatrToStr(date, DateUtil.SHORT_PATTERN);
        RiskJudgmentTaskStatusEnum statusEnum = RiskJudgmentTaskStatusEnum.进行中;
        List<RiskJudgmentTaskBo> taskBos = riskJudgmentTaskMapper.listByDateAndStatus(dateStr, RiskJudgmentTaskStatusEnum.未开始.getCode());
        taskBos.forEach(e -> {
            e.setTaskStatus(statusEnum.getCode());
            try {
                String cdate = DateUtil.formatDatrToStr(e.getTaskDate(), "yyyy年MM月dd日");
                DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId( toke, product, appKey,e.getDepartmentId());
                Set<String> userIds = Sets.newHashSet(Arrays.asList(e.getFlowUserIds().split(",")));
//                asyncTask.pushRiskJudgmentMessage(userIds,e.getOrgCode(),
//                        e.getTaskName(),cdate, departmentBo.getDepartmentName(),
//                        statusEnum.getName(), e.getId(),e.getTaskStatus());
            } catch (Exception ex) {
                logger.error("风险研判推送异常", ex);
            }
        });
        if (taskBos.size() > 0) {
            riskJudgmentTaskMapper.updateBatch(taskBos);
        }
    }
    
	@Override
	public void freshRiskJudgmentLangerCount(Long riskSourceId) {
		RiskSourceBo riskSource = riskSourceMapper.getById(riskSourceId);
		if(riskSource != null && StringUtil.isNotEmpty(riskSource.getBelongDepartmentId()) ){
			Long count1 = latentDangerMapper.countNotFinishByTypeAndDeptId(1, riskSource.getBelongDepartmentId());
			Long count2 = latentDangerMapper.countNotFinishByTypeAndDeptId(2, riskSource.getBelongDepartmentId());
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("departmentId", riskSource.getBelongDepartmentId());
			map.put("inputResult", count1);
			map.put("taskStatus", RiskJudgmentTaskStatusEnum.进行中.getCode());			
			map.put("itemFlag", "other_latent_danger_state_a");
			riskJudgmentFillRecordMapper.updateInputResultAndselectResult(map);//更新一般隐患数量
			map.put("inputResult", count2);
			map.put("itemFlag", "other_latent_danger_state_b");
			riskJudgmentFillRecordMapper.updateInputResultAndselectResult(map);//更新重大隐患数量
		}
	}

	@Override
	public void freshRiskJudgmentTaskwork(String deptId) {
		//循环更新riskJudgmentFillRecordMapper 的 select_result and input_result	
	    Long count = 0L;
	    String defaultSelectId = null;
	    Map<String,Object> paramMap = new HashMap<String,Object>();
		for(RiskJudgeTaskworkTypeEnum eum : RiskJudgeTaskworkTypeEnum.values()){
			count = getCount(eum.getIntemFlag(), deptId);//查询条件:  部门  + 类型
			defaultSelectId = getDefaultSelectId(eum.getIntemFlag(), deptId);//查询条件:  部门  + 类型
			paramMap.clear();
			paramMap.put("departmentId", deptId);
			paramMap.put("inputResult", count);
			paramMap.put("selectResult", defaultSelectId);
			paramMap.put("taskStatus", RiskJudgmentTaskStatusEnum.进行中.getCode());			
			paramMap.put("itemFlag",eum.getIntemFlag());
			riskJudgmentFillRecordMapper.updateInputResultAndselectResult(paramMap);
		}
	}
}
