
package com.yeejoin.amos.patrol.service.business.service.impl;


import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.common.core.request.CheckResultPushSpcRequest;
import com.yeejoin.amos.patrol.common.core.response.*;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.common.enums.CheckStatusEnum;
import com.yeejoin.amos.patrol.service.business.dao.mapper.CheckMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PointMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RouteMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.TaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointDao;
import com.yeejoin.amos.patrol.service.business.service.intfc.ISafety3DDataSendService;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.remote.RemoteSpcService;
import com.yeejoin.amos.patrol.service.remote.feign.AmosRiskFeign;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
//import com.yeejoin.amos.security.common.model.UserModel;

@Service("safety3DDataSend")
public class Safety3DDataSendServiceImpl implements ISafety3DDataSendService {

    private static final Logger logger = Logger.getLogger(Safety3DDataSendServiceImpl.class);

    @Autowired
    private CheckMapper checkMapper;

    @Resource
    private TaskMapper taskMapper;

    @Resource
    private PointMapper pointMapper;

    @Autowired
    private IPointDao iPointDao;
    
    @Autowired
    private RemoteSpcService remoteSpcService;

    @Resource
    private RouteMapper routeMapper;

    @Autowired
    private AmosRiskFeign amosRiskFeign;
    
	@Autowired
	private RemoteSecurityService remoteSecurityService;

    @Override
    public PointCheckInfoRespone pointCheckInfoPush(String toke,String product,String appKey,Long checkId) {
        //PointStatusCache pointStatusCache = PointStatusCache.getInstance();
        List<PointCheckInfoRespone> pointCheckInfoList = checkMapper.getCheckInfoById(checkId);
        PointCheckInfoRespone pointCheckInfo = new PointCheckInfoRespone();
        if (!pointCheckInfoList.isEmpty()) {
            pointCheckInfo = pointCheckInfoList.get(0);
            AgencyUserModel userModel = remoteSecurityService.getUserById( toke, product, appKey,String.valueOf(pointCheckInfo.getUserID()));
            if(userModel != null){
            	pointCheckInfo.setUserName(userModel.getUserName());
            	pointCheckInfo.setTelephone(userModel.getMobile());
            }
            List<CheckInputResponse> checkInputList = new ArrayList<CheckInputResponse>();
            pointCheckInfoList.forEach(action -> {
                CheckInputResponse checkInputBo = new CheckInputResponse();
                checkInputBo.setInputItemName(action.getInputName());
                checkInputBo.setInputValue(action.getInputValue());
                checkInputBo.setIsOK(action.getInputStatus());
                checkInputBo.setInputLevel(action.getInputLevel());
                checkInputList.add(checkInputBo);
            });
            pointCheckInfo.setCheckInput(checkInputList);
            Point point = iPointDao.findById(Long.valueOf(pointCheckInfo.getPointID())).get();
            String pointStatus = point.getStatus();
            if (!ObjectUtils.isEmpty(point) && !ObjectUtils.isEmpty(pointStatus)) {
                if (!pointStatus.equals(pointCheckInfo.getStatus())) {
                    pointCheckInfo.setIsChangeStatus(true);
                }
            } else {
                pointCheckInfo.setIsChangeStatus(true);
            }
            logger.debug("推送数据============" + pointCheckInfo);
//            remoteServer.checkStatusPush(pointCheckInfo);
        }
        return pointCheckInfo;
    }


    @Override
    public TaskInfoRespone taskDetailInfoPush(Long taskId) {
        List<TaskInfoRespone> taskInfoResponeList = taskMapper.getTaskDetailInfoByTaskId(taskId);
        TaskInfoRespone taskInfoRespone = new TaskInfoRespone();
        if (!taskInfoResponeList.isEmpty()) {
            taskInfoRespone = taskInfoResponeList.get(0);
            List<CheckInputResponse> checkInputList = new ArrayList<CheckInputResponse>();
            taskInfoResponeList.forEach(action -> {
                CheckInputResponse checkInputResponse = new CheckInputResponse();
                checkInputResponse.setInputItemName(action.getInputItemName());
                checkInputResponse.setInputValue(action.getInputValue());
                checkInputResponse.setIsOK(action.getInputStatus());
                checkInputList.add(checkInputResponse);
            });
            taskInfoRespone.setCheckInputs(checkInputList);
//            remoteServer.errorTaskPush(taskInfoRespone);
        }
        return taskInfoRespone;

    }


    @Override
    public List<PointInfoSyn3DRespone> pushPointTo3D(List<Long> pointIds) {
        List<PointInfoSyn3DRespone> list = new ArrayList<>();
        if (!pointIds.isEmpty()) {
            pointIds.forEach(pointId -> {
                List<Map<String, Object>> result = pointMapper.getPointInfoById(pointId);
                List<PointUserSyn3DRespone> users = new ArrayList<PointUserSyn3DRespone>();
                Map<String, PointUserSyn3DRespone> map = new HashMap<String, PointUserSyn3DRespone>();
                PointInfoSyn3DRespone pointInfoResponse = new PointInfoSyn3DRespone();
                if (!result.isEmpty()) {
                    result.forEach(action -> {
                        pointInfoResponse.setPointId(getValue(action.get("pointId")));
                        pointInfoResponse.setPointName(getValue(action.get("pointName")));
                        pointInfoResponse.setPointLevel(getValue(action.get("pointLevel")));
                        pointInfoResponse.setStatus(getValue(action.get("status")));
                        pointInfoResponse.setCoordinates(getValue(action.get("coordinates")));
                        pointInfoResponse.setOrgCode(getValue(action.get("defaultOrgCode")));
                        if (action.get("floor") != null) {
                            PointPositionInfoSyn3DRespone config = new PointPositionInfoSyn3DRespone();
                            config.setBelongObjModel("floor_" + getValue(action.get("floor")));
                            config.setIsIndoor(Boolean.valueOf(action.get("isIndoor").toString()));
                            pointInfoResponse.setNodeConfigDTO(config);
                        }
                        pointInfoResponse.setAddress(getValue(action.get("address")));
                        if (action.get("userId") != null && !map.containsKey(action.get("userId").toString())) {
                            PointUserSyn3DRespone pointUserSyn3DRespone = new PointUserSyn3DRespone();
                            pointUserSyn3DRespone.setUserId(getValue(action.get("userId")));
                            pointUserSyn3DRespone.setUserName(getValue(action.get("userName")));
                            pointUserSyn3DRespone.setOrgCode(getValue(action.get("orgCode")));
                            pointUserSyn3DRespone.setGroupName(getValue(action.get("groupName")));
                            map.put(action.get("userId").toString(), pointUserSyn3DRespone);
                            users.add(pointUserSyn3DRespone);
                        }
                        pointInfoResponse.setIsDelete(getValue(action.get("is_delete")).equals("false") ? false : true);
                    });
                    pointInfoResponse.setUsers(users);
                }
                list.add(pointInfoResponse);
            });
//            remoteServer.pointInfoPush(list);
        }
        return list;
    }

    private String getValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public RouteResponse pushRouteInfoTo3D(List<Long> routeIds) {
        // TODO Auto-generated method stub
        RouteResponse routeResponse = new RouteResponse();
        Map<String, PatrolUserRespone> map = new HashMap<String, PatrolUserRespone>();
        List<RouteResponse> routeResponseList = new ArrayList<>();
        for (Long routeId : routeIds) {
            List<Map<String, Object>> routeList = routeMapper.getRouteInfoList(routeId);
            RouteResponse routeInfo = new RouteResponse();
            if (!routeList.isEmpty()) {
                List<PatrolUserRespone> exeUserList = new ArrayList<>();
                routeList.forEach(item -> {
                    routeInfo.setBoss(getValue(item.get("boss")));
                    routeInfo.setIsDelete(getValue(item.get("isDelete")).equals("false") ? false : true);
                    routeInfo.setRouteId(Integer.valueOf(getValue(item.get("routeId"))));
                    routeInfo.setRouteName(getValue(item.get("routeName")));
                    routeInfo.setTel(getValue(item.get("tel")));
                    routeInfo.setOrgCode(getValue(item.get("defaultOrgCode")));
                    if (item.get("userId") != null && !map.containsKey(item.get("userId").toString())) {
                        PatrolUserRespone exeUser = new PatrolUserRespone();
                        exeUser.setGroupName(getValue(item.get("groupName")));
                        exeUser.setOrgCode(getValue(item.get("orgCode")));
                        exeUser.setUserName(getValue(item.get("userName")));
                        exeUser.setUserId(getValue(item.get("userId")));
                        exeUserList.add(exeUser);
                        map.put(item.get("userId").toString(), exeUser);
                    }
                    routeInfo.setPatrolUsers(exeUserList);
                });
                routeResponseList.add(routeInfo);
            }
        }
//        remoteServer.routeInfoPush(routeResponseList);
        return routeResponse;
    }

    /**
     * 推送巡检记录到业务
     */
    @Override
    public PointCheckInfoBusinessRespone pointCheckInfoPushToB(String toke,String product,String appKey,Long checkId) {
        //获取推送内容
        PointCheckInfoBusinessRespone pb = checkMapper.getCheckInfoBusinessById(checkId);
        if(ObjectUtils.isEmpty(pb)){
        	 return pb;
        }
        AgencyUserModel userById = remoteSecurityService.getUserById(toke, product, appKey, pb.getUserId());
        if(null != userById && !StringUtils.isEmpty(userById.getUserName())) {
        	pb.setUserName(userById.getRealName());
        	pb.setCheckUser(userById.getRealName());
        }
//        //获取到推送点的状态
//        Point point = iPointDao.findOne(pb.getId());
//        String pointStatus = point.getStatus();
//        if (!ObjectUtils.isEmpty(point) && !ObjectUtils.isEmpty(pointStatus)) {
//            if (!pointStatus.equals(pb.getNodeState())) {
//                pointStatusCache.putPointStatus(pb.getId(), pb.getNodeState());
//            }
//        } else {
//            pointStatusCache.putPointStatus(pb.getId(), pb.getNodeState());
//        }
//        remoteServer.checkStatusPushToB(pb);
        pb.setItems(pb.getPointInputitems());
        try {
            CommonResponse commonResponse = amosRiskFeign.checkStatusPushToB(pb);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }


	@Override
	public CheckResultPushSpcRequest pushSpcCheckResult(String toke,String product,String appKey,Long checkId) {
		 List<PointCheckInfoRespone> pointCheckInfoList = checkMapper.getCheckInfoById(checkId);
	        PointCheckInfoRespone pointCheckInfo = new PointCheckInfoRespone();
	        CheckResultPushSpcRequest checkResultPushSpcRequest = new CheckResultPushSpcRequest();
	        if (!pointCheckInfoList.isEmpty()) {
	            pointCheckInfo = pointCheckInfoList.get(0);
	            AgencyUserModel userModel = remoteSecurityService.getUserById( toke, product, appKey,String.valueOf(pointCheckInfo.getUserID()));
	            if (userModel != null){
	            	checkResultPushSpcRequest.setExecutorName(userModel.getUserName());         	
	            }
	            //新增加点的id
	            checkResultPushSpcRequest.setPointID(pointCheckInfo.getPointID());
	            
	            //查询点公司code	            
	            Point pot= iPointDao.findById(Long.valueOf(pointCheckInfo.getPointID())).get();
	            
	            checkResultPushSpcRequest.setCode(pot.getOrgCode());
	            //新加楼层
	            checkResultPushSpcRequest.setNum(pot.getFloor()+"");
	         
	    	    //三维坐标
	    	    checkResultPushSpcRequest.setCoordinates(pot.getCoordinates());;
	    	    checkResultPushSpcRequest.setName(pot.getName());
	    	    
	    	    
	            checkResultPushSpcRequest.setRiskSourceId(pointCheckInfo.getRiskSourceId());
	            checkResultPushSpcRequest.setPointName(pointCheckInfo.getPointName());
	            checkResultPushSpcRequest.setRiskSourceName(pointCheckInfo.getPointName());
	            checkResultPushSpcRequest.setExecuteStatus(pointCheckInfo.getStatus());
	            checkResultPushSpcRequest.setExecutorTime(DateUtil.getMidDate(pointCheckInfo.getCheckTime()));
	            checkResultPushSpcRequest.setNodeState(pointCheckInfo.getStatus());
	            if(CheckStatusEnum.UNQUALIFIED.getCode().equals(pointCheckInfo.getStatus())){
	            	Map<String,List<String>> riskFactorMap = new HashMap<>();
	 	            pointCheckInfoList.forEach(action -> {
	 	            	if(CheckStatusEnum.UNQUALIFIED.getCode().equals(action.getInputStatus())){
	 	            		if(riskFactorMap.containsKey(action.getClassifyName())){
		 	            		List<String> controlContent = riskFactorMap.get(action.getClassifyName());
		 	            		controlContent.add(action.getInputName());
		 	            	}else{
		 	            		List<String> controlContent = new ArrayList<>();
		 	            		controlContent.add(action.getInputName());
		 	            		riskFactorMap.put(action.getClassifyName(), controlContent);
		 	            	}
	 	            	}
	 	            });
	 	           checkResultPushSpcRequest.setRiskFactorMap(riskFactorMap);
	            }
	        }
	       
			remoteSpcService.pushSpcCheckResult(checkResultPushSpcRequest);
	        return checkResultPushSpcRequest;
	}
}

