package com.yeejoin.amos.patrol.service.business.service.impl;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import com.yeejoin.amos.patrol.common.entity.Plan;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.common.entity.PointClassify;
import com.yeejoin.amos.patrol.common.entity.PointInputItem;
import com.yeejoin.amos.patrol.common.entity.Route;
import com.yeejoin.amos.patrol.common.entity.RoutePoint;
import com.yeejoin.amos.patrol.common.entity.RoutePointItem;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointClassifyDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPointInputItemDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IRouteDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IRoutePointDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IRoutePointItemDao;
import com.yeejoin.amos.patrol.service.business.param.SynClassifyInfoParam;
import com.yeejoin.amos.patrol.service.business.param.SynInputItemParam;
import com.yeejoin.amos.patrol.service.business.param.SynItemInfoParam;
import com.yeejoin.amos.patrol.service.business.param.SynPlanParam;
import com.yeejoin.amos.patrol.service.business.param.SynPointParam;
import com.yeejoin.amos.patrol.service.business.param.SynRouteInfoParam;
import com.yeejoin.amos.patrol.service.business.param.SynRouteItemInfoParam;
import com.yeejoin.amos.patrol.service.business.param.SynRouteParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.service.business.service.intfc.ISynDataService;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;

@Service("synDataService")
public class SynDataServiceImpl implements ISynDataService {
	
	private final Logger log = LoggerFactory.getLogger(SynDataServiceImpl.class);

    @Autowired
    private IInputItemDao iInputItemDao;

    @Autowired
    private IPointDao iPointDao;

    @Autowired
    private IPointInputItemDao iPointInputItemDao;

    @Autowired
    private IRouteDao iRouteDao;

    @Autowired
    private IRoutePointDao iRoutePointDao;

    @Autowired
    private IRoutePointItemDao iRoutePointItemDao;

    @Autowired
    private IPlanDao iPlanDao;

    @Autowired
    private IPlanTaskDao iplanTaskDao;

    @Autowired
    private PlanTaskMapper planTaskMapper;

    @Autowired
    private IPointClassifyDao iPointClassifyDao;

    @Autowired
    private IPlanTaskService iPlanTaskService;

    private static final String YYMMMMDD = "yyyy-MM-dd";

    @Override
    public CommonResponse saveInputItem(SynInputItemParam synInputItemParam, String orgCode, String userId) {
        InputItem inputItem = iInputItemDao.findByOriginalId(synInputItemParam.getOriginalId());
        if (inputItem == null) {
            if (StringUtils.isEmpty(synInputItemParam.getItemType())) {
                return CommonResponseUtil.failure("请选择类型");
            }
            inputItem = buildSaveItemByType(synInputItemParam, orgCode, userId);
            iInputItemDao.save(inputItem);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse updateInputItem(SynInputItemParam synInputItemParam) {
        InputItem inputItem = iInputItemDao.findByOriginalId(synInputItemParam.getOriginalId());
        if (inputItem != null) {
            inputItem.setName(synInputItemParam.getItemName());
            inputItem.setBasisJson(synInputItemParam.getBasisJson());
            iInputItemDao.save(inputItem);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse deleteInputItem(SynInputItemParam synInputItemParam) {
        InputItem inputItem = iInputItemDao.findByOriginalId(synInputItemParam.getOriginalId());
        if (inputItem != null) {
            inputItem.setIsDelete(true);
            iInputItemDao.save(inputItem);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse saveSinglePoint(SynPointParam synPointParam, String orgCode, String userId) {
        Point point = iPointDao.findByOriginalId(synPointParam.getOriginalId());
        if (point == null) {
            point = buildSavePoint(synPointParam, orgCode, userId);
            iPointDao.save(point);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse updateSinglePoint(SynPointParam synPointParam) {
        Point point = iPointDao.findByOriginalId(synPointParam.getOriginalId());
        if (point != null) {
            point.setName(synPointParam.getPointName());
            point.setPointNo(synPointParam.getPointNo());
            point.setLevel(synPointParam.getLevel());
            point.setCoordinates(synPointParam.getCoordinates());
            point.setLastUpdateTime(new Date());
            iPointDao.save(point);
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse deleteSinglePoint(SynPointParam synPointParam) {
        Point point = iPointDao.findByOriginalId(synPointParam.getOriginalId());
        if (point != null) {
            point.setIsDelete(true);
            iPointDao.save(point);
        }
        return CommonResponseUtil.success();
    }

    @Transactional
    @Override
    public CommonResponse synPointItemRelation(SynPointParam synPointParam, Boolean isSave, String userId) {
        Point point = iPointDao.findByOriginalId(synPointParam.getOriginalId());
        if (point != null) {
            point.setLevel(synPointParam.getLevel());
            point.setLastUpdateTime(new Date());
            iPointDao.save(point);
            long pointId = point.getId();
            List<SynItemInfoParam> itemInfoList = synPointParam.getItemInfo();
            if (!CollectionUtils.isEmpty(itemInfoList)) {
                if (!isSave) {
                    List<Long> pointIds = Lists.newArrayList(pointId);
                    iPointClassifyDao.deleteByPointId(pointIds);
                    iPointInputItemDao.deleteByPointId(pointIds);
                }
                Map<String, PointClassify> pointClassifyMap = Maps.newHashMap();
                //保存分类
                List<SynClassifyInfoParam> classifyInfoParamList = synPointParam.getClassifyInfo();
                if (!CollectionUtils.isEmpty(classifyInfoParamList)) {
                    List<PointClassify> pointClassifyList = Lists.newArrayList();
                    int classfyOrderNo = 0;
                    for (SynClassifyInfoParam synClassifyInfoParam : classifyInfoParamList) {
                        PointClassify pointClassify = new PointClassify();
                        pointClassify.setPointId(pointId);
                        pointClassify.setName(synClassifyInfoParam.getName());
                        pointClassify.setOrderNo(classfyOrderNo);
                        pointClassify.setCreatorId(userId);
                        pointClassify.setOriginalId(synClassifyInfoParam.getClassifyOriginalId());
                        pointClassifyList.add(pointClassify);
                        classfyOrderNo++;
                    }
                    iPointClassifyDao.saveAll(pointClassifyList);
                    pointClassifyMap = Maps.uniqueIndex(pointClassifyList, PointClassify::getOriginalId);
                }
                //保存点和项的关系
                List<InputItem> inputItemList = iInputItemDao.listByOriginalIds(Lists.transform(itemInfoList, SynItemInfoParam::getItemOriginalId));
                Map<String, InputItem> inputItemVoMap = Maps.uniqueIndex(inputItemList, InputItem::getOriginalId);
                List<PointInputItem> pointInputItemList = Lists.newArrayList();
                int orderNo = 0;
                for (SynItemInfoParam itemInfo : itemInfoList) {
                    List<String> classifyOriginalIds = itemInfo.getClassifyOriginalIds();
                    String classifyIds = "";
                    if (!CollectionUtils.isEmpty(classifyOriginalIds)) {
                        StringBuilder classifyIdsBuilder = new StringBuilder();
                        for (String classifyOriginalId : classifyOriginalIds) {
                            PointClassify classify = pointClassifyMap.get(classifyOriginalId);
                            if (classify != null) {
                                classifyIdsBuilder.append(classify.getId()).append(",");
                            }
                        }
                        classifyIds = classifyIdsBuilder.substring(0, classifyIdsBuilder.length() - 1);
                    }
                    PointInputItem pointInputItem = new PointInputItem();
                    pointInputItem.setOrderNo(orderNo);
                    pointInputItem.setPointId(pointId);
                    pointInputItem.setInputItemId(inputItemVoMap.get(itemInfo.getItemOriginalId()).getId());
                    pointInputItem.setClassifyIds(classifyIds);
                    pointInputItemList.add(pointInputItem);
                    orderNo++;
                }
                iPointInputItemDao.saveAll(pointInputItemList);
            }
        }
        return CommonResponseUtil.success();
    }

    @Transactional
    @Override
    public CommonResponse saveRoute(SynRouteParam synRouteParam, String orgCode, String userId) {
        String routeOriginalId = synRouteParam.getOriginalId();
        Route route = iRouteDao.findByOriginalId(routeOriginalId);
        if (route == null) {
            route = buildSaveRoute(synRouteParam, orgCode, userId);
            iRouteDao.save(route);
            long routeId = route.getId();
            List<SynRouteInfoParam> routeInfoList = synRouteParam.getRouteInfo();
            synRouteRelation(routeInfoList, routeId, true, userId, orgCode);
        }
        return CommonResponseUtil.success();
    }

    @Transactional
    @Override
    public CommonResponse updateRoute(SynRouteParam synRouteParam, String orgCode, String userId) {
        String routeOriginalId = synRouteParam.getOriginalId();
        Route route = iRouteDao.findByOriginalId(routeOriginalId);
        if (route != null) {
            route.setBoss(synRouteParam.getBoss());
            route.setName(synRouteParam.getRouteName());
            iRouteDao.save(route);
            long routeId = route.getId();
            List<SynRouteInfoParam> routeInfoList = synRouteParam.getRouteInfo();
            synRouteRelation(routeInfoList, routeId, false, userId, orgCode);
        }
        return CommonResponseUtil.success();
    }

    @Transactional
    @Override
    public CommonResponse savePlan(SynPlanParam synPlanParam, String orgCode, String userId) {
        Plan plan = iPlanDao.findByOriginalId(synPlanParam.getOriginalId());
        Route route = iRouteDao.findByOriginalId(synPlanParam.getRouteOriginalId());
        if (plan == null && route != null) {
            boolean tag = savePlanAndRedo(route, synPlanParam, orgCode, userId);
            if (!tag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return CommonResponseUtil.failure("计划重做失败");
            }
        }
        return CommonResponseUtil.success();
    }

    private boolean savePlanAndRedo(Route route, SynPlanParam synPlanParam, String orgCode, String userId) {
        Date now = new Date();
        Plan plan = new Plan();
        plan.setName(synPlanParam.getPlanName());
        plan.setOrgCode(orgCode);
        plan.setDeptId(synPlanParam.getDeptId());
        plan.setRouteId(route.getId());
        plan.setIsFixedDate("0");
        plan.setInOrder("0");
        plan.setPlanBegin(synPlanParam.getPlanBegin());
        plan.setPlanEnd(synPlanParam.getPlanEnd());
        plan.setDayRate(0);
        plan.setDayInterval(1);
        plan.setDayIntervalUnit("1");
        plan.setExecuteInterval(1);
        plan.setMonthType("1");
        plan.setWhatDay("1");
        plan.setWhatWeek(1);
        plan.setWeekDay(1);
        plan.setUserId(synPlanParam.getUserIds());
        plan.setWeekBeginNum(1);
        plan.setWeekEndNum(7);
        plan.setMinSpace(0);
        plan.setIsScore("1");
        plan.setError(0);
        plan.setStatus(Byte.parseByte(XJConstant.PLAN_STATUS_START));
        plan.setNextGenDate(DateUtil.getIntervalDate(now, 0));
        plan.setCreateBy(userId);
        plan.setRemark1(synPlanParam.getRemark());
        plan.setFirstFlag(0);
        plan.setOriginalId(synPlanParam.getOriginalId());
        HashMap<String, Object> map = Maps.newHashMap();
        switch (synPlanParam.getPlanType()) {
            case "1":
                plan.setDayTime("00:00:00");
                plan.setDayBegin(DateUtil.formatStrToTime("08:00:00"));
                plan.setDayEnd(DateUtil.formatStrToTime("23:00:00"));
                plan.setDuration(1440);
                plan.setRemark("每1天的00:00执行");
                plan.setExecuteRate(1);
                plan.setPlanType("1");
//                if (XJConstant.GEN_MORE_DATA_YES.equalsIgnoreCase(isGenMoreCheck)) {//测试时使用，环境配置为YES，生成多条数据，便于测试
//                    plan.setDayRate(XJConstant.DAY_RATE_MANY);//频率多次
//                    plan.setDayInterval(10);//间隔10
//                    plan.setDayIntervalUnit(XJConstant.INTERVAL_UNIT_MINUTE);//间隔单位:分钟
//                    plan.setDuration(60);//工作时长60分钟
//                }
                map.put("beginDate", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
                map.put("endDate", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
                break;
            case "2":
                plan.setDayTime("08:00:00");
                plan.setDayBegin(DateUtil.formatStrToTime("00:00:00"));
                plan.setDayEnd(DateUtil.formatStrToTime("23:59:59"));
                plan.setDuration(60);
                plan.setRemark("执行区间:第1天00:00至第7天23:59结束");
                plan.setExecuteRate(1);
                plan.setPlanType("2");
                map.put("beginDate", DateUtil.formatDatrToStr(DateUtil.getThisWeekMonday(now), YYMMMMDD));
                map.put("endDate", DateUtil.formatDatrToStr(now, YYMMMMDD));
                break;
            case "3":
                plan.setDayTime("08:00:00");
                plan.setDayBegin(DateUtil.formatStrToTime("00:00:00"));
                plan.setDayEnd(DateUtil.formatStrToTime("23:59:59"));
                plan.setDuration(60);
                plan.setRemark("执行区间:开始日期所在月1号00:00至下月1号00:00");
                plan.setExecuteRate(1);
                plan.setPlanType("3");
                map.put("beginDate", DateUtil.formatDatrToStr(DateUtil.getThisMonthFirstDay(now), YYMMMMDD));
                map.put("endDate", DateUtil.formatDatrToStr(now, YYMMMMDD));
                break;
            case "4":
                plan.setDayTime("08:00:00");
                plan.setDayBegin(DateUtil.formatStrToTime("00:00:00"));
                plan.setDayEnd(DateUtil.formatStrToTime("23:59:59"));
                plan.setDuration(60);
                plan.setRemark("每1年执行,执行频率：1年1次");
                plan.setExecuteRate(1);
                plan.setPlanType("4");
                map.put("beginDate", DateUtil.formatDatrToStr(DateUtil.getCurrYearFirst(), YYMMMMDD));
                map.put("endDate", DateUtil.formatDatrToStr(DateUtil.getCurrYearLast(), YYMMMMDD));
                break;
            case "5":
                plan.setDayTime("08:00:00");
                plan.setDayBegin(DateUtil.formatStrToTime("00:00:00"));
                plan.setDayEnd(DateUtil.formatStrToTime("23:59:59"));
                plan.setDuration(60);
                plan.setRemark("每1年执行,执行频率：1年4次");
                plan.setExecuteRate(4);
                plan.setPlanType("4");
                map.put("beginDate", DateUtil.formatDatrToStr(DateUtil.getCurrYearFirst(), YYMMMMDD));
                map.put("endDate", DateUtil.formatDatrToStr(DateUtil.getCurrYearLast(), YYMMMMDD));
                break;
            case "6"://区间执行，执行一次
            	plan.setPlanType(XJConstant.PLAN_TYPE_WEEK);
            	plan.setIsFixedDate(XJConstant.FIX_DATE_NO);
                plan.setDayTime("08:00:00");
                plan.setDayBegin(DateUtil.formatStrToTime("00:00:00"));
                plan.setDayEnd(DateUtil.formatStrToTime("23:59:59"));
                plan.setPlanBegin(DateUtil.getFirstDayOfWeekAtDay(synPlanParam.getPlanBegin()));
                plan.setPlanEnd(DateUtil.getEndDayOfWeekAtDay(synPlanParam.getPlanEnd()));             
                plan.setWeekBeginNum(DateUtil.getDayOfWeek(synPlanParam.getPlanBegin()));
                plan.setWeekEndNum(DateUtil.getDayOfWeek(synPlanParam.getPlanBegin()) + DateUtil.calInterverDay(synPlanParam.getPlanBegin(), synPlanParam.getPlanEnd()));
                plan.setExecuteInterval(DateUtil.calAtWeekOfDay(synPlanParam.getPlanEnd())- DateUtil.calAtWeekOfDay(synPlanParam.getPlanEnd()) + 1);
                plan.setRemark("区间执行,执行一次");
                map.put("beginDate", DateUtil.formatDatrToStr(new Date(),YYMMMMDD));
                map.put("endDate", DateUtil.formatDatrToStr(new Date(),YYMMMMDD));
                break;
            default:
                break;
        }
        iPlanDao.save(plan);
        map.put("planId", plan.getId());
        map.put("changeFlag", "0");
        try {
            iPlanTaskService.reGenPlanTask(map);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public CommonResponse updatePlan(SynPlanParam synPlanParam) {
        return CommonResponseUtil.success();
    }

    @Transactional
    @Override
    public CommonResponse stopPlan(String originalId) {
        Plan plan = iPlanDao.findByOriginalId(originalId);
        if (plan != null) {
            plan.setStatus(Byte.parseByte(XJConstant.PLAN_STATUS_STOP));
            iPlanDao.save(plan);
            List<PlanTask> planTasks = iplanTaskDao.findByPlanId(plan.getId());
            if (!CollectionUtils.isEmpty(planTasks)) {
                planTasks.forEach(e -> e.setStatus(Integer.parseInt(XJConstant.PLAN_STATUS_STOP)));
                iplanTaskDao.saveAll(planTasks);
            }
        }
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse getPlanFinishTimes(String originalIds) {
        List<Map<String, Object>> list = Lists.newArrayList();
        List<String> originalIdList = Arrays.asList(originalIds.split(","));
        List<Plan> planList = iPlanDao.findByOriginalIds(originalIdList);
        if (!CollectionUtils.isEmpty(planList)) {
            Map<Long, Plan> planMap = Maps.uniqueIndex(planList, Plan::getId);
            List<Long> planIds = Lists.transform(planList, Plan::getId);
            list = planTaskMapper.countFinishByPlanIds(planIds);
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(e -> e.put("originalId", planMap.get(Long.valueOf(e.get("planId").toString())).getOriginalId()));
            }
        }
        return CommonResponseUtil.success(list);
    }


    private void synRouteRelation(List<SynRouteInfoParam> routeInfoList, Long routeId, Boolean isSave, String userId, String orgCode) {
        if (!CollectionUtils.isEmpty(routeInfoList)) {
            List<String> pointOriginalIds = Lists.newArrayList();
            for (SynRouteInfoParam synRouteInfoParam : routeInfoList) {
                pointOriginalIds.add(synRouteInfoParam.getPointOriginalId());
            }
            List<Point> pointVos = iPointDao.listByOriginalIds(pointOriginalIds);
            List<Long> pointIds = Lists.transform(pointVos, Point::getId);
            if (!isSave) {
                List<BigInteger> routePointIds = iRoutePointDao.queryRoutePointByPointId(pointIds);
                if (!CollectionUtils.isEmpty(routePointIds)) {
                    routePointIds.forEach(id -> iRoutePointItemDao.delRoutePointItem(id.longValue()));
                }
                iRoutePointDao.delRoutePointByRouteId(routeId);
            }
            Map<String, Point> pointVoMap = Maps.uniqueIndex(pointVos, Point::getOriginalId);
            int routePointOrderNo = 0;
            for (SynRouteInfoParam synRouteInfoParam : routeInfoList) {
                long pointId = pointVoMap.get(synRouteInfoParam.getPointOriginalId()).getId();
                RoutePoint routePoint = new RoutePoint();
                routePoint.setOrgCode(orgCode);
                routePoint.setRouteId(routeId);
                routePoint.setPointId(pointId);
                routePoint.setOrderNo(routePointOrderNo);
                routePoint.setCreatorId(userId);           
                List<RoutePoint> exixtPointList = iRoutePointDao.findByPointIdAndRouteId(pointId,routeId);
                if(null == exixtPointList || exixtPointList.size() == 0){
                	iRoutePointDao.save(routePoint);
                } else {
                	routePoint.setId(exixtPointList.get(0).getId());
                }
                routePointOrderNo++;
                List<SynRouteItemInfoParam> itemInfo = synRouteInfoParam.getItemInfo();
                List<String> itemOriginalIds = Lists.transform(itemInfo, SynRouteItemInfoParam::getItemOriginalId);
                List<InputItem> inputItemVos = iInputItemDao.listByOriginalIds(itemOriginalIds);
                List<Long> itemIds = Lists.transform(inputItemVos, InputItem::getId);
                Map<String, InputItem> inputItemVoMap = Maps.uniqueIndex(inputItemVos, InputItem::getOriginalId);
                List<RoutePointItem> routePointItems = Lists.newArrayList();
                log.info("pointId"+pointId+"-->itemIds"+itemIds);
                List<PointInputItem> pointInputItems = iPointInputItemDao.findAllPointInputItemByPointIdAndItemIds(pointId, itemIds);
                Map<String, PointInputItem> pointInputItemMap = Maps.newHashMap();
                pointInputItems.forEach(i -> {
                    List<Long> classifyIds = Arrays.stream(i.getClassifyIds().split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    for (Long classifyId : classifyIds) {
                        pointInputItemMap.put(buildId(i.getPointId(), i.getInputItemId(), classifyId), i);
                    }
                });
                int orderNo = 0;
                for (SynRouteItemInfoParam item : itemInfo) {
                    Long itemId = inputItemVoMap.get(item.getItemOriginalId()).getId();
                    PointClassify pointClassify = iPointClassifyDao.findByOriginalId(item.getClassifyOriginalId());
                    Long classifyId = pointClassify.getId();
                    PointInputItem pointInputItem = pointInputItemMap.get(buildId(pointId, itemId, classifyId));
                    if (pointInputItem != null) {
                        RoutePointItem routePointItem = buildRoutePointItem(pointInputItem, routePoint, orderNo, userId, item.getBasisJson().toJSONString(), classifyId);
                        routePointItems.add(routePointItem);
                        orderNo++;
                    }
                }
                iRoutePointItemDao.saveAll(routePointItems);
            }
        }
    }

    private RoutePointItem buildRoutePointItem(PointInputItem pointInputItem, RoutePoint routePoint, Integer orderNo, String userId, String json, Long classifyId) {
        RoutePointItem routePointItem = new RoutePointItem();
        routePointItem.setRoutePointId(routePoint.getId());
        routePointItem.setPointInputItemId(pointInputItem.getId());
        routePointItem.setOrderNo(orderNo);
        routePointItem.setCreatorId(userId);
        routePointItem.setBasisJson(json);
        routePointItem.setPointClassifyId(classifyId);
        return routePointItem;
    }

    private String buildId(Long pointId, Long itemId, Long classifyIds) {
        return pointId + "_" + itemId + "_" + classifyIds;
    }

    private Route buildSaveRoute(SynRouteParam synRouteParam, String orgCode, String userId) {
        Route route = new Route();
        route.setCreatorId(userId);
        route.setOrgCode(orgCode);
        route.setName(synRouteParam.getRouteName());
        route.setBoss(synRouteParam.getBoss());
        route.setOriginalId(synRouteParam.getOriginalId());
        return route;
    }

    private InputItem buildSaveItemByType(SynInputItemParam synInputItemParam, String orgCode, String userId) {
        InputItem inputItem = new InputItem();
        if ("选择".equals(synInputItemParam.getItemType())) {
            inputItem.setOrgCode(orgCode);
            inputItem.setName(synInputItemParam.getItemName());
            inputItem.setOrderNo(0);
            inputItem.setItemType(synInputItemParam.getItemType());
            inputItem.setIsMust("否");
            inputItem.setIsScore("否");
            inputItem.setIsMultiline("否");
            inputItem.setCatalogId(0L);
            String dataJsonStr = "[{\"name\":\"通过\",\"isOk\":\"是\",\"isChecked\":\"否\",\"orderNo\":0},{\"name\":\"不通过\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]";
            JSONArray dataJson = JSONArray.parseArray(dataJsonStr);
            inputItem.setDataJson(dataJson.toJSONString());
            String pictureJsonStr = "[{\"isMust\":\"是\",\"name\":\"照片\",\"orderNo\":0}]";
            JSONArray pictureJson = JSONArray.parseArray(pictureJsonStr);
            inputItem.setPictureJson(pictureJson.toJSONString());
            if (StringUtils.isEmpty(synInputItemParam.getItemNo())) {
                inputItem.setItemNo(buildRandomNum(synInputItemParam.getOriginalId()));
            } else {
                inputItem.setItemNo(synInputItemParam.getItemNo());
            }
            inputItem.setOriginalId(synInputItemParam.getOriginalId());
            inputItem.setCreateBy(userId);
            inputItem.setBasisJson(synInputItemParam.getBasisJson());
        }
        return inputItem;
    }

    private Point buildSavePoint(SynPointParam synPointParam, String orgCode, String userId) {
        Point point = new Point();
        point.setName(synPointParam.getPointName());
        if (StringUtils.isEmpty(synPointParam.getPointNo())) {
            point.setPointNo(buildRandomNum(synPointParam.getOriginalId()));
        } else {
            point.setPointNo(synPointParam.getPointNo());
        }
        point.setLevel(synPointParam.getLevel());
        point.setSaveGps("0");
        point.setDistance(0);
        point.setShotMinNumber(0);
        point.setShotMaxNumber(10);
        point.setFixedShot(10);
        point.setOffline(false);
        point.setIsFixed("1");
        point.setCatalogId(0L);
        point.setIsScore("0");
        point.setOrgCode(orgCode);
        point.setCoordinates(synPointParam.getCoordinates());
        point.setStatus("0");
        point.setIsIndoor(false);
        point.setOriginalId(synPointParam.getOriginalId());
        point.setCreatorId(userId);
        point.setChargePersonId(synPointParam.getChargePersonId());
        return point;
    }

    private String buildRandomNum(String originalId) {
        return "SPC_" + (int) ((Math.random() * 9 + 1) * 100000) + "_" + originalId;
    }
}
